with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;


Procedure tdstev is

	use lapack.Integer_IO;
	use lapack.Double_Precision_IO;

	N	 : Fortran_Integer := 3;
	D	 : lapack.Fortran_Double_Precision_Vector ( 1..N );
	E	 : lapack.Fortran_Double_Precision_Vector ( 1..N-1 );
	Z,A	 : lapack.Fortran_Double_Precision_Matrix ( 1..N, 1..N);
	WORK	 : lapack.Fortran_Double_Precision_Vector ( 1..2*N-2);
	INFO	 : Fortran_Integer;

	ERR, TMP : Double_Precision := 0.0;

begin

        -- A is symmetric positive definite tridiagonal metric

        A := (( 2.0, -1.0,  0.0),
              (-1.0,  2.0, -1.0),
              ( 0.0, -1.0,  6.0));

        -- D, E are tridiagonal arrays

        E :=  (A(1,2),A(2,3));
        D :=  (A(1,1),A(2,2),A(3,3));
        

	lapack.DSTEV (
	JOBZ	 => 'V',
	N	 => N,
	D	 => D,
	E	 => E,
	Z	 => Z,
	LDZ	 => N,
	WORK	 => WORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in D'Range(1) loop

          for J in A'Range(1) loop
            TMP := 0.0;

            for K in A'Range(2) loop
                TMP := TMP + ( A(J,K) * Z(K,I) ) ;
            end loop;

            TMP := TMP - ( D(I) * Z(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;



	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tdstev;
