with Ada.Text_IO; use  Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;
with lapack;

Procedure tchbev is

	use lapack.Integer_IO;
	use lapack.Real_IO;

	N	 : Fortran_Integer := 3;
	KD	 : Fortran_Integer := 2;

	LDAB	 : Fortran_Integer := KD + 1;
	AB	 : lapack.Fortran_Complex_Matrix ( 1..LDAB, 1..N);

	W	 : lapack.Fortran_Real_Vector ( 1..N );
	Z,A	 : lapack.Fortran_Complex_Matrix ( 1..N, 1..N);
	WORK	 : lapack.Fortran_Complex_Vector ( 1..N );
	RWORK	 : lapack.Fortran_Real_Vector ( 1..3*N-2);
	INFO	 : Fortran_Integer;

	TMP : Complex := (0.0,0.0);	
	ERR : Real := 0.0;

begin

        -- A is Hermitian matrix
        A := (( ( 3.0, 0.0), ( 1.0,-2.0), ( 4.0, 7.0)),
              ( ( 1.0,+2.0), (-4.0, 0.0), ( 0.0,-2.0)),
              ( ( 4.0,-7.0), ( 0.0, 2.0), ( 2.0, 0.0)));

        -- AB is A in band triangular storage scheme
        -- kd = 2
        AB := (( (0.0,0.0), (0.0,0.0) , A(1,3)),
               ( (0.0,0.0),  A(1,2)   , A(2,3)),
               (  A(1,1)  ,  A(2,2)   , A(3,3)) );

	lapack.CHBEV (
	JOBZ	 => 'V',
	UPLO	 => 'U',
	N	 => N,
	KD	 => KD,
	AB	 => AB,
	LDAB	 => LDAB,
	W	 => W,
	Z	 => Z,
	LDZ	 => N,
	WORK	 => WORK,
	RWORK	 => RWORK,
	INFO	 => INFO);

	-- Test if error
	if (INFO /= 0) then
	   Put ("ERROR ");
	   Put ( INFO );
	   New_line;
	end if;

	-- Verify routine
        ERR := 0.0;

        for I in W'Range(1) loop

          for J in A'Range(1) loop
            TMP := (0.0,0.0);

            for K in A'Range(2) loop
                TMP := TMP + ( A(J,K) * Z(K,I) ) ;
            end loop;

            TMP := TMP - ( W(I) * Z(J,I) );
            -- PUT (TMP);
            -- new_line;
            ERR := ERR + abs( TMP );
          end loop;
          
        end loop;
                

	PUT ( "Abs Error:");
	PUT ( ERR );
	New_line;

end tchbev;
