with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxbzm is
   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;
   use cxbbase.Double_Precision_IO;
   
   procedure zmf_inc ( N,M : Fortran_Integer;
			 I : in out Fortran_Complex_Star_16_Matrix );
   pragma Import ( Fortran, zmf_inc, "zmfinc_" );

   N    : constant := 3;

   M : Fortran_Complex_Star_16_Matrix (1 .. N, 1 .. N);

     procedure PUT ( X: Complex_Star_16 ) is 
      begin 
         PUT( X.Re );
         PUT( "," );
         PUT( X.Im );
     end PUT;
   
   procedure Put_Fortran (Item : in Fortran_Complex_Star_16_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            PUT (Item(I,J));
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;

begin   

   for I in M'Range loop
     for J in M'Range loop
       M(I,J) := ((Double_Precision(I + J) / 13.0),
	(Double_Precision(I - J) / 13.0));
     end loop;
   end loop;

   -- Put_Fortran (M);
   zmf_inc ( 3, 3, M );
   Put_line ("Check for passing Complex*16 array");
   put_line ("The result should be all one");
   Put_Fortran (M);

end cxbzm;
