-- OBJECTIVE: 
--      Check that the specification of the package Interfaces.FORTRAN
--      are available for use.
--
-- TEST DESCRIPTION:
--      This test verifies that the parameter is passed in out and in_out
-- to FORTRAN  subprogram correctly 
--      
--
--
-- CHANGE HISTORY:
--      19 SEP 85   Wasu    
--
--
with Ada.Text_IO;	
with Interfaces.FORTRAN; 
use Interfaces.FORTRAN;
with cxbbase;
use cxbbase;

procedure CXBZ is

     use Ada.Text_IO;
     use cxbbase.Double_Precision_IO;

     procedure PUT ( X: Complex_Star_16 ) is 
      begin 
	 PUT( X.Re );
         PUT( "," );
	 PUT( X.Im );
     end PUT;

     procedure ZF_INC ( A: in      Complex_Star_16;
                        B: out     Complex_Star_16;
                        C: in  out Complex_Star_16);
     pragma Import (Fortran, ZF_INC, "zfinc_");

     TST : Complex_Star_16;                     
     TST_I_S, TST_O_S, TST_IO_S: Complex_Star_16;

begin
         TST := (1.0/3.0 , 2.0/3.0);	
         TST_I_S  := TST;
         TST_O_S  := TST;
         TST_IO_S := TST;
	 PUT_LINE("Complex*16 number passing:");
         PUT_LINE("mode: in out in/out");
         PUT_LINE ("Ada send:");
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
	 New_Line;
	 ZF_INC ( TST_I_S, TST_O_S, TST_IO_S );
         PUT_LINE("Ada recieve:");                  
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
         New_Line;
	 TST := TST + (2.0/3.0, 1.0/3.0);
         PUT ( "3 Should be :" );
         PUT ( TST );
end CXBZ;

