-- subtype problem with pragma convention
-- see comments
-- Fconv3.adb
with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxbsm is

   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;
   use cxbbase.Real_IO;
   
   procedure smf_inc ( N,M : Fortran_Integer; I : in out Fortran_Real_Matrix );
   pragma Import ( Fortran, smf_inc, "smfinc_" );

   N    : constant := 3;

   M : Fortran_Real_Matrix (1 .. N, 1 .. N);

   
   procedure Put_Fortran (Item : in Fortran_Real_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            Put ( Real'Image(Item (I, J) ));
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;

begin   

   for I in M'Range loop
     for J in M'Range loop
       M(I,J) := Real(I + J) / 13.0;
     end loop;
   end loop;

   -- Put_Fortran (M);
   smf_inc ( 3, 3, M );
   PUT_LINE ( "Check for passing Real array");
   PUT_LINE ( "The resul should be all one");
   Put_Fortran (M);

end cxbsm;
