-- OBJECTIVE: 
--      Check that the specification of the package Interfaces.FORTRAN
--      are available for use.
--
-- TEST DESCRIPTION:
--      This test verifies that the parameter is passed in out and in_out
--  to FORTRAN subprogram correctly 
--      
--
--
-- CHANGE HISTORY:
--      19 SEP 85   Wasu    
--
--
with Ada.Text_IO;	
with Interfaces.FORTRAN; 
use Interfaces.FORTRAN;
with cxbbase;

procedure CXBS is

     use Ada.Text_IO;
     use cxbbase.Real_IO;

     procedure SF_INC ( A: in      Real;
                        B: out     Real;
                        C: in  out Real);
     pragma Import (Fortran, SF_INC, "sfinc_");

     TST : Real;                     
     TST_I_S, TST_O_S, TST_IO_S: Real;
begin
         TST := 1.0/3.0;	
         TST_I_S  := TST;
         TST_O_S  := TST;
         TST_IO_S := TST;
         PUT_LINE ("Real number passing:");
         PUT_LINE ("mode: in out in/out");
         PUT_LINE ("Ada send:");
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
	 New_Line;
	 SF_INC ( TST_I_S, TST_O_S, TST_IO_S );
         PUT_LINE("Ada recieve:");                  
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
         New_Line;
	 TST := TST + 2.0/3.0;
         PUT ( "3 Should be :" );
         PUT ( TST );
end CXBS;

