with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxblm is

   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;

   procedure lmf_inc ( N,M : Fortran_Integer; 
			I : in out Fortran_Logical_Matrix );
   pragma Import ( Fortran, lmf_inc, "lmfinc_" );

   N    : constant := 3;

   M : Fortran_Logical_Matrix( 1..N, 1..N);
   
   procedure Put_Fortran (Item : in Fortran_Logical_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            If Item(I,J) then
		Put ("T");
	    else 
		Put ("F");
	    end if;
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;
   
begin   

   for I in M'Range(1) loop
     for J in M'Range(2) loop
       M(I,J) := Logical( I > J);
     end loop;
   end loop;

   Put_line ("Ada logical array");
   Put_Fortran (M);
   lmf_inc ( 3, 3, M );
   Put_line ("back from Fortran");
   Put_Fortran (M);

end cxblm;
