-- OBJECTIVE: 
--      Check that the specification of the package Interfaces.FORTRAN
--      are available for use.
--
-- TEST DESCRIPTION:
--      This test verifies that the parameter is passed in out and in_out
-- to FORTRAN  subprogram correctly 
--      
--
--
-- CHANGE HISTORY:
--      19 SEP 85   Wasu    
--
--
with Ada.Text_IO;	
with Interfaces.FORTRAN; 
use Interfaces.FORTRAN;

procedure CXBL is

     use Ada.Text_IO;

     procedure PUT ( x: Logical ) is
        begin 
	if x then
	  PUT('T');
        else 
         PUT('F');
        end if;
        end PUT;

        
     procedure LF_INC ( I: in      Logical;
                        J: out     Logical;
                        K: in  out Logical);
     pragma Import (Fortran, LF_INC,"lfinc_");

                     
     TST_I_I, TST_O_I, TST_IO_I: Logical;
begin
	
         TST_I_I  := True;
         TST_O_I  := True;
         TST_IO_I := True;
	 PUT_LINE ("Logical value passing:");
         PUT_LINE ("mode: in out in/out");
         PUT_LINE ("Ada send:");

         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
      	 New_line;

	 LF_INC ( TST_I_I, TST_O_I, TST_IO_I );         
         PUT_LINE("Ada recieve and send:");         
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
         New_line;       

	 LF_INC ( TST_I_I, TST_O_I, TST_IO_I );         
         PUT_LINE("Ada recieve:");         
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
         New_line;       

end CXBL;


