-- subtype problem with pragma convention
-- see comments
-- Fconv3.adb
with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxbim is

   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;
   use cxbbase.Integer_IO;

   procedure imf_inc ( N,M : Fortran_Integer; I : in out Fortran_Integer_Matrix );
   pragma Import ( Fortran, imf_inc, "imfinc_" );

   N    : constant := 3;

   subtype Fortran_Int_Matrix is Fortran_Integer_Matrix (1 .. N, 1 .. N);

   M : Fortran_Int_Matrix;
   
   procedure Put_Fortran (Item : in Fortran_Int_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            Put ( Item (I, J) );
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;

   I, J, K : Fortran_Integer;
   
begin   

   for I in M'Range(1) loop
     for J in M'Range(2) loop
       M(I,J) := I * 10 + J;
     end loop;
   end loop;

   -- Put_Fortran (M);
   imf_inc ( 3, 3, M );
   Put_Line ("Check for passing Integer arrar");
   Put_Line ("The result should row colunm row colunm");
   Put_Fortran (M);

end cxbim;
