-- OBJECTIVE: 
--      Check that the specification of the package Interfaces.FORTRAN
--      are available for use.
--
-- TEST DESCRIPTION:
--      This test verifies that the parameter is passed in out and in_out
-- to FORTRAN  subprogram correctly 
--      
--
--
-- CHANGE HISTORY:
--      19 SEP 85   Wasu    
--
--
with Ada.Text_IO;	
with Interfaces.FORTRAN;
use Interfaces.FORTRAN;
with cxbbase;

procedure CXBI is

     use Ada.Text_IO;
     use cxbbase.Integer_IO;

     procedure IF_INC ( I: in      Fortran_Integer;
                        J: out     Fortran_Integer;
                        K: in  out Fortran_Integer);
     pragma Import (Fortran, IF_INC,"ifinc_");

                     
     TST_I_I, TST_O_I, TST_IO_I: Fortran_Integer;
begin
	
         TST_I_I  := 1;
         TST_O_I  := 1;
         TST_IO_I := 1;
         PUT_LINE("Integer number passing:");
	 PUT_LINE("mode: in out in/out");
	 PUT_LINE ("Ada send:");
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
	 New_Line;
	 IF_INC ( TST_I_I, TST_O_I, TST_IO_I );
	 PUT_LINE("Ada recieve:");         
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
         New_Line;
-- test for negative number
         TST_I_I  := -1;
         TST_O_I  := -1;
         TST_IO_I := -1;
         PUT_LINE ("Ada send:");
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
	 New_Line;
	 IF_INC ( TST_I_I, TST_O_I, TST_IO_I );         
         PUT_LINE("Ada recieve:");
         PUT ( TST_I_I );
         PUT ( TST_O_I );
         PUT ( TST_IO_I );
         New_Line;

end CXBI;
--  expect output is
--  1 1 1  ada
--  1 1 1  fortran
--  2 2 2  fortran
--  1 2 2  ada   first one is in 
--  -1 -1 -1  ada
--  -1 -1 -1  fortran
--  0  0  0  fortran
--  -1 0 0  ada   first one is in 
-- however read about discustion for these in readme.

