with Interfaces.Fortran;
use  Interfaces.Fortran;
with cxbbase;
use  cxbbase;
with Text_IO;
use  Text_IO;

procedure cxbfun1 is 
    type LFun_S_2 is access function (X,Y : in Real) 
         return Logical;
	 pragma Convention ( Fortran, LFun_S_2 );

    type LFun_D_2 is access function (X,Y : in Double_Precision) 
         return Logical;
	 pragma Convention ( Fortran, LFun_D_2 );

    type LFun_C_1 is access function (X : in Complex) 
         return Logical;
	 pragma Convention ( Fortran, LFun_C_1 );

    type LFun_Z_1 is access function (X : in Complex_Star_16) 
         return Logical;
	 pragma Convention ( Fortran, LFun_Z_1 );

	procedure f_fun1 ( F: LFun_S_2 );
	pragma Import ( Fortran, f_fun1, "ffun1_");

	procedure f_fun2 ( F: LFun_D_2 );
	pragma Import ( Fortran, f_fun2, "ffun2_");

	procedure f_fun3 ( F: LFun_C_1 );
	pragma Import ( Fortran, f_fun3, "ffun3_");
	
	procedure f_fun4 ( F: LFun_Z_1 );
	pragma Import ( Fortran, f_fun4, "ffun4_");

	function fun1 ( X, Y : Real ) return Logical is
	begin 
	    put ( Real'Image(X) );
	    put ( Real'Image(Y) );
	    return Logical ( X = Y );
	end fun1;	 	
	pragma Convention ( Fortran, fun1);

	function fun2 ( X, Y : Double_Precision ) return Logical is 
	begin
	    put ( Double_Precision'Image(X) );
	    put ( Double_Precision'Image(Y) );
		return Logical ( X = Y );
	end fun2;
	pragma Convention ( Fortran, fun2);

	function fun3 ( X : Complex ) return Logical is 
	begin
	    put ( Real'Image(Re(X)) );
	    put ( Real'Image(Im(X)) );
		return Logical ( Re(X) = Im(X) );
	end fun3;
	pragma Convention ( Fortran, fun3);

	function fun4 ( X : Complex_Star_16 ) return Logical is 
	begin
	    put ( Double_Precision'Image(Re(X)) );
	    put ( Double_Precision'Image(Im(X)) );
		return Logical ( Re(X) = Im(X) );
	end fun4;
	pragma Convention ( Fortran, fun4);

	x1 : Lfun_S_2;
	x2 : Lfun_D_2;
	x3 : Lfun_C_1;
	x4 : Lfun_Z_1;	
begin 

	x1 := fun1'Access;	
	f_fun1 ( x1 );

	x2 := fun2'Access;
	f_fun2 ( x2 );

	x3 := fun3'Access;
	f_fun3 ( x3 );

	x4 := fun4'Access;
	f_fun4 ( x4 );

end cxbfun1;
