-- subtype problem with pragma convention
-- see comments
-- Fconv3.adb
with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxbdm is

   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;
   use cxbbase.Double_Precision_IO;
   
   procedure dmf_inc ( N,M : Fortran_Integer; 
	                 I : in out Fortran_Double_Precision_Matrix );
   pragma Import ( Fortran, dmf_inc, "dmfinc_" );

   N    : constant := 3;

   M : Fortran_Double_Precision_Matrix (1 .. N, 1 .. N);

   
   procedure Put_Fortran (Item : in Fortran_Double_Precision_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            Put ( Double_Precision'Image(Item (I, J) ));
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;

begin   

   for I in M'Range loop
     for J in M'Range loop
       M(I,J) := Double_Precision(I + J) / 13.0;
     end loop;
   end loop;

   -- Put_Fortran (M);
   dmf_inc ( 3, 3, M );
   Put_Line("Check for passing Double precision array");
   Put_line("The result should be all one");
   Put_Fortran (M);

end cxbdm;
