-- OBJECTIVE: 
--      Check that the specification of the package Interfaces.FORTRAN
--      are available for use.
--
-- TEST DESCRIPTION:
--      This test verifies that the parameter is passed in out and in_out 
-- to FORTRAN  subprogram correctly 
--      
--
--
-- CHANGE HISTORY:
--      19 SEP 85   Wasu    
--
--
with Ada.Text_IO;	
with Interfaces.FORTRAN; 
use Interfaces.FORTRAN;
with cxbbase;

procedure CXBD is

     use Ada.Text_IO;
     use cxbbase.Double_Precision_IO;

     procedure DF_INC ( A: in      Double_Precision;
                        B: out     Double_Precision;
                        C: in  out Double_Precision);
     pragma Import (Fortran, DF_INC, "dfinc_");

     TST : Double_Precision;                     
     TST_I_S, TST_O_S, TST_IO_S: Double_Precision;
begin
         TST := 1.0/3.0;	
         TST_I_S  := TST;
         TST_O_S  := TST;
         TST_IO_S := TST;
	 PUT_LINE("Double Precision number passing:");
         PUT_LINE("mode: in out in/out");
         PUT_LINE ("Ada send:");	 
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
	 New_Line;
	 DF_INC ( TST_I_S, TST_O_S, TST_IO_S );
         PUT_LINE("Ada recieve:");                  
         PUT ( TST_I_S );
         PUT ( TST_O_S );
         PUT ( TST_IO_S );
         New_Line;
	 TST := TST + 2.0/3.0;
         PUT ( " 3 Should be :" );
         PUT ( TST );
end CXBD;

