with Ada.Text_IO;
with Interfaces.Fortran;
with cxbbase; 

procedure cxbcm is
   use Ada.Text_IO;
   use Interfaces.Fortran;
   use cxbbase;
   use cxbbase.Real_IO;
   
   procedure cmf_inc ( N,M : Fortran_Integer;
			 I : in out Fortran_Complex_Matrix );
   pragma Import ( Fortran, cmf_inc, "cmfinc_" );

   N    : constant := 3;

   M : Fortran_Complex_Matrix (1 .. N, 1 .. N);

     procedure PUT ( X: Complex ) is 
      begin 
         PUT( X.Re );
         PUT( "," );
         PUT( X.Im );
     end PUT;
   
   procedure Put_Fortran (Item : in Fortran_Complex_Matrix) is
   begin
      for I in Item'Range (1) loop
         for J in Item'Range (2) loop
            PUT (Item(I,J));
         end loop;
         New_Line;
      end loop;
      New_Line;
   end Put_Fortran;

begin   

   for I in M'Range loop
     for J in M'Range loop
       M(I,J) := ((Real(I + J) / 13.0),(Real(I - J) / 13.0));
     end loop;
   end loop;

   -- Put_Fortran (M);
   cmf_inc ( 3, 3, M );
   Put_line ( "Check for passing complex array");
   Put_line ("The result shoud be all one");
   Put_Fortran (M);

end cxbcm;
