with Ada.Numerics.Generic_Complex_Types;
with Ada.Text_IO; use Ada.Text_IO;
with Interfaces.Fortran; use  Interfaces.Fortran;

package cxbbase is

    --  Fortran complex*16 may be define in standard lib
    --  but didn't include by now, so define here.

    package Double_Precision_Complex_Types is
       new Ada.Numerics.Generic_Complex_Types (Double_Precision);

    type Complex_Star_16 is new Double_Precision_Complex_Types.Complex;

    type Imaginary_Star_16 is new Double_Precision_Complex_Types.Imaginary;
        i : constant Imaginary_Star_16
          := Imaginary_Star_16 (Double_Precision_Complex_Types.i);
        j : constant Imaginary_Star_16
          := Imaginary_Star_16 (Double_Precision_Complex_Types.j);

    -- Fortran Vector type

    type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
	 of Fortran_Integer;
    pragma Convention (Fortran, Fortran_Integer_Vector);

    type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
    pragma Convention (Fortran, Fortran_Real_Vector);

    type Fortran_Double_Precision_Vector is array (Fortran_Integer range <>) 
         of Double_Precision;
    pragma Convention (Fortran, Fortran_Double_Precision_Vector);

    type Fortran_Complex_Vector is array (Fortran_Integer range <>) 
         of Complex;
    pragma Convention (Fortran, Fortran_Complex_Vector);

    type Fortran_Complex_Star_16_Vector is array (Fortran_Integer range <>) 
         of Complex_Star_16;
    pragma Convention (Fortran, Fortran_Complex_Star_16_Vector);

    type Fortran_Logical_Vector is array (Fortran_Integer range <>) 
         of Logical;
    pragma Convention (Fortran, Fortran_Logical_Vector);


    -- Fortran Matrics type

    type Fortran_Integer_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>) 
         of Fortran_Integer;
    pragma Convention (Fortran, Fortran_Integer_Matrix);

    type Fortran_Real_Matrix is array (Fortran_Integer range <>,
                                       Fortran_Integer range <>) 
         of Real;
    pragma Convention (Fortran, Fortran_Real_Matrix);

    type Fortran_Double_Precision_Matrix is array (Fortran_Integer range <>,
                                                   Fortran_Integer range <>) 
         of Double_Precision;
    pragma Convention (Fortran, Fortran_Double_Precision_Matrix);

    type Fortran_Complex_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>) 
         of Complex;
    pragma Convention (Fortran, Fortran_Complex_Matrix);

    type Fortran_Complex_Star_16_Matrix is array (Fortran_Integer range <>,
                                                  Fortran_Integer range <>) 
         of Complex_Star_16;
    pragma Convention (Fortran, Fortran_Complex_Star_16_Matrix);

    type Fortran_Logical_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>)
         of Logical;
    pragma Convention (Fortran, Fortran_Logical_Matrix);

    -- Temporary define
    -- function name passing to xGEESx fortran subroutine 
    -- SELECT parameter rename to LSELECT 

    type LFun_S_2 is access function (X,Y : in Real) 
         return Logical;
    type LFun_D_2 is access function (X,Y : in Double_Precision) 
         return Logical;
    type LFun_C_1 is access function (X : in Complex) 
         return Logical;
    type LFun_Z_1 is access function (X : in Complex_Star_16) 
         return Logical;


    package Integer_IO is new Ada.Text_IO.Integer_IO( Fortran_Integer );
    package Real_IO is new Ada.Text_IO.Float_IO( Real );
    package Double_Precision_IO is new Ada.Text_IO.Float_IO( Double_Precision );

end cxbbase;

