#!/usr/bin/perl

# Program to translate Lapack Fortran Source code to Ada specification
# Written by Wasu Chaopanon
# Please read Changelog for more information
# usage:  fs2a < file.f > file.ads
# version 0.2


%farg = ("","");
$t = "";
$type_f = "";
$rt_type = "";

%re_arg = ("DELTA" , "V_DELTA" ,
	   "IN"    , "P_IN"    ,
	   "RANGE" , "M_RANGE" ,
	   "SELECT", "L_SELECT",
	   "TYPE"  , "M_TYPE" );

# get subroutine name and function
# at the first line of Fortran declaration

header: while ( <STDIN> ) {
    
    last header if (/^\*/);  
    
    if ( /SUBROUTINE/ ) { 
	$type_f = "procedure ";
	$subn = $'; 
	chop $subn;
	
    } elsif ( /FUNCTION/ ) {
	$type_f = "function "; 
	$subn = $';
	$rt_type = $_;
	chop $subn;
    } else {
	$subn .= substr($_,9);
	chop $subn;
    }
    
} 

$func = ( $type_f =~ /F/);

#get parameter list
#print $subn,"\n";

$subn =~ s/ //g;
( $subname , @sarg) = split ( /\(|\,|\)|\n/, $subn);

# We have function name and parameter here

# Get lapack version and routine type 
lp: while ( <STDIN> ) {
    last lp if (!/^\*/);
    if (/LAPACK/) {
	$rtype = $';
	last lp;
    };
	
};

$rtype = "LAPACK" . $rtype;

# determine parameter type 

arg:  while ( <STDIN> ) {

    last arg if (/======/);
    next arg if (/^\*/);
    if (/ INTEGER /) {
	$t = "Fortran_Integer";
	$_ = $';

    } elsif (/ REAL /)   {
	$t = "Real";
	$_ = $';

    } elsif (/ PRECISION /) {
	$t = "Double_Precision";
	$_ = $';

    } elsif (/ COMPLEX/){
	if ( /COMPLEX\*16/) {
	    $t = "Complex_Star_16";
	} else {
	    $t = "Complex";
	}
	$_ = $';

    } elsif (/ LOGICAL/){
	$t = "Logical";
	$_ = $';
    } elsif (/ CHARACTER/) {
	if (/CHARACTER\*1/ | /CHARACTER / | /CHARACTER\n/ ) {
	    $t = "Character";
	    $_ = $';
	} else {
	    m/\*./; 
	    m/\)/;
	    $t = "String";
	    $_ = $';	
	}
    } else { $_ = substr( $_,9) }
	    
    s/ //g;
    chop;

    # for parameter that have ( is matrix
    # and () is vector 

    foreach $j ( split ( /\,/, $_) ) {
	#print  "\"",$j,"\""," ",$t, "\n";

	if ($j=~ s/\(.*\)//o  ) { 
	    if ( $t =~ /^F/ ) {        #Fortran_Int
		$t1 = $t."_Vector";
	    } else {
		$t1 = "Fortran_".$t."_Vector";
	    }
	}elsif ( $j=~ s/\(.*//o ){
	    if ( $t =~ /^F/ ) {        #Fortran_Int
		$t1 = $t."_Matrix";
	    } else {
		$t1 = "Fortran_".$t."_Matrix";
	    }
	} else { 
	    $t1 = $t 
	    }
	$farg{$j} = $t1;
    }	   	
};

$pur = "";
$_ = <STDIN>;

#purpose here

 skip2: while ( <STDIN> ) {
     last skip2 if ( /=========/ | /^\* Description/ );
     last skip2 if ( /^\*$/ );
     s/^\*/--/;
     $pur .= $_;
 };

# parameter also in argument list that have mode here
# check mode "in" "out" "in out" for "workspace"
# change to "in out" mode

if (! $func) {
 mode: while ( <STDIN> ) {

     last mode if ( !/\*/ );
     
     #if ( /\(input\)/ )  { ($k) = split; print $k,"\n" };
     if ( /\(output\)/ )  { 
	 ($tmp, $k) = split(/ +/);
	 $farg{$k} = "out ".$farg{$k};
     };
     if ( /\(workspace.*\)/ ) {
	 ($tmp, $k) = split(/ +/);
	 $farg{$k} = "in out ".$farg{$k};
     };	
     
     #print $k,"\n";
     
 };

};

# For all information we have
# print in Ada format

#comment first

print "--  ", $rtype;
print $pur;
print "\n";

if (scalar(@sarg) > 0 ) {	
    print $type_f,$subname, " (\n";
    $k = "";			

    foreach $i ( @sarg ) {
	if ( $re_arg{$i} eq "" ) {
	    $k .= "\t".$i."\t : ";
	}else{
	    $k .= "\t".$re_arg{$i}."\t : ";
	};
	$k .= $farg{$i}.";\n";
    };

    chop $k;
    chop $k;
    print $k;
    print " )";
} else {
    print $type_f,$subname;
}
				
# for function print return type statement
if ( $type_f =~ /F/ ) {
    $_ = $rt_type;
    
    if (/INTEGER/) {
	$t = "Fortran_Integer";

    } elsif (/REAL/)   {
	$t = "Real";
	
    } elsif (/PRECISION/) {
	$t = "Double_Precision";
	
    } elsif (/COMPLEX/){
	if ( /COMPLEX*16/) {
	    $t = "Comples_Star_16";
	} else {
	    $t = "Complex";
	}
	
    } elsif (/LOGICAL/){
	$t = "Logical";
	
    } elsif (/CHARACTER/) {
	print $_;
	if (/CHARACTER*1/ | /CHARACTER / | /CHARACTER\n/ ) {
	    $t = "Character";
	} else {
	    $t = "String";
	}
    } else { $t = "ERROR" }
    
    
    print " Return ", $t;
};

print ";\n";

#print pragma import
print "\n";
$lsubname = $subname;
$lsubname =~ tr/[A-Z]/[a-z]/;	
$lsubname = "\"".$lsubname."_"."\"";
print "pragma Import ( Fortran, ",$subname;
print ", ", $lsubname, ");\n";
print "\n";

#end program





