#change history
# name              changes
# -----             ---------------------------
# Nasser M. Abbasi  073012  initial

SHELL = /bin/bash 

CURRENT_DIR := $(shell pwd)
CLICK_STOPWATCH = date
SYSTEM_LIBRARIES_LOCATION = /usr/lib

all:: 
	+$(LOOP_OVER_DIRS)

clean::
	+$(LOOP_OVER_DIRS)
	
testing::	
	+$(LOOP_OVER_DIRS)

EXIT_ON_ERROR	= +e

ifdef DIRS
LOOP_OVER_DIRS =						\
	@for d in $(DIRS); do					\
		if test -d $$d; then				\
			set $(EXIT_ON_ERROR);			\
			echo "cd $$d; make $@";		\
			cd $$d; make $@; cd ..;		\
			set +e;					\
		else						\
			echo "Skipping non-directory $$d...";	\
		fi;						\
		$(CLICK_STOPWATCH);				\
done

$(DIRS)::
	@if test -d $@; then				\
		set $(EXIT_ON_ERROR);			\
		echo "cd $@; make $@";			\
		cd $@; make $@;				\
		set +e;					\
	else						\
		echo "Skipping non-directory $@...";	\
	fi						\
	$(CLICK_STOPWATCH);
endif # DIRS

#
# Don't delete these files if we get killed.
#
.PRECIOUS: .adb .ads

#
#
.PHONY: all clean FORCE $(DIRS)
