------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------
with Interfaces.Fortran; use  Interfaces.Fortran;
with labase; use  labase;

package ladrv is

--  LAPACK driver routine (version 2.0) --
--  CGBSV computes the solution to a complex system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure CGBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBSV, "cgbsv_");

--  LAPACK driver routine (version 2.0) --
--  CGBSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure CGBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBSVX, "cgbsvx_");

--  LAPACK driver routine (version 2.0) --
--  CGEEV computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure CGEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEEV, "cgeev_");

--  LAPACK driver routine (version 2.0) --
--  CGEEVX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure CGEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	ABNRM	 : out Real;
	RCONDE	 : out Fortran_Real_Vector;
	RCONDV	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEEVX, "cgeevx_");

--  LAPACK driver routine (version 2.0) --
--  SGEGS computes for a pair of N-by-N complex nonsymmetric matrices A,
--  B:  the generalized eigenvalues (alpha, beta), the complex Schur
--  form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure CGEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	VSL	 : out Fortran_Complex_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Complex_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEGS, "cgegs_");

--  LAPACK driver routine (version 2.0) --
--  CGEGV computes for a pair of N-by-N complex nonsymmetric matrices A
--  and B, the generalized eigenvalues (alpha, beta), and optionally,
--  the left and/or right generalized eigenvectors (VL and VR).

procedure CGEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEGV, "cgegv_");

--  LAPACK driver routine (version 2.0) --
--  CGELS solves overdetermined or underdetermined complex linear systems
--  involving an M-by-N matrix A, or its conjugate-transpose, using a QR
--  or LQ factorization of A.  It is assumed that A has full rank.

procedure CGELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGELS, "cgels_");

--  LAPACK driver routine (version 2.0) --
--  CGELSS computes the minimum norm solution to a complex linear
--  least squares problem:

procedure CGELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGELSS, "cgelss_");

--  LAPACK driver routine (version 2.0) --
--  CGELSX computes the minimum-norm solution to a complex linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure CGELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGELSX, "cgelsx_");

--  LAPACK driver routine (version 2.0) --
--  CGESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure CGESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGESV, "cgesv_");

--  LAPACK driver routine (version 2.0) --
--  CGESVD computes the singular value decomposition (SVD) of a complex
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure CGESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Complex_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGESVD, "cgesvd_");

--  LAPACK driver routine (version 2.0) --
--  CGESVX uses the LU factorization to compute the solution to a complex
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure CGESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGESVX, "cgesvx_");

--  LAPACK driver routine (version 2.0) --
--  CGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure CGGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Complex_Vector;
	X	 : out Fortran_Complex_Vector;
	Y	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGGLM, "cggglm_");

--  LAPACK driver routine (version 2.0) --
--  CGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure CGGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	X	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGLSE, "cgglse_");

--  LAPACK driver routine (version 2.0) --
--  CGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N complex matrix A and P-by-N complex matrix B:

procedure CGGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGSVD, "cggsvd_");

--  LAPACK driver routine (version 2.0) --
--  CHBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.

procedure CHBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBEV, "chbev_");

--  LAPACK driver routine (version 2.0) --
--  CHBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.  If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure CHBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBEVD, "chbevd_");

--  LAPACK driver routine (version 2.0) --
--  CHBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian band matrix A.  Eigenvalues and eigenvectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure CHBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBEVX, "chbevx_");

--  LAPACK driver routine (version 2.0) --
--  CHBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be Hermitian
--  and banded, and B is also positive definite.

procedure CHBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBGV, "chbgv_");

--  LAPACK driver routine (version 2.0) --
--  CHEEV computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.

procedure CHEEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEEV, "cheev_");

--  LAPACK driver routine (version 2.0) --
--  CHEEVD computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.  If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure CHEEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEEVD, "cheevd_");

--  LAPACK driver routine (version 2.0) --
--  CHEEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure CHEEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEEVX, "cheevx_");

--  LAPACK driver routine (version 2.0) --
--  CHEGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian and B is also
--  positive definite.

procedure CHEGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEGV, "chegv_");

--  LAPACK driver routine (version 2.0) --
--  CHESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure CHESV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHESV, "chesv_");

--  LAPACK driver routine (version 2.0) --
--  CHESVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure CHESVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHESVX, "chesvx_");

--  LAPACK driver routine (version 2.0) --
--  CHPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix in packed storage.

procedure CHPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPEV, "chpev_");

--  LAPACK driver routine (version 2.0) --
--  CHPEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian matrix A in packed storage.  If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure CHPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPEVD, "chpevd_");

--  LAPACK driver routine (version 2.0) --
--  CHPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A in packed storage.
--  Eigenvalues/vectors can be selected by specifying either a range of
--  values or a range of indices for the desired eigenvalues.

procedure CHPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPEVX, "chpevx_");

--  LAPACK driver routine (version 2.0) --
--  CHPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian, stored in packed format,
--  and B is also positive definite.

procedure CHPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	BP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPGV, "chpgv_");

--  LAPACK driver routine (version 2.0) --
--  CHPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure CHPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPSV, "chpsv_");

--  LAPACK driver routine (version 2.0) --
--  CHPSVX uses the diagonal pivoting factorization A = U*D*U**H or
--  A = L*D*L**H to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N Hermitian matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure CHPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPSVX, "chpsvx_");

--  LAPACK driver routine (version 2.0) --
--  CPBSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure CPBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBSV, "cpbsv_");

--  LAPACK driver routine (version 2.0) --
--  CPBSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure CPBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBSVX, "cpbsvx_");

--  LAPACK driver routine (version 2.0) --
--  CPOSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure CPOSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOSV, "cposv_");

--  LAPACK driver routine (version 2.0) --
--  CPOSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure CPOSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOSVX, "cposvx_");

--  LAPACK driver routine (version 2.0) --
--  CPPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure CPPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPSV, "cppsv_");

--  LAPACK driver routine (version 2.0) --
--  CPPSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure CPPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPSVX, "cppsvx_");

--  LAPACK driver routine (version 2.0) --
--  CSPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure CSPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPSV, "cspsv_");

--  LAPACK driver routine (version 2.0) --
--  CSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure CSPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPSVX, "cspsvx_");

--  LAPACK driver routine (version 2.0) --
--  CSYSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure CSYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYSV, "csysv_");

--  LAPACK driver routine (version 2.0) --
--  CSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure CSYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYSVX, "csysvx_");

--  LAPACK driver routine (version 2.0) --
--  DGBSV computes the solution to a real system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure DGBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBSV, "dgbsv_");

--  LAPACK driver routine (version 2.0) --
--  DGBSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure DGBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBSVX, "dgbsvx_");

--  LAPACK driver routine (version 2.0) --
--  DGEEV computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure DGEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEEV, "dgeev_");

--  LAPACK driver routine (version 2.0) --
--  DGEEVX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure DGEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	ABNRM	 : out Double_Precision;
	RCONDE	 : out Fortran_Double_Precision_Vector;
	RCONDV	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEEVX, "dgeevx_");

--  LAPACK driver routine (version 2.0) --
--  DGEGS computes for a pair of N-by-N real nonsymmetric matrices A, B:
--  the generalized eigenvalues (alphar +/- alphai*i, beta), the real
--  Schur form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure DGEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	VSL	 : out Fortran_Double_Precision_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Double_Precision_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEGS, "dgegs_");

--  LAPACK driver routine (version 2.0) --
--  DGEGV computes for a pair of n-by-n real nonsymmetric matrices A and
--  B, the generalized eigenvalues (alphar +/- alphai*i, beta), and
--  optionally, the left and/or right generalized eigenvectors (VL and
--  VR).

procedure DGEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEGV, "dgegv_");

--  LAPACK driver routine (version 2.0) --
--  DGELS solves overdetermined or underdetermined real linear systems
--  involving an M-by-N matrix A, or its transpose, using a QR or LQ
--  factorization of A.  It is assumed that A has full rank.

procedure DGELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGELS, "dgels_");

--  LAPACK driver routine (version 2.0) --
--  DGELSS computes the minimum norm solution to a real linear least
--  squares problem:

procedure DGELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGELSS, "dgelss_");

--  LAPACK driver routine (version 2.0) --
--  DGELSX computes the minimum-norm solution to a real linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure DGELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGELSX, "dgelsx_");

--  LAPACK driver routine (version 2.0) --
--  DGESV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure DGESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGESV, "dgesv_");

--  LAPACK driver routine (version 2.0) --
--  DGESVD computes the singular value decomposition (SVD) of a real
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure DGESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Double_Precision_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGESVD, "dgesvd_");

--  LAPACK driver routine (version 2.0) --
--  DGESVX uses the LU factorization to compute the solution to a real
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure DGESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGESVX, "dgesvx_");

--  LAPACK driver routine (version 2.0) --
--  DGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure DGGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	X	 : out Fortran_Double_Precision_Vector;
	Y	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGGLM, "dggglm_");

--  LAPACK driver routine (version 2.0) --
--  DGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure DGGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	X	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGLSE, "dgglse_");

--  LAPACK driver routine (version 2.0) --
--  DGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N real matrix A and P-by-N real matrix B:

procedure DGGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGSVD, "dggsvd_");

--  LAPACK driver routine (version 2.0) --
--  DPBSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure DPBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBSV, "dpbsv_");

--  LAPACK driver routine (version 2.0) --
--  DPBSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure DPBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBSVX, "dpbsvx_");

--  LAPACK driver routine (version 2.0) --
--  DPOSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure DPOSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOSV, "dposv_");

--  LAPACK driver routine (version 2.0) --
--  DPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure DPOSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOSVX, "dposvx_");

--  LAPACK driver routine (version 2.0) --
--  DPPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure DPPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPSV, "dppsv_");

--  LAPACK driver routine (version 2.0) --
--  DPPSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure DPPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPSVX, "dppsvx_");

--  LAPACK driver routine (version 2.0) --
--  DSBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A.

procedure DSBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBEV, "dsbev_");

--  LAPACK driver routine (version 2.0) --
--  DSBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A. If eigenvectors are desired, it uses
--  a divide and conquer algorithm.

procedure DSBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBEVD, "dsbevd_");

--  LAPACK driver routine (version 2.0) --
--  DSBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric band matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure DSBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBEVX, "dsbevx_");

--  LAPACK driver routine (version 2.0) --
--  DSBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be symmetric
--  and banded, and B is also positive definite.

procedure DSBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Double_Precision_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBGV, "dsbgv_");

--  LAPACK driver routine (version 2.0) --
--  DSPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A in packed storage.

procedure DSPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPEV, "dspev_");

--  LAPACK driver routine (version 2.0) --
--  DSPEVD computes all the eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage. If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure DSPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPEVD, "dspevd_");

--  LAPACK driver routine (version 2.0) --
--  DSPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage.  Eigenvalues/vectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure DSPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPEVX, "dspevx_");

--  LAPACK driver routine (version 2.0) --
--  DSPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric, stored in packed format,
--  and B is also positive definite.

procedure DSPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	BP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPGV, "dspgv_");

--  LAPACK driver routine (version 2.0) --
--  DSPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure DSPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPSV, "dspsv_");

--  LAPACK driver routine (version 2.0) --
--  DSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a real system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure DSPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPSVX, "dspsvx_");

--  LAPACK driver routine (version 2.0) --
--  DSTEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix A.

procedure DSTEV (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEV, "dstev_");

--  LAPACK driver routine (version 2.0) --
--  DSTEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix. If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure DSTEVD (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEVD, "dstevd_");

--  LAPACK driver routine (version 2.0) --
--  DSTEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric tridiagonal matrix A.  Eigenvalues and
--  eigenvectors can be selected by specifying either a range of values
--  or a range of indices for the desired eigenvalues.

procedure DSTEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEVX, "dstevx_");

--  LAPACK driver routine (version 2.0) --
--  DSYEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A.

procedure DSYEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYEV, "dsyev_");

--  LAPACK driver routine (version 2.0) --
--  DSYEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A. If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure DSYEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYEVD, "dsyevd_");

--  LAPACK driver routine (version 2.0) --
--  DSYEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A.  Eigenvalues and eigenvectors can be
--  selected by specifying either a range of values or a range of indices
--  for the desired eigenvalues.

procedure DSYEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYEVX, "dsyevx_");

--  LAPACK driver routine (version 2.0) --
--  DSYGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric and B is also
--  positive definite.

procedure DSYGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYGV, "dsygv_");

--  LAPACK driver routine (version 2.0) --
--  DSYSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure DSYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYSV, "dsysv_");

--  LAPACK driver routine (version 2.0) --
--  DSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a real system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure DSYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYSVX, "dsysvx_");

--  LAPACK driver routine (version 2.0) --
--  SGBSV computes the solution to a real system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure SGBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBSV, "sgbsv_");

--  LAPACK driver routine (version 2.0) --
--  SGBSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure SGBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBSVX, "sgbsvx_");

--  LAPACK driver routine (version 2.0) --
--  SGEEV computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure SGEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEEV, "sgeev_");

--  LAPACK driver routine (version 2.0) --
--  SGEEVX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure SGEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	ABNRM	 : out Real;
	RCONDE	 : out Fortran_Real_Vector;
	RCONDV	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEEVX, "sgeevx_");

--  LAPACK driver routine (version 2.0) --
--  SGEGS computes for a pair of N-by-N real nonsymmetric matrices A, B:
--  the generalized eigenvalues (alphar +/- alphai*i, beta), the real
--  Schur form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure SGEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	VSL	 : out Fortran_Real_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Real_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEGS, "sgegs_");

--  LAPACK driver routine (version 2.0) --
--  SGEGV computes for a pair of n-by-n real nonsymmetric matrices A and
--  B, the generalized eigenvalues (alphar +/- alphai*i, beta), and
--  optionally, the left and/or right generalized eigenvectors (VL and
--  VR).

procedure SGEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEGV, "sgegv_");

--  LAPACK driver routine (version 2.0) --
--  SGELS solves overdetermined or underdetermined real linear systems
--  involving an M-by-N matrix A, or its transpose, using a QR or LQ
--  factorization of A.  It is assumed that A has full rank.

procedure SGELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGELS, "sgels_");

--  LAPACK driver routine (version 2.0) --
--  SGELSS computes the minimum norm solution to a real linear least
--  squares problem:

procedure SGELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGELSS, "sgelss_");

--  LAPACK driver routine (version 2.0) --
--  SGELSX computes the minimum-norm solution to a real linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure SGELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGELSX, "sgelsx_");

--  LAPACK driver routine (version 2.0) --
--  SGESV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure SGESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGESV, "sgesv_");

--  LAPACK driver routine (version 2.0) --
--  SGESVD computes the singular value decomposition (SVD) of a real
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure SGESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Real_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGESVD, "sgesvd_");

--  LAPACK driver routine (version 2.0) --
--  SGESVX uses the LU factorization to compute the solution to a real
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure SGESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGESVX, "sgesvx_");

--  LAPACK driver routine (version 2.0) --
--  SGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure SGGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	X	 : out Fortran_Real_Vector;
	Y	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGGLM, "sggglm_");

--  LAPACK driver routine (version 2.0) --
--  SGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure SGGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	X	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGLSE, "sgglse_");

--  LAPACK driver routine (version 2.0) --
--  SGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N real matrix A and P-by-N real matrix B:

procedure SGGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGSVD, "sggsvd_");

--  LAPACK driver routine (version 2.0) --
--  SPBSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure SPBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBSV, "spbsv_");

--  LAPACK driver routine (version 2.0) --
--  SPBSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure SPBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBSVX, "spbsvx_");

--  LAPACK driver routine (version 2.0) --
--  SPOSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure SPOSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOSV, "sposv_");

--  LAPACK driver routine (version 2.0) --
--  SPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure SPOSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOSVX, "sposvx_");

--  LAPACK driver routine (version 2.0) --
--  SPPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure SPPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPSV, "sppsv_");

--  LAPACK driver routine (version 2.0) --
--  SPPSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure SPPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPSVX, "sppsvx_");

--  LAPACK driver routine (version 2.0) --
--  SSBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A.

procedure SSBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBEV, "ssbev_");

--  LAPACK driver routine (version 2.0) --
--  SSBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A. If eigenvectors are desired, it uses
--  a divide and conquer algorithm.

procedure SSBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBEVD, "ssbevd_");

--  LAPACK driver routine (version 2.0) --
--  SSBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric band matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SSBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBEVX, "ssbevx_");

--  LAPACK driver routine (version 2.0) --
--  SSBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be symmetric
--  and banded, and B is also positive definite.

procedure SSBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Real_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBGV, "ssbgv_");

--  LAPACK driver routine (version 2.0) --
--  SSPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A in packed storage.

procedure SSPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPEV, "sspev_");

--  LAPACK driver routine (version 2.0) --
--  SSPEVD computes all the eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage. If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure SSPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPEVD, "sspevd_");

--  LAPACK driver routine (version 2.0) --
--  SSPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage.  Eigenvalues/vectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SSPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPEVX, "sspevx_");

--  LAPACK driver routine (version 2.0) --
--  SSPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric, stored in packed format,
--  and B is also positive definite.

procedure SSPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	BP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPGV, "sspgv_");

--  LAPACK driver routine (version 2.0) --
--  SSPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure SSPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPSV, "sspsv_");

--  LAPACK driver routine (version 2.0) --
--  SSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a real system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure SSPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPSVX, "sspsvx_");

--  LAPACK driver routine (version 2.0) --
--  SSTEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix A.

procedure SSTEV (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEV, "sstev_");

--  LAPACK driver routine (version 2.0) --
--  SSTEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix. If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure SSTEVD (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEVD, "sstevd_");

--  LAPACK driver routine (version 2.0) --
--  SSTEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric tridiagonal matrix A.  Eigenvalues and
--  eigenvectors can be selected by specifying either a range of values
--  or a range of indices for the desired eigenvalues.

procedure SSTEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEVX, "sstevx_");

--  LAPACK driver routine (version 2.0) --
--  SSYEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A.

procedure SSYEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYEV, "ssyev_");

--  LAPACK driver routine (version 2.0) --
--  SSYEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A. If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure SSYEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYEVD, "ssyevd_");

--  LAPACK driver routine (version 2.0) --
--  SSYEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A.  Eigenvalues and eigenvectors can be
--  selected by specifying either a range of values or a range of indices
--  for the desired eigenvalues.

procedure SSYEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYEVX, "ssyevx_");

--  LAPACK driver routine (version 2.0) --
--  SSYGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric and B is also
--  positive definite.

procedure SSYGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYGV, "ssygv_");

--  LAPACK driver routine (version 2.0) --
--  SSYSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SSYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYSV, "ssysv_");

--  LAPACK driver routine (version 2.0) --
--  SSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a real system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SSYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYSVX, "ssysvx_");

--  LAPACK driver routine (version 2.0) --
--  ZGBSV computes the solution to a complex system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure ZGBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBSV, "zgbsv_");

--  LAPACK driver routine (version 2.0) --
--  ZGBSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure ZGBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBSVX, "zgbsvx_");

--  LAPACK driver routine (version 2.0) --
--  ZGEEV computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure ZGEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEEV, "zgeev_");

--  LAPACK driver routine (version 2.0) --
--  ZGEEVX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure ZGEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	ABNRM	 : out Double_Precision;
	RCONDE	 : out Fortran_Double_Precision_Vector;
	RCONDV	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEEVX, "zgeevx_");

--  LAPACK driver routine (version 2.0) --
--  DGEGS computes for a pair of N-by-N complex nonsymmetric matrices A,
--  B:  the generalized eigenvalues (alpha, beta), the complex Schur
--  form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure ZGEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	VSL	 : out Fortran_Complex_Star_16_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Complex_Star_16_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEGS, "zgegs_");

--  LAPACK driver routine (version 2.0) --
--  ZGEGV computes for a pair of N-by-N complex nonsymmetric matrices A
--  and B, the generalized eigenvalues (alpha, beta), and optionally,
--  the left and/or right generalized eigenvectors (VL and VR).

procedure ZGEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEGV, "zgegv_");

--  LAPACK driver routine (version 2.0) --
--  ZGELS solves overdetermined or underdetermined complex linear systems
--  involving an M-by-N matrix A, or its conjugate-transpose, using a QR
--  or LQ factorization of A.  It is assumed that A has full rank.

procedure ZGELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGELS, "zgels_");

--  LAPACK driver routine (version 2.0) --
--  ZGELSS computes the minimum norm solution to a complex linear
--  least squares problem:

procedure ZGELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGELSS, "zgelss_");

--  LAPACK driver routine (version 2.0) --
--  ZGELSX computes the minimum-norm solution to a complex linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure ZGELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGELSX, "zgelsx_");

--  LAPACK driver routine (version 2.0) --
--  ZGESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure ZGESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGESV, "zgesv_");

--  LAPACK driver routine (version 2.0) --
--  ZGESVD computes the singular value decomposition (SVD) of a complex
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure ZGESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Complex_Star_16_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGESVD, "zgesvd_");

--  LAPACK driver routine (version 2.0) --
--  ZGESVX uses the LU factorization to compute the solution to a complex
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure ZGESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGESVX, "zgesvx_");

--  LAPACK driver routine (version 2.0) --
--  ZGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure ZGGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Complex_Star_16_Vector;
	X	 : out Fortran_Complex_Star_16_Vector;
	Y	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGGLM, "zggglm_");

--  LAPACK driver routine (version 2.0) --
--  ZGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure ZGGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	X	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGLSE, "zgglse_");

--  LAPACK driver routine (version 2.0) --
--  ZGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N complex matrix A and P-by-N complex matrix B:

procedure ZGGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGSVD, "zggsvd_");

--  LAPACK driver routine (version 2.0) --
--  ZHBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.

procedure ZHBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBEV, "zhbev_");

--  LAPACK driver routine (version 2.0) --
--  ZHBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.  If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure ZHBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBEVD, "zhbevd_");

--  LAPACK driver routine (version 2.0) --
--  ZHBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian band matrix A.  Eigenvalues and eigenvectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure ZHBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBEVX, "zhbevx_");

--  LAPACK driver routine (version 2.0) --
--  ZHBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be Hermitian
--  and banded, and B is also positive definite.

procedure ZHBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Star_16_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBGV, "zhbgv_");

--  LAPACK driver routine (version 2.0) --
--  ZHEEV computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.

procedure ZHEEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEEV, "zheev_");

--  LAPACK driver routine (version 2.0) --
--  ZHEEVD computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.  If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure ZHEEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEEVD, "zheevd_");

--  LAPACK driver routine (version 2.0) --
--  ZHEEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure ZHEEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEEVX, "zheevx_");

--  LAPACK driver routine (version 2.0) --
--  ZHEGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian and B is also
--  positive definite.

procedure ZHEGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEGV, "zhegv_");

--  LAPACK driver routine (version 2.0) --
--  ZHESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure ZHESV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHESV, "zhesv_");

--  LAPACK driver routine (version 2.0) --
--  ZHESVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure ZHESVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHESVX, "zhesvx_");

--  LAPACK driver routine (version 2.0) --
--  ZHPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix in packed storage.

procedure ZHPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPEV, "zhpev_");

--  LAPACK driver routine (version 2.0) --
--  ZHPEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian matrix A in packed storage.  If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure ZHPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPEVD, "zhpevd_");

--  LAPACK driver routine (version 2.0) --
--  ZHPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A in packed storage.
--  Eigenvalues/vectors can be selected by specifying either a range of
--  values or a range of indices for the desired eigenvalues.

procedure ZHPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPEVX, "zhpevx_");

--  LAPACK driver routine (version 2.0) --
--  ZHPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian, stored in packed format,
--  and B is also positive definite.

procedure ZHPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	BP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPGV, "zhpgv_");

--  LAPACK driver routine (version 2.0) --
--  ZHPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure ZHPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPSV, "zhpsv_");

--  LAPACK driver routine (version 2.0) --
--  ZHPSVX uses the diagonal pivoting factorization A = U*D*U**H or
--  A = L*D*L**H to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N Hermitian matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure ZHPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPSVX, "zhpsvx_");

--  LAPACK driver routine (version 2.0) --
--  ZPBSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure ZPBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBSV, "zpbsv_");

--  LAPACK driver routine (version 2.0) --
--  ZPBSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure ZPBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBSVX, "zpbsvx_");

--  LAPACK driver routine (version 2.0) --
--  ZPOSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure ZPOSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOSV, "zposv_");

--  LAPACK driver routine (version 2.0) --
--  ZPOSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure ZPOSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOSVX, "zposvx_");

--  LAPACK driver routine (version 2.0) --
--  ZPPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure ZPPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPSV, "zppsv_");

--  LAPACK driver routine (version 2.0) --
--  ZPPSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure ZPPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPSVX, "zppsvx_");

--  LAPACK driver routine (version 2.0) --
--  ZSPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure ZSPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPSV, "zspsv_");

--  LAPACK driver routine (version 2.0) --
--  ZSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure ZSPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPSVX, "zspsvx_");

--  LAPACK driver routine (version 2.0) --
--  ZSYSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure ZSYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYSV, "zsysv_");

--  LAPACK driver routine (version 2.0) --
--  ZSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure ZSYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYSVX, "zsysvx_");

--  LAPACK driver routine (version 2.0) --
--  SGEES computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure SGEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_S_2;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VS	 : out Fortran_Real_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEES, "sgees_");

--  LAPACK driver routine (version 2.0) --
--  SGEESX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure SGEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_S_2;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VS	 : out Fortran_Real_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Real;
	RCONDV	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEESX, "sgeesx_");

--  LAPACK driver routine (version 2.0) --
--  CGEES computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure CGEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_C_1;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : Fortran_Integer;
	W	 : Fortran_Complex_Vector;
	VS	 : Fortran_Complex_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : Fortran_Real_Vector;
	BWORK	 : Fortran_Logical_Vector;
	INFO	 : Fortran_Integer );

pragma Import ( Fortran, CGEES, "cgees_");

--  LAPACK driver routine (version 2.0) --
--  CGEESX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure CGEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_C_1;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VS	 : out Fortran_Complex_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Real;
	RCONDV	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEESX, "cgeesx_");

--  LAPACK driver routine (version 2.0) --
--  DGEES computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure DGEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_D_2;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VS	 : out Fortran_Double_Precision_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEES, "dgees_");

--  LAPACK driver routine (version 2.0) --
--  DGEESX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure DGEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_D_2;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VS	 : out Fortran_Double_Precision_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Double_Precision;
	RCONDV	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEESX, "dgeesx_");

--  LAPACK driver routine (version 2.0) --
--  ZGEES computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure ZGEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 :  LFun_Z_1;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VS	 : out Fortran_Complex_Star_16_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEES, "zgees_");

--  LAPACK driver routine (version 2.0) --
--  ZGEESX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure ZGEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_Z_1;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VS	 : out Fortran_Complex_Star_16_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Double_Precision;
	RCONDV	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEESX, "zgeesx_");

end ladrv;
