------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------
with Interfaces.Fortran; use  Interfaces.Fortran;
with labase; use  labase;

package lacmp is

--  LAPACK routine (version 2.0) --
--  CBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure CBDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VT	 : Fortran_Complex_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CBDSQR, "cbdsqr_");

--  LAPACK routine (version 2.0) --
--  CGBBRD reduces a complex general m-by-n band matrix A to real upper
--  bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure CGBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Complex_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBBRD, "cgbbrd_");

--  LAPACK routine (version 2.0) --
--  CGBCON estimates the reciprocal of the condition number of a complex
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by CGBTRF.

procedure CGBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBCON, "cgbcon_");

--  LAPACK routine (version 2.0) --
--  CGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure CGBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBEQU, "cgbequ_");

--  LAPACK routine (version 2.0) --
--  CGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure CGBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBRFS, "cgbrfs_");

--  LAPACK routine (version 2.0) --
--  CGBTF2 computes an LU factorization of a complex m-by-n band matrix
--  A using partial pivoting with row interchanges.

procedure CGBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBTF2, "cgbtf2_");

--  LAPACK routine (version 2.0) --
--  CGBTRF computes an LU factorization of a complex m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure CGBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBTRF, "cgbtrf_");

--  LAPACK routine (version 2.0) --
--  CGBTRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general band matrix A using the LU factorization computed
--  by CGBTRF.

procedure CGBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGBTRS, "cgbtrs_");

--  LAPACK routine (version 2.0) --
--  CGEBAK forms the right or left eigenvectors of a complex general
--  matrix by backward transformation on the computed eigenvectors of the
--  balanced matrix output by CGEBAL.

procedure CGEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEBAK, "cgebak_");

--  LAPACK routine (version 2.0) --
--  CGEBAL balances a general complex matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure CGEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEBAL, "cgebal_");

--  LAPACK routine (version 2.0) --
--  CGEBD2 reduces a complex general m by n matrix A to upper or lower
--  real bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure CGEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Complex_Vector;
	TAUP	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEBD2, "cgebd2_");

--  LAPACK routine (version 2.0) --
--  CGEBRD reduces a general complex M-by-N matrix A to upper or lower
--  bidiagonal form B by a unitary transformation: Q**H * A * P = B.

procedure CGEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Complex_Vector;
	TAUP	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEBRD, "cgebrd_");

--  LAPACK routine (version 2.0) --
--  CGECON estimates the reciprocal of the condition number of a general
--  complex matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by CGETRF.

procedure CGECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGECON, "cgecon_");

--  LAPACK routine (version 2.0) --
--  CGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure CGEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEEQU, "cgeequ_");

--  LAPACK routine (version 2.0) --
--  CGEHD2 reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure CGEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEHD2, "cgehd2_");

--  LAPACK routine (version 2.0) --
--  CGEHRD reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure CGEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEHRD, "cgehrd_");

--  LAPACK routine (version 2.0) --
--  CGELQ2 computes an LQ factorization of a complex m by n matrix A:
--  A = L * Q.

procedure CGELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGELQ2, "cgelq2_");

--  LAPACK routine (version 2.0) --
--  CGELQF computes an LQ factorization of a complex M-by-N matrix A:
--  A = L * Q.

procedure CGELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGELQF, "cgelqf_");

--  LAPACK routine (version 2.0) --
--  CGEQL2 computes a QL factorization of a complex m by n matrix A:
--  A = Q * L.

procedure CGEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEQL2, "cgeql2_");

--  LAPACK routine (version 2.0) --
--  CGEQLF computes a QL factorization of a complex M-by-N matrix A:
--  A = Q * L.

procedure CGEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEQLF, "cgeqlf_");

--  LAPACK routine (version 2.0) --
--  CGEQR2 computes a QR factorization of a complex m by n matrix A:
--  A = Q * R.

procedure CGEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEQR2, "cgeqr2_");

--  LAPACK routine (version 2.0) --
--  CGEQRF computes a QR factorization of a complex M-by-N matrix A:
--  A = Q * R.

procedure CGEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEQRF, "cgeqrf_");

--  LAPACK routine (version 2.0) --
--  CGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure CGERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGERFS, "cgerfs_");

--  LAPACK routine (version 2.0) --
--  CGERQ2 computes an RQ factorization of a complex m by n matrix A:
--  A = R * Q.

procedure CGERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGERQ2, "cgerq2_");

--  LAPACK routine (version 2.0) --
--  CGERQF computes an RQ factorization of a complex M-by-N matrix A:
--  A = R * Q.

procedure CGERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGERQF, "cgerqf_");

--  LAPACK routine (version 2.0) --
--  CGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure CGETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGETF2, "cgetf2_");

--  LAPACK routine (version 2.0) --
--  CGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure CGETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGETRF, "cgetrf_");

--  LAPACK routine (version 2.0) --
--  CGETRI computes the inverse of a matrix using the LU factorization
--  computed by CGETRF.

procedure CGETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGETRI, "cgetri_");

--  LAPACK routine (version 2.0) --
--  CGETRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by CGETRF.

procedure CGETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGETRS, "cgetrs_");

--  LAPACK routine (version 2.0) --
--  CGGBAK forms the right or left eigenvectors of a complex generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  CGGBAL.

procedure CGGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Real_Vector;
	RSCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGBAK, "cggbak_");

--  LAPACK routine (version 2.0) --
--  CGGBAL balances a pair of general complex matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure CGGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Real_Vector;
	RSCALE	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGBAL, "cggbal_");

--  LAPACK routine (version 2.0) --
--  CGGHRD reduces a pair of complex matrices (A,B) to generalized upper
--  Hessenberg form using unitary transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are unitary, and ' means conjugate transpose.

procedure CGGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGHRD, "cgghrd_");

--  LAPACK routine (version 2.0) --
--  CGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure CGGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGQRF, "cggqrf_");

--  LAPACK routine (version 2.0) --
--  CGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure CGGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGRQF, "cggrqf_");

--  LAPACK routine (version 2.0) --
--  CGGSVP computes unitary matrices U, V and Q such that

procedure CGGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	TAU	 : in out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGGSVP, "cggsvp_");

--  LAPACK routine (version 2.0) --
--  CGTCON estimates the reciprocal of the condition number of a complex
--  tridiagonal matrix A using the LU factorization as computed by
--  CGTTRF.

procedure CGTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTCON, "cgtcon_");

--  LAPACK routine (version 2.0) --
--  CGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure CGTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DLF	 : Fortran_Complex_Vector;
	DF	 : Fortran_Complex_Vector;
	DUF	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTRFS, "cgtrfs_");

--  LAPACK routine (version 2.0) --
--  CGTSV  solves the equation

procedure CGTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTSV, "cgtsv_");

--  LAPACK routine (version 2.0) --
--  CGTSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure CGTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DLF	 : Fortran_Complex_Vector;
	DF	 : Fortran_Complex_Vector;
	DUF	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTSVX, "cgtsvx_");

--  LAPACK routine (version 2.0) --
--  CGTTRF computes an LU factorization of a complex tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure CGTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : out Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTTRF, "cgttrf_");

--  LAPACK routine (version 2.0) --
--  CGTTRS solves one of the systems of equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by CGTTRF.

procedure CGTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGTTRS, "cgttrs_");

--  LAPACK routine (version 2.0) --
--  CHBGST reduces a complex Hermitian-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure CHBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBGST, "chbgst_");

--  LAPACK routine (version 2.0) --
--  CHBTRD reduces a complex Hermitian band matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure CHBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHBTRD, "chbtrd_");

--  LAPACK routine (version 2.0) --
--  CHECON estimates the reciprocal of the condition number of a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHETRF.

procedure CHECON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHECON, "checon_");

--  LAPACK routine (version 2.0) --
--  CHEGS2 reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure CHEGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEGS2, "chegs2_");

--  LAPACK routine (version 2.0) --
--  CHEGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure CHEGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHEGST, "chegst_");

--  LAPACK routine (version 2.0) --
--  CHERFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure CHERFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHERFS, "cherfs_");

--  LAPACK routine (version 2.0) --
--  CHETD2 reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q' * A * Q = T.

procedure CHETD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETD2, "chetd2_");

--  LAPACK routine (version 2.0) --
--  CHETF2 computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure CHETF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETF2, "chetf2_");

--  LAPACK routine (version 2.0) --
--  CHETRD reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure CHETRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETRD, "chetrd_");

--  LAPACK routine (version 2.0) --
--  CHETRF computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure CHETRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETRF, "chetrf_");

--  LAPACK routine (version 2.0) --
--  CHETRI computes the inverse of a complex Hermitian indefinite matrix
--  A using the factorization A = U*D*U**H or A = L*D*L**H computed by
--  CHETRF.

procedure CHETRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETRI, "chetri_");

--  LAPACK routine (version 2.0) --
--  CHETRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHETRF.

procedure CHETRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHETRS, "chetrs_");

--  LAPACK routine (version 2.0) --
--  CHGEQZ implements a single-shift version of the QZ
--  method for finding the generalized eigenvalues w(i)=ALPHA(i)/BETA(i)
--  of the equation

procedure CHGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHGEQZ, "chgeqz_");

--  LAPACK routine (version 2.0) --
--  CHPCON estimates the reciprocal of the condition number of a complex
--  Hermitian packed matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHPTRF.

procedure CHPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPCON, "chpcon_");

--  LAPACK routine (version 2.0) --
--  CHPGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form, using packed storage.

procedure CHPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	BP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPGST, "chpgst_");

--  LAPACK routine (version 2.0) --
--  CHPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure CHPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPRFS, "chprfs_");

--  LAPACK routine (version 2.0) --
--  CHPTRD reduces a complex Hermitian matrix A stored in packed form to
--  real symmetric tridiagonal form T by a unitary similarity
--  transformation: Q**H * A * Q = T.

procedure CHPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPTRD, "chptrd_");

--  LAPACK routine (version 2.0) --
--  CHPTRF computes the factorization of a complex Hermitian packed
--  matrix A using the Bunch-Kaufman diagonal pivoting method:

procedure CHPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPTRF, "chptrf_");

--  LAPACK routine (version 2.0) --
--  CHPTRI computes the inverse of a complex Hermitian indefinite matrix
--  A in packed storage using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHPTRF.

procedure CHPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPTRI, "chptri_");

--  LAPACK routine (version 2.0) --
--  CHPTRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A stored in packed format using the factorization
--  A = U*D*U**H or A = L*D*L**H computed by CHPTRF.

procedure CHPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHPTRS, "chptrs_");

--  LAPACK routine (version 2.0) --
--  CHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a complex upper Hessenberg matrix H.

procedure CHSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Fortran_Complex_Vector;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHSEIN, "chsein_");

--  LAPACK routine (version 2.0) --
--  CHSEQR computes the eigenvalues of a complex upper Hessenberg
--  matrix H, and, optionally, the matrices T and Z from the Schur
--  decomposition H = Z T Z**H, where T is an upper triangular matrix
--  (the Schur form), and Z is the unitary matrix of Schur vectors.

procedure CHSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CHSEQR, "chseqr_");

--  LAPACK routine (version 2.0) --
--  Using the divide and conquer method, CLAED0 computes all eigenvalues
--  of a symmetric tridiagonal matrix which is one diagonal block of
--  those from reducing a dense or band Hermitian matrix and
--  corresponding eigenvectors of the dense or band matrix.

procedure CLAED0 (
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Complex_Matrix;
	LDQS	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAED0, "claed0_");

--  LAPACK routine (version 2.0) --
--  CLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense or banded
--  Hermitian matrix that has been reduced to tridiagonal form.

procedure CLAED7 (
	N	 : Fortran_Integer;
	CUTPNT	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	INDXQ	 : out Fortran_Integer_Vector;
	QSTORE	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAED7, "claed7_");

--  LAPACK routine (version 2.0) --
--  CLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure CLAED8 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Complex_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INDXQ	 : Fortran_Integer_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Real_Matrix;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAED8, "claed8_");

--  LAPACK routine (version 2.0) --
--  CLAHEF computes a partial factorization of a complex Hermitian
--  matrix A using the Bunch-Kaufman diagonal pivoting method. The
--  partial factorization has the form:

procedure CLAHEF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAHEF, "clahef_");

--  LAPACK routine (version 2.0) --
--  CLASYF computes a partial factorization of a complex symmetric matrix
--  A using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure CLASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLASYF, "clasyf_");

--  LAPACK routine (version 2.0) --
--  CLATZM applies a Householder matrix generated by CTZRQF to a matrix.

procedure CLATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex;
	C1	 : Fortran_Complex_Matrix;
	C2	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector );

pragma Import ( Fortran, CLATZM, "clatzm_");

--  LAPACK routine (version 2.0) --
--  CPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite band matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  CPBTRF.

procedure CPBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBCON, "cpbcon_");

--  LAPACK routine (version 2.0) --
--  CPBEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure CPBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBEQU, "cpbequ_");

--  LAPACK routine (version 2.0) --
--  CPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure CPBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBRFS, "cpbrfs_");

--  LAPACK routine (version 2.0) --
--  CPBSTF computes a split Cholesky factorization of a complex
--  Hermitian positive definite band matrix A.

procedure CPBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBSTF, "cpbstf_");

--  LAPACK routine (version 2.0) --
--  CPBTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure CPBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBTF2, "cpbtf2_");

--  LAPACK routine (version 2.0) --
--  CPBTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure CPBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBTRF, "cpbtrf_");

--  LAPACK routine (version 2.0) --
--  CPBTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite band matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by CPBTRF.

procedure CPBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPBTRS, "cpbtrs_");

--  LAPACK routine (version 2.0) --
--  CPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite matrix using the
--  Cholesky factorization A = U**H*U or A = L*L**H computed by CPOTRF.

procedure CPOCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOCON, "cpocon_");

--  LAPACK routine (version 2.0) --
--  CPOEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure CPOEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOEQU, "cpoequ_");

--  LAPACK routine (version 2.0) --
--  CPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure CPORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPORFS, "cporfs_");

--  LAPACK routine (version 2.0) --
--  CPOTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure CPOTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOTF2, "cpotf2_");

--  LAPACK routine (version 2.0) --
--  CPOTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure CPOTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOTRF, "cpotrf_");

--  LAPACK routine (version 2.0) --
--  CPOTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by CPOTRF.

procedure CPOTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOTRI, "cpotri_");

--  LAPACK routine (version 2.0) --
--  CPOTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A using the Cholesky factorization 
--  A = U**H*U or A = L*L**H computed by CPOTRF.

procedure CPOTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPOTRS, "cpotrs_");

--  LAPACK routine (version 2.0) --
--  CPPCON estimates the reciprocal of the condition number (in the 
--  1-norm) of a complex Hermitian positive definite packed matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  CPPTRF.

procedure CPPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPCON, "cppcon_");

--  LAPACK routine (version 2.0) --
--  CPPEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure CPPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPEQU, "cppequ_");

--  LAPACK routine (version 2.0) --
--  CPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure CPPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPRFS, "cpprfs_");

--  LAPACK routine (version 2.0) --
--  CPPTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A stored in packed format.

procedure CPPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPTRF, "cpptrf_");

--  LAPACK routine (version 2.0) --
--  CPPTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by CPPTRF.

procedure CPPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPTRI, "cpptri_");

--  LAPACK routine (version 2.0) --
--  CPPTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**H*U or A = L*L**H computed by CPPTRF.

procedure CPPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPPTRS, "cpptrs_");

--  LAPACK routine (version 2.0) --
--  CPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite tridiagonal matrix
--  using the factorization A = L*D*L**H or A = U**H*D*U computed by
--  CPTTRF.

procedure CPTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTCON, "cptcon_");

--  LAPACK routine (version 2.0) --
--  CPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using SPTTRF and then calling CBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure CPTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTEQR, "cpteqr_");

--  LAPACK routine (version 2.0) --
--  CPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure CPTRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTRFS, "cptrfs_");

--  LAPACK routine (version 2.0) --
--  CPTSV computes the solution to a complex system of linear equations
--  A*X = B, where A is an N-by-N Hermitian positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure CPTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTSV, "cptsv_");

--  LAPACK routine (version 2.0) --
--  CPTSVX uses the factorization A = L*D*L**H to compute the solution
--  to a complex system of linear equations A*X = B, where A is an
--  N-by-N Hermitian positive definite tridiagonal matrix and X and B
--  are N-by-NRHS matrices.

procedure CPTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTSVX, "cptsvx_");

--  LAPACK routine (version 2.0) --
--  CPTTRF computes the factorization of a complex Hermitian positive
--  definite tridiagonal matrix A.

procedure CPTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTTRF, "cpttrf_");

--  LAPACK routine (version 2.0) --
--  CPTTRS solves a system of linear equations A * X = B with a
--  Hermitian positive definite tridiagonal matrix A using the
--  factorization A = U**H*D*U or A = L*D*L**H computed by CPTTRF.

procedure CPTTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CPTTRS, "cpttrs_");

--  LAPACK routine (version 2.0) --
--  CSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric packed matrix A using the
--  factorization A = U*D*U**T or A = L*D*L**T computed by CSPTRF.

procedure CSPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPCON, "cspcon_");

--  LAPACK routine (version 2.0) --
--  CSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure CSPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPRFS, "csprfs_");

--  LAPACK routine (version 2.0) --
--  CSPTRF computes the factorization of a complex symmetric matrix A
--  stored in packed format using the Bunch-Kaufman diagonal pivoting
--  method:

procedure CSPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPTRF, "csptrf_");

--  LAPACK routine (version 2.0) --
--  CSPTRI computes the inverse of a complex symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by CSPTRF.

procedure CSPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPTRI, "csptri_");

--  LAPACK routine (version 2.0) --
--  CSPTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by CSPTRF.

procedure CSPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSPTRS, "csptrs_");

--  LAPACK routine (version 2.0) --
--  CSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if CHETRD or CHPTRD or CHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure CSTEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSTEDC, "cstedc_");

--  LAPACK routine (version 2.0) --
--  CSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure CSTEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Real_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSTEIN, "cstein_");

--  LAPACK routine (version 2.0) --
--  CSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if CHETRD or CHPTRD or CHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure CSTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSTEQR, "csteqr_");

--  LAPACK routine (version 2.0) --
--  CSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by CSYTRF.

procedure CSYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYCON, "csycon_");

--  LAPACK routine (version 2.0) --
--  CSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure CSYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYRFS, "csyrfs_");

--  LAPACK routine (version 2.0) --
--  CSYTF2 computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure CSYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYTF2, "csytf2_");

--  LAPACK routine (version 2.0) --
--  CSYTRF computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure CSYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYTRF, "csytrf_");

--  LAPACK routine (version 2.0) --
--  CSYTRI computes the inverse of a complex symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  CSYTRF.

procedure CSYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYTRI, "csytri_");

--  LAPACK routine (version 2.0) --
--  CSYTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by CSYTRF.

procedure CSYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CSYTRS, "csytrs_");

--  LAPACK routine (version 2.0) --
--  CTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure CTBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTBCON, "ctbcon_");

--  LAPACK routine (version 2.0) --
--  CTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure CTBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTBRFS, "ctbrfs_");

--  LAPACK routine (version 2.0) --
--  CTBTRS solves a triangular system of the form

procedure CTBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTBTRS, "ctbtrs_");

--  LAPACK routine (version 2.0) --
--  CTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of complex upper triangular matrices (A,B).

procedure CTGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTGEVC, "ctgevc_");

--  LAPACK routine (version 2.0) --
--  CTGSJA computes the generalized singular value decomposition (GSVD)
--  of two complex upper triangular (or trapezoidal) matrices A and B.

procedure CTGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTGSJA, "ctgsja_");

--  LAPACK routine (version 2.0) --
--  CTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure CTPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTPCON, "ctpcon_");

--  LAPACK routine (version 2.0) --
--  CTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure CTPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTPRFS, "ctprfs_");

--  LAPACK routine (version 2.0) --
--  CTPTRI computes the inverse of a complex upper or lower triangular
--  matrix A stored in packed format.

procedure CTPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTPTRI, "ctptri_");

--  LAPACK routine (version 2.0) --
--  CTPTRS solves a triangular system of the form

procedure CTPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTPTRS, "ctptrs_");

--  LAPACK routine (version 2.0) --
--  CTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure CTRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRCON, "ctrcon_");

--  LAPACK routine (version 2.0) --
--  CTREVC computes some or all of the right and/or left eigenvectors of
--  a complex upper triangular matrix T.

procedure CTREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTREVC, "ctrevc_");

--  LAPACK routine (version 2.0) --
--  CTREXC reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that the diagonal element of T with row index IFST
--  is moved to row ILST.

procedure CTREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTREXC, "ctrexc_");

--  LAPACK routine (version 2.0) --
--  CTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure CTRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRRFS, "ctrrfs_");

--  LAPACK routine (version 2.0) --
--  CTRSEN reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in
--  the leading positions on the diagonal of the upper triangular matrix
--  T, and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure CTRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	M	 : out Fortran_Integer;
	S	 : out Real;
	SEP	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRSEN, "ctrsen_");

--  LAPACK routine (version 2.0) --
--  CTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a complex upper triangular
--  matrix T (or of any matrix Q*T*Q**H with Q unitary).

procedure CTRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Matrix;
	LDWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRSNA, "ctrsna_");

--  LAPACK routine (version 2.0) --
--  CTRSYL solves the complex Sylvester matrix equation:

procedure CTRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRSYL, "ctrsyl_");

--  LAPACK routine (version 2.0) --
--  CTRTI2 computes the inverse of a complex upper or lower triangular
--  matrix.

procedure CTRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRTI2, "ctrti2_");

--  LAPACK routine (version 2.0) --
--  CTRTRI computes the inverse of a complex upper or lower triangular
--  matrix A.

procedure CTRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRTRI, "ctrtri_");

--  LAPACK routine (version 2.0) --
--  CTRTRS solves a triangular system of the form

procedure CTRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTRTRS, "ctrtrs_");

--  LAPACK routine (version 2.0) --
--  CTZRQF reduces the M-by-N ( M<=N ) complex upper trapezoidal matrix A
--  to upper triangular form by means of unitary transformations.

procedure CTZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CTZRQF, "ctzrqf_");

--  LAPACK routine (version 2.0) --
--  CUNG2L generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure CUNG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNG2L, "cung2l_");

--  LAPACK routine (version 2.0) --
--  CUNG2R generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure CUNG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNG2R, "cung2r_");

--  LAPACK routine (version 2.0) --
--  CUNGBR generates one of the complex unitary matrices Q or P**H
--  determined by CGEBRD when reducing a complex matrix A to bidiagonal
--  form: A = Q * B * P**H.  Q and P**H are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure CUNGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGBR, "cungbr_");

--  LAPACK routine (version 2.0) --
--  CUNGHR generates a complex unitary matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  CGEHRD:

procedure CUNGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGHR, "cunghr_");

--  LAPACK routine (version 2.0) --
--  CUNGL2 generates an m-by-n complex matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure CUNGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGL2, "cungl2_");

--  LAPACK routine (version 2.0) --
--  CUNGLQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure CUNGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGLQ, "cunglq_");

--  LAPACK routine (version 2.0) --
--  CUNGQL generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure CUNGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGQL, "cungql_");

--  LAPACK routine (version 2.0) --
--  CUNGQR generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure CUNGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGQR, "cungqr_");

--  LAPACK routine (version 2.0) --
--  CUNGR2 generates an m by n complex matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure CUNGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGR2, "cungr2_");

--  LAPACK routine (version 2.0) --
--  CUNGRQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure CUNGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGRQ, "cungrq_");

--  LAPACK routine (version 2.0) --
--  CUNGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  CHETRD:

procedure CUNGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNGTR, "cungtr_");

--  LAPACK routine (version 2.0) --
--  CUNM2L overwrites the general complex m-by-n matrix C with

procedure CUNM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNM2L, "cunm2l_");

--  LAPACK routine (version 2.0) --
--  CUNM2R overwrites the general complex m-by-n matrix C with

procedure CUNM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNM2R, "cunm2r_");

--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', CUNMBR overwrites the general complex M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'C':      Q**H * C       C * Q**H

procedure CUNMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMBR, "cunmbr_");

--  LAPACK routine (version 2.0) --
--  CUNMHR overwrites the general complex M-by-N matrix C with

procedure CUNMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMHR, "cunmhr_");

--  LAPACK routine (version 2.0) --
--  CUNML2 overwrites the general complex m-by-n matrix C with

procedure CUNML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNML2, "cunml2_");

--  LAPACK routine (version 2.0) --
--  CUNMLQ overwrites the general complex M-by-N matrix C with

procedure CUNMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMLQ, "cunmlq_");

--  LAPACK routine (version 2.0) --
--  CUNMQL overwrites the general complex M-by-N matrix C with

procedure CUNMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMQL, "cunmql_");

--  LAPACK routine (version 2.0) --
--  CUNMQR overwrites the general complex M-by-N matrix C with

procedure CUNMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMQR, "cunmqr_");

--  LAPACK routine (version 2.0) --
--  CUNMR2 overwrites the general complex m-by-n matrix C with

procedure CUNMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMR2, "cunmr2_");

--  LAPACK routine (version 2.0) --
--  CUNMRQ overwrites the general complex M-by-N matrix C with

procedure CUNMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMRQ, "cunmrq_");

--  LAPACK routine (version 2.0) --
--  CUNMTR overwrites the general complex M-by-N matrix C with

procedure CUNMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUNMTR, "cunmtr_");

--  LAPACK routine (version 2.0) --
--  CUPGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  CHPTRD using packed storage:

procedure CUPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	TAU	 : Fortran_Complex_Vector;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUPGTR, "cupgtr_");

--  LAPACK routine (version 2.0) --
--  CUPMTR overwrites the general complex M-by-N matrix C with

procedure CUPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CUPMTR, "cupmtr_");

--  LAPACK routine (version 2.0) --
--  DBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure DBDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VT	 : Fortran_Double_Precision_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DBDSQR, "dbdsqr_");

--  LAPACK routine (version 2.0) --
--  DDISNA computes the reciprocal condition numbers for the eigenvectors
--  of a real symmetric or complex Hermitian matrix or for the left or
--  right singular vectors of a general m-by-n matrix. The reciprocal
--  condition number is the 'gap' between the corresponding eigenvalue or
--  singular value and the nearest other one.

procedure DDISNA (
	JOB	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DDISNA, "ddisna_");

--  LAPACK routine (version 2.0) --
--  DGBBRD reduces a real general m-by-n band matrix A to upper
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure DGBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Double_Precision_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBBRD, "dgbbrd_");

--  LAPACK routine (version 2.0) --
--  DGBCON estimates the reciprocal of the condition number of a real
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by DGBTRF.

procedure DGBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBCON, "dgbcon_");

--  LAPACK routine (version 2.0) --
--  DGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure DGBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBEQU, "dgbequ_");

--  LAPACK routine (version 2.0) --
--  DGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure DGBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBRFS, "dgbrfs_");

--  LAPACK routine (version 2.0) --
--  DGBTF2 computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure DGBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBTF2, "dgbtf2_");

--  LAPACK routine (version 2.0) --
--  DGBTRF computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure DGBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBTRF, "dgbtrf_");

--  LAPACK routine (version 2.0) --
--  DGBTRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general band matrix A using the LU factorization computed
--  by DGBTRF.

procedure DGBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGBTRS, "dgbtrs_");

--  LAPACK routine (version 2.0) --
--  DGEBAK forms the right or left eigenvectors of a real general matrix
--  by backward transformation on the computed eigenvectors of the
--  balanced matrix output by DGEBAL.

procedure DGEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEBAK, "dgebak_");

--  LAPACK routine (version 2.0) --
--  DGEBAL balances a general real matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure DGEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEBAL, "dgebal_");

--  LAPACK routine (version 2.0) --
--  DGEBD2 reduces a real general m by n matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure DGEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Double_Precision_Vector;
	TAUP	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEBD2, "dgebd2_");

--  LAPACK routine (version 2.0) --
--  DGEBRD reduces a general real M-by-N matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.

procedure DGEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Double_Precision_Vector;
	TAUP	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEBRD, "dgebrd_");

--  LAPACK routine (version 2.0) --
--  DGECON estimates the reciprocal of the condition number of a general
--  real matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by DGETRF.

procedure DGECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGECON, "dgecon_");

--  LAPACK routine (version 2.0) --
--  DGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure DGEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEEQU, "dgeequ_");

--  LAPACK routine (version 2.0) --
--  DGEHD2 reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure DGEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEHD2, "dgehd2_");

--  LAPACK routine (version 2.0) --
--  DGEHRD reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure DGEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEHRD, "dgehrd_");

--  LAPACK routine (version 2.0) --
--  DGELQ2 computes an LQ factorization of a real m by n matrix A:
--  A = L * Q.

procedure DGELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGELQ2, "dgelq2_");

--  LAPACK routine (version 2.0) --
--  DGELQF computes an LQ factorization of a real M-by-N matrix A:
--  A = L * Q.

procedure DGELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGELQF, "dgelqf_");

--  LAPACK routine (version 2.0) --
--  DGEQL2 computes a QL factorization of a real m by n matrix A:
--  A = Q * L.

procedure DGEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEQL2, "dgeql2_");

--  LAPACK routine (version 2.0) --
--  DGEQLF computes a QL factorization of a real M-by-N matrix A:
--  A = Q * L.

procedure DGEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEQLF, "dgeqlf_");

--  LAPACK routine (version 2.0) --
--  DGEQR2 computes a QR factorization of a real m by n matrix A:
--  A = Q * R.

procedure DGEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEQR2, "dgeqr2_");

--  LAPACK routine (version 2.0) --
--  DGEQRF computes a QR factorization of a real M-by-N matrix A:
--  A = Q * R.

procedure DGEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGEQRF, "dgeqrf_");

--  LAPACK routine (version 2.0) --
--  DGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure DGERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGERFS, "dgerfs_");

--  LAPACK routine (version 2.0) --
--  DGERQ2 computes an RQ factorization of a real m by n matrix A:
--  A = R * Q.

procedure DGERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGERQ2, "dgerq2_");

--  LAPACK routine (version 2.0) --
--  DGERQF computes an RQ factorization of a real M-by-N matrix A:
--  A = R * Q.

procedure DGERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGERQF, "dgerqf_");

--  LAPACK routine (version 2.0) --
--  DGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure DGETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGETF2, "dgetf2_");

--  LAPACK routine (version 2.0) --
--  DGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure DGETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGETRF, "dgetrf_");

--  LAPACK routine (version 2.0) --
--  DGETRI computes the inverse of a matrix using the LU factorization
--  computed by DGETRF.

procedure DGETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGETRI, "dgetri_");

--  LAPACK routine (version 2.0) --
--  DGETRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by DGETRF.

procedure DGETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGETRS, "dgetrs_");

--  LAPACK routine (version 2.0) --
--  DGGBAK forms the right or left eigenvectors of a real generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  DGGBAL.

procedure DGGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Double_Precision_Vector;
	RSCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGBAK, "dggbak_");

--  LAPACK routine (version 2.0) --
--  DGGBAL balances a pair of general real matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure DGGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Double_Precision_Vector;
	RSCALE	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGBAL, "dggbal_");

--  LAPACK routine (version 2.0) --
--  DGGHRD reduces a pair of real matrices (A,B) to generalized upper
--  Hessenberg form using orthogonal transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are orthogonal, and ' means transpose.

procedure DGGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGHRD, "dgghrd_");

--  LAPACK routine (version 2.0) --
--  DGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure DGGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGQRF, "dggqrf_");

--  LAPACK routine (version 2.0) --
--  DGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure DGGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGRQF, "dggrqf_");

--  LAPACK routine (version 2.0) --
--  DGGSVP computes orthogonal matrices U, V and Q such that

procedure DGGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	TAU	 : in out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGGSVP, "dggsvp_");

--  LAPACK routine (version 2.0) --
--  DGTCON estimates the reciprocal of the condition number of a real
--  tridiagonal matrix A using the LU factorization as computed by
--  DGTTRF.

procedure DGTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTCON, "dgtcon_");

--  LAPACK routine (version 2.0) --
--  DGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure DGTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DLF	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	DUF	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTRFS, "dgtrfs_");

--  LAPACK routine (version 2.0) --
--  DGTSV  solves the equation

procedure DGTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTSV, "dgtsv_");

--  LAPACK routine (version 2.0) --
--  DGTSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B or A**T * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure DGTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DLF	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	DUF	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTSVX, "dgtsvx_");

--  LAPACK routine (version 2.0) --
--  DGTTRF computes an LU factorization of a real tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure DGTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : out Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTTRF, "dgttrf_");

--  LAPACK routine (version 2.0) --
--  DGTTRS solves one of the systems of equations
--     A*X = B  or  A'*X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by DGTTRF.

procedure DGTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DGTTRS, "dgttrs_");

--  LAPACK routine (version 2.0) --
--  DHGEQZ implements a single-/double-shift version of the QZ method for
--  finding the generalized eigenvalues

procedure DHGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DHGEQZ, "dhgeqz_");

--  LAPACK routine (version 2.0) --
--  DHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a real upper Hessenberg matrix H.

procedure DHSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Fortran_Double_Precision_Vector;
	WI	 : Fortran_Double_Precision_Vector;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DHSEIN, "dhsein_");

--  LAPACK routine (version 2.0) --
--  DHSEQR computes the eigenvalues of a real upper Hessenberg matrix H
--  and, optionally, the matrices T and Z from the Schur decomposition
--  H = Z T Z**T, where T is an upper quasi-triangular matrix (the Schur
--  form), and Z is the orthogonal matrix of Schur vectors.

procedure DHSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DHSEQR, "dhseqr_");

--  LAPACK routine (version 2.0) --
--  DLAED0 computes all eigenvalues and corresponding eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.

procedure DLAED0 (
	ICOMPQ	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Double_Precision_Matrix;
	LDQS	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED0, "dlaed0_");

--  LAPACK routine (version 2.0) --
--  DLAED1 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix.  This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
--  the case in which eigenvalues only or eigenvalues and eigenvectors
--  of a full symmetric matrix (which was reduced to tridiagonal form)
--  are desired.

procedure DLAED1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED1, "dlaed1_");

--  LAPACK routine (version 2.0) --
--  DLAED2 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny entry in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure DLAED2 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : out Fortran_Integer_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	COLTYP	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED2, "dlaed2_");

--  LAPACK routine (version 2.0) --
--  DLAED3 finds the roots of the secular equation, as defined by the
--  values in D, W, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to DLAED4 and then updates the eigenvectors by
--  multiplying the matrix of eigenvectors of the pair of eigensystems
--  being combined by the matrix of eigenvectors of the K-by-K system
--  which is solved here.

procedure DLAED3 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	DLAMDA	 : Fortran_Double_Precision_Vector;
	Q2	 : Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : Fortran_Integer_Vector;
	CTOT	 : Fortran_Integer_Vector;
	W	 : Fortran_Double_Precision_Vector;
	S	 : in out Fortran_Double_Precision_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED3, "dlaed3_");

--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th updated eigenvalue of a symmetric
--  rank-one modification to a diagonal matrix whose elements are
--  given in the array d, and that

procedure DLAED4 (
	N	 : Fortran_Integer;
	I	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	V_DELTA	 : out Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	DLAM	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED4, "dlaed4_");

--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th eigenvalue of a symmetric rank-one
--  modification of a 2-by-2 diagonal matrix

procedure DLAED5 (
	I	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	V_DELTA	 : out Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	DLAM	 : out Double_Precision );

pragma Import ( Fortran, DLAED5, "dlaed5_");

--  LAPACK routine (version 2.0) --
--  DLAED6 computes the positive or negative root (closest to the origin)
--  of
--                   z(1)        z(2)        z(3)
--  f(x) =   rho + --------- + ---------- + ---------
--                  d(1)-x      d(2)-x      d(3)-x

procedure DLAED6 (
	KNITER	 : Fortran_Integer;
	ORGATI	 : Logical;
	RHO	 : Double_Precision;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	FINIT	 : Double_Precision;
	TAU	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED6, "dlaed6_");

--  LAPACK routine (version 2.0) --
--  DLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense symmetric matrix
--  that has been reduced to tridiagonal form.  DLAED1 handles
--  the case in which all eigenvalues and eigenvectors of a symmetric
--  tridiagonal matrix are desired.

procedure DLAED7 (
	ICOMPQ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : out Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	QSTORE	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED7, "dlaed7_");

--  LAPACK routine (version 2.0) --
--  DLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure DLAED8 (
	ICOMPQ	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Double_Precision_Matrix;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED8, "dlaed8_");

--  LAPACK routine (version 2.0) --
--  DLAED9 finds the roots of the secular equation, as defined by the
--  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to DLAED4 and then stores the new matrix of
--  eigenvectors for use in calculating the next level of Z vectors.

procedure DLAED9 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	Q	 : in out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	DLAMDA	 : Fortran_Double_Precision_Vector;
	W	 : Fortran_Double_Precision_Vector;
	S	 : out Fortran_Double_Precision_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAED9, "dlaed9_");

--  LAPACK routine (version 2.0) --
--  DLAEDA computes the Z vector corresponding to the merge step in the
--  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
--  problem.

procedure DLAEDA (
	N	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	Q	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Double_Precision_Vector;
	ZTEMP	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAEDA, "dlaeda_");

--  LAPACK routine (version 2.0) --
--  DLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
--  tridiagonal matrix and lambda is a scalar, as

procedure DLAGTF (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Vector;
	LAMBDA	 : Double_Precision;
	B	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	TOL	 : Double_Precision;
	D	 : out Fortran_Double_Precision_Vector;
	P_IN	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAGTF, "dlagtf_");

--  LAPACK routine (version 2.0) --
--  DLAMRG will create a permutation list which will merge the elements
--  of A (which is composed of two independently sorted sets) into a
--  single set which is sorted in ascending order.

procedure DLAMRG (
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Vector;
	DTRD1	 : Fortran_Integer;
	DTRD2	 : Fortran_Integer;
	INDEX	 : out Fortran_Integer_Vector );

pragma Import ( Fortran, DLAMRG, "dlamrg_");

--  LAPACK routine (version 2.0) --
--     DLASQ1 computes the singular values of a real N-by-N bidiagonal
--     matrix with diagonal D and off-diagonal E. The singular values are
--     computed to high relative accuracy, barring over/underflow or
--     denormalization. The algorithm is described in

procedure DLASQ1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASQ1, "dlasq1_");

--  LAPACK routine (version 2.0) --
--     DLASQ2 computes the singular values of a real N-by-N unreduced
--     bidiagonal matrix with squared diagonal elements in Q and
--     squared off-diagonal elements in E. The singular values are
--     computed to relative accuracy TOL, barring over/underflow or
--     denormalization.

procedure DLASQ2 (
	M	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Vector;
	E	 : in out Fortran_Double_Precision_Vector;
	QQ	 : Fortran_Double_Precision_Vector;
	EE	 : Fortran_Double_Precision_Vector;
	EPS	 : Double_Precision;
	TOL2	 : Double_Precision;
	SMALL2	 : Double_Precision;
	SUP	 : Double_Precision;
	KEND	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASQ2, "dlasq2_");

--  LAPACK routine (version 2.0) --
--     DLASQ3 is the workhorse of the whole bidiagonal SVD algorithm.
--     This can be described as the differential qd with shifts.

procedure DLASQ3 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	QQ	 : Fortran_Double_Precision_Vector;
	EE	 : Fortran_Double_Precision_Vector;
	SUP	 : Double_Precision;
	SIGMA	 : Double_Precision;
	KEND	 : Fortran_Integer;
	OFF	 : Fortran_Integer;
	IPHASE	 : Fortran_Integer;
	ICONV	 : Fortran_Integer;
	EPS	 : Double_Precision;
	TOL2	 : Double_Precision;
	SMALL2	 : Double_Precision );

pragma Import ( Fortran, DLASQ3, "dlasq3_");

--  LAPACK routine (version 2.0) --
--     DLASQ4 estimates TAU, the smallest eigenvalue of a matrix. This
--     routine improves the input value of SUP which is an upper bound
--     for the smallest eigenvalue for this matrix .

procedure DLASQ4 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	TAU	 : out Double_Precision;
	SUP	 : Double_Precision );

pragma Import ( Fortran, DLASQ4, "dlasq4_");

--  LAPACK routine (version 2.0) --
--  Sort the numbers in D in increasing order (if ID = 'I') or
--  in decreasing order (if ID = 'D' ).

procedure DLASRT (
	ID	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASRT, "dlasrt_");

--  LAPACK routine (version 2.0) --
--  DLASYF computes a partial factorization of a real symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure DLASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Double_Precision_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASYF, "dlasyf_");

--  LAPACK routine (version 2.0) --
--  DLATZM applies a Householder matrix generated by DTZRQF to a matrix.

procedure DLATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Double_Precision;
	C1	 : Fortran_Double_Precision_Matrix;
	C2	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, DLATZM, "dlatzm_");

--  LAPACK routine (version 2.0) --
--  DOPGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  DSPTRD using packed storage:

procedure DOPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	TAU	 : Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DOPGTR, "dopgtr_");

--  LAPACK routine (version 2.0) --
--  DOPMTR overwrites the general real M-by-N matrix C with

procedure DOPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DOPMTR, "dopmtr_");

--  LAPACK routine (version 2.0) --
--  DORG2L generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure DORG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORG2L, "dorg2l_");

--  LAPACK routine (version 2.0) --
--  DORG2R generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure DORG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORG2R, "dorg2r_");

--  LAPACK routine (version 2.0) --
--  DORGBR generates one of the real orthogonal matrices Q or P**T
--  determined by DGEBRD when reducing a real matrix A to bidiagonal
--  form: A = Q * B * P**T.  Q and P**T are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure DORGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGBR, "dorgbr_");

--  LAPACK routine (version 2.0) --
--  DORGHR generates a real orthogonal matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  DGEHRD:

procedure DORGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGHR, "dorghr_");

--  LAPACK routine (version 2.0) --
--  DORGL2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure DORGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGL2, "dorgl2_");

--  LAPACK routine (version 2.0) --
--  DORGLQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure DORGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGLQ, "dorglq_");

--  LAPACK routine (version 2.0) --
--  DORGQL generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure DORGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGQL, "dorgql_");

--  LAPACK routine (version 2.0) --
--  DORGQR generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure DORGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGQR, "dorgqr_");

--  LAPACK routine (version 2.0) --
--  DORGR2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure DORGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGR2, "dorgr2_");

--  LAPACK routine (version 2.0) --
--  DORGRQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure DORGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGRQ, "dorgrq_");

--  LAPACK routine (version 2.0) --
--  DORGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  DSYTRD:

procedure DORGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORGTR, "dorgtr_");

--  LAPACK routine (version 2.0) --
--  DORM2L overwrites the general real m by n matrix C with

procedure DORM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORM2L, "dorm2l_");

--  LAPACK routine (version 2.0) --
--  DORM2R overwrites the general real m by n matrix C with

procedure DORM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORM2R, "dorm2r_");

--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', DORMBR overwrites the general real M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'T':      Q**T * C       C * Q**T

procedure DORMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMBR, "dormbr_");

--  LAPACK routine (version 2.0) --
--  DORMHR overwrites the general real M-by-N matrix C with

procedure DORMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMHR, "dormhr_");

--  LAPACK routine (version 2.0) --
--  DORML2 overwrites the general real m by n matrix C with

procedure DORML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORML2, "dorml2_");

--  LAPACK routine (version 2.0) --
--  DORMLQ overwrites the general real M-by-N matrix C with

procedure DORMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMLQ, "dormlq_");

--  LAPACK routine (version 2.0) --
--  DORMQL overwrites the general real M-by-N matrix C with

procedure DORMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMQL, "dormql_");

--  LAPACK routine (version 2.0) --
--  DORMQR overwrites the general real M-by-N matrix C with

procedure DORMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMQR, "dormqr_");

--  LAPACK routine (version 2.0) --
--  DORMR2 overwrites the general real m by n matrix C with

procedure DORMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMR2, "dormr2_");

--  LAPACK routine (version 2.0) --
--  DORMRQ overwrites the general real M-by-N matrix C with

procedure DORMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMRQ, "dormrq_");

--  LAPACK routine (version 2.0) --
--  DORMTR overwrites the general real M-by-N matrix C with

procedure DORMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DORMTR, "dormtr_");

--  LAPACK routine (version 2.0) --
--  DPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite band matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by DPBTRF.

procedure DPBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBCON, "dpbcon_");

--  LAPACK routine (version 2.0) --
--  DPBEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure DPBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBEQU, "dpbequ_");

--  LAPACK routine (version 2.0) --
--  DPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure DPBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBRFS, "dpbrfs_");

--  LAPACK routine (version 2.0) --
--  DPBSTF computes a split Cholesky factorization of a real
--  symmetric positive definite band matrix A.

procedure DPBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBSTF, "dpbstf_");

--  LAPACK routine (version 2.0) --
--  DPBTF2 computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure DPBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBTF2, "dpbtf2_");

--  LAPACK routine (version 2.0) --
--  DPBTRF computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure DPBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBTRF, "dpbtrf_");

--  LAPACK routine (version 2.0) --
--  DPBTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite band matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by DPBTRF.

procedure DPBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPBTRS, "dpbtrs_");

--  LAPACK routine (version 2.0) --
--  DPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by DPOTRF.

procedure DPOCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOCON, "dpocon_");

--  LAPACK routine (version 2.0) --
--  DPOEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure DPOEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOEQU, "dpoequ_");

--  LAPACK routine (version 2.0) --
--  DPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure DPORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPORFS, "dporfs_");

--  LAPACK routine (version 2.0) --
--  DPOTF2 computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure DPOTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOTF2, "dpotf2_");

--  LAPACK routine (version 2.0) --
--  DPOTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure DPOTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOTRF, "dpotrf_");

--  LAPACK routine (version 2.0) --
--  DPOTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by DPOTRF.

procedure DPOTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOTRI, "dpotri_");

--  LAPACK routine (version 2.0) --
--  DPOTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by DPOTRF.

procedure DPOTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPOTRS, "dpotrs_");

--  LAPACK routine (version 2.0) --
--  DPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite packed matrix using
--  the Cholesky factorization A = U**T*U or A = L*L**T computed by
--  DPPTRF.

procedure DPPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPCON, "dppcon_");

--  LAPACK routine (version 2.0) --
--  DPPEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure DPPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPEQU, "dppequ_");

--  LAPACK routine (version 2.0) --
--  DPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure DPPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPRFS, "dpprfs_");

--  LAPACK routine (version 2.0) --
--  DPPTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A stored in packed format.

procedure DPPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPTRF, "dpptrf_");

--  LAPACK routine (version 2.0) --
--  DPPTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by DPPTRF.

procedure DPPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPTRI, "dpptri_");

--  LAPACK routine (version 2.0) --
--  DPPTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**T*U or A = L*L**T computed by DPPTRF.

procedure DPPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPPTRS, "dpptrs_");

--  LAPACK routine (version 2.0) --
--  DPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite tridiagonal matrix
--  using the factorization A = L*D*L**T or A = U**T*D*U computed by
--  DPTTRF.

procedure DPTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTCON, "dptcon_");

--  LAPACK routine (version 2.0) --
--  DPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using DPTTRF, and then calling DBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure DPTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTEQR, "dpteqr_");

--  LAPACK routine (version 2.0) --
--  DPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure DPTRFS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTRFS, "dptrfs_");

--  LAPACK routine (version 2.0) --
--  DPTSV computes the solution to a real system of linear equations
--  A*X = B, where A is an N-by-N symmetric positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure DPTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTSV, "dptsv_");

--  LAPACK routine (version 2.0) --
--  DPTSVX uses the factorization A = L*D*L**T to compute the solution
--  to a real system of linear equations A*X = B, where A is an N-by-N
--  symmetric positive definite tridiagonal matrix and X and B are
--  N-by-NRHS matrices.

procedure DPTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTSVX, "dptsvx_");

--  LAPACK routine (version 2.0) --
--  DPTTRF computes the factorization of a real symmetric positive
--  definite tridiagonal matrix A.

procedure DPTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTTRF, "dpttrf_");

--  LAPACK routine (version 2.0) --
--  DPTTRS solves a system of linear equations A * X = B with a
--  symmetric positive definite tridiagonal matrix A using the
--  factorization A = L*D*L**T or A = U**T*D*U computed by DPTTRF.
--  (The two forms are equivalent if A is real.)

procedure DPTTRS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DPTTRS, "dpttrs_");

--  LAPACK routine (version 2.0) --
--  DSBGST reduces a real symmetric-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure DSBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Double_Precision_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBGST, "dsbgst_");

--  LAPACK routine (version 2.0) --
--  DSBTRD reduces a real symmetric band matrix A to symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure DSBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSBTRD, "dsbtrd_");

--  LAPACK routine (version 2.0) --
--  DSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric packed matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSPTRF.

procedure DSPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPCON, "dspcon_");

--  LAPACK routine (version 2.0) --
--  DSPGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form, using packed storage.

procedure DSPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	BP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPGST, "dspgst_");

--  LAPACK routine (version 2.0) --
--  DSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure DSPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPRFS, "dsprfs_");

--  LAPACK routine (version 2.0) --
--  DSPTRD reduces a real symmetric matrix A stored in packed form to
--  symmetric tridiagonal form T by an orthogonal similarity
--  transformation: Q**T * A * Q = T.

procedure DSPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPTRD, "dsptrd_");

--  LAPACK routine (version 2.0) --
--  DSPTRF computes the factorization of a real symmetric matrix A stored
--  in packed format using the Bunch-Kaufman diagonal pivoting method:

procedure DSPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPTRF, "dsptrf_");

--  LAPACK routine (version 2.0) --
--  DSPTRI computes the inverse of a real symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by DSPTRF.

procedure DSPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPTRI, "dsptri_");

--  LAPACK routine (version 2.0) --
--  DSPTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSPTRF.

procedure DSPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSPTRS, "dsptrs_");

--  LAPACK routine (version 2.0) --
--  DSTEBZ computes the eigenvalues of a symmetric tridiagonal
--  matrix T.  The user may ask for all eigenvalues, all eigenvalues
--  in the half-open interval (VL, VU], or the IL-th through IU-th
--  eigenvalues.

procedure DSTEBZ (
	M_RANGE	 : Character;
	ORDER	 : Character;
	N	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : out Fortran_Integer;
	NSPLIT	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	IBLOCK	 : out Fortran_Integer_Vector;
	ISPLIT	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEBZ, "dstebz_");

--  LAPACK routine (version 2.0) --
--  DSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band real symmetric matrix can also be
--  found if DSYTRD or DSPTRD or DSBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure DSTEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEDC, "dstedc_");

--  LAPACK routine (version 2.0) --
--  DSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure DSTEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Double_Precision_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEIN, "dstein_");

--  LAPACK routine (version 2.0) --
--  DSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band symmetric matrix can also be found
--  if DSYTRD or DSPTRD or DSBTRD has been used to reduce this matrix to
--  tridiagonal form.

procedure DSTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTEQR, "dsteqr_");

--  LAPACK routine (version 2.0) --
--  DSTERF computes all eigenvalues of a symmetric tridiagonal matrix
--  using the Pal-Walker-Kahan variant of the QL or QR algorithm.

procedure DSTERF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSTERF, "dsterf_");

--  LAPACK routine (version 2.0) --
--  DSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSYTRF.

procedure DSYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYCON, "dsycon_");

--  LAPACK routine (version 2.0) --
--  DSYGS2 reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure DSYGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYGS2, "dsygs2_");

--  LAPACK routine (version 2.0) --
--  DSYGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure DSYGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYGST, "dsygst_");

--  LAPACK routine (version 2.0) --
--  DSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure DSYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYRFS, "dsyrfs_");

--  LAPACK routine (version 2.0) --
--  DSYTD2 reduces a real symmetric matrix A to symmetric tridiagonal
--  form T by an orthogonal similarity transformation: Q' * A * Q = T.

procedure DSYTD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTD2, "dsytd2_");

--  LAPACK routine (version 2.0) --
--  DSYTF2 computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method:

procedure DSYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTF2, "dsytf2_");

--  LAPACK routine (version 2.0) --
--  DSYTRD reduces a real symmetric matrix A to real symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure DSYTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTRD, "dsytrd_");

--  LAPACK routine (version 2.0) --
--  DSYTRF computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure DSYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTRF, "dsytrf_");

--  LAPACK routine (version 2.0) --
--  DSYTRI computes the inverse of a real symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  DSYTRF.

procedure DSYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTRI, "dsytri_");

--  LAPACK routine (version 2.0) --
--  DSYTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by DSYTRF.

procedure DSYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DSYTRS, "dsytrs_");

--  LAPACK routine (version 2.0) --
--  DTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure DTBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTBCON, "dtbcon_");

--  LAPACK routine (version 2.0) --
--  DTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure DTBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTBRFS, "dtbrfs_");

--  LAPACK routine (version 2.0) --
--  DTBTRS solves a triangular system of the form

procedure DTBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTBTRS, "dtbtrs_");

--  LAPACK routine (version 2.0) --
--  DTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of real upper triangular matrices (A,B).

procedure DTGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTGEVC, "dtgevc_");

--  LAPACK routine (version 2.0) --
--  DTGSJA computes the generalized singular value decomposition (GSVD)
--  of two real upper triangular (or trapezoidal) matrices A and B.

procedure DTGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTGSJA, "dtgsja_");

--  LAPACK routine (version 2.0) --
--  DTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure DTPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTPCON, "dtpcon_");

--  LAPACK routine (version 2.0) --
--  DTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure DTPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTPRFS, "dtprfs_");

--  LAPACK routine (version 2.0) --
--  DTPTRI computes the inverse of a real upper or lower triangular
--  matrix A stored in packed format.

procedure DTPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTPTRI, "dtptri_");

--  LAPACK routine (version 2.0) --
--  DTPTRS solves a triangular system of the form

procedure DTPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTPTRS, "dtptrs_");

--  LAPACK routine (version 2.0) --
--  DTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure DTRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRCON, "dtrcon_");

--  LAPACK routine (version 2.0) --
--  DTREVC computes some or all of the right and/or left eigenvectors of
--  a real upper quasi-triangular matrix T.

procedure DTREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTREVC, "dtrevc_");

--  LAPACK routine (version 2.0) --
--  DTREXC reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that the diagonal block of T with row index IFST is
--  moved to row ILST.

procedure DTREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTREXC, "dtrexc_");

--  LAPACK routine (version 2.0) --
--  DTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure DTRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRRFS, "dtrrfs_");

--  LAPACK routine (version 2.0) --
--  DTRSEN reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that a selected cluster of eigenvalues appears in
--  the leading diagonal blocks of the upper quasi-triangular matrix T,
--  and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure DTRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	M	 : out Fortran_Integer;
	S	 : out Double_Precision;
	SEP	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRSEN, "dtrsen_");

--  LAPACK routine (version 2.0) --
--  DTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a real upper
--  quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q
--  orthogonal).

procedure DTRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Matrix;
	LDWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRSNA, "dtrsna_");

--  LAPACK routine (version 2.0) --
--  DTRSYL solves the real Sylvester matrix equation:

procedure DTRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRSYL, "dtrsyl_");

--  LAPACK routine (version 2.0) --
--  DTRTI2 computes the inverse of a real upper or lower triangular
--  matrix.

procedure DTRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRTI2, "dtrti2_");

--  LAPACK routine (version 2.0) --
--  DTRTRI computes the inverse of a real upper or lower triangular
--  matrix A.

procedure DTRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRTRI, "dtrtri_");

--  LAPACK routine (version 2.0) --
--  DTRTRS solves a triangular system of the form

procedure DTRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTRTRS, "dtrtrs_");

--  LAPACK routine (version 2.0) --
--  DTZRQF reduces the M-by-N ( M<=N ) real upper trapezoidal matrix A
--  to upper triangular form by means of orthogonal transformations.

procedure DTZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DTZRQF, "dtzrqf_");

--  LAPACK routine (version 2.0) --
--  SBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure SBDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VT	 : Fortran_Real_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SBDSQR, "sbdsqr_");

--  LAPACK routine (version 2.0) --
--  SDISNA computes the reciprocal condition numbers for the eigenvectors
--  of a real symmetric or complex Hermitian matrix or for the left or
--  right singular vectors of a general m-by-n matrix. The reciprocal
--  condition number is the 'gap' between the corresponding eigenvalue or
--  singular value and the nearest other one.

procedure SDISNA (
	JOB	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SDISNA, "sdisna_");

--  LAPACK routine (version 2.0) --
--  SGBBRD reduces a real general m-by-n band matrix A to upper
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure SGBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Real_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBBRD, "sgbbrd_");

--  LAPACK routine (version 2.0) --
--  SGBCON estimates the reciprocal of the condition number of a real
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by SGBTRF.

procedure SGBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBCON, "sgbcon_");

--  LAPACK routine (version 2.0) --
--  SGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure SGBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBEQU, "sgbequ_");

--  LAPACK routine (version 2.0) --
--  SGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure SGBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBRFS, "sgbrfs_");

--  LAPACK routine (version 2.0) --
--  SGBTF2 computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure SGBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBTF2, "sgbtf2_");

--  LAPACK routine (version 2.0) --
--  SGBTRF computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure SGBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBTRF, "sgbtrf_");

--  LAPACK routine (version 2.0) --
--  SGBTRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general band matrix A using the LU factorization computed
--  by SGBTRF.

procedure SGBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGBTRS, "sgbtrs_");

--  LAPACK routine (version 2.0) --
--  SGEBAK forms the right or left eigenvectors of a real general matrix
--  by backward transformation on the computed eigenvectors of the
--  balanced matrix output by SGEBAL.

procedure SGEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEBAK, "sgebak_");

--  LAPACK routine (version 2.0) --
--  SGEBAL balances a general real matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure SGEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEBAL, "sgebal_");

--  LAPACK routine (version 2.0) --
--  SGEBD2 reduces a real general m by n matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure SGEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Real_Vector;
	TAUP	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEBD2, "sgebd2_");

--  LAPACK routine (version 2.0) --
--  SGEBRD reduces a general real M-by-N matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.

procedure SGEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Real_Vector;
	TAUP	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEBRD, "sgebrd_");

--  LAPACK routine (version 2.0) --
--  SGECON estimates the reciprocal of the condition number of a general
--  real matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by SGETRF.

procedure SGECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGECON, "sgecon_");

--  LAPACK routine (version 2.0) --
--  SGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure SGEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEEQU, "sgeequ_");

--  LAPACK routine (version 2.0) --
--  SGEHD2 reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure SGEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEHD2, "sgehd2_");

--  LAPACK routine (version 2.0) --
--  SGEHRD reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure SGEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEHRD, "sgehrd_");

--  LAPACK routine (version 2.0) --
--  SGELQ2 computes an LQ factorization of a real m by n matrix A:
--  A = L * Q.

procedure SGELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGELQ2, "sgelq2_");

--  LAPACK routine (version 2.0) --
--  SGELQF computes an LQ factorization of a real M-by-N matrix A:
--  A = L * Q.

procedure SGELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGELQF, "sgelqf_");

--  LAPACK routine (version 2.0) --
--  SGEQL2 computes a QL factorization of a real m by n matrix A:
--  A = Q * L.

procedure SGEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEQL2, "sgeql2_");

--  LAPACK routine (version 2.0) --
--  SGEQLF computes a QL factorization of a real M-by-N matrix A:
--  A = Q * L.

procedure SGEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEQLF, "sgeqlf_");

--  LAPACK routine (version 2.0) --
--  SGEQR2 computes a QR factorization of a real m by n matrix A:
--  A = Q * R.

procedure SGEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEQR2, "sgeqr2_");

--  LAPACK routine (version 2.0) --
--  SGEQRF computes a QR factorization of a real M-by-N matrix A:
--  A = Q * R.

procedure SGEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGEQRF, "sgeqrf_");

--  LAPACK routine (version 2.0) --
--  SGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure SGERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGERFS, "sgerfs_");

--  LAPACK routine (version 2.0) --
--  SGERQ2 computes an RQ factorization of a real m by n matrix A:
--  A = R * Q.

procedure SGERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGERQ2, "sgerq2_");

--  LAPACK routine (version 2.0) --
--  SGERQF computes an RQ factorization of a real M-by-N matrix A:
--  A = R * Q.

procedure SGERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGERQF, "sgerqf_");

--  LAPACK routine (version 2.0) --
--  SGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure SGETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGETF2, "sgetf2_");

--  LAPACK routine (version 2.0) --
--  SGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure SGETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGETRF, "sgetrf_");

--  LAPACK routine (version 2.0) --
--  SGETRI computes the inverse of a matrix using the LU factorization
--  computed by SGETRF.

procedure SGETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGETRI, "sgetri_");

--  LAPACK routine (version 2.0) --
--  SGETRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by SGETRF.

procedure SGETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGETRS, "sgetrs_");

--  LAPACK routine (version 2.0) --
--  SGGBAK forms the right or left eigenvectors of a real generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  SGGBAL.

procedure SGGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Real_Vector;
	RSCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGBAK, "sggbak_");

--  LAPACK routine (version 2.0) --
--  SGGBAL balances a pair of general real matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure SGGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Real_Vector;
	RSCALE	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGBAL, "sggbal_");

--  LAPACK routine (version 2.0) --
--  SGGHRD reduces a pair of real matrices (A,B) to generalized upper
--  Hessenberg form using orthogonal transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are orthogonal, and ' means transpose.

procedure SGGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGHRD, "sgghrd_");

--  LAPACK routine (version 2.0) --
--  SGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure SGGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGQRF, "sggqrf_");

--  LAPACK routine (version 2.0) --
--  SGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure SGGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGRQF, "sggrqf_");

--  LAPACK routine (version 2.0) --
--  SGGSVP computes orthogonal matrices U, V and Q such that

procedure SGGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	TAU	 : in out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGGSVP, "sggsvp_");

--  LAPACK routine (version 2.0) --
--  SGTCON estimates the reciprocal of the condition number of a real
--  tridiagonal matrix A using the LU factorization as computed by
--  SGTTRF.

procedure SGTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTCON, "sgtcon_");

--  LAPACK routine (version 2.0) --
--  SGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure SGTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DLF	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	DUF	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTRFS, "sgtrfs_");

--  LAPACK routine (version 2.0) --
--  SGTSV  solves the equation

procedure SGTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTSV, "sgtsv_");

--  LAPACK routine (version 2.0) --
--  SGTSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B or A**T * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure SGTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DLF	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	DUF	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTSVX, "sgtsvx_");

--  LAPACK routine (version 2.0) --
--  SGTTRF computes an LU factorization of a real tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure SGTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : out Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTTRF, "sgttrf_");

--  LAPACK routine (version 2.0) --
--  SGTTRS solves one of the systems of equations
--     A*X = B  or  A'*X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by SGTTRF.

procedure SGTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SGTTRS, "sgttrs_");

--  LAPACK routine (version 2.0) --
--  SHGEQZ implements a single-/double-shift version of the QZ method for
--  finding the generalized eigenvalues

procedure SHGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SHGEQZ, "shgeqz_");

--  LAPACK routine (version 2.0) --
--  SHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a real upper Hessenberg matrix H.

procedure SHSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Fortran_Real_Vector;
	WI	 : Fortran_Real_Vector;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SHSEIN, "shsein_");

--  LAPACK routine (version 2.0) --
--  SHSEQR computes the eigenvalues of a real upper Hessenberg matrix H
--  and, optionally, the matrices T and Z from the Schur decomposition
--  H = Z T Z**T, where T is an upper quasi-triangular matrix (the Schur
--  form), and Z is the orthogonal matrix of Schur vectors.

procedure SHSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SHSEQR, "shseqr_");

--  LAPACK routine (version 2.0) --
--  SLAED0 computes all eigenvalues and corresponding eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.

procedure SLAED0 (
	ICOMPQ	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Real_Matrix;
	LDQS	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED0, "slaed0_");

--  LAPACK routine (version 2.0) --
--  SLAED1 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix.  This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and eigenvectors of a tridiagonal matrix.  SLAED7 handles
--  the case in which eigenvalues only or eigenvalues and eigenvectors
--  of a full symmetric matrix (which was reduced to tridiagonal form)
--  are desired.

procedure SLAED1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED1, "slaed1_");

--  LAPACK routine (version 2.0) --
--  SLAED2 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny entry in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure SLAED2 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : out Fortran_Integer_Vector;
	W	 : out Fortran_Real_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	COLTYP	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED2, "slaed2_");

--  LAPACK routine (version 2.0) --
--  SLAED3 finds the roots of the secular equation, as defined by the
--  values in D, W, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to SLAED4 and then updates the eigenvectors by
--  multiplying the matrix of eigenvectors of the pair of eigensystems
--  being combined by the matrix of eigenvectors of the K-by-K system
--  which is solved here.

procedure SLAED3 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	DLAMDA	 : Fortran_Real_Vector;
	Q2	 : Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : Fortran_Integer_Vector;
	CTOT	 : Fortran_Integer_Vector;
	W	 : Fortran_Real_Vector;
	S	 : in out Fortran_Real_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED3, "slaed3_");

--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th updated eigenvalue of a symmetric
--  rank-one modification to a diagonal matrix whose elements are
--  given in the array d, and that

procedure SLAED4 (
	N	 : Fortran_Integer;
	I	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	V_DELTA	 : out Fortran_Real_Vector;
	RHO	 : Real;
	DLAM	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED4, "slaed4_");

--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th eigenvalue of a symmetric rank-one
--  modification of a 2-by-2 diagonal matrix

procedure SLAED5 (
	I	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	V_DELTA	 : out Fortran_Real_Vector;
	RHO	 : Real;
	DLAM	 : out Real );

pragma Import ( Fortran, SLAED5, "slaed5_");

--  LAPACK routine (version 2.0) --
--  SLAED6 computes the positive or negative root (closest to the origin)
--  of
--                   z(1)        z(2)        z(3)
--  f(x) =   rho + --------- + ---------- + ---------
--                  d(1)-x      d(2)-x      d(3)-x

procedure SLAED6 (
	KNITER	 : Fortran_Integer;
	ORGATI	 : Logical;
	RHO	 : Real;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	FINIT	 : Real;
	TAU	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED6, "slaed6_");

--  LAPACK routine (version 2.0) --
--  SLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense symmetric matrix
--  that has been reduced to tridiagonal form.  SLAED1 handles
--  the case in which all eigenvalues and eigenvectors of a symmetric
--  tridiagonal matrix are desired.

procedure SLAED7 (
	ICOMPQ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : out Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	QSTORE	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED7, "slaed7_");

--  LAPACK routine (version 2.0) --
--  SLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure SLAED8 (
	ICOMPQ	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Real_Matrix;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED8, "slaed8_");

--  LAPACK routine (version 2.0) --
--  SLAED9 finds the roots of the secular equation, as defined by the
--  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to SLAED4 and then stores the new matrix of
--  eigenvectors for use in calculating the next level of Z vectors.

procedure SLAED9 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	Q	 : in out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	DLAMDA	 : Fortran_Real_Vector;
	W	 : Fortran_Real_Vector;
	S	 : out Fortran_Real_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAED9, "slaed9_");

--  LAPACK routine (version 2.0) --
--  SLAEDA computes the Z vector corresponding to the merge step in the
--  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
--  problem.

procedure SLAEDA (
	N	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	Q	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Real_Vector;
	ZTEMP	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAEDA, "slaeda_");

--  LAPACK routine (version 2.0) --
--  SLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
--  tridiagonal matrix and lambda is a scalar, as

procedure SLAGTF (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Vector;
	LAMBDA	 : Real;
	B	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	TOL	 : Real;
	D	 : out Fortran_Real_Vector;
	P_IN	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAGTF, "slagtf_");

--  LAPACK routine (version 2.0) --
--  SLAMRG will create a permutation list which will merge the elements
--  of A (which is composed of two independently sorted sets) into a
--  single set which is sorted in ascending order.

procedure SLAMRG (
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	A	 : Fortran_Real_Vector;
	STRD1	 : Fortran_Integer;
	STRD2	 : Fortran_Integer;
	INDEX	 : out Fortran_Integer_Vector );

pragma Import ( Fortran, SLAMRG, "slamrg_");

--  LAPACK routine (version 2.0) --
--     SLASQ1 computes the singular values of a real N-by-N bidiagonal
--     matrix with diagonal D and off-diagonal E. The singular values are
--     computed to high relative accuracy, barring over/underflow or
--     denormalization. The algorithm is described in

procedure SLASQ1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASQ1, "slasq1_");

--  LAPACK routine (version 2.0) --
--     SLASQ2 computes the singular values of a real N-by-N unreduced
--     bidiagonal matrix with squared diagonal elements in Q and
--     squared off-diagonal elements in E. The singular values are
--     computed to relative accuracy TOL, barring over/underflow or
--     denormalization.

procedure SLASQ2 (
	M	 : Fortran_Integer;
	Q	 : out Fortran_Real_Vector;
	E	 : in out Fortran_Real_Vector;
	QQ	 : Fortran_Real_Vector;
	EE	 : Fortran_Real_Vector;
	EPS	 : Real;
	TOL2	 : Real;
	SMALL2	 : Real;
	SUP	 : Real;
	KEND	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASQ2, "slasq2_");

--  LAPACK routine (version 2.0) --
--     SLASQ3 is the workhorse of the whole bidiagonal SVD algorithm.
--     This can be described as the differential qd with shifts.

procedure SLASQ3 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	QQ	 : Fortran_Real_Vector;
	EE	 : Fortran_Real_Vector;
	SUP	 : Real;
	SIGMA	 : Real;
	KEND	 : Fortran_Integer;
	OFF	 : Fortran_Integer;
	IPHASE	 : Fortran_Integer;
	ICONV	 : Fortran_Integer;
	EPS	 : Real;
	TOL2	 : Real;
	SMALL2	 : Real );

pragma Import ( Fortran, SLASQ3, "slasq3_");

--  LAPACK routine (version 2.0) --
--     SLASQ4 estimates TAU, the smallest eigenvalue of a matrix. This
--     routine improves the input value of SUP which is an upper bound
--     for the smallest eigenvalue for this matrix .

procedure SLASQ4 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	TAU	 : out Real;
	SUP	 : Real );

pragma Import ( Fortran, SLASQ4, "slasq4_");

--  LAPACK routine (version 2.0) --
--  Sort the numbers in D in increasing order (if ID = 'I') or
--  in decreasing order (if ID = 'D' ).

procedure SLASRT (
	ID	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASRT, "slasrt_");

--  LAPACK routine (version 2.0) --
--  SLASYF computes a partial factorization of a real symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure SLASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Real_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASYF, "slasyf_");

--  LAPACK routine (version 2.0) --
--  SLATZM applies a Householder matrix generated by STZRQF to a matrix.

procedure SLATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Real_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Real;
	C1	 : Fortran_Real_Matrix;
	C2	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector );

pragma Import ( Fortran, SLATZM, "slatzm_");

--  LAPACK routine (version 2.0) --
--  SOPGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  SSPTRD using packed storage:

procedure SOPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	TAU	 : Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SOPGTR, "sopgtr_");

--  LAPACK routine (version 2.0) --
--  SOPMTR overwrites the general real M-by-N matrix C with

procedure SOPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SOPMTR, "sopmtr_");

--  LAPACK routine (version 2.0) --
--  SORG2L generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure SORG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORG2L, "sorg2l_");

--  LAPACK routine (version 2.0) --
--  SORG2R generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure SORG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORG2R, "sorg2r_");

--  LAPACK routine (version 2.0) --
--  SORGBR generates one of the real orthogonal matrices Q or P**T
--  determined by SGEBRD when reducing a real matrix A to bidiagonal
--  form: A = Q * B * P**T.  Q and P**T are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure SORGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGBR, "sorgbr_");

--  LAPACK routine (version 2.0) --
--  SORGHR generates a real orthogonal matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  SGEHRD:

procedure SORGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGHR, "sorghr_");

--  LAPACK routine (version 2.0) --
--  SORGL2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure SORGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGL2, "sorgl2_");

--  LAPACK routine (version 2.0) --
--  SORGLQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure SORGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGLQ, "sorglq_");

--  LAPACK routine (version 2.0) --
--  SORGQL generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure SORGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGQL, "sorgql_");

--  LAPACK routine (version 2.0) --
--  SORGQR generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure SORGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGQR, "sorgqr_");

--  LAPACK routine (version 2.0) --
--  SORGR2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure SORGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGR2, "sorgr2_");

--  LAPACK routine (version 2.0) --
--  SORGRQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure SORGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGRQ, "sorgrq_");

--  LAPACK routine (version 2.0) --
--  SORGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  SSYTRD:

procedure SORGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORGTR, "sorgtr_");

--  LAPACK routine (version 2.0) --
--  SORM2L overwrites the general real m by n matrix C with

procedure SORM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORM2L, "sorm2l_");

--  LAPACK routine (version 2.0) --
--  SORM2R overwrites the general real m by n matrix C with

procedure SORM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORM2R, "sorm2r_");

--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', SORMBR overwrites the general real M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'T':      Q**T * C       C * Q**T

procedure SORMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMBR, "sormbr_");

--  LAPACK routine (version 2.0) --
--  SORMHR overwrites the general real M-by-N matrix C with

procedure SORMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMHR, "sormhr_");

--  LAPACK routine (version 2.0) --
--  SORML2 overwrites the general real m by n matrix C with

procedure SORML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORML2, "sorml2_");

--  LAPACK routine (version 2.0) --
--  SORMLQ overwrites the general real M-by-N matrix C with

procedure SORMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMLQ, "sormlq_");

--  LAPACK routine (version 2.0) --
--  SORMQL overwrites the general real M-by-N matrix C with

procedure SORMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMQL, "sormql_");

--  LAPACK routine (version 2.0) --
--  SORMQR overwrites the general real M-by-N matrix C with

procedure SORMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMQR, "sormqr_");

--  LAPACK routine (version 2.0) --
--  SORMR2 overwrites the general real m by n matrix C with

procedure SORMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMR2, "sormr2_");

--  LAPACK routine (version 2.0) --
--  SORMRQ overwrites the general real M-by-N matrix C with

procedure SORMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMRQ, "sormrq_");

--  LAPACK routine (version 2.0) --
--  SORMTR overwrites the general real M-by-N matrix C with

procedure SORMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SORMTR, "sormtr_");

--  LAPACK routine (version 2.0) --
--  SPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite band matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by SPBTRF.

procedure SPBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBCON, "spbcon_");

--  LAPACK routine (version 2.0) --
--  SPBEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure SPBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBEQU, "spbequ_");

--  LAPACK routine (version 2.0) --
--  SPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure SPBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBRFS, "spbrfs_");

--  LAPACK routine (version 2.0) --
--  SPBSTF computes a split Cholesky factorization of a real
--  symmetric positive definite band matrix A.

procedure SPBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBSTF, "spbstf_");

--  LAPACK routine (version 2.0) --
--  SPBTF2 computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure SPBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBTF2, "spbtf2_");

--  LAPACK routine (version 2.0) --
--  SPBTRF computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure SPBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBTRF, "spbtrf_");

--  LAPACK routine (version 2.0) --
--  SPBTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite band matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by SPBTRF.

procedure SPBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPBTRS, "spbtrs_");

--  LAPACK routine (version 2.0) --
--  SPOCON estimates the reciprocal of the condition number (in the 
--  1-norm) of a real symmetric positive definite matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by SPOTRF.

procedure SPOCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOCON, "spocon_");

--  LAPACK routine (version 2.0) --
--  SPOEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure SPOEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOEQU, "spoequ_");

--  LAPACK routine (version 2.0) --
--  SPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure SPORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPORFS, "sporfs_");

--  LAPACK routine (version 2.0) --
--  SPOTF2 computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure SPOTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOTF2, "spotf2_");

--  LAPACK routine (version 2.0) --
--  SPOTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure SPOTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOTRF, "spotrf_");

--  LAPACK routine (version 2.0) --
--  SPOTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by SPOTRF.

procedure SPOTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOTRI, "spotri_");

--  LAPACK routine (version 2.0) --
--  SPOTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by SPOTRF.

procedure SPOTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPOTRS, "spotrs_");

--  LAPACK routine (version 2.0) --
--  SPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite packed matrix using
--  the Cholesky factorization A = U**T*U or A = L*L**T computed by
--  SPPTRF.

procedure SPPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPCON, "sppcon_");

--  LAPACK routine (version 2.0) --
--  SPPEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure SPPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPEQU, "sppequ_");

--  LAPACK routine (version 2.0) --
--  SPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SPPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPRFS, "spprfs_");

--  LAPACK routine (version 2.0) --
--  SPPTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A stored in packed format.

procedure SPPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPTRF, "spptrf_");

--  LAPACK routine (version 2.0) --
--  SPPTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by SPPTRF.

procedure SPPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPTRI, "spptri_");

--  LAPACK routine (version 2.0) --
--  SPPTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**T*U or A = L*L**T computed by SPPTRF.

procedure SPPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPPTRS, "spptrs_");

--  LAPACK routine (version 2.0) --
--  SPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite tridiagonal matrix
--  using the factorization A = L*D*L**T or A = U**T*D*U computed by
--  SPTTRF.

procedure SPTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTCON, "sptcon_");

--  LAPACK routine (version 2.0) --
--  SPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using SPTTRF, and then calling SBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure SPTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTEQR, "spteqr_");

--  LAPACK routine (version 2.0) --
--  SPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure SPTRFS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTRFS, "sptrfs_");

--  LAPACK routine (version 2.0) --
--  SPTSV computes the solution to a real system of linear equations
--  A*X = B, where A is an N-by-N symmetric positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure SPTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTSV, "sptsv_");

--  LAPACK routine (version 2.0) --
--  SPTSVX uses the factorization A = L*D*L**T to compute the solution
--  to a real system of linear equations A*X = B, where A is an N-by-N
--  symmetric positive definite tridiagonal matrix and X and B are
--  N-by-NRHS matrices.

procedure SPTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTSVX, "sptsvx_");

--  LAPACK routine (version 2.0) --
--  SPTTRF computes the factorization of a real symmetric positive
--  definite tridiagonal matrix A.

procedure SPTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTTRF, "spttrf_");

--  LAPACK routine (version 2.0) --
--  SPTTRS solves a system of linear equations A * X = B with a
--  symmetric positive definite tridiagonal matrix A using the
--  factorization A = L*D*L**T or A = U**T*D*U computed by SPTTRF.
--  (The two forms are equivalent if A is real.)

procedure SPTTRS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SPTTRS, "spttrs_");

--  LAPACK routine (version 2.0) --
--  SSBGST reduces a real symmetric-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure SSBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Real_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBGST, "ssbgst_");

--  LAPACK routine (version 2.0) --
--  SSBTRD reduces a real symmetric band matrix A to symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SSBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSBTRD, "ssbtrd_");

--  LAPACK routine (version 2.0) --
--  SSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric packed matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSPTRF.

procedure SSPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPCON, "sspcon_");

--  LAPACK routine (version 2.0) --
--  SSPGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form, using packed storage.

procedure SSPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	BP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPGST, "sspgst_");

--  LAPACK routine (version 2.0) --
--  SSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SSPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPRFS, "ssprfs_");

--  LAPACK routine (version 2.0) --
--  SSPTRD reduces a real symmetric matrix A stored in packed form to
--  symmetric tridiagonal form T by an orthogonal similarity
--  transformation: Q**T * A * Q = T.

procedure SSPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPTRD, "ssptrd_");

--  LAPACK routine (version 2.0) --
--  SSPTRF computes the factorization of a real symmetric matrix A stored
--  in packed format using the Bunch-Kaufman diagonal pivoting method:

procedure SSPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPTRF, "ssptrf_");

--  LAPACK routine (version 2.0) --
--  SSPTRI computes the inverse of a real symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by SSPTRF.

procedure SSPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPTRI, "ssptri_");

--  LAPACK routine (version 2.0) --
--  SSPTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSPTRF.

procedure SSPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSPTRS, "ssptrs_");

--  LAPACK routine (version 2.0) --
--  SSTEBZ computes the eigenvalues of a symmetric tridiagonal
--  matrix T.  The user may ask for all eigenvalues, all eigenvalues
--  in the half-open interval (VL, VU], or the IL-th through IU-th
--  eigenvalues.

procedure SSTEBZ (
	M_RANGE	 : Character;
	ORDER	 : Character;
	N	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : out Fortran_Integer;
	NSPLIT	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	IBLOCK	 : out Fortran_Integer_Vector;
	ISPLIT	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEBZ, "sstebz_");

--  LAPACK routine (version 2.0) --
--  SSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band real symmetric matrix can also be
--  found if SSYTRD or SSPTRD or SSBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure SSTEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEDC, "sstedc_");

--  LAPACK routine (version 2.0) --
--  SSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure SSTEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Real_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEIN, "sstein_");

--  LAPACK routine (version 2.0) --
--  SSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band symmetric matrix can also be found
--  if SSYTRD or SSPTRD or SSBTRD has been used to reduce this matrix to
--  tridiagonal form.

procedure SSTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTEQR, "ssteqr_");

--  LAPACK routine (version 2.0) --
--  SSTERF computes all eigenvalues of a symmetric tridiagonal matrix
--  using the Pal-Walker-Kahan variant of the QL or QR algorithm.

procedure SSTERF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSTERF, "ssterf_");

--  LAPACK routine (version 2.0) --
--  SSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSYTRF.

procedure SSYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYCON, "ssycon_");

--  LAPACK routine (version 2.0) --
--  SSYGS2 reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SSYGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYGS2, "ssygs2_");

--  LAPACK routine (version 2.0) --
--  SSYGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SSYGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYGST, "ssygst_");

--  LAPACK routine (version 2.0) --
--  SSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure SSYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYRFS, "ssyrfs_");

--  LAPACK routine (version 2.0) --
--  SSYTD2 reduces a real symmetric matrix A to symmetric tridiagonal
--  form T by an orthogonal similarity transformation: Q' * A * Q = T.

procedure SSYTD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTD2, "ssytd2_");

--  LAPACK routine (version 2.0) --
--  SSYTF2 computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method:

procedure SSYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTF2, "ssytf2_");

--  LAPACK routine (version 2.0) --
--  SSYTRD reduces a real symmetric matrix A to real symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SSYTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTRD, "ssytrd_");

--  LAPACK routine (version 2.0) --
--  SSYTRF computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure SSYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTRF, "ssytrf_");

--  LAPACK routine (version 2.0) --
--  SSYTRI computes the inverse of a real symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  SSYTRF.

procedure SSYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTRI, "ssytri_");

--  LAPACK routine (version 2.0) --
--  SSYTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by SSYTRF.

procedure SSYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SSYTRS, "ssytrs_");

--  LAPACK routine (version 2.0) --
--  STBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure STBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STBCON, "stbcon_");

--  LAPACK routine (version 2.0) --
--  STBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure STBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STBRFS, "stbrfs_");

--  LAPACK routine (version 2.0) --
--  STBTRS solves a triangular system of the form

procedure STBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STBTRS, "stbtrs_");

--  LAPACK routine (version 2.0) --
--  STGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of real upper triangular matrices (A,B).

procedure STGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STGEVC, "stgevc_");

--  LAPACK routine (version 2.0) --
--  STGSJA computes the generalized singular value decomposition (GSVD)
--  of two real upper triangular (or trapezoidal) matrices A and B.

procedure STGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STGSJA, "stgsja_");

--  LAPACK routine (version 2.0) --
--  STPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure STPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STPCON, "stpcon_");

--  LAPACK routine (version 2.0) --
--  STPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure STPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STPRFS, "stprfs_");

--  LAPACK routine (version 2.0) --
--  STPTRI computes the inverse of a real upper or lower triangular
--  matrix A stored in packed format.

procedure STPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STPTRI, "stptri_");

--  LAPACK routine (version 2.0) --
--  STPTRS solves a triangular system of the form

procedure STPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STPTRS, "stptrs_");

--  LAPACK routine (version 2.0) --
--  STRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure STRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRCON, "strcon_");

--  LAPACK routine (version 2.0) --
--  STREVC computes some or all of the right and/or left eigenvectors of
--  a real upper quasi-triangular matrix T.

procedure STREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector;
	INFO	 : Fortran_Integer );

pragma Import ( Fortran, STREVC, "strevc_");

--  LAPACK routine (version 2.0) --
--  STREXC reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that the diagonal block of T with row index IFST is
--  moved to row ILST.

procedure STREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STREXC, "strexc_");

--  LAPACK routine (version 2.0) --
--  STRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure STRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRRFS, "strrfs_");

--  LAPACK routine (version 2.0) --
--  STRSEN reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that a selected cluster of eigenvalues appears in
--  the leading diagonal blocks of the upper quasi-triangular matrix T,
--  and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure STRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	M	 : out Fortran_Integer;
	S	 : out Real;
	SEP	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRSEN, "strsen_");

--  LAPACK routine (version 2.0) --
--  STRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a real upper
--  quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q
--  orthogonal).

procedure STRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Matrix;
	LDWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRSNA, "strsna_");

--  LAPACK routine (version 2.0) --
--  STRSYL solves the real Sylvester matrix equation:

procedure STRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRSYL, "strsyl_");

--  LAPACK routine (version 2.0) --
--  STRTI2 computes the inverse of a real upper or lower triangular
--  matrix.

procedure STRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRTI2, "strti2_");

--  LAPACK routine (version 2.0) --
--  STRTRI computes the inverse of a real upper or lower triangular
--  matrix A.

procedure STRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRTRI, "strtri_");

--  LAPACK routine (version 2.0) --
--  STRTRS solves a triangular system of the form

procedure STRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STRTRS, "strtrs_");

--  LAPACK routine (version 2.0) --
--  STZRQF reduces the M-by-N ( M<=N ) real upper trapezoidal matrix A
--  to upper triangular form by means of orthogonal transformations.

procedure STZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, STZRQF, "stzrqf_");

--  LAPACK routine (version 2.0) --
--  ZBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure ZBDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VT	 : Fortran_Complex_Star_16_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZBDSQR, "zbdsqr_");

--  LAPACK routine (version 2.0) --
--  ZGBBRD reduces a complex general m-by-n band matrix A to real upper
--  bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure ZGBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Complex_Star_16_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBBRD, "zgbbrd_");

--  LAPACK routine (version 2.0) --
--  ZGBCON estimates the reciprocal of the condition number of a complex
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by ZGBTRF.

procedure ZGBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBCON, "zgbcon_");

--  LAPACK routine (version 2.0) --
--  ZGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure ZGBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBEQU, "zgbequ_");

--  LAPACK routine (version 2.0) --
--  ZGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure ZGBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBRFS, "zgbrfs_");

--  LAPACK routine (version 2.0) --
--  ZGBTF2 computes an LU factorization of a complex m-by-n band matrix
--  A using partial pivoting with row interchanges.

procedure ZGBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBTF2, "zgbtf2_");

--  LAPACK routine (version 2.0) --
--  ZGBTRF computes an LU factorization of a complex m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure ZGBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBTRF, "zgbtrf_");

--  LAPACK routine (version 2.0) --
--  ZGBTRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general band matrix A using the LU factorization computed
--  by ZGBTRF.

procedure ZGBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGBTRS, "zgbtrs_");

--  LAPACK routine (version 2.0) --
--  ZGEBAK forms the right or left eigenvectors of a complex general
--  matrix by backward transformation on the computed eigenvectors of the
--  balanced matrix output by ZGEBAL.

procedure ZGEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEBAK, "zgebak_");

--  LAPACK routine (version 2.0) --
--  ZGEBAL balances a general complex matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure ZGEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEBAL, "zgebal_");

--  LAPACK routine (version 2.0) --
--  ZGEBD2 reduces a complex general m by n matrix A to upper or lower
--  real bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure ZGEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Complex_Star_16_Vector;
	TAUP	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEBD2, "zgebd2_");

--  LAPACK routine (version 2.0) --
--  ZGEBRD reduces a general complex M-by-N matrix A to upper or lower
--  bidiagonal form B by a unitary transformation: Q**H * A * P = B.

procedure ZGEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Complex_Star_16_Vector;
	TAUP	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEBRD, "zgebrd_");

--  LAPACK routine (version 2.0) --
--  ZGECON estimates the reciprocal of the condition number of a general
--  complex matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by ZGETRF.

procedure ZGECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGECON, "zgecon_");

--  LAPACK routine (version 2.0) --
--  ZGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure ZGEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEEQU, "zgeequ_");

--  LAPACK routine (version 2.0) --
--  ZGEHD2 reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure ZGEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEHD2, "zgehd2_");

--  LAPACK routine (version 2.0) --
--  ZGEHRD reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure ZGEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEHRD, "zgehrd_");

--  LAPACK routine (version 2.0) --
--  ZGELQ2 computes an LQ factorization of a complex m by n matrix A:
--  A = L * Q.

procedure ZGELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGELQ2, "zgelq2_");

--  LAPACK routine (version 2.0) --
--  ZGELQF computes an LQ factorization of a complex M-by-N matrix A:
--  A = L * Q.

procedure ZGELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGELQF, "zgelqf_");

--  LAPACK routine (version 2.0) --
--  ZGEQL2 computes a QL factorization of a complex m by n matrix A:
--  A = Q * L.

procedure ZGEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEQL2, "zgeql2_");

--  LAPACK routine (version 2.0) --
--  ZGEQLF computes a QL factorization of a complex M-by-N matrix A:
--  A = Q * L.

procedure ZGEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEQLF, "zgeqlf_");

--  LAPACK routine (version 2.0) --
--  ZGEQR2 computes a QR factorization of a complex m by n matrix A:
--  A = Q * R.

procedure ZGEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEQR2, "zgeqr2_");

--  LAPACK routine (version 2.0) --
--  ZGEQRF computes a QR factorization of a complex M-by-N matrix A:
--  A = Q * R.

procedure ZGEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEQRF, "zgeqrf_");

--  LAPACK routine (version 2.0) --
--  ZGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure ZGERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGERFS, "zgerfs_");

--  LAPACK routine (version 2.0) --
--  ZGERQ2 computes an RQ factorization of a complex m by n matrix A:
--  A = R * Q.

procedure ZGERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGERQ2, "zgerq2_");

--  LAPACK routine (version 2.0) --
--  ZGERQF computes an RQ factorization of a complex M-by-N matrix A:
--  A = R * Q.

procedure ZGERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGERQF, "zgerqf_");

--  LAPACK routine (version 2.0) --
--  ZGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure ZGETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGETF2, "zgetf2_");

--  LAPACK routine (version 2.0) --
--  ZGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure ZGETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGETRF, "zgetrf_");

--  LAPACK routine (version 2.0) --
--  ZGETRI computes the inverse of a matrix using the LU factorization
--  computed by ZGETRF.

procedure ZGETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGETRI, "zgetri_");

--  LAPACK routine (version 2.0) --
--  ZGETRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by ZGETRF.

procedure ZGETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGETRS, "zgetrs_");

--  LAPACK routine (version 2.0) --
--  ZGGBAK forms the right or left eigenvectors of a complex generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  ZGGBAL.

procedure ZGGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Double_Precision_Vector;
	RSCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGBAK, "zggbak_");

--  LAPACK routine (version 2.0) --
--  ZGGBAL balances a pair of general complex matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure ZGGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Double_Precision_Vector;
	RSCALE	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGBAL, "zggbal_");

--  LAPACK routine (version 2.0) --
--  ZGGHRD reduces a pair of complex matrices (A,B) to generalized upper
--  Hessenberg form using unitary transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are unitary, and ' means conjugate transpose.

procedure ZGGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGHRD, "zgghrd_");

--  LAPACK routine (version 2.0) --
--  ZGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure ZGGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGQRF, "zggqrf_");

--  LAPACK routine (version 2.0) --
--  ZGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure ZGGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGRQF, "zggrqf_");

--  LAPACK routine (version 2.0) --
--  ZGGSVP computes unitary matrices U, V and Q such that

procedure ZGGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	TAU	 : in out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGGSVP, "zggsvp_");

--  LAPACK routine (version 2.0) --
--  ZGTCON estimates the reciprocal of the condition number of a complex
--  tridiagonal matrix A using the LU factorization as computed by
--  ZGTTRF.

procedure ZGTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTCON, "zgtcon_");

--  LAPACK routine (version 2.0) --
--  ZGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure ZGTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DLF	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Complex_Star_16_Vector;
	DUF	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTRFS, "zgtrfs_");

--  LAPACK routine (version 2.0) --
--  ZGTSV  solves the equation

procedure ZGTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTSV, "zgtsv_");

--  LAPACK routine (version 2.0) --
--  ZGTSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure ZGTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DLF	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Complex_Star_16_Vector;
	DUF	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTSVX, "zgtsvx_");

--  LAPACK routine (version 2.0) --
--  ZGTTRF computes an LU factorization of a complex tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure ZGTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : out Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTTRF, "zgttrf_");

--  LAPACK routine (version 2.0) --
--  ZGTTRS solves one of the systems of equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by ZGTTRF.

procedure ZGTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGTTRS, "zgttrs_");

--  LAPACK routine (version 2.0) --
--  ZHBGST reduces a complex Hermitian-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure ZHBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Star_16_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBGST, "zhbgst_");

--  LAPACK routine (version 2.0) --
--  ZHBTRD reduces a complex Hermitian band matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure ZHBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHBTRD, "zhbtrd_");

--  LAPACK routine (version 2.0) --
--  ZHECON estimates the reciprocal of the condition number of a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHETRF.

procedure ZHECON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHECON, "zhecon_");

--  LAPACK routine (version 2.0) --
--  ZHEGS2 reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure ZHEGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEGS2, "zhegs2_");

--  LAPACK routine (version 2.0) --
--  ZHEGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure ZHEGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHEGST, "zhegst_");

--  LAPACK routine (version 2.0) --
--  ZHERFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure ZHERFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHERFS, "zherfs_");

--  LAPACK routine (version 2.0) --
--  ZHETD2 reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q' * A * Q = T.

procedure ZHETD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETD2, "zhetd2_");

--  LAPACK routine (version 2.0) --
--  ZHETF2 computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure ZHETF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETF2, "zhetf2_");

--  LAPACK routine (version 2.0) --
--  ZHETRD reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure ZHETRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETRD, "zhetrd_");

--  LAPACK routine (version 2.0) --
--  ZHETRF computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure ZHETRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETRF, "zhetrf_");

--  LAPACK routine (version 2.0) --
--  ZHETRI computes the inverse of a complex Hermitian indefinite matrix
--  A using the factorization A = U*D*U**H or A = L*D*L**H computed by
--  ZHETRF.

procedure ZHETRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETRI, "zhetri_");

--  LAPACK routine (version 2.0) --
--  ZHETRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHETRF.

procedure ZHETRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHETRS, "zhetrs_");

--  LAPACK routine (version 2.0) --
--  ZHGEQZ implements a single-shift version of the QZ
--  method for finding the generalized eigenvalues w(i)=ALPHA(i)/BETA(i)
--  of the equation

procedure ZHGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHGEQZ, "zhgeqz_");

--  LAPACK routine (version 2.0) --
--  ZHPCON estimates the reciprocal of the condition number of a complex
--  Hermitian packed matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHPTRF.

procedure ZHPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPCON, "zhpcon_");

--  LAPACK routine (version 2.0) --
--  ZHPGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form, using packed storage.

procedure ZHPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	BP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPGST, "zhpgst_");

--  LAPACK routine (version 2.0) --
--  ZHPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure ZHPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPRFS, "zhprfs_");

--  LAPACK routine (version 2.0) --
--  ZHPTRD reduces a complex Hermitian matrix A stored in packed form to
--  real symmetric tridiagonal form T by a unitary similarity
--  transformation: Q**H * A * Q = T.

procedure ZHPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPTRD, "zhptrd_");

--  LAPACK routine (version 2.0) --
--  ZHPTRF computes the factorization of a complex Hermitian packed
--  matrix A using the Bunch-Kaufman diagonal pivoting method:

procedure ZHPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPTRF, "zhptrf_");

--  LAPACK routine (version 2.0) --
--  ZHPTRI computes the inverse of a complex Hermitian indefinite matrix
--  A in packed storage using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHPTRF.

procedure ZHPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPTRI, "zhptri_");

--  LAPACK routine (version 2.0) --
--  ZHPTRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A stored in packed format using the factorization
--  A = U*D*U**H or A = L*D*L**H computed by ZHPTRF.

procedure ZHPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHPTRS, "zhptrs_");

--  LAPACK routine (version 2.0) --
--  ZHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a complex upper Hessenberg matrix H.

procedure ZHSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Fortran_Complex_Star_16_Vector;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHSEIN, "zhsein_");

--  LAPACK routine (version 2.0) --
--  ZHSEQR computes the eigenvalues of a complex upper Hessenberg
--  matrix H, and, optionally, the matrices T and Z from the Schur
--  decomposition H = Z T Z**H, where T is an upper triangular matrix
--  (the Schur form), and Z is the unitary matrix of Schur vectors.

procedure ZHSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZHSEQR, "zhseqr_");

--  LAPACK routine (version 2.0) --
--  Using the divide and conquer method, ZLAED0 computes all eigenvalues
--  of a symmetric tridiagonal matrix which is one diagonal block of
--  those from reducing a dense or band Hermitian matrix and
--  corresponding eigenvectors of the dense or band matrix.

procedure ZLAED0 (
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Complex_Star_16_Matrix;
	LDQS	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAED0, "zlaed0_");

--  LAPACK routine (version 2.0) --
--  ZLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense or banded
--  Hermitian matrix that has been reduced to tridiagonal form.

procedure ZLAED7 (
	N	 : Fortran_Integer;
	CUTPNT	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	INDXQ	 : out Fortran_Integer_Vector;
	QSTORE	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAED7, "zlaed7_");

--  LAPACK routine (version 2.0) --
--  ZLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure ZLAED8 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Complex_Star_16_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INDXQ	 : Fortran_Integer_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Double_Precision_Matrix;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAED8, "zlaed8_");

--  LAPACK routine (version 2.0) --
--  ZLAHEF computes a partial factorization of a complex Hermitian
--  matrix A using the Bunch-Kaufman diagonal pivoting method. The
--  partial factorization has the form:

procedure ZLAHEF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Star_16_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAHEF, "zlahef_");

--  LAPACK routine (version 2.0) --
--  ZLASYF computes a partial factorization of a complex symmetric matrix
--  A using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure ZLASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Star_16_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLASYF, "zlasyf_");

--  LAPACK routine (version 2.0) --
--  ZLATZM applies a Householder matrix generated by ZTZRQF to a matrix.

procedure ZLATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex_Star_16;
	C1	 : Fortran_Complex_Star_16_Matrix;
	C2	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector );

pragma Import ( Fortran, ZLATZM, "zlatzm_");

--  LAPACK routine (version 2.0) --
--  ZPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite band matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  ZPBTRF.

procedure ZPBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBCON, "zpbcon_");

--  LAPACK routine (version 2.0) --
--  ZPBEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure ZPBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBEQU, "zpbequ_");

--  LAPACK routine (version 2.0) --
--  ZPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure ZPBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBRFS, "zpbrfs_");

--  LAPACK routine (version 2.0) --
--  ZPBSTF computes a split Cholesky factorization of a complex
--  Hermitian positive definite band matrix A.

procedure ZPBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBSTF, "zpbstf_");

--  LAPACK routine (version 2.0) --
--  ZPBTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure ZPBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBTF2, "zpbtf2_");

--  LAPACK routine (version 2.0) --
--  ZPBTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure ZPBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBTRF, "zpbtrf_");

--  LAPACK routine (version 2.0) --
--  ZPBTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite band matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by ZPBTRF.

procedure ZPBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPBTRS, "zpbtrs_");

--  LAPACK routine (version 2.0) --
--  ZPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite matrix using the
--  Cholesky factorization A = U**H*U or A = L*L**H computed by ZPOTRF.

procedure ZPOCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOCON, "zpocon_");

--  LAPACK routine (version 2.0) --
--  ZPOEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure ZPOEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOEQU, "zpoequ_");

--  LAPACK routine (version 2.0) --
--  ZPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure ZPORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPORFS, "zporfs_");

--  LAPACK routine (version 2.0) --
--  ZPOTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure ZPOTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOTF2, "zpotf2_");

--  LAPACK routine (version 2.0) --
--  ZPOTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure ZPOTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOTRF, "zpotrf_");

--  LAPACK routine (version 2.0) --
--  ZPOTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by ZPOTRF.

procedure ZPOTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOTRI, "zpotri_");

--  LAPACK routine (version 2.0) --
--  ZPOTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by ZPOTRF.

procedure ZPOTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPOTRS, "zpotrs_");

--  LAPACK routine (version 2.0) --
--  ZPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite packed matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  ZPPTRF.

procedure ZPPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPCON, "zppcon_");

--  LAPACK routine (version 2.0) --
--  ZPPEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure ZPPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPEQU, "zppequ_");

--  LAPACK routine (version 2.0) --
--  ZPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure ZPPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPRFS, "zpprfs_");

--  LAPACK routine (version 2.0) --
--  ZPPTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A stored in packed format.

procedure ZPPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPTRF, "zpptrf_");

--  LAPACK routine (version 2.0) --
--  ZPPTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by ZPPTRF.

procedure ZPPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPTRI, "zpptri_");

--  LAPACK routine (version 2.0) --
--  ZPPTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**H*U or A = L*L**H computed by ZPPTRF.

procedure ZPPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPPTRS, "zpptrs_");

--  LAPACK routine (version 2.0) --
--  ZPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite tridiagonal matrix
--  using the factorization A = L*D*L**H or A = U**H*D*U computed by
--  ZPTTRF.

procedure ZPTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTCON, "zptcon_");

--  LAPACK routine (version 2.0) --
--  ZPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using DPTTRF and then calling ZBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure ZPTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTEQR, "zpteqr_");

--  LAPACK routine (version 2.0) --
--  ZPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure ZPTRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTRFS, "zptrfs_");

--  LAPACK routine (version 2.0) --
--  ZPTSV computes the solution to a complex system of linear equations
--  A*X = B, where A is an N-by-N Hermitian positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure ZPTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTSV, "zptsv_");

--  LAPACK routine (version 2.0) --
--  ZPTSVX uses the factorization A = L*D*L**H to compute the solution
--  to a complex system of linear equations A*X = B, where A is an
--  N-by-N Hermitian positive definite tridiagonal matrix and X and B
--  are N-by-NRHS matrices.

procedure ZPTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTSVX, "zptsvx_");

--  LAPACK routine (version 2.0) --
--  ZPTTRF computes the factorization of a complex Hermitian positive
--  definite tridiagonal matrix A.

procedure ZPTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTTRF, "zpttrf_");

--  LAPACK routine (version 2.0) --
--  ZPTTRS solves a system of linear equations A * X = B with a
--  Hermitian positive definite tridiagonal matrix A using the
--  factorization A = U**H*D*U or A = L*D*L**H computed by ZPTTRF.

procedure ZPTTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZPTTRS, "zpttrs_");

--  LAPACK routine (version 2.0) --
--  ZSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric packed matrix A using the
--  factorization A = U*D*U**T or A = L*D*L**T computed by ZSPTRF.

procedure ZSPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPCON, "zspcon_");

--  LAPACK routine (version 2.0) --
--  ZSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure ZSPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPRFS, "zsprfs_");

--  LAPACK routine (version 2.0) --
--  ZSPTRF computes the factorization of a complex symmetric matrix A
--  stored in packed format using the Bunch-Kaufman diagonal pivoting
--  method:

procedure ZSPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPTRF, "zsptrf_");

--  LAPACK routine (version 2.0) --
--  ZSPTRI computes the inverse of a complex symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by ZSPTRF.

procedure ZSPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPTRI, "zsptri_");

--  LAPACK routine (version 2.0) --
--  ZSPTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by ZSPTRF.

procedure ZSPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSPTRS, "zsptrs_");

--  LAPACK routine (version 2.0) --
--  ZSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure ZSTEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSTEDC, "zstedc_");

--  LAPACK routine (version 2.0) --
--  ZSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure ZSTEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Double_Precision_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSTEIN, "zstein_");

--  LAPACK routine (version 2.0) --
--  ZSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure ZSTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSTEQR, "zsteqr_");

--  LAPACK routine (version 2.0) --
--  ZSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by ZSYTRF.

procedure ZSYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYCON, "zsycon_");

--  LAPACK routine (version 2.0) --
--  ZSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure ZSYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYRFS, "zsyrfs_");

--  LAPACK routine (version 2.0) --
--  ZSYTF2 computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure ZSYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYTF2, "zsytf2_");

--  LAPACK routine (version 2.0) --
--  ZSYTRF computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure ZSYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYTRF, "zsytrf_");

--  LAPACK routine (version 2.0) --
--  ZSYTRI computes the inverse of a complex symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  ZSYTRF.

procedure ZSYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYTRI, "zsytri_");

--  LAPACK routine (version 2.0) --
--  ZSYTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by ZSYTRF.

procedure ZSYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZSYTRS, "zsytrs_");

--  LAPACK routine (version 2.0) --
--  ZTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure ZTBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTBCON, "ztbcon_");

--  LAPACK routine (version 2.0) --
--  ZTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure ZTBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTBRFS, "ztbrfs_");

--  LAPACK routine (version 2.0) --
--  ZTBTRS solves a triangular system of the form

procedure ZTBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTBTRS, "ztbtrs_");

--  LAPACK routine (version 2.0) --
--  ZTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of complex upper triangular matrices (A,B).

procedure ZTGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTGEVC, "ztgevc_");

--  LAPACK routine (version 2.0) --
--  ZTGSJA computes the generalized singular value decomposition (GSVD)
--  of two complex upper triangular (or trapezoidal) matrices A and B.

procedure ZTGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTGSJA, "ztgsja_");

--  LAPACK routine (version 2.0) --
--  ZTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure ZTPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTPCON, "ztpcon_");

--  LAPACK routine (version 2.0) --
--  ZTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure ZTPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTPRFS, "ztprfs_");

--  LAPACK routine (version 2.0) --
--  ZTPTRI computes the inverse of a complex upper or lower triangular
--  matrix A stored in packed format.

procedure ZTPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTPTRI, "ztptri_");

--  LAPACK routine (version 2.0) --
--  ZTPTRS solves a triangular system of the form

procedure ZTPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTPTRS, "ztptrs_");

--  LAPACK routine (version 2.0) --
--  ZTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure ZTRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRCON, "ztrcon_");

--  LAPACK routine (version 2.0) --
--  ZTREVC computes some or all of the right and/or left eigenvectors of
--  a complex upper triangular matrix T.

procedure ZTREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTREVC, "ztrevc_");

--  LAPACK routine (version 2.0) --
--  ZTREXC reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that the diagonal element of T with row index IFST
--  is moved to row ILST.

procedure ZTREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTREXC, "ztrexc_");

--  LAPACK routine (version 2.0) --
--  ZTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure ZTRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRRFS, "ztrrfs_");

--  LAPACK routine (version 2.0) --
--  ZTRSEN reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in
--  the leading positions on the diagonal of the upper triangular matrix
--  T, and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure ZTRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	M	 : out Fortran_Integer;
	S	 : out Double_Precision;
	SEP	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRSEN, "ztrsen_");

--  LAPACK routine (version 2.0) --
--  ZTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a complex upper triangular
--  matrix T (or of any matrix Q*T*Q**H with Q unitary).

procedure ZTRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Matrix;
	LDWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRSNA, "ztrsna_");

--  LAPACK routine (version 2.0) --
--  ZTRSYL solves the complex Sylvester matrix equation:

procedure ZTRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRSYL, "ztrsyl_");

--  LAPACK routine (version 2.0) --
--  ZTRTI2 computes the inverse of a complex upper or lower triangular
--  matrix.

procedure ZTRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRTI2, "ztrti2_");

--  LAPACK routine (version 2.0) --
--  ZTRTRI computes the inverse of a complex upper or lower triangular
--  matrix A.

procedure ZTRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRTRI, "ztrtri_");

--  LAPACK routine (version 2.0) --
--  ZTRTRS solves a triangular system of the form

procedure ZTRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTRTRS, "ztrtrs_");

--  LAPACK routine (version 2.0) --
--  ZTZRQF reduces the M-by-N ( M<=N ) complex upper trapezoidal matrix A
--  to upper triangular form by means of unitary transformations.

procedure ZTZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZTZRQF, "ztzrqf_");

--  LAPACK routine (version 2.0) --
--  ZUNG2L generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure ZUNG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNG2L, "zung2l_");

--  LAPACK routine (version 2.0) --
--  ZUNG2R generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure ZUNG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNG2R, "zung2r_");

--  LAPACK routine (version 2.0) --
--  ZUNGBR generates one of the complex unitary matrices Q or P**H
--  determined by ZGEBRD when reducing a complex matrix A to bidiagonal
--  form: A = Q * B * P**H.  Q and P**H are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure ZUNGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGBR, "zungbr_");

--  LAPACK routine (version 2.0) --
--  ZUNGHR generates a complex unitary matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  ZGEHRD:

procedure ZUNGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGHR, "zunghr_");

--  LAPACK routine (version 2.0) --
--  ZUNGL2 generates an m-by-n complex matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure ZUNGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGL2, "zungl2_");

--  LAPACK routine (version 2.0) --
--  ZUNGLQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure ZUNGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGLQ, "zunglq_");

--  LAPACK routine (version 2.0) --
--  ZUNGQL generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure ZUNGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGQL, "zungql_");

--  LAPACK routine (version 2.0) --
--  ZUNGQR generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure ZUNGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGQR, "zungqr_");

--  LAPACK routine (version 2.0) --
--  ZUNGR2 generates an m by n complex matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure ZUNGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGR2, "zungr2_");

--  LAPACK routine (version 2.0) --
--  ZUNGRQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure ZUNGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGRQ, "zungrq_");

--  LAPACK routine (version 2.0) --
--  ZUNGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  ZHETRD:

procedure ZUNGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNGTR, "zungtr_");

--  LAPACK routine (version 2.0) --
--  ZUNM2L overwrites the general complex m-by-n matrix C with

procedure ZUNM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNM2L, "zunm2l_");

--  LAPACK routine (version 2.0) --
--  ZUNM2R overwrites the general complex m-by-n matrix C with

procedure ZUNM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNM2R, "zunm2r_");

--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', ZUNMBR overwrites the general complex M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'C':      Q**H * C       C * Q**H

procedure ZUNMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMBR, "zunmbr_");

--  LAPACK routine (version 2.0) --
--  ZUNMHR overwrites the general complex M-by-N matrix C with

procedure ZUNMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMHR, "zunmhr_");

--  LAPACK routine (version 2.0) --
--  ZUNML2 overwrites the general complex m-by-n matrix C with

procedure ZUNML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNML2, "zunml2_");

--  LAPACK routine (version 2.0) --
--  ZUNMLQ overwrites the general complex M-by-N matrix C with

procedure ZUNMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMLQ, "zunmlq_");

--  LAPACK routine (version 2.0) --
--  ZUNMQL overwrites the general complex M-by-N matrix C with

procedure ZUNMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMQL, "zunmql_");

--  LAPACK routine (version 2.0) --
--  ZUNMQR overwrites the general complex M-by-N matrix C with

procedure ZUNMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMQR, "zunmqr_");

--  LAPACK routine (version 2.0) --
--  ZUNMR2 overwrites the general complex m-by-n matrix C with

procedure ZUNMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMR2, "zunmr2_");

--  LAPACK routine (version 2.0) --
--  ZUNMRQ overwrites the general complex M-by-N matrix C with

procedure ZUNMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMRQ, "zunmrq_");

--  LAPACK routine (version 2.0) --
--  ZUNMTR overwrites the general complex M-by-N matrix C with

procedure ZUNMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUNMTR, "zunmtr_");

--  LAPACK routine (version 2.0) --
--  ZUPGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  ZHPTRD using packed storage:

procedure ZUPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	TAU	 : Fortran_Complex_Star_16_Vector;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUPGTR, "zupgtr_");

--  LAPACK routine (version 2.0) --
--  ZUPMTR overwrites the general complex M-by-N matrix C with

procedure ZUPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZUPMTR, "zupmtr_");

end lacmp;
