------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 b o d y                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- The LAPADA library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------
with Ada.Text_IO; use Ada.Text_IO;
with Interfaces.FORTRAN; use Interfaces.FORTRAN; 
with labase; use labase;

package labaseio is 

    package Integer_IO is new Ada.Text_IO.Integer_IO( Fortran_Integer );
    package Real_IO is new Ada.Text_IO.Float_IO( Real );
    package Double_Precision_IO is 
	new Ada.Text_IO.Float_IO( Double_Precision );

    use Integer_IO;
    use Real_IO;
    use Double_Precision_IO;

    -- Should implement fully operlation on Complex io
    -- Check in  Complex type in Ada later that may be predefine

    procedure PUT ( X: Complex );
    procedure PUT ( X: Complex_Star_16 ); 

   -- Vector/Matrix output 
   -- may be use generic, try once but didn't work 
   -- do easy one

   procedure PUT ( V: Fortran_Integer_Vector);
   procedure PUT ( V: Fortran_Real_Vector);
   procedure PUT ( V: Fortran_Double_Precision_Vector);
   procedure PUT ( V: Fortran_Complex_Vector);
   procedure PUT ( V: Fortran_Complex_Star_16_Vector);
--   procedure PUT ( V: Fortran_Logical_Vector);

   procedure PUT ( M: Fortran_Integer_Matrix);
   procedure PUT ( M: Fortran_Real_Matrix);
   procedure PUT ( M: Fortran_Double_Precision_Matrix);
   procedure PUT ( M: Fortran_Complex_Matrix);
   procedure PUT ( M: Fortran_Complex_Star_16_Matrix);
--   procedure PUT ( M: Fortran_Logical_Matrix);

end labaseio;
