------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 b o d y                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- The LAPADA library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------
with Ada.Text_IO; use Ada.Text_IO;
with Interfaces.FORTRAN; use Interfaces.FORTRAN;
with labase; use labase;

package body labaseio is 

    use Integer_IO;
    use Real_IO;
    use Double_Precision_IO;

    procedure PUT ( X: Complex ) is 
      begin 
         PUT( X.Re );
         PUT( "," );
         PUT( X.Im );
    end PUT;

    procedure PUT ( X: Complex_Star_16 ) is 
      begin 
         PUT( X.Re );
         PUT( "," );
         PUT( X.Im );
     end PUT;

   procedure PUT ( V: Fortran_Integer_Vector) is 
   begin
      for I in V'Range (1) loop
            Put ( V(I));
         New_Line;
      end loop;
   end PUT;

   procedure PUT ( V: Fortran_Real_Vector) is
   begin
      for I in V'Range (1) loop
            Put ( V(I));
         New_Line;
      end loop;
   end PUT;

   procedure PUT ( V: Fortran_Double_Precision_Vector) is
   begin
      for I in V'Range (1) loop
            Put ( V(I));
         New_Line;
      end loop;
   end PUT;

   procedure PUT ( V: Fortran_Complex_Vector) is
   begin
      for I in V'Range (1) loop
            Put ( V(I));
         New_Line;
      end loop;
   end PUT;

   procedure PUT ( V: Fortran_Complex_Star_16_Vector) is
   begin
      for I in V'Range (1) loop
            Put ( V(I));
         New_Line;
      end loop;
   end PUT;

-- procedure PUT ( V: Fortran_Logical_Vector) is

   procedure PUT ( M: Fortran_Integer_Matrix) is
   begin
      for I in M'Range (1) loop
         for J in M'Range (2) loop
            Put ( M (I,J));
         end loop;
         New_Line;
      end loop;
   end Put;

   procedure PUT ( M: Fortran_Real_Matrix) is
   begin
      for I in M'Range (1) loop
         for J in M'Range (2) loop
            Put ( M (I,J));
         end loop;
         New_Line;
      end loop;
   end Put;

   procedure PUT ( M: Fortran_Double_Precision_Matrix) is
   begin
      for I in M'Range (1) loop
         for J in M'Range (2) loop
            Put ( M (I,J));
         end loop;
         New_Line;
      end loop;
   end Put;

   procedure PUT ( M: Fortran_Complex_Matrix) is
   begin
      for I in M'Range (1) loop
         for J in M'Range (2) loop
            Put ( M (I,J));
         end loop;
         New_Line;
      end loop;
   end Put;

   procedure PUT ( M: Fortran_Complex_Star_16_Matrix) is
   begin
      for I in M'Range (1) loop
         for J in M'Range (2) loop
            Put ( M (I,J));
         end loop;
         New_Line;
      end loop;
   end Put;

--   procedure PUT ( M: Fortran_Logical_Matrix) is

end labaseio;
