------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Numerics.Generic_Complex_Types;
with Interfaces.Fortran; use  Interfaces.Fortran;

package labase is

   -- Nothing to do below this point.

    --  Fortran type complex*16 may be defined in Interfaces.Fortran, but
    --  is not currently, so it is defined here.

    package Double_Precision_Complex_Types is
       new Ada.Numerics.Generic_Complex_Types (Double_Precision);

    type Complex_Star_16 is new Double_Precision_Complex_Types.Complex;

    type Imaginary_Star_16 is new Double_Precision_Complex_Types.Imaginary;
        i : constant Imaginary_Star_16
          := Imaginary_Star_16 (Double_Precision_Complex_Types.i);
        j : constant Imaginary_Star_16
          := Imaginary_Star_16 (Double_Precision_Complex_Types.j);

    -- Fortran Vector type

    type Fortran_Integer_Vector is array (Fortran_Integer range <>) 
	 of Fortran_Integer;
    pragma Convention (Fortran, Fortran_Integer_Vector);

    type Fortran_Real_Vector is array (Fortran_Integer range <>) 
         of Real;
    pragma Convention (Fortran, Fortran_Real_Vector);

    type Fortran_Double_Precision_Vector is array (Fortran_Integer range <>) 
         of Double_Precision;
    pragma Convention (Fortran, Fortran_Double_Precision_Vector);

    type Fortran_Complex_Vector is array (Fortran_Integer range <>) 
         of Complex;
    pragma Convention (Fortran, Fortran_Complex_Vector);

    type Fortran_Complex_Star_16_Vector is array (Fortran_Integer range <>) 
         of Complex_Star_16;
    pragma Convention (Fortran, Fortran_Complex_Star_16_Vector);

    type Fortran_Logical_Vector is array (Fortran_Integer range <>) 
         of Logical;
    pragma Convention (Fortran, Fortran_Logical_Vector);


    -- Fortran Matrix type

    type Fortran_Integer_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>) 
         of Fortran_Integer;
    pragma Convention (Fortran, Fortran_Integer_Matrix);

    type Fortran_Real_Matrix is array (Fortran_Integer range <>,
                                       Fortran_Integer range <>) 
         of Real;
    pragma Convention (Fortran, Fortran_Real_Matrix);

    type Fortran_Double_Precision_Matrix is array (Fortran_Integer range <>,
                                                   Fortran_Integer range <>) 
         of Double_Precision;
    pragma Convention (Fortran, Fortran_Double_Precision_Matrix);

    type Fortran_Complex_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>) 
         of Complex;
    pragma Convention (Fortran, Fortran_Complex_Matrix);

    type Fortran_Complex_Star_16_Matrix is array (Fortran_Integer range <>,
                                                  Fortran_Integer range <>) 
         of Complex_Star_16;
    pragma Convention (Fortran, Fortran_Complex_Star_16_Matrix);

    type Fortran_Logical_Matrix is array (Fortran_Integer range <>,
                                          Fortran_Integer range <>)
         of Logical;
    pragma Convention (Fortran, Fortran_Logical_Matrix);


    --type String_Array is array (Fortran_Integer range <>) of String;

    -- Access_To_Function types, used in connection with LAPACK xGEESx 
    -- fortran subroutines.

    type LFun_S_2 is access function (X,Y : in Real) 
         return Logical;
    type LFun_D_2 is access function (X,Y : in Double_Precision) 
         return Logical;
    type LFun_C_1 is access function (X : in Complex) 
         return Logical;
    type LFun_Z_1 is access function (X : in Complex_Star_16) 
         return Logical;

end labase;

