------------------------------------------------------------------------------
--                                                                          --
--                           LAPACK.AUX   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.11 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces.Fortran; use  Interfaces.Fortran;


package lapack.aux is

--  LAPACK auxiliary routine (version 2.0) --
--  SLABAD takes as input the values computed by SLAMCH for underflow and
--  overflow, and returns the square root of each of these values if the
--  log of LARGE is sufficiently large.  This subroutine is intended to
--  identify machines with a large exponent range, such as the Crays, and
--  redefine the underflow and overflow limits to be the square roots of
--  the values computed by SLAMCH.  This subroutine is needed because
--  SLAMCH does not compensate for poor arithmetic in the upper half of
--  the exponent range, as is found on a Cray.

procedure SLABAD (
	SMALL	 : Real;
	LARGE	 : Real );

pragma Import ( Fortran, SLABAD, "slabad_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLABRD reduces the first NB rows and columns of a real general
--  m by n matrix A to upper or lower bidiagonal form by an orthogonal
--  transformation Q' * A * P, and returns the matrices X and Y which
--  are needed to apply the transformation to the unreduced part of A.

procedure SLABRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Real_Vector;
	TAUP	 : out Fortran_Real_Vector;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	Y	 : out Fortran_Real_Matrix;
	LDY	 : out Fortran_Integer );

pragma Import ( Fortran, SLABRD, "slabrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLACON estimates the 1-norm of a square, real matrix A.
--  Reverse communication is used for evaluating matrix-vector products.

procedure SLACON (
	N	 : Fortran_Integer;
	V	 : in out Fortran_Real_Vector;
	X	 : Fortran_Real_Vector;
	ISGN	 : in out Fortran_Integer_Vector;
	EST	 : out Real;
	KASE	 : Fortran_Integer );

pragma Import ( Fortran, SLACON, "slacon_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLACPY copies all or part of a two-dimensional matrix A to another
--  matrix B.

procedure SLACPY (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : out Fortran_Real_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, SLACPY, "slacpy_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLADIV performs complex division in  real arithmetic

procedure SLADIV (
	A	 : Real;
	B	 : Real;
	C	 : Real;
	D	 : Real;
	P	 : out Real;
	Q	 : out Real );

pragma Import ( Fortran, SLADIV, "sladiv_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAE2  computes the eigenvalues of a 2-by-2 symmetric matrix
--     [  A   B  ]
--     [  B   C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, and RT2
--  is the eigenvalue of smaller absolute value.

procedure SLAE2 (
	A	 : Real;
	B	 : Real;
	C	 : Real;
	RT1	 : out Real;
	RT2	 : out Real );

pragma Import ( Fortran, SLAE2, "slae2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAEBZ contains the iteration loops which compute and use the
--  function N(w), which is the count of eigenvalues of a symmetric
--  tridiagonal matrix T less than or equal to its argument  w.  It
--  performs a choice of two types of loops:

procedure SLAEBZ (
	IJOB	 : Fortran_Integer;
	NITMAX	 : Fortran_Integer;
	N	 : Fortran_Integer;
	MMAX	 : Fortran_Integer;
	MINP	 : Fortran_Integer;
	NBMIN	 : Fortran_Integer;
	ABSTOL	 : Real;
	RELTOL	 : Real;
	PIVMIN	 : Real;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	E2	 : Fortran_Real_Vector;
	NVAL	 : Fortran_Integer_Vector;
	AB	 : Fortran_Real_Matrix;
	C	 : Fortran_Real_Vector;
	MOUT	 : out Fortran_Integer;
	NAB	 : Fortran_Integer_Matrix;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAEBZ, "slaebz_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAEIN uses inverse iteration to find a right or left eigenvector
--  corresponding to the eigenvalue (WR,WI) of a real upper Hessenberg
--  matrix H.

procedure SLAEIN (
	RIGHTV	 : Logical;
	NOINIT	 : Logical;
	N	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Real;
	WI	 : Real;
	VR	 : Fortran_Real_Vector;
	VI	 : Fortran_Real_Vector;
	B	 : in out Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	EPS3	 : Real;
	SMLNUM	 : Real;
	BIGNUM	 : Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAEIN, "slaein_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAEV2 computes the eigendecomposition of a 2-by-2 symmetric matrix
--     [  A   B  ]
--     [  B   C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
--  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
--  eigenvector for RT1, giving the decomposition

procedure SLAEV2 (
	A	 : Real;
	B	 : Real;
	C	 : Real;
	RT1	 : out Real;
	RT2	 : out Real;
	CS1	 : out Real;
	SN1	 : out Real );

pragma Import ( Fortran, SLAEV2, "slaev2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAEXC swaps adjacent diagonal blocks T11 and T22 of order 1 or 2 in
--  an upper quasi-triangular matrix T by an orthogonal similarity
--  transformation.

procedure SLAEXC (
	WANTQ	 : Logical;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	J1	 : Fortran_Integer;
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAEXC, "slaexc_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAG2 computes the eigenvalues of a 2 x 2 generalized eigenvalue
--  problem  A - w B, with scaling as necessary to avoid over-/underflow.

procedure SLAG2 (
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	SAFMIN	 : Real;
	SCALE1	 : out Real;
	SCALE2	 : out Real;
	WR1	 : out Real;
	WR2	 : out Real;
	WI	 : out Real );

pragma Import ( Fortran, SLAG2, "slag2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAGS2 computes 2-by-2 orthogonal matrices U, V and Q, such
--  that if ( UPPER ) then

procedure SLAGS2 (
	UPPER	 : Logical;
	A1	 : Real;
	A2	 : Real;
	A3	 : Real;
	B1	 : Real;
	B2	 : Real;
	B3	 : Real;
	CSU	 : out Real;
	SNU	 : out Real;
	CSV	 : out Real;
	SNV	 : out Real;
	CSQ	 : out Real;
	SNQ	 : out Real );

pragma Import ( Fortran, SLAGS2, "slags2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAGTM performs a matrix-vector product of the form

procedure SLAGTM (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	ALPHA	 : Real;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	BETA	 : Real;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, SLAGTM, "slagtm_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAGTS may be used to solve one of the systems of equations

procedure SLAGTS (
	JOB	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	P_IN	 : Fortran_Integer_Vector;
	Y	 : Fortran_Real_Vector;
	TOL	 : Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAGTS, "slagts_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAHQR is an auxiliary routine called by SHSEQR to update the
--  eigenvalues and Schur decomposition already computed by SHSEQR, by
--  dealing with the Hessenberg submatrix in rows and columns ILO to IHI.

procedure SLAHQR (
	WANTT	 : Logical;
	WANTZ	 : Logical;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	ILOZ	 : Fortran_Integer;
	IHIZ	 : Fortran_Integer;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAHQR, "slahqr_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAHRD reduces the first NB columns of a real general n-by-(n-k+1)
--  matrix A so that elements below the k-th subdiagonal are zero. The
--  reduction is performed by an orthogonal similarity transformation
--  Q' * A * Q. The routine returns the matrices V and T which determine
--  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

procedure SLAHRD (
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	T	 : out Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Y	 : out Fortran_Real_Matrix;
	LDY	 : Fortran_Integer );

pragma Import ( Fortran, SLAHRD, "slahrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAIC1 applies one step of incremental condition estimation in
--  its simplest version:

procedure SLAIC1 (
	JOB	 : Fortran_Integer;
	J	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	SEST	 : Real;
	W	 : Fortran_Real_Vector;
	GAMMA	 : Real;
	SESTPR	 : out Real;
	S	 : out Real;
	C	 : out Real );

pragma Import ( Fortran, SLAIC1, "slaic1_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLALN2 solves a system of the form  (ca A - w D ) X = s B
--  or (ca A' - w D) X = s B   with possible scaling ("s") and
--  perturbation of A.  (A' means A-transpose.)

procedure SLALN2 (
	LTRANS	 : Logical;
	NA	 : Fortran_Integer;
	NW	 : Fortran_Integer;
	SMIN	 : Real;
	CA	 : Real;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D1	 : Real;
	D2	 : Real;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WR	 : Real;
	WI	 : Real;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	SCALE	 : out Real;
	XNORM	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLALN2, "slaln2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAMCH determines single precision machine parameters.

function SLAMCH (
	CMACH	 : Character ) Return Real;

pragma Import ( Fortran, SLAMCH, "slamch_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANGB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n band matrix  A,  with kl sub-diagonals and ku super-diagonals.

function SLANGB (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANGB, "slangb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANGE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real matrix A.

function SLANGE (
	NORM	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANGE, "slange_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANGT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real tridiagonal matrix A.

function SLANGT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANGT, "slangt_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANHS  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  Hessenberg matrix A.

function SLANHS (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANHS, "slanhs_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANSB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n symmetric band matrix A,  with k super-diagonals.

function SLANSB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANSB, "slansb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANSP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric matrix A,  supplied in packed form.

function SLANSP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANSP, "slansp_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANST  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric tridiagonal matrix A.

function SLANST (
	NORM	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANST, "slanst_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANSY  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric matrix A.

function SLANSY (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANSY, "slansy_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANTB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n triangular band matrix A,  with ( k + 1 ) diagonals.

function SLANTB (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANTB, "slantb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANTP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  triangular matrix A, supplied in packed form.

function SLANTP (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANTP, "slantp_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANTR  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  trapezoidal or triangular matrix A.

function SLANTR (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, SLANTR, "slantr_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLANV2 computes the Schur factorization of a real 2-by-2 nonsymmetric
--  matrix in standard form:

procedure SLANV2 (
	A	 : Real;
	B	 : Real;
	C	 : Real;
	D	 : Real;
	RT1R	 : out Real;
	RT1I	 : out Real;
	RT2R	 : out Real;
	RT2I	 : out Real;
	CS	 : out Real;
	SN	 : out Real );

pragma Import ( Fortran, SLANV2, "slanv2_");

--  LAPACK auxiliary routine (version 2.0) --
--  Given two column vectors X and Y, let

procedure SLAPLL (
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Real_Vector;
	INCY	 : Fortran_Integer;
	SSMIN	 : out Real );

pragma Import ( Fortran, SLAPLL, "slapll_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAPMT rearranges the columns of the M by N matrix X as specified
--  by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
--  If FORWRD = .TRUE.,  forward permutation:

procedure SLAPMT (
	FORWRD	 : Logical;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	K	 : Fortran_Integer_Vector );

pragma Import ( Fortran, SLAPMT, "slapmt_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAPY2 returns sqrt(x**2+y**2), taking care not to cause unnecessary
--  overflow.

function SLAPY2 (
	X	 : Real;
	Y	 : Real ) Return Real;

pragma Import ( Fortran, SLAPY2, "slapy2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAPY3 returns sqrt(x**2+y**2+z**2), taking care not to cause
--  unnecessary overflow.

function SLAPY3 (
	X	 : Real;
	Y	 : Real;
	Z	 : Real ) Return Real;

pragma Import ( Fortran, SLAPY3, "slapy3_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQGB equilibrates a general M by N band matrix A with KL
--  subdiagonals and KU superdiagonals using the row and scaling factors
--  in the vectors R and C.

procedure SLAQGB (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, SLAQGB, "slaqgb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQGE equilibrates a general M by N matrix A using the row and
--  scaling factors in the vectors R and C.

procedure SLAQGE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	ROWCND	 : Real;
	COLCND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, SLAQGE, "slaqge_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQSB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure SLAQSB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, SLAQSB, "slaqsb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQSP equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure SLAQSP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, SLAQSP, "slaqsp_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQSY equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure SLAQSY (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, SLAQSY, "slaqsy_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAQTR solves the real quasi-triangular system

procedure SLAQTR (
	LTRAN	 : Logical;
	LREAL	 : Logical;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	B	 : Fortran_Real_Vector;
	W	 : Real;
	SCALE	 : out Real;
	X	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAQTR, "slaqtr_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAR2V applies a vector of real plane rotations from both sides to
--  a sequence of 2-by-2 real symmetric matrices, defined by the elements
--  of the vectors x, y and z. For i = 1,2,...,n

procedure SLAR2V (
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	Y	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Real_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, SLAR2V, "slar2v_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARF applies a real elementary reflector H to a real m by n matrix
--  C, from either the left or the right. H is represented in the form

procedure SLARF (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Real_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Real;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector );

pragma Import ( Fortran, SLARF, "slarf_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARFB applies a real block reflector H or its transpose H' to a
--  real m by n matrix C, from either the left or the right.

procedure SLARFB (
	SIDE	 : Character;
	TRANS	 : Character;
	DIRECT	 : Character;
	STOREV	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Matrix;
	LDWORK	 : Fortran_Integer );

pragma Import ( Fortran, SLARFB, "slarfb_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARFG generates a real elementary reflector H of order n, such
--  that

procedure SLARFG (
	N	 : Fortran_Integer;
	ALPHA	 : Real;
	X	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	TAU	 : out Real );

pragma Import ( Fortran, SLARFG, "slarfg_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARFT forms the triangular factor T of a real block reflector H
--  of order n, which is defined as a product of k elementary reflectors.

procedure SLARFT (
	DIRECT	 : Character;
	STOREV	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	T	 : out Fortran_Real_Matrix;
	LDT	 : Fortran_Integer );

pragma Import ( Fortran, SLARFT, "slarft_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARFX applies a real elementary reflector H to a real m by n
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure SLARFX (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Real_Vector;
	TAU	 : Real;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector );

pragma Import ( Fortran, SLARFX, "slarfx_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARGV generates a vector of real plane rotations, determined by
--  elements of the real vectors x and y. For i = 1,2,...,n

procedure SLARGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Real_Vector;
	INCY	 : Fortran_Integer;
	C	 : out Fortran_Real_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, SLARGV, "slargv_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARNV returns a vector of n random real numbers from a uniform or
--  normal distribution.

procedure SLARNV (
	IDIST	 : Fortran_Integer;
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Real_Vector );

pragma Import ( Fortran, SLARNV, "slarnv_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARTG generate a plane rotation so that

procedure SLARTG (
	F	 : Real;
	G	 : Real;
	CS	 : out Real;
	SN	 : out Real;
	R	 : out Real );

pragma Import ( Fortran, SLARTG, "slartg_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARTV applies a vector of real plane rotations to elements of the
--  real vectors x and y. For i = 1,2,...,n

procedure SLARTV (
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Real_Vector;
	INCY	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Real_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, SLARTV, "slartv_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLARUV returns a vector of n random real numbers from a uniform (0,1)
--  distribution (n <= 128).

procedure SLARUV (
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Real_Vector );

pragma Import ( Fortran, SLARUV, "slaruv_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAS2  computes the singular values of the 2-by-2 matrix
--     [  F   G  ]
--     [  0   H  ].
--  On return, SSMIN is the smaller singular value and SSMAX is the
--  larger singular value.

procedure SLAS2 (
	F	 : Real;
	G	 : Real;
	H	 : Real;
	SSMIN	 : out Real;
	SSMAX	 : out Real );

pragma Import ( Fortran, SLAS2, "slas2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASCL multiplies the M by N real matrix A by the real scalar
--  CTO/CFROM.  This is done without over/underflow as long as the final
--  result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that
--  A may be full, upper triangular, lower triangular, upper Hessenberg,
--  or banded.

procedure SLASCL (
	M_TYPE	 : Character;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	CFROM	 : Real;
	CTO	 : Real;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASCL, "slascl_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASET initializes an m-by-n matrix A to BETA on the diagonal and
--  ALPHA on the offdiagonals.

procedure SLASET (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ALPHA	 : Real;
	BETA	 : Real;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, SLASET, "slaset_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASR   performs the transformation

procedure SLASR (
	SIDE	 : Character;
	PIVOT	 : Character;
	DIRECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Real_Vector;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, SLASR, "slasr_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASSQ  returns the values  scl  and  smsq  such that

procedure SLASSQ (
	N	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer;
	SCALE	 : Real;
	SUMSQ	 : Real );

pragma Import ( Fortran, SLASSQ, "slassq_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASV2 computes the singular value decomposition of a 2-by-2
--  triangular matrix
--     [  F   G  ]
--     [  0   H  ].
--  On return, abs(SSMAX) is the larger singular value, abs(SSMIN) is the
--  smaller singular value, and (CSL,SNL) and (CSR,SNR) are the left and
--  right singular vectors for abs(SSMAX), giving the decomposition

procedure SLASV2 (
	F	 : Real;
	G	 : Real;
	H	 : Real;
	SSMIN	 : out Real;
	SSMAX	 : out Real;
	SNR	 : out Real;
	CSR	 : out Real;
	SNL	 : out Real;
	CSL	 : out Real );

pragma Import ( Fortran, SLASV2, "slasv2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASWP performs a series of row interchanges on the matrix A.
--  One row interchange is initiated for each of rows K1 through K2 of A.

procedure SLASWP (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	K1	 : Fortran_Integer;
	K2	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, SLASWP, "slaswp_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLASY2 solves for the N1 by N2 matrix X, 1 <= N1,N2 <= 2, in

procedure SLASY2 (
	LTRANL	 : Logical;
	LTRANR	 : Logical;
	ISGN	 : Fortran_Integer;
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	TL	 : Fortran_Real_Matrix;
	LDTL	 : Fortran_Integer;
	TR	 : Fortran_Real_Matrix;
	LDTR	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	SCALE	 : out Real;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	XNORM	 : out Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLASY2, "slasy2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLATBS solves one of the triangular systems

procedure SLATBS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLATBS, "slatbs_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLATPS solves one of the triangular systems

procedure SLATPS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	X	 : Fortran_Real_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLATPS, "slatps_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLATRD reduces NB rows and columns of a real symmetric matrix A to
--  symmetric tridiagonal form by an orthogonal similarity
--  transformation Q' * A * Q, and returns the matrices V and W which are
--  needed to apply the transformation to the unreduced part of A.

procedure SLATRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	W	 : out Fortran_Real_Matrix;
	LDW	 : Fortran_Integer );

pragma Import ( Fortran, SLATRD, "slatrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLATRS solves one of the triangular systems

procedure SLATRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Real_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLATRS, "slatrs_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAUU2 computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure SLAUU2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAUU2, "slauu2_");

--  LAPACK auxiliary routine (version 2.0) --
--  SLAUUM computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure SLAUUM (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, SLAUUM, "slauum_");

--  LAPACK auxiliary routine (version 2.0) --
--  SRSCL multiplies an n-element real vector x by the real scalar 1/a.
--  This is done without overflow or underflow as long as
--  the final result x/a does not overflow or underflow.

procedure SRSCL (
	N	 : Fortran_Integer;
	SA	 : Real;
	SX	 : Fortran_Real_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, SRSCL, "srscl_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLABAD takes as input the values computed by SLAMCH for underflow and
--  overflow, and returns the square root of each of these values if the
--  log of LARGE is sufficiently large.  This subroutine is intended to
--  identify machines with a large exponent range, such as the Crays, and
--  redefine the underflow and overflow limits to be the square roots of
--  the values computed by DLAMCH.  This subroutine is needed because
--  DLAMCH does not compensate for poor arithmetic in the upper half of
--  the exponent range, as is found on a Cray.

procedure DLABAD (
	SMALL	 : Double_Precision;
	LARGE	 : Double_Precision );

pragma Import ( Fortran, DLABAD, "dlabad_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLABRD reduces the first NB rows and columns of a real general
--  m by n matrix A to upper or lower bidiagonal form by an orthogonal
--  transformation Q' * A * P, and returns the matrices X and Y which
--  are needed to apply the transformation to the unreduced part of A.

procedure DLABRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Double_Precision_Vector;
	TAUP	 : out Fortran_Double_Precision_Vector;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	Y	 : out Fortran_Double_Precision_Matrix;
	LDY	 : out Fortran_Integer );

pragma Import ( Fortran, DLABRD, "dlabrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLACON estimates the 1-norm of a square, real matrix A.
--  Reverse communication is used for evaluating matrix-vector products.

procedure DLACON (
	N	 : Fortran_Integer;
	V	 : in out Fortran_Double_Precision_Vector;
	X	 : Fortran_Double_Precision_Vector;
	ISGN	 : in out Fortran_Integer_Vector;
	EST	 : out Double_Precision;
	KASE	 : Fortran_Integer );

pragma Import ( Fortran, DLACON, "dlacon_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLACPY copies all or part of a two-dimensional matrix A to another
--  matrix B.

procedure DLACPY (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : out Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, DLACPY, "dlacpy_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLADIV performs complex division in  real arithmetic

procedure DLADIV (
	A	 : Double_Precision;
	B	 : Double_Precision;
	C	 : Double_Precision;
	D	 : Double_Precision;
	P	 : out Double_Precision;
	Q	 : out Double_Precision );

pragma Import ( Fortran, DLADIV, "dladiv_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAE2  computes the eigenvalues of a 2-by-2 symmetric matrix
--     [  A   B  ]
--     [  B   C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, and RT2
--  is the eigenvalue of smaller absolute value.

procedure DLAE2 (
	A	 : Double_Precision;
	B	 : Double_Precision;
	C	 : Double_Precision;
	RT1	 : out Double_Precision;
	RT2	 : out Double_Precision );

pragma Import ( Fortran, DLAE2, "dlae2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAEBZ contains the iteration loops which compute and use the
--  function N(w), which is the count of eigenvalues of a symmetric
--  tridiagonal matrix T less than or equal to its argument  w.  It
--  performs a choice of two types of loops:

procedure DLAEBZ (
	IJOB	 : Fortran_Integer;
	NITMAX	 : Fortran_Integer;
	N	 : Fortran_Integer;
	MMAX	 : Fortran_Integer;
	MINP	 : Fortran_Integer;
	NBMIN	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	RELTOL	 : Double_Precision;
	PIVMIN	 : Double_Precision;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	E2	 : Fortran_Double_Precision_Vector;
	NVAL	 : Fortran_Integer_Vector;
	AB	 : Fortran_Double_Precision_Matrix;
	C	 : Fortran_Double_Precision_Vector;
	MOUT	 : out Fortran_Integer;
	NAB	 : Fortran_Integer_Matrix;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAEBZ, "dlaebz_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAEIN uses inverse iteration to find a right or left eigenvector
--  corresponding to the eigenvalue (WR,WI) of a real upper Hessenberg
--  matrix H.

procedure DLAEIN (
	RIGHTV	 : Logical;
	NOINIT	 : Logical;
	N	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Double_Precision;
	WI	 : Double_Precision;
	VR	 : Fortran_Double_Precision_Vector;
	VI	 : Fortran_Double_Precision_Vector;
	B	 : in out Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	EPS3	 : Double_Precision;
	SMLNUM	 : Double_Precision;
	BIGNUM	 : Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAEIN, "dlaein_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAEV2 computes the eigendecomposition of a 2-by-2 symmetric matrix
--     [  A   B  ]
--     [  B   C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
--  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
--  eigenvector for RT1, giving the decomposition

procedure DLAEV2 (
	A	 : Double_Precision;
	B	 : Double_Precision;
	C	 : Double_Precision;
	RT1	 : out Double_Precision;
	RT2	 : out Double_Precision;
	CS1	 : out Double_Precision;
	SN1	 : out Double_Precision );

pragma Import ( Fortran, DLAEV2, "dlaev2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAEXC swaps adjacent diagonal blocks T11 and T22 of order 1 or 2 in
--  an upper quasi-triangular matrix T by an orthogonal similarity
--  transformation.

procedure DLAEXC (
	WANTQ	 : Logical;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	J1	 : Fortran_Integer;
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAEXC, "dlaexc_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAG2 computes the eigenvalues of a 2 x 2 generalized eigenvalue
--  problem  A - w B, with scaling as necessary to avoid over-/underflow.

procedure DLAG2 (
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	SAFMIN	 : Double_Precision;
	SCALE1	 : out Double_Precision;
	SCALE2	 : out Double_Precision;
	WR1	 : out Double_Precision;
	WR2	 : out Double_Precision;
	WI	 : out Double_Precision );

pragma Import ( Fortran, DLAG2, "dlag2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAGS2 computes 2-by-2 orthogonal matrices U, V and Q, such
--  that if ( UPPER ) then

procedure DLAGS2 (
	UPPER	 : Logical;
	A1	 : Double_Precision;
	A2	 : Double_Precision;
	A3	 : Double_Precision;
	B1	 : Double_Precision;
	B2	 : Double_Precision;
	B3	 : Double_Precision;
	CSU	 : out Double_Precision;
	SNU	 : out Double_Precision;
	CSV	 : out Double_Precision;
	SNV	 : out Double_Precision;
	CSQ	 : out Double_Precision;
	SNQ	 : out Double_Precision );

pragma Import ( Fortran, DLAGS2, "dlags2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAGTM performs a matrix-vector product of the form

procedure DLAGTM (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	ALPHA	 : Double_Precision;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	BETA	 : Double_Precision;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, DLAGTM, "dlagtm_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAGTS may be used to solve one of the systems of equations

procedure DLAGTS (
	JOB	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	P_IN	 : Fortran_Integer_Vector;
	Y	 : Fortran_Double_Precision_Vector;
	TOL	 : Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAGTS, "dlagts_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAHQR is an auxiliary routine called by DHSEQR to update the
--  eigenvalues and Schur decomposition already computed by DHSEQR, by
--  dealing with the Hessenberg submatrix in rows and columns ILO to IHI.

procedure DLAHQR (
	WANTT	 : Logical;
	WANTZ	 : Logical;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	ILOZ	 : Fortran_Integer;
	IHIZ	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAHQR, "dlahqr_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAHRD reduces the first NB columns of a real general n-by-(n-k+1)
--  matrix A so that elements below the k-th subdiagonal are zero. The
--  reduction is performed by an orthogonal similarity transformation
--  Q' * A * Q. The routine returns the matrices V and T which determine
--  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

procedure DLAHRD (
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	T	 : out Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Y	 : out Fortran_Double_Precision_Matrix;
	LDY	 : Fortran_Integer );

pragma Import ( Fortran, DLAHRD, "dlahrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAIC1 applies one step of incremental condition estimation in
--  its simplest version:

procedure DLAIC1 (
	JOB	 : Fortran_Integer;
	J	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	SEST	 : Double_Precision;
	W	 : Fortran_Double_Precision_Vector;
	GAMMA	 : Double_Precision;
	SESTPR	 : Double_Precision;
	S	 : out Double_Precision;
	C	 : out Double_Precision );

pragma Import ( Fortran, DLAIC1, "dlaic1_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLALN2 solves a system of the form  (ca A - w D ) X = s B
--  or (ca A' - w D) X = s B   with possible scaling ("s") and
--  perturbation of A.  (A' means A-transpose.)

procedure DLALN2 (
	LTRANS	 : Logical;
	NA	 : Fortran_Integer;
	NW	 : Fortran_Integer;
	SMIN	 : Double_Precision;
	CA	 : Double_Precision;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D1	 : Double_Precision;
	D2	 : Double_Precision;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WR	 : Double_Precision;
	WI	 : Double_Precision;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	XNORM	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLALN2, "dlaln2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAMCH determines double precision machine parameters.

function DLAMCH (
	CMACH	 : Character ) Return Double_Precision;

pragma Import ( Fortran, DLAMCH, "dlamch_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANGB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n band matrix  A,  with kl sub-diagonals and ku super-diagonals.

function DLANGB (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANGB, "dlangb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANGE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real matrix A.

function DLANGE (
	NORM	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANGE, "dlange_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANGT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real tridiagonal matrix A.

function DLANGT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANGT, "dlangt_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANHS  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  Hessenberg matrix A.

function DLANHS (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANHS, "dlanhs_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANSB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n symmetric band matrix A,  with k super-diagonals.

function DLANSB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANSB, "dlansb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANSP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric matrix A,  supplied in packed form.

function DLANSP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANSP, "dlansp_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANST  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric tridiagonal matrix A.

function DLANST (
	NORM	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANST, "dlanst_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANSY  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  real symmetric matrix A.

function DLANSY (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANSY, "dlansy_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANTB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n triangular band matrix A,  with ( k + 1 ) diagonals.

function DLANTB (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANTB, "dlantb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANTP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  triangular matrix A, supplied in packed form.

function DLANTP (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANTP, "dlantp_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANTR  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  trapezoidal or triangular matrix A.

function DLANTR (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, DLANTR, "dlantr_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLANV2 computes the Schur factorization of a real 2-by-2 nonsymmetric
--  matrix in standard form:

procedure DLANV2 (
	A	 : Double_Precision;
	B	 : Double_Precision;
	C	 : Double_Precision;
	D	 : Double_Precision;
	RT1R	 : out Double_Precision;
	RT1I	 : out Double_Precision;
	RT2R	 : out Double_Precision;
	RT2I	 : out Double_Precision;
	CS	 : out Double_Precision;
	SN	 : out Double_Precision );

pragma Import ( Fortran, DLANV2, "dlanv2_");

--  LAPACK auxiliary routine (version 2.0) --
--  Given two column vectors X and Y, let

procedure DLAPLL (
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Double_Precision_Vector;
	INCY	 : Fortran_Integer;
	SSMIN	 : out Double_Precision );

pragma Import ( Fortran, DLAPLL, "dlapll_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAPMT rearranges the columns of the M by N matrix X as specified
--  by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
--  If FORWRD = .TRUE.,  forward permutation:

procedure DLAPMT (
	FORWRD	 : Logical;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	K	 : Fortran_Integer_Vector );

pragma Import ( Fortran, DLAPMT, "dlapmt_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAPY2 returns sqrt(x**2+y**2), taking care not to cause unnecessary
--  overflow.

function DLAPY2 (
	X	 : Double_Precision;
	Y	 : Double_Precision ) Return Double_Precision;

pragma Import ( Fortran, DLAPY2, "dlapy2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAPY3 returns sqrt(x**2+y**2+z**2), taking care not to cause
--  unnecessary overflow.

function DLAPY3 (
	X	 : Double_Precision;
	Y	 : Double_Precision;
	Z	 : Double_Precision ) Return Double_Precision;

pragma Import ( Fortran, DLAPY3, "dlapy3_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQGB equilibrates a general M by N band matrix A with KL
--  subdiagonals and KU superdiagonals using the row and scaling factors
--  in the vectors R and C.

procedure DLAQGB (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, DLAQGB, "dlaqgb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQGE equilibrates a general M by N matrix A using the row and
--  scaling factors in the vectors R and C.

procedure DLAQGE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	ROWCND	 : Double_Precision;
	COLCND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, DLAQGE, "dlaqge_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQSB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure DLAQSB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, DLAQSB, "dlaqsb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQSP equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure DLAQSP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, DLAQSP, "dlaqsp_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQSY equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure DLAQSY (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, DLAQSY, "dlaqsy_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAQTR solves the real quasi-triangular system

procedure DLAQTR (
	LTRAN	 : Logical;
	LREAL	 : Logical;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Vector;
	W	 : Double_Precision;
	SCALE	 : out Double_Precision;
	X	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAQTR, "dlaqtr_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAR2V applies a vector of real plane rotations from both sides to
--  a sequence of 2-by-2 real symmetric matrices, defined by the elements
--  of the vectors x, y and z. For i = 1,2,...,n

procedure DLAR2V (
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	Y	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Double_Precision_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, DLAR2V, "dlar2v_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARF applies a real elementary reflector H to a real m by n matrix
--  C, from either the left or the right. H is represented in the form

procedure DLARF (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Double_Precision;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, DLARF, "dlarf_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARFB applies a real block reflector H or its transpose H' to a
--  real m by n matrix C, from either the left or the right.

procedure DLARFB (
	SIDE	 : Character;
	TRANS	 : Character;
	DIRECT	 : Character;
	STOREV	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Matrix;
	LDWORK	 : Fortran_Integer );

pragma Import ( Fortran, DLARFB, "dlarfb_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARFG generates a real elementary reflector H of order n, such
--  that

procedure DLARFG (
	N	 : Fortran_Integer;
	ALPHA	 : Double_Precision;
	X	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	TAU	 : out Double_Precision );

pragma Import ( Fortran, DLARFG, "dlarfg_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARFT forms the triangular factor T of a real block reflector H
--  of order n, which is defined as a product of k elementary reflectors.

procedure DLARFT (
	DIRECT	 : Character;
	STOREV	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	T	 : out Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer );

pragma Import ( Fortran, DLARFT, "dlarft_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARFX applies a real elementary reflector H to a real m by n
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure DLARFX (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Vector;
	TAU	 : Double_Precision;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, DLARFX, "dlarfx_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARGV generates a vector of real plane rotations, determined by
--  elements of the real vectors x and y. For i = 1,2,...,n

procedure DLARGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Double_Precision_Vector;
	INCY	 : Fortran_Integer;
	C	 : out Fortran_Double_Precision_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, DLARGV, "dlargv_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARNV returns a vector of n random real numbers from a uniform or
--  normal distribution.

procedure DLARNV (
	IDIST	 : Fortran_Integer;
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, DLARNV, "dlarnv_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARTG generate a plane rotation so that

procedure DLARTG (
	F	 : Double_Precision;
	G	 : Double_Precision;
	CS	 : out Double_Precision;
	SN	 : out Double_Precision;
	R	 : out Double_Precision );

pragma Import ( Fortran, DLARTG, "dlartg_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARTV applies a vector of real plane rotations to elements of the
--  real vectors x and y. For i = 1,2,...,n

procedure DLARTV (
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Double_Precision_Vector;
	INCY	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Double_Precision_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, DLARTV, "dlartv_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLARUV returns a vector of n random real numbers from a uniform (0,1)
--  distribution (n <= 128).

procedure DLARUV (
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, DLARUV, "dlaruv_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAS2  computes the singular values of the 2-by-2 matrix
--     [  F   G  ]
--     [  0   H  ].
--  On return, SSMIN is the smaller singular value and SSMAX is the
--  larger singular value.

procedure DLAS2 (
	F	 : Double_Precision;
	G	 : Double_Precision;
	H	 : Double_Precision;
	SSMIN	 : out Double_Precision;
	SSMAX	 : out Double_Precision );

pragma Import ( Fortran, DLAS2, "dlas2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASCL multiplies the M by N real matrix A by the real scalar
--  CTO/CFROM.  This is done without over/underflow as long as the final
--  result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that
--  A may be full, upper triangular, lower triangular, upper Hessenberg,
--  or banded.

procedure DLASCL (
	M_TYPE	 : Character;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	CFROM	 : Double_Precision;
	CTO	 : Double_Precision;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASCL, "dlascl_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASET initializes an m-by-n matrix A to BETA on the diagonal and
--  ALPHA on the offdiagonals.

procedure DLASET (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ALPHA	 : Double_Precision;
	BETA	 : Double_Precision;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, DLASET, "dlaset_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASR   performs the transformation

procedure DLASR (
	SIDE	 : Character;
	PIVOT	 : Character;
	DIRECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Double_Precision_Vector;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, DLASR, "dlasr_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASSQ  returns the values  scl  and  smsq  such that

procedure DLASSQ (
	N	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer;
	SCALE	 : Double_Precision;
	SUMSQ	 : Double_Precision );

pragma Import ( Fortran, DLASSQ, "dlassq_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASV2 computes the singular value decomposition of a 2-by-2
--  triangular matrix
--     [  F   G  ]
--     [  0   H  ].
--  On return, abs(SSMAX) is the larger singular value, abs(SSMIN) is the
--  smaller singular value, and (CSL,SNL) and (CSR,SNR) are the left and
--  right singular vectors for abs(SSMAX), giving the decomposition

procedure DLASV2 (
	F	 : Double_Precision;
	G	 : Double_Precision;
	H	 : Double_Precision;
	SSMIN	 : out Double_Precision;
	SSMAX	 : out Double_Precision;
	SNR	 : out Double_Precision;
	CSR	 : out Double_Precision;
	SNL	 : out Double_Precision;
	CSL	 : out Double_Precision );

pragma Import ( Fortran, DLASV2, "dlasv2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASWP performs a series of row interchanges on the matrix A.
--  One row interchange is initiated for each of rows K1 through K2 of A.

procedure DLASWP (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	K1	 : Fortran_Integer;
	K2	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, DLASWP, "dlaswp_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLASY2 solves for the N1 by N2 matrix X, 1 <= N1,N2 <= 2, in

procedure DLASY2 (
	LTRANL	 : Logical;
	LTRANR	 : Logical;
	ISGN	 : Fortran_Integer;
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	TL	 : Fortran_Double_Precision_Matrix;
	LDTL	 : Fortran_Integer;
	TR	 : Fortran_Double_Precision_Matrix;
	LDTR	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	XNORM	 : out Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLASY2, "dlasy2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLATBS solves one of the triangular systems

procedure DLATBS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLATBS, "dlatbs_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLATPS solves one of the triangular systems

procedure DLATPS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	X	 : Fortran_Double_Precision_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLATPS, "dlatps_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLATRD reduces NB rows and columns of a real symmetric matrix A to
--  symmetric tridiagonal form by an orthogonal similarity
--  transformation Q' * A * Q, and returns the matrices V and W which are
--  needed to apply the transformation to the unreduced part of A.

procedure DLATRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Matrix;
	LDW	 : Fortran_Integer );

pragma Import ( Fortran, DLATRD, "dlatrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLATRS solves one of the triangular systems

procedure DLATRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLATRS, "dlatrs_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAUU2 computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure DLAUU2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAUU2, "dlauu2_");

--  LAPACK auxiliary routine (version 2.0) --
--  DLAUUM computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure DLAUUM (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, DLAUUM, "dlauum_");

--  LAPACK auxiliary routine (version 2.0) --
--  DRSCL multiplies an n-element real vector x by the real scalar 1/a.
--  This is done without overflow or underflow as long as
--  the final result x/a does not overflow or underflow.

procedure DRSCL (
	N	 : Fortran_Integer;
	SA	 : Double_Precision;
	SX	 : Fortran_Double_Precision_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, DRSCL, "drscl_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLABRD reduces the first NB rows and columns of a complex general
--  m by n matrix A to upper or lower real bidiagonal form by a unitary
--  transformation Q' * A * P, and returns the matrices X and Y which
--  are needed to apply the transformation to the unreduced part of A.

procedure CLABRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Complex_Vector;
	TAUP	 : out Fortran_Complex_Vector;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	Y	 : out Fortran_Complex_Matrix;
	LDY	 : out Fortran_Integer );

pragma Import ( Fortran, CLABRD, "clabrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLACGV conjugates a complex vector of length N.

procedure CLACGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, CLACGV, "clacgv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLACON estimates the 1-norm of a square, complex matrix A.
--  Reverse communication is used for evaluating matrix-vector products.

procedure CLACON (
	N	 : Fortran_Integer;
	V	 : in out Fortran_Complex_Vector;
	X	 : Fortran_Complex_Vector;
	EST	 : out Real;
	KASE	 : Fortran_Integer );

pragma Import ( Fortran, CLACON, "clacon_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLACPY copies all or part of a two-dimensional matrix A to another
--  matrix B.

procedure CLACPY (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : out Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, CLACPY, "clacpy_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLACRM performs a very simple matrix-matrix multiplication:
--           C := A * B,
--  where A is M by N and complex; B is N by N and real;
--  C is M by N and complex.

procedure CLACRM (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector );

pragma Import ( Fortran, CLACRM, "clacrm_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLACRT applies a plane rotation, where the cos and sin (C and S) are
--  complex and the vectors CX and CY are complex.

procedure CLACRT (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	CY	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer;
	C	 : Complex;
	S	 : Complex );

pragma Import ( Fortran, CLACRT, "clacrt_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLADIV := X / Y, where X and Y are complex.  The computation of X / Y
--  will not overflow on an intermediary step unless the results
--  overflows.

function CLADIV (
	X	 : Complex;
	Y	 : Complex ) Return Complex;

pragma Import ( Fortran, CLADIV, "cladiv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAEIN uses inverse iteration to find a right or left eigenvector
--  corresponding to the eigenvalue W of a complex upper Hessenberg
--  matrix H.

procedure CLAEIN (
	RIGHTV	 : Logical;
	NOINIT	 : Logical;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Complex;
	V	 : Fortran_Complex_Vector;
	B	 : in out Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	EPS3	 : Real;
	SMLNUM	 : Real;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAEIN, "claein_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAESY computes the eigendecomposition of a 2-by-2 symmetric matrix
--     ( ( A, B );( B, C ) )
--  provided the norm of the matrix of eigenvectors is larger than
--  some threshold value.

procedure CLAESY (
	A	 : Complex;
	B	 : Complex;
	C	 : Complex;
	RT1	 : out Complex;
	RT2	 : out Complex;
	EVSCAL	 : out Complex;
	CS1	 : out Complex;
	SN1	 : out Complex );

pragma Import ( Fortran, CLAESY, "claesy_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAEV2 computes the eigendecomposition of a 2-by-2 Hermitian matrix
--     [  A         B  ]
--     [  CONJG(B)  C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
--  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
--  eigenvector for RT1, giving the decomposition

procedure CLAEV2 (
	A	 : Complex;
	B	 : Complex;
	C	 : Complex;
	RT1	 : out Real;
	RT2	 : out Real;
	CS1	 : out Real;
	SN1	 : out Complex );

pragma Import ( Fortran, CLAEV2, "claev2_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAGS2 computes 2-by-2 unitary matrices U, V and Q, such
--  that if ( UPPER ) then

procedure CLAGS2 (
	UPPER	 : Logical;
	A1	 : Real;
	A2	 : Complex;
	A3	 : Real;
	B1	 : Real;
	B2	 : Complex;
	B3	 : Real;
	CSU	 : out Real;
	SNU	 : out Complex;
	CSV	 : out Real;
	SNV	 : out Complex;
	CSQ	 : out Real;
	SNQ	 : out Complex );

pragma Import ( Fortran, CLAGS2, "clags2_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAGTM performs a matrix-vector product of the form

procedure CLAGTM (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	ALPHA	 : Real;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	BETA	 : Real;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, CLAGTM, "clagtm_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAHQR is an auxiliary routine called by CHSEQR to update the
--  eigenvalues and Schur decomposition already computed by CHSEQR, by
--  dealing with the Hessenberg submatrix in rows and columns ILO to IHI.

procedure CLAHQR (
	WANTT	 : Logical;
	WANTZ	 : Logical;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	ILOZ	 : Fortran_Integer;
	IHIZ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAHQR, "clahqr_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAHRD reduces the first NB columns of a complex general n-by-(n-k+1)
--  matrix A so that elements below the k-th subdiagonal are zero. The
--  reduction is performed by a unitary similarity transformation
--  Q' * A * Q. The routine returns the matrices V and T which determine
--  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

procedure CLAHRD (
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	T	 : out Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	Y	 : out Fortran_Complex_Matrix;
	LDY	 : Fortran_Integer );

pragma Import ( Fortran, CLAHRD, "clahrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAIC1 applies one step of incremental condition estimation in
--  its simplest version:

procedure CLAIC1 (
	JOB	 : Fortran_Integer;
	J	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	SEST	 : Real;
	W	 : Fortran_Complex_Vector;
	GAMMA	 : Complex;
	SESTPR	 : out Real;
	S	 : out Complex;
	C	 : out Complex );

pragma Import ( Fortran, CLAIC1, "claic1_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANGB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n band matrix  A,  with kl sub-diagonals and ku super-diagonals.

function CLANGB (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANGB, "clangb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANGE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex matrix A.

function CLANGE (
	NORM	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANGE, "clange_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANGT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex tridiagonal matrix A.

function CLANGT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector ) Return Real;

pragma Import ( Fortran, CLANGT, "clangt_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANHB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n hermitian band matrix A,  with k super-diagonals.

function CLANHB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANHB, "clanhb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANHE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex hermitian matrix A.

function CLANHE (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANHE, "clanhe_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANHP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex hermitian matrix A,  supplied in packed form.

function CLANHP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANHP, "clanhp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANHS  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  Hessenberg matrix A.

function CLANHS (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANHS, "clanhs_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANHT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex Hermitian tridiagonal matrix A.

function CLANHT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector ) Return Real;

pragma Import ( Fortran, CLANHT, "clanht_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANSB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n symmetric band matrix A,  with k super-diagonals.

function CLANSB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANSB, "clansb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANSP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex symmetric matrix A,  supplied in packed form.

function CLANSP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANSP, "clansp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANSY  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex symmetric matrix A.

function CLANSY (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANSY, "clansy_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANTB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n triangular band matrix A,  with ( k + 1 ) diagonals.

function CLANTB (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANTB, "clantb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANTP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  triangular matrix A, supplied in packed form.

function CLANTP (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANTP, "clantp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLANTR  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  trapezoidal or triangular matrix A.

function CLANTR (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector ) Return Real;

pragma Import ( Fortran, CLANTR, "clantr_");

--  LAPACK auxiliary routine (version 2.0) --
--  Given two column vectors X and Y, let

procedure CLAPLL (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer;
	SSMIN	 : out Real );

pragma Import ( Fortran, CLAPLL, "clapll_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAPMT rearranges the columns of the M by N matrix X as specified
--  by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
--  If FORWRD = .TRUE.,  forward permutation:

procedure CLAPMT (
	FORWRD	 : Logical;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	K	 : Fortran_Integer_Vector );

pragma Import ( Fortran, CLAPMT, "clapmt_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQGB equilibrates a general M by N band matrix A with KL
--  subdiagonals and KU superdiagonals using the row and scaling factors
--  in the vectors R and C.

procedure CLAQGB (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQGB, "claqgb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQGE equilibrates a general M by N matrix A using the row and
--  scaling factors in the vectors R and C.

procedure CLAQGE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	ROWCND	 : Real;
	COLCND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQGE, "claqge_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQHB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure CLAQHB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQHB, "claqhb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQHE equilibrates a Hermitian matrix A using the scaling factors
--  in the vector S.

procedure CLAQHE (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQHE, "claqhe_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQHP equilibrates a Hermitian matrix A using the scaling factors
--  in the vector S.

procedure CLAQHP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQHP, "claqhp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQSB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure CLAQSB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQSB, "claqsb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQSP equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure CLAQSP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQSP, "claqsp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAQSY equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure CLAQSY (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Real_Vector;
	SCOND	 : Real;
	AMAX	 : Real;
	EQUED	 : out Character );

pragma Import ( Fortran, CLAQSY, "claqsy_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAR2V applies a vector of complex plane rotations with real cosines
--  from both sides to a sequence of 2-by-2 complex Hermitian matrices,
--  defined by the elements of the vectors x, y and z. For i = 1,2,...,n

procedure CLAR2V (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	Y	 : Fortran_Complex_Vector;
	Z	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Complex_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, CLAR2V, "clar2v_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARF applies a complex elementary reflector H to a complex M-by-N
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure CLARF (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector );

pragma Import ( Fortran, CLARF, "clarf_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARFB applies a complex block reflector H or its transpose H' to a
--  complex M-by-N matrix C, from either the left or the right.

procedure CLARFB (
	SIDE	 : Character;
	TRANS	 : Character;
	DIRECT	 : Character;
	STOREV	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Matrix;
	LDWORK	 : Fortran_Integer );

pragma Import ( Fortran, CLARFB, "clarfb_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARFG generates a complex elementary reflector H of order n, such
--  that

procedure CLARFG (
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	TAU	 : out Complex );

pragma Import ( Fortran, CLARFG, "clarfg_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARFT forms the triangular factor T of a complex block reflector H
--  of order n, which is defined as a product of k elementary reflectors.

procedure CLARFT (
	DIRECT	 : Character;
	STOREV	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	T	 : out Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer );

pragma Import ( Fortran, CLARFT, "clarft_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARFX applies a complex elementary reflector H to a complex m by n
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure CLARFX (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Vector;
	TAU	 : Complex;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector );

pragma Import ( Fortran, CLARFX, "clarfx_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARGV generates a vector of complex plane rotations with real
--  cosines, determined by elements of the complex vectors x and y.
--  For i = 1,2,...,n

procedure CLARGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer;
	C	 : out Fortran_Real_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, CLARGV, "clargv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARNV returns a vector of n random complex numbers from a uniform or
--  normal distribution.

procedure CLARNV (
	IDIST	 : Fortran_Integer;
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Complex_Vector );

pragma Import ( Fortran, CLARNV, "clarnv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARTG generates a plane rotation so that

procedure CLARTG (
	F	 : Complex;
	G	 : Complex;
	CS	 : out Real;
	SN	 : out Complex;
	R	 : out Complex );

pragma Import ( Fortran, CLARTG, "clartg_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLARTV applies a vector of complex plane rotations with real cosines
--  to elements of the complex vectors x and y. For i = 1,2,...,n

procedure CLARTV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Complex_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, CLARTV, "clartv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLASCL multiplies the M by N complex matrix A by the real scalar
--  CTO/CFROM.  This is done without over/underflow as long as the final
--  result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that
--  A may be full, upper triangular, lower triangular, upper Hessenberg,
--  or banded.

procedure CLASCL (
	M_TYPE	 : Character;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	CFROM	 : Real;
	CTO	 : Real;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLASCL, "clascl_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLASET initializes a 2-D array A to BETA on the diagonal and
--  ALPHA on the offdiagonals.

procedure CLASET (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	BETA	 : Complex;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, CLASET, "claset_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLASR   performs the transformation

procedure CLASR (
	SIDE	 : Character;
	PIVOT	 : Character;
	DIRECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	S	 : Fortran_Real_Vector;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, CLASR, "clasr_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLASSQ returns the values scl and ssq such that

procedure CLASSQ (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	SCALE	 : Real;
	SUMSQ	 : Real );

pragma Import ( Fortran, CLASSQ, "classq_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLASWP performs a series of row interchanges on the matrix A.
--  One row interchange is initiated for each of rows K1 through K2 of A.

procedure CLASWP (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	K1	 : Fortran_Integer;
	K2	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, CLASWP, "claswp_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLATBS solves one of the triangular systems

procedure CLATBS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLATBS, "clatbs_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLATPS solves one of the triangular systems

procedure CLATPS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	X	 : Fortran_Complex_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLATPS, "clatps_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLATRD reduces NB rows and columns of a complex Hermitian matrix A to
--  Hermitian tridiagonal form by a unitary similarity
--  transformation Q' * A * Q, and returns the matrices V and W which are
--  needed to apply the transformation to the unreduced part of A.

procedure CLATRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	W	 : out Fortran_Complex_Matrix;
	LDW	 : Fortran_Integer );

pragma Import ( Fortran, CLATRD, "clatrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLATRS solves one of the triangular systems

procedure CLATRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	SCALE	 : out Real;
	CNORM	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLATRS, "clatrs_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAUU2 computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure CLAUU2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAUU2, "clauu2_");

--  LAPACK auxiliary routine (version 2.0) --
--  CLAUUM computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure CLAUUM (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CLAUUM, "clauum_");

--  LAPACK auxiliary routine (version 2.0) --
--  CROT   applies a plane rotation, where the cos (C) is real and the
--  sin (S) is complex, and the vectors CX and CY are complex.

procedure CROT (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	CY	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer;
	C	 : Real;
	S	 : Complex );

pragma Import ( Fortran, CROT, "crot_");

--  LAPACK auxiliary routine (version 2.0) --
--  CSPMV  performs the matrix-vector operation

procedure CSPMV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	AP	 : Fortran_Complex_Vector;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	BETA	 : Complex;
	Y	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer );

pragma Import ( Fortran, CSPMV, "cspmv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CSPR    performs the symmetric rank 1 operation

procedure CSPR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector );

pragma Import ( Fortran, CSPR, "cspr_");

--  LAPACK auxiliary routine (version 2.0) --
--  CSRSCL multiplies an n-element complex vector x by the real scalar
--  1/a.  This is done without overflow or underflow as long as
--  the final result x/a does not overflow or underflow.

procedure CSRSCL (
	N	 : Fortran_Integer;
	SA	 : Real;
	SX	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, CSRSCL, "csrscl_");

--  LAPACK auxiliary routine (version 2.0) --
--  CSYMV  performs the matrix-vector  operation

procedure CSYMV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	BETA	 : Complex;
	Y	 : Fortran_Complex_Vector;
	INCY	 : Fortran_Integer );

pragma Import ( Fortran, CSYMV, "csymv_");

--  LAPACK auxiliary routine (version 2.0) --
--  CSYR   performs the symmetric rank 1 operation

procedure CSYR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex;
	X	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, CSYR, "csyr_");

--  LAPACK auxiliary routine (version 2.0) --
--  CGEQPF computes a QR factorization with column pivoting of a
--  complex M-by-N matrix A: A*P = Q*R.

procedure CGEQPF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, CGEQPF, "cgeqpf_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLABRD reduces the first NB rows and columns of a complex general
--  m by n matrix A to upper or lower real bidiagonal form by a unitary
--  transformation Q' * A * P, and returns the matrices X and Y which
--  are needed to apply the transformation to the unreduced part of A.

procedure ZLABRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Complex_Star_16_Vector;
	TAUP	 : out Fortran_Complex_Star_16_Vector;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	Y	 : out Fortran_Complex_Star_16_Matrix;
	LDY	 : out Fortran_Integer );

pragma Import ( Fortran, ZLABRD, "zlabrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLACGV conjugates a complex vector of length N.

procedure ZLACGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, ZLACGV, "zlacgv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLACON estimates the 1-norm of a square, complex matrix A.
--  Reverse communication is used for evaluating matrix-vector products.

procedure ZLACON (
	N	 : Fortran_Integer;
	V	 : in out Fortran_Complex_Star_16_Vector;
	X	 : Fortran_Complex_Star_16_Vector;
	EST	 : out Double_Precision;
	KASE	 : Fortran_Integer );

pragma Import ( Fortran, ZLACON, "zlacon_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLACPY copies all or part of a two-dimensional matrix A to another
--  matrix B.

procedure ZLACPY (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : out Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, ZLACPY, "zlacpy_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLACRM performs a very simple matrix-matrix multiplication:
--           C := A * B,
--  where A is M by N and complex; B is N by N and real;
--  C is M by N and complex.

procedure ZLACRM (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector );

pragma Import ( Fortran, ZLACRM, "zlacrm_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLACRT applies a plane rotation, where the cos and sin (C and S) are
--  complex and the vectors CX and CY are complex.

procedure ZLACRT (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	CY	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer;
	C	 : Complex_Star_16;
	S	 : Complex_Star_16 );

pragma Import ( Fortran, ZLACRT, "zlacrt_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLADIV := X / Y, where X and Y are complex.  The computation of X / Y
--  will not overflow on an intermediary step unless the results
--  overflows.

function ZLADIV (
	X	 : Complex_Star_16;
	Y	 : Complex_Star_16 ) Return Complex;

pragma Import ( Fortran, ZLADIV, "zladiv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAEIN uses inverse iteration to find a right or left eigenvector
--  corresponding to the eigenvalue W of a complex upper Hessenberg
--  matrix H.

procedure ZLAEIN (
	RIGHTV	 : Logical;
	NOINIT	 : Logical;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Complex_Star_16;
	V	 : Fortran_Complex_Star_16_Vector;
	B	 : in out Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	EPS3	 : Double_Precision;
	SMLNUM	 : Double_Precision;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAEIN, "zlaein_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAESY computes the eigendecomposition of a 2-by-2 symmetric matrix
--     ( ( A, B );( B, C ) )
--  provided the norm of the matrix of eigenvectors is larger than
--  some threshold value.

procedure ZLAESY (
	A	 : Complex_Star_16;
	B	 : Complex_Star_16;
	C	 : Complex_Star_16;
	RT1	 : out Complex_Star_16;
	RT2	 : out Complex_Star_16;
	EVSCAL	 : out Complex_Star_16;
	CS1	 : out Complex_Star_16;
	SN1	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLAESY, "zlaesy_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAEV2 computes the eigendecomposition of a 2-by-2 Hermitian matrix
--     [  A         B  ]
--     [  CONJG(B)  C  ].
--  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
--  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
--  eigenvector for RT1, giving the decomposition

procedure ZLAEV2 (
	A	 : Complex_Star_16;
	B	 : Complex_Star_16;
	C	 : Complex_Star_16;
	RT1	 : out Double_Precision;
	RT2	 : out Double_Precision;
	CS1	 : out Double_Precision;
	SN1	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLAEV2, "zlaev2_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAGS2 computes 2-by-2 unitary matrices U, V and Q, such
--  that if ( UPPER ) then

procedure ZLAGS2 (
	UPPER	 : Logical;
	A1	 : Double_Precision;
	A2	 : Complex_Star_16;
	A3	 : Double_Precision;
	B1	 : Double_Precision;
	B2	 : Complex_Star_16;
	B3	 : Double_Precision;
	CSU	 : out Double_Precision;
	SNU	 : out Complex_Star_16;
	CSV	 : out Double_Precision;
	SNV	 : out Complex_Star_16;
	CSQ	 : out Double_Precision;
	SNQ	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLAGS2, "zlags2_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAGTM performs a matrix-vector product of the form

procedure ZLAGTM (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	ALPHA	 : Double_Precision;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	BETA	 : Double_Precision;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer );

pragma Import ( Fortran, ZLAGTM, "zlagtm_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAHQR is an auxiliary routine called by ZHSEQR to update the
--  eigenvalues and Schur decomposition already computed by ZHSEQR, by
--  dealing with the Hessenberg submatrix in rows and columns ILO to IHI.

procedure ZLAHQR (
	WANTT	 : Logical;
	WANTZ	 : Logical;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	ILOZ	 : Fortran_Integer;
	IHIZ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAHQR, "zlahqr_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAHRD reduces the first NB columns of a complex general n-by-(n-k+1)
--  matrix A so that elements below the k-th subdiagonal are zero. The
--  reduction is performed by a unitary similarity transformation
--  Q' * A * Q. The routine returns the matrices V and T which determine
--  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

procedure ZLAHRD (
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	T	 : out Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	Y	 : out Fortran_Complex_Star_16_Matrix;
	LDY	 : Fortran_Integer );

pragma Import ( Fortran, ZLAHRD, "zlahrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAIC1 applies one step of incremental condition estimation in
--  its simplest version:

procedure ZLAIC1 (
	JOB	 : Fortran_Integer;
	J	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	SEST	 : Double_Precision;
	W	 : Fortran_Complex_Star_16_Vector;
	GAMMA	 : Complex_Star_16;
	SESTPR	 : Double_Precision;
	S	 : out Complex_Star_16;
	C	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLAIC1, "zlaic1_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANGB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n band matrix  A,  with kl sub-diagonals and ku super-diagonals.

function ZLANGB (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANGB, "zlangb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANGE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex matrix A.

function ZLANGE (
	NORM	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANGE, "zlange_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANGT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex tridiagonal matrix A.

function ZLANGT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANGT, "zlangt_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANHB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n hermitian band matrix A,  with k super-diagonals.

function ZLANHB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANHB, "zlanhb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANHE  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex hermitian matrix A.

function ZLANHE (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANHE, "zlanhe_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANHP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex hermitian matrix A,  supplied in packed form.

function ZLANHP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANHP, "zlanhp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANHS  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  Hessenberg matrix A.

function ZLANHS (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANHS, "zlanhs_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANHT  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex Hermitian tridiagonal matrix A.

function ZLANHT (
	NORM	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANHT, "zlanht_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANSB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n symmetric band matrix A,  with k super-diagonals.

function ZLANSB (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANSB, "zlansb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANSP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex symmetric matrix A,  supplied in packed form.

function ZLANSP (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANSP, "zlansp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANSY  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  complex symmetric matrix A.

function ZLANSY (
	NORM	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANSY, "zlansy_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANTB  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the element of  largest absolute value  of an
--  n by n triangular band matrix A,  with ( k + 1 ) diagonals.

function ZLANTB (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANTB, "zlantb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANTP  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  triangular matrix A, supplied in packed form.

function ZLANTP (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANTP, "zlantp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLANTR  returns the value of the one norm,  or the Frobenius norm, or
--  the  infinity norm,  or the  element of  largest absolute value  of a
--  trapezoidal or triangular matrix A.

function ZLANTR (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	WORK	 : Fortran_Double_Precision_Vector ) Return Double_Precision;

pragma Import ( Fortran, ZLANTR, "zlantr_");

--  LAPACK auxiliary routine (version 2.0) --
--  Given two column vectors X and Y, let

procedure ZLAPLL (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer;
	SSMIN	 : out Double_Precision );

pragma Import ( Fortran, ZLAPLL, "zlapll_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAPMT rearranges the columns of the M by N matrix X as specified
--  by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
--  If FORWRD = .TRUE.,  forward permutation:

procedure ZLAPMT (
	FORWRD	 : Logical;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	K	 : Fortran_Integer_Vector );

pragma Import ( Fortran, ZLAPMT, "zlapmt_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQGB equilibrates a general M by N band matrix A with KL
--  subdiagonals and KU superdiagonals using the row and scaling factors
--  in the vectors R and C.

procedure ZLAQGB (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQGB, "zlaqgb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQGE equilibrates a general M by N matrix A using the row and
--  scaling factors in the vectors R and C.

procedure ZLAQGE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	ROWCND	 : Double_Precision;
	COLCND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQGE, "zlaqge_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQHB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure ZLAQHB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQHB, "zlaqhb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQHE equilibrates a Hermitian matrix A using the scaling factors
--  in the vector S.

procedure ZLAQHE (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQHE, "zlaqhe_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQHP equilibrates a Hermitian matrix A using the scaling factors
--  in the vector S.

procedure ZLAQHP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQHP, "zlaqhp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQSB equilibrates a symmetric band matrix A using the scaling
--  factors in the vector S.

procedure ZLAQSB (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQSB, "zlaqsb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQSP equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure ZLAQSP (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQSP, "zlaqsp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAQSY equilibrates a symmetric matrix A using the scaling factors
--  in the vector S.

procedure ZLAQSY (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : Fortran_Double_Precision_Vector;
	SCOND	 : Double_Precision;
	AMAX	 : Double_Precision;
	EQUED	 : out Character );

pragma Import ( Fortran, ZLAQSY, "zlaqsy_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAR2V applies a vector of complex plane rotations with real cosines
--  from both sides to a sequence of 2-by-2 complex Hermitian matrices,
--  defined by the elements of the vectors x, y and z. For i = 1,2,...,n

procedure ZLAR2V (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	Y	 : Fortran_Complex_Star_16_Vector;
	Z	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Complex_Star_16_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, ZLAR2V, "zlar2v_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARF applies a complex elementary reflector H to a complex M-by-N
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure ZLARF (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex_Star_16;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector );

pragma Import ( Fortran, ZLARF, "zlarf_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARFB applies a complex block reflector H or its transpose H' to a
--  complex M-by-N matrix C, from either the left or the right.

procedure ZLARFB (
	SIDE	 : Character;
	TRANS	 : Character;
	DIRECT	 : Character;
	STOREV	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Matrix;
	LDWORK	 : Fortran_Integer );

pragma Import ( Fortran, ZLARFB, "zlarfb_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARFG generates a complex elementary reflector H of order n, such
--  that

procedure ZLARFG (
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	TAU	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLARFG, "zlarfg_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARFT forms the triangular factor T of a complex block reflector H
--  of order n, which is defined as a product of k elementary reflectors.

procedure ZLARFT (
	DIRECT	 : Character;
	STOREV	 : Character;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	T	 : out Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer );

pragma Import ( Fortran, ZLARFT, "zlarft_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARFX applies a complex elementary reflector H to a complex m by n
--  matrix C, from either the left or the right. H is represented in the
--  form

procedure ZLARFX (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Vector;
	TAU	 : Complex_Star_16;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector );

pragma Import ( Fortran, ZLARFX, "zlarfx_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARGV generates a vector of complex plane rotations with real
--  cosines, determined by elements of the complex vectors x and y.
--  For i = 1,2,...,n

procedure ZLARGV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer;
	C	 : out Fortran_Double_Precision_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, ZLARGV, "zlargv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARNV returns a vector of n random complex numbers from a uniform or
--  normal distribution.

procedure ZLARNV (
	IDIST	 : Fortran_Integer;
	ISEED	 : Fortran_Integer_Vector;
	N	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Vector );

pragma Import ( Fortran, ZLARNV, "zlarnv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARTG generates a plane rotation so that

procedure ZLARTG (
	F	 : Complex_Star_16;
	G	 : Complex_Star_16;
	CS	 : out Double_Precision;
	SN	 : out Complex_Star_16;
	R	 : out Complex_Star_16 );

pragma Import ( Fortran, ZLARTG, "zlartg_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLARTV applies a vector of complex plane rotations with real cosines
--  to elements of the complex vectors x and y. For i = 1,2,...,n

procedure ZLARTV (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	Y	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Complex_Star_16_Vector;
	INCC	 : Fortran_Integer );

pragma Import ( Fortran, ZLARTV, "zlartv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLASCL multiplies the M by N complex matrix A by the real scalar
--  CTO/CFROM.  This is done without over/underflow as long as the final
--  result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that
--  A may be full, upper triangular, lower triangular, upper Hessenberg,
--  or banded.

procedure ZLASCL (
	M_TYPE	 : Character;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	CFROM	 : Double_Precision;
	CTO	 : Double_Precision;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLASCL, "zlascl_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLASET initializes a 2-D array A to BETA on the diagonal and
--  ALPHA on the offdiagonals.

procedure ZLASET (
	UPLO	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	BETA	 : Complex_Star_16;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, ZLASET, "zlaset_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLASR   performs the transformation

procedure ZLASR (
	SIDE	 : Character;
	PIVOT	 : Character;
	DIRECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	S	 : Fortran_Double_Precision_Vector;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, ZLASR, "zlasr_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLASSQ returns the values scl and ssq such that

procedure ZLASSQ (
	N	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	SCALE	 : Double_Precision;
	SUMSQ	 : Double_Precision );

pragma Import ( Fortran, ZLASSQ, "zlassq_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLASWP performs a series of row interchanges on the matrix A.
--  One row interchange is initiated for each of rows K1 through K2 of A.

procedure ZLASWP (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	K1	 : Fortran_Integer;
	K2	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, ZLASWP, "zlaswp_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLATBS solves one of the triangular systems

procedure ZLATBS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLATBS, "zlatbs_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLATPS solves one of the triangular systems

procedure ZLATPS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	X	 : Fortran_Complex_Star_16_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLATPS, "zlatps_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLATRD reduces NB rows and columns of a complex Hermitian matrix A to
--  Hermitian tridiagonal form by a unitary similarity
--  transformation Q' * A * Q, and returns the matrices V and W which are
--  needed to apply the transformation to the unreduced part of A.

procedure ZLATRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Complex_Star_16_Matrix;
	LDW	 : Fortran_Integer );

pragma Import ( Fortran, ZLATRD, "zlatrd_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLATRS solves one of the triangular systems

procedure ZLATRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	NORMIN	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	SCALE	 : out Double_Precision;
	CNORM	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLATRS, "zlatrs_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAUU2 computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure ZLAUU2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAUU2, "zlauu2_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZLAUUM computes the product U * U' or L' * L, where the triangular
--  factor U or L is stored in the upper or lower triangular part of
--  the array A.

procedure ZLAUUM (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZLAUUM, "zlauum_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZROT   applies a plane rotation, where the cos (C) is real and the
--  sin (S) is complex, and the vectors CX and CY are complex.

procedure ZROT (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	CY	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer;
	C	 : Double_Precision;
	S	 : Complex_Star_16 );

pragma Import ( Fortran, ZROT, "zrot_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZSPMV  performs the matrix-vector operation

procedure ZSPMV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	AP	 : Fortran_Complex_Star_16_Vector;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	BETA	 : Complex_Star_16;
	Y	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer );

pragma Import ( Fortran, ZSPMV, "zspmv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZSPR    performs the symmetric rank 1 operation

procedure ZSPR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector );

pragma Import ( Fortran, ZSPR, "zspr_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZDRSCL multiplies an n-element complex vector x by the real scalar
--  1/a.  This is done without overflow or underflow as long as
--  the final result x/a does not overflow or underflow.

procedure ZDRSCL (
	N	 : Fortran_Integer;
	SA	 : Double_Precision;
	SX	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer );

pragma Import ( Fortran, ZDRSCL, "zdrscl_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZSYMV  performs the matrix-vector  operation

procedure ZSYMV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	BETA	 : Complex_Star_16;
	Y	 : Fortran_Complex_Star_16_Vector;
	INCY	 : Fortran_Integer );

pragma Import ( Fortran, ZSYMV, "zsymv_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZSYR   performs the symmetric rank 1 operation

procedure ZSYR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	ALPHA	 : Complex_Star_16;
	X	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer );

pragma Import ( Fortran, ZSYR, "zsyr_");

--  LAPACK auxiliary routine (version 2.0) --
--  ZGEQPF computes a QR factorization with column pivoting of a
--  complex M-by-N matrix A: A*P = Q*R.

procedure ZGEQPF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer );

pragma Import ( Fortran, ZGEQPF, "zgeqpf_");

--  LAPACK auxiliary routine (version 2.0) --
--  ICMAX1 finds the index of the element whose real part has maximum
--  absolute value.

function ICMAX1 (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer ) Return Fortran_Integer;

pragma Import ( Fortran, ICMAX1, "icmax1_");

--  LAPACK auxiliary routine (version 2.0) --
--  ILAENV is called from the LAPACK routines to choose problem-dependent
--  parameters for the local environment.  See ISPEC for a description of
--  the parameters.

function ILAENV (
	ISPEC	 : Fortran_Integer;
	NAME	 : String;
	OPTS	 : String;
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	N3	 : Fortran_Integer;
	N4	 : Fortran_Integer ) Return Fortran_Integer;

pragma Import ( Fortran, ILAENV, "ilaenv_");

--  LAPACK auxiliary routine (version 2.0) --
--  IZMAX1 finds the index of the element whose real part has maximum
--  absolute value.

function IZMAX1 (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer ) Return Fortran_Integer;

pragma Import ( Fortran, IZMAX1, "izmax1_");

--  LAPACK auxiliary routine (version 2.0) --
--  LSAME returns .TRUE. if CA is the same letter as CB regardless of
--  case.

function LSAME (
	CA	 : Character;
	CB	 : Character ) Return Logical;

pragma Import ( Fortran, LSAME, "lsame_");

--  LAPACK auxiliary routine (version 2.0) --
--  LSAMEN  tests if the first N letters of CA are the same as the
--  first N letters of CB, regardless of case.
--  LSAMEN returns .TRUE. if CA and CB are equivalent except for case
--  and .FALSE. otherwise.  LSAMEN also returns .FALSE. if LEN( CA )
--  or LEN( CB ) is less than N.

function LSAMEN (
	N	 : Fortran_Integer;
	CA	 : String;
	CB	 : String ) Return Logical;

pragma Import ( Fortran, LSAMEN, "lsamen_");

--  LAPACK auxiliary routine (version 2.0) --
--  SCSUM1 takes the sum of the absolute values of a complex
--  vector and returns a single precision result.

function SCSUM1 (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Vector;
	INCX	 : Fortran_Integer ) Return Real;

pragma Import ( Fortran, SCSUM1, "scsum1_");

--  LAPACK auxiliary routine (version 2.0) --
--  SECOND returns the user time for a process in seconds.
--  This version gets the time from the system function ETIME.

function SECOND Return Real;

pragma Import ( Fortran, SECOND, "second_");

--  LAPACK auxiliary routine (version 2.0) --
--  DSECND returns the user time for a process in seconds.
--  This version gets the time from the system function ETIME.

function DSECND Return Double_Precision;

pragma Import ( Fortran, DSECND, "dsecnd_");

--  LAPACK auxiliary routine (version 2.0) --
--  DZSUM1 takes the sum of the absolute values of a complex
--  vector and returns a double precision result.

function DZSUM1 (
	N	 : Fortran_Integer;
	CX	 : Fortran_Complex_Star_16_Vector;
	INCX	 : Fortran_Integer ) Return Double_Precision;

pragma Import ( Fortran, DZSUM1, "dzsum1_");

--  LAPACK auxiliary routine (version 2.0) --
--  XERBLA  is an error handler for the LAPACK routines.
--  It is called by an LAPACK routine if an input parameter has an
--  invalid value.  A message is printed and execution stops.

procedure XERBLA (
	SRNAME	 : String;
	INFO	 : Fortran_Integer );

pragma Import ( Fortran, XERBLA, "xerbla_");

end lapack.aux;
