------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------
with Interfaces.Fortran; use  Interfaces.Fortran;
with labase; use  labase;
with ladrv;  use  ladrv;

package ladrv1 is

--  LAPACK driver routine (version 2.0) --
--  CGBSV computes the solution to a complex system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGBSV;


--  LAPACK driver routine (version 2.0) --
--  CGBSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGBSVX;


--  LAPACK driver routine (version 2.0) --
--  CGEEV computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGEEV;


--  LAPACK driver routine (version 2.0) --
--  CGEEVX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	ABNRM	 : out Real;
	RCONDE	 : out Fortran_Real_Vector;
	RCONDV	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGEEVX;


--  LAPACK driver routine (version 2.0) --
--  SGEGS computes for a pair of N-by-N complex nonsymmetric matrices A,
--  B:  the generalized eigenvalues (alpha, beta), the complex Schur
--  form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure GEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	VSL	 : out Fortran_Complex_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Complex_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGEGS;


--  LAPACK driver routine (version 2.0) --
--  CGEGV computes for a pair of N-by-N complex nonsymmetric matrices A
--  and B, the generalized eigenvalues (alpha, beta), and optionally,
--  the left and/or right generalized eigenvectors (VL and VR).

procedure GEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	VL	 : out Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGEGV;


--  LAPACK driver routine (version 2.0) --
--  CGELS solves overdetermined or underdetermined complex linear systems
--  involving an M-by-N matrix A, or its conjugate-transpose, using a QR
--  or LQ factorization of A.  It is assumed that A has full rank.

procedure GELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGELS;


--  LAPACK driver routine (version 2.0) --
--  CGELSS computes the minimum norm solution to a complex linear
--  least squares problem:

procedure GELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGELSS;


--  LAPACK driver routine (version 2.0) --
--  CGELSX computes the minimum-norm solution to a complex linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure GELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGELSX;


--  LAPACK driver routine (version 2.0) --
--  CGESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGESV;


--  LAPACK driver routine (version 2.0) --
--  CGESVD computes the singular value decomposition (SVD) of a complex
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure GESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Complex_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGESVD;


--  LAPACK driver routine (version 2.0) --
--  CGESVX uses the LU factorization to compute the solution to a complex
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGESVX;


--  LAPACK driver routine (version 2.0) --
--  CGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure GGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Complex_Vector;
	X	 : out Fortran_Complex_Vector;
	Y	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGGLM;


--  LAPACK driver routine (version 2.0) --
--  CGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure GGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	X	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGLSE;


--  LAPACK driver routine (version 2.0) --
--  CGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N complex matrix A and P-by-N complex matrix B:

procedure GGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGGSVD;


--  LAPACK driver routine (version 2.0) --
--  CHBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.

procedure HBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHBEV;


--  LAPACK driver routine (version 2.0) --
--  CHBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.  If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure HBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHBEVD;


--  LAPACK driver routine (version 2.0) --
--  CHBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian band matrix A.  Eigenvalues and eigenvectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure HBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHBEVX;


--  LAPACK driver routine (version 2.0) --
--  CHBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be Hermitian
--  and banded, and B is also positive definite.

procedure HBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHBGV;


--  LAPACK driver routine (version 2.0) --
--  CHEEV computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.

procedure HEEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHEEV;


--  LAPACK driver routine (version 2.0) --
--  CHEEVD computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.  If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure HEEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHEEVD;


--  LAPACK driver routine (version 2.0) --
--  CHEEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure HEEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHEEVX;


--  LAPACK driver routine (version 2.0) --
--  CHEGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian and B is also
--  positive definite.

procedure HEGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHEGV;


--  LAPACK driver routine (version 2.0) --
--  CHESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure HESV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHESV;


--  LAPACK driver routine (version 2.0) --
--  CHESVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure HESVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHESVX;


--  LAPACK driver routine (version 2.0) --
--  CHPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix in packed storage.

procedure HPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHPEV;


--  LAPACK driver routine (version 2.0) --
--  CHPEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian matrix A in packed storage.  If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure HPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHPEVD;


--  LAPACK driver routine (version 2.0) --
--  CHPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A in packed storage.
--  Eigenvalues/vectors can be selected by specifying either a range of
--  values or a range of indices for the desired eigenvalues.

procedure HPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHPEVX;


--  LAPACK driver routine (version 2.0) --
--  CHPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian, stored in packed format,
--  and B is also positive definite.

procedure HPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	BP	 : Fortran_Complex_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHPGV;


--  LAPACK driver routine (version 2.0) --
--  CHPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure HPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHPSV;


--  LAPACK driver routine (version 2.0) --
--  CHPSVX uses the diagonal pivoting factorization A = U*D*U**H or
--  A = L*D*L**H to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N Hermitian matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure HPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHPSVX;


--  LAPACK driver routine (version 2.0) --
--  CPBSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPBSV;


--  LAPACK driver routine (version 2.0) --
--  CPBSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPBSVX;


--  LAPACK driver routine (version 2.0) --
--  CPOSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPOSV;


--  LAPACK driver routine (version 2.0) --
--  CPOSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPOSVX;


--  LAPACK driver routine (version 2.0) --
--  CPPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPPSV;


--  LAPACK driver routine (version 2.0) --
--  CPPSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPPSVX;


--  LAPACK driver routine (version 2.0) --
--  CSPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure SPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSPSV;


--  LAPACK driver routine (version 2.0) --
--  CSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure SPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CSPSVX;


--  LAPACK driver routine (version 2.0) --
--  CSYSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSYSV;


--  LAPACK driver routine (version 2.0) --
--  CSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CSYSVX;


--  LAPACK driver routine (version 2.0) --
--  DGBSV computes the solution to a real system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGBSV;


--  LAPACK driver routine (version 2.0) --
--  DGBSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGBSVX;


--  LAPACK driver routine (version 2.0) --
--  DGEEV computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEEV;


--  LAPACK driver routine (version 2.0) --
--  DGEEVX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	ABNRM	 : out Double_Precision;
	RCONDE	 : out Fortran_Double_Precision_Vector;
	RCONDV	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGEEVX;


--  LAPACK driver routine (version 2.0) --
--  DGEGS computes for a pair of N-by-N real nonsymmetric matrices A, B:
--  the generalized eigenvalues (alphar +/- alphai*i, beta), the real
--  Schur form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure GEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	VSL	 : out Fortran_Double_Precision_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Double_Precision_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEGS;


--  LAPACK driver routine (version 2.0) --
--  DGEGV computes for a pair of n-by-n real nonsymmetric matrices A and
--  B, the generalized eigenvalues (alphar +/- alphai*i, beta), and
--  optionally, the left and/or right generalized eigenvectors (VL and
--  VR).

procedure GEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	VL	 : out Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEGV;


--  LAPACK driver routine (version 2.0) --
--  DGELS solves overdetermined or underdetermined real linear systems
--  involving an M-by-N matrix A, or its transpose, using a QR or LQ
--  factorization of A.  It is assumed that A has full rank.

procedure GELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGELS;


--  LAPACK driver routine (version 2.0) --
--  DGELSS computes the minimum norm solution to a real linear least
--  squares problem:

procedure GELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGELSS;


--  LAPACK driver routine (version 2.0) --
--  DGELSX computes the minimum-norm solution to a real linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure GELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGELSX;


--  LAPACK driver routine (version 2.0) --
--  DGESV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGESV;


--  LAPACK driver routine (version 2.0) --
--  DGESVD computes the singular value decomposition (SVD) of a real
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure GESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Double_Precision_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGESVD;


--  LAPACK driver routine (version 2.0) --
--  DGESVX uses the LU factorization to compute the solution to a real
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGESVX;


--  LAPACK driver routine (version 2.0) --
--  DGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure GGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	X	 : out Fortran_Double_Precision_Vector;
	Y	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGGLM;


--  LAPACK driver routine (version 2.0) --
--  DGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure GGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	X	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGLSE;


--  LAPACK driver routine (version 2.0) --
--  DGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N real matrix A and P-by-N real matrix B:

procedure GGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGGSVD;


--  LAPACK driver routine (version 2.0) --
--  DPBSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPBSV;


--  LAPACK driver routine (version 2.0) --
--  DPBSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPBSVX;


--  LAPACK driver routine (version 2.0) --
--  DPOSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPOSV;


--  LAPACK driver routine (version 2.0) --
--  DPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPOSVX;


--  LAPACK driver routine (version 2.0) --
--  DPPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPPSV;


--  LAPACK driver routine (version 2.0) --
--  DPPSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPPSVX;


--  LAPACK driver routine (version 2.0) --
--  DSBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A.

procedure SBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSBEV;


--  LAPACK driver routine (version 2.0) --
--  DSBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A. If eigenvectors are desired, it uses
--  a divide and conquer algorithm.

procedure SBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSBEVD;


--  LAPACK driver routine (version 2.0) --
--  DSBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric band matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSBEVX;


--  LAPACK driver routine (version 2.0) --
--  DSBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be symmetric
--  and banded, and B is also positive definite.

procedure SBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Double_Precision_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSBGV;


--  LAPACK driver routine (version 2.0) --
--  DSPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A in packed storage.

procedure SPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSPEV;


--  LAPACK driver routine (version 2.0) --
--  DSPEVD computes all the eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage. If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure SPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSPEVD;


--  LAPACK driver routine (version 2.0) --
--  DSPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage.  Eigenvalues/vectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSPEVX;


--  LAPACK driver routine (version 2.0) --
--  DSPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric, stored in packed format,
--  and B is also positive definite.

procedure SPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	BP	 : Fortran_Double_Precision_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSPGV;


--  LAPACK driver routine (version 2.0) --
--  DSPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure SPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSPSV;


--  LAPACK driver routine (version 2.0) --
--  DSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a real system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure SPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSPSVX;


--  LAPACK driver routine (version 2.0) --
--  DSTEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix A.

procedure STEV (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSTEV;


--  LAPACK driver routine (version 2.0) --
--  DSTEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix. If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure STEVD (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSTEVD;


--  LAPACK driver routine (version 2.0) --
--  DSTEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric tridiagonal matrix A.  Eigenvalues and
--  eigenvectors can be selected by specifying either a range of values
--  or a range of indices for the desired eigenvalues.

procedure STEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSTEVX;


--  LAPACK driver routine (version 2.0) --
--  DSYEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A.

procedure SYEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYEV;


--  LAPACK driver routine (version 2.0) --
--  DSYEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A. If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure SYEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYEVD;


--  LAPACK driver routine (version 2.0) --
--  DSYEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A.  Eigenvalues and eigenvectors can be
--  selected by specifying either a range of values or a range of indices
--  for the desired eigenvalues.

procedure SYEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSYEVX;


--  LAPACK driver routine (version 2.0) --
--  DSYGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric and B is also
--  positive definite.

procedure SYGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYGV;


--  LAPACK driver routine (version 2.0) --
--  DSYSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYSV;


--  LAPACK driver routine (version 2.0) --
--  DSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a real system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSYSVX;


--  LAPACK driver routine (version 2.0) --
--  SGBSV computes the solution to a real system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGBSV;


--  LAPACK driver routine (version 2.0) --
--  SGBSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGBSVX;


--  LAPACK driver routine (version 2.0) --
--  SGEEV computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEEV;


--  LAPACK driver routine (version 2.0) --
--  SGEEVX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	ABNRM	 : out Real;
	RCONDE	 : out Fortran_Real_Vector;
	RCONDV	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGEEVX;


--  LAPACK driver routine (version 2.0) --
--  SGEGS computes for a pair of N-by-N real nonsymmetric matrices A, B:
--  the generalized eigenvalues (alphar +/- alphai*i, beta), the real
--  Schur form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure GEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	VSL	 : out Fortran_Real_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Real_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEGS;


--  LAPACK driver routine (version 2.0) --
--  SGEGV computes for a pair of n-by-n real nonsymmetric matrices A and
--  B, the generalized eigenvalues (alphar +/- alphai*i, beta), and
--  optionally, the left and/or right generalized eigenvectors (VL and
--  VR).

procedure GEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	VL	 : out Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEGV;


--  LAPACK driver routine (version 2.0) --
--  SGELS solves overdetermined or underdetermined real linear systems
--  involving an M-by-N matrix A, or its transpose, using a QR or LQ
--  factorization of A.  It is assumed that A has full rank.

procedure GELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGELS;


--  LAPACK driver routine (version 2.0) --
--  SGELSS computes the minimum norm solution to a real linear least
--  squares problem:

procedure GELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGELSS;


--  LAPACK driver routine (version 2.0) --
--  SGELSX computes the minimum-norm solution to a real linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure GELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Real;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGELSX;


--  LAPACK driver routine (version 2.0) --
--  SGESV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGESV;


--  LAPACK driver routine (version 2.0) --
--  SGESVD computes the singular value decomposition (SVD) of a real
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure GESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Real_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGESVD;


--  LAPACK driver routine (version 2.0) --
--  SGESVX uses the LU factorization to compute the solution to a real
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGESVX;


--  LAPACK driver routine (version 2.0) --
--  SGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure GGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	X	 : out Fortran_Real_Vector;
	Y	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGGLM;


--  LAPACK driver routine (version 2.0) --
--  SGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure GGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	X	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGLSE;


--  LAPACK driver routine (version 2.0) --
--  SGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N real matrix A and P-by-N real matrix B:

procedure GGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGGSVD;


--  LAPACK driver routine (version 2.0) --
--  SPBSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPBSV;


--  LAPACK driver routine (version 2.0) --
--  SPBSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPBSVX;


--  LAPACK driver routine (version 2.0) --
--  SPOSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPOSV;


--  LAPACK driver routine (version 2.0) --
--  SPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPOSVX;


--  LAPACK driver routine (version 2.0) --
--  SPPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPPSV;


--  LAPACK driver routine (version 2.0) --
--  SPPSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
--  compute the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	EQUED	 : Character;
	S	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPPSVX;


--  LAPACK driver routine (version 2.0) --
--  SSBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A.

procedure SBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSBEV;


--  LAPACK driver routine (version 2.0) --
--  SSBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a real symmetric band matrix A. If eigenvectors are desired, it uses
--  a divide and conquer algorithm.

procedure SBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSBEVD;


--  LAPACK driver routine (version 2.0) --
--  SSBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric band matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSBEVX;


--  LAPACK driver routine (version 2.0) --
--  SSBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be symmetric
--  and banded, and B is also positive definite.

procedure SBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Real_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSBGV;


--  LAPACK driver routine (version 2.0) --
--  SSPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A in packed storage.

procedure SPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSPEV;


--  LAPACK driver routine (version 2.0) --
--  SSPEVD computes all the eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage. If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure SPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSPEVD;


--  LAPACK driver routine (version 2.0) --
--  SSPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A in packed storage.  Eigenvalues/vectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure SPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSPEVX;


--  LAPACK driver routine (version 2.0) --
--  SSPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric, stored in packed format,
--  and B is also positive definite.

procedure SPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	BP	 : Fortran_Real_Vector;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSPGV;


--  LAPACK driver routine (version 2.0) --
--  SSPSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure SPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSPSV;


--  LAPACK driver routine (version 2.0) --
--  SSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a real system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure SPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSPSVX;


--  LAPACK driver routine (version 2.0) --
--  SSTEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix A.

procedure STEV (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSTEV;


--  LAPACK driver routine (version 2.0) --
--  SSTEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric tridiagonal matrix. If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure STEVD (
	JOBZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSTEVD;


--  LAPACK driver routine (version 2.0) --
--  SSTEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric tridiagonal matrix A.  Eigenvalues and
--  eigenvectors can be selected by specifying either a range of values
--  or a range of indices for the desired eigenvalues.

procedure STEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSTEVX;


--  LAPACK driver routine (version 2.0) --
--  SSYEV computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A.

procedure SYEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYEV;


--  LAPACK driver routine (version 2.0) --
--  SSYEVD computes all eigenvalues and, optionally, eigenvectors of a
--  real symmetric matrix A. If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure SYEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYEVD;


--  LAPACK driver routine (version 2.0) --
--  SSYEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a real symmetric matrix A.  Eigenvalues and eigenvectors can be
--  selected by specifying either a range of values or a range of indices
--  for the desired eigenvalues.

procedure SYEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSYEVX;


--  LAPACK driver routine (version 2.0) --
--  SSYGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a real generalized symmetric-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be symmetric and B is also
--  positive definite.

procedure SYGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYGV;


--  LAPACK driver routine (version 2.0) --
--  SSYSV computes the solution to a real system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYSV;


--  LAPACK driver routine (version 2.0) --
--  SSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a real system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSYSVX;


--  LAPACK driver routine (version 2.0) --
--  ZGBSV computes the solution to a complex system of linear equations
--  A * X = B, where A is a band matrix of order N with KL subdiagonals
--  and KU superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSV (
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGBSV;


--  LAPACK driver routine (version 2.0) --
--  ZGBSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a band matrix of order N with KL subdiagonals and KU
--  superdiagonals, and X and B are N-by-NRHS matrices.

procedure GBSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBSVX;


--  LAPACK driver routine (version 2.0) --
--  ZGEEV computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEEV;


--  LAPACK driver routine (version 2.0) --
--  ZGEEVX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues and, optionally, the left and/or right eigenvectors.

procedure GEEVX (
	BALANC	 : Character;
	JOBVL	 : Character;
	JOBVR	 : Character;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	ABNRM	 : out Double_Precision;
	RCONDE	 : out Fortran_Double_Precision_Vector;
	RCONDV	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEEVX;


--  LAPACK driver routine (version 2.0) --
--  DGEGS computes for a pair of N-by-N complex nonsymmetric matrices A,
--  B:  the generalized eigenvalues (alpha, beta), the complex Schur
--  form (A, B), and optionally left and/or right Schur vectors
--  (VSL and VSR).

procedure GEGS (
	JOBVSL	 : Character;
	JOBVSR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	VSL	 : out Fortran_Complex_Star_16_Matrix;
	LDVSL	 : Fortran_Integer;
	VSR	 : out Fortran_Complex_Star_16_Matrix;
	LDVSR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEGS;


--  LAPACK driver routine (version 2.0) --
--  ZGEGV computes for a pair of N-by-N complex nonsymmetric matrices A
--  and B, the generalized eigenvalues (alpha, beta), and optionally,
--  the left and/or right generalized eigenvectors (VL and VR).

procedure GEGV (
	JOBVL	 : Character;
	JOBVR	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	VL	 : out Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : out Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEGV;


--  LAPACK driver routine (version 2.0) --
--  ZGELS solves overdetermined or underdetermined complex linear systems
--  involving an M-by-N matrix A, or its conjugate-transpose, using a QR
--  or LQ factorization of A.  It is assumed that A has full rank.

procedure GELS (
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGELS;


--  LAPACK driver routine (version 2.0) --
--  ZGELSS computes the minimum norm solution to a complex linear
--  least squares problem:

procedure GELSS (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGELSS;


--  LAPACK driver routine (version 2.0) --
--  ZGELSX computes the minimum-norm solution to a complex linear least
--  squares problem:
--      minimize || A * X - B ||
--  using a complete orthogonal factorization of A.  A is an M-by-N
--  matrix which may be rank-deficient.

procedure GELSX (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	JPVT	 : Fortran_Integer_Vector;
	RCOND	 : Double_Precision;
	RANK	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGELSX;


--  LAPACK driver routine (version 2.0) --
--  ZGESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGESV;


--  LAPACK driver routine (version 2.0) --
--  ZGESVD computes the singular value decomposition (SVD) of a complex
--  M-by-N matrix A, optionally computing the left and/or right singular
--  vectors. The SVD is written

procedure GESVD (
	JOBU	 : Character;
	JOBVT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	VT	 : out Fortran_Complex_Star_16_Matrix;
	LDVT	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGESVD;


--  LAPACK driver routine (version 2.0) --
--  ZGESVX uses the LU factorization to compute the solution to a complex
--  system of linear equations
--     A * X = B,
--  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

procedure GESVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	EQUED	 : Character;
	R	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGESVX;


--  LAPACK driver routine (version 2.0) --
--  ZGGGLM solves a general Gauss-Markov linear model (GLM) problem:

procedure GGGLM (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	D	 : Fortran_Complex_Star_16_Vector;
	X	 : out Fortran_Complex_Star_16_Vector;
	Y	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGGLM;


--  LAPACK driver routine (version 2.0) --
--  ZGGLSE solves the linear equality-constrained least squares (LSE)
--  problem:

procedure GGLSE (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	X	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGLSE;


--  LAPACK driver routine (version 2.0) --
--  ZGGSVD computes the generalized singular value decomposition (GSVD)
--  of an M-by-N complex matrix A and P-by-N complex matrix B:

procedure GGSVD (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	P	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGGSVD;


--  LAPACK driver routine (version 2.0) --
--  ZHBEV computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.

procedure HBEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHBEV;


--  LAPACK driver routine (version 2.0) --
--  ZHBEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian band matrix A.  If eigenvectors are desired, it
--  uses a divide and conquer algorithm.

procedure HBEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHBEVD;


--  LAPACK driver routine (version 2.0) --
--  ZHBEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian band matrix A.  Eigenvalues and eigenvectors
--  can be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure HBEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHBEVX;


--  LAPACK driver routine (version 2.0) --
--  ZHBGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite banded eigenproblem, of
--  the form A*x=(lambda)*B*x. Here A and B are assumed to be Hermitian
--  and banded, and B is also positive definite.

procedure HBGV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Star_16_Matrix;
	LDBB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHBGV;


--  LAPACK driver routine (version 2.0) --
--  ZHEEV computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.

procedure HEEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHEEV;


--  LAPACK driver routine (version 2.0) --
--  ZHEEVD computes all eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix A.  If eigenvectors are desired, it uses a
--  divide and conquer algorithm.

procedure HEEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHEEVD;


--  LAPACK driver routine (version 2.0) --
--  ZHEEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A.  Eigenvalues and eigenvectors can
--  be selected by specifying either a range of values or a range of
--  indices for the desired eigenvalues.

procedure HEEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHEEVX;


--  LAPACK driver routine (version 2.0) --
--  ZHEGV computes all the eigenvalues, and optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian and B is also
--  positive definite.

procedure HEGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHEGV;


--  LAPACK driver routine (version 2.0) --
--  ZHESV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure HESV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHESV;


--  LAPACK driver routine (version 2.0) --
--  ZHESVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N Hermitian matrix and X and B are N-by-NRHS
--  matrices.

procedure HESVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHESVX;


--  LAPACK driver routine (version 2.0) --
--  ZHPEV computes all the eigenvalues and, optionally, eigenvectors of a
--  complex Hermitian matrix in packed storage.

procedure HPEV (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPEV;


--  LAPACK driver routine (version 2.0) --
--  ZHPEVD computes all the eigenvalues and, optionally, eigenvectors of
--  a complex Hermitian matrix A in packed storage.  If eigenvectors are
--  desired, it uses a divide and conquer algorithm.

procedure HPEVD (
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHPEVD;


--  LAPACK driver routine (version 2.0) --
--  ZHPEVX computes selected eigenvalues and, optionally, eigenvectors
--  of a complex Hermitian matrix A in packed storage.
--  Eigenvalues/vectors can be selected by specifying either a range of
--  values or a range of indices for the desired eigenvalues.

procedure HPEVX (
	JOBZ	 : Character;
	M_RANGE	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	M	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPEVX;


--  LAPACK driver routine (version 2.0) --
--  ZHPGV computes all the eigenvalues and, optionally, the eigenvectors
--  of a complex generalized Hermitian-definite eigenproblem, of the form
--  A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.
--  Here A and B are assumed to be Hermitian, stored in packed format,
--  and B is also positive definite.

procedure HPGV (
	ITYPE	 : Fortran_Integer;
	JOBZ	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	BP	 : Fortran_Complex_Star_16_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPGV;


--  LAPACK driver routine (version 2.0) --
--  ZHPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure HPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHPSV;


--  LAPACK driver routine (version 2.0) --
--  ZHPSVX uses the diagonal pivoting factorization A = U*D*U**H or
--  A = L*D*L**H to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N Hermitian matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure HPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPSVX;


--  LAPACK driver routine (version 2.0) --
--  ZPBSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPBSV;


--  LAPACK driver routine (version 2.0) --
--  ZPBSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite band matrix and X
--  and B are N-by-NRHS matrices.

procedure PBSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPBSVX;


--  LAPACK driver routine (version 2.0) --
--  ZPOSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPOSV;


--  LAPACK driver routine (version 2.0) --
--  ZPOSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix and X and B
--  are N-by-NRHS matrices.

procedure POSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPOSVX;


--  LAPACK driver routine (version 2.0) --
--  ZPPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPPSV;


--  LAPACK driver routine (version 2.0) --
--  ZPPSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to
--  compute the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N Hermitian positive definite matrix stored in
--  packed format and X and B are N-by-NRHS matrices.

procedure PPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	EQUED	 : Character;
	S	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPPSVX;


--  LAPACK driver routine (version 2.0) --
--  ZSPSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix stored in packed format and X
--  and B are N-by-NRHS matrices.

procedure SPSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSPSV;


--  LAPACK driver routine (version 2.0) --
--  ZSPSVX uses the diagonal pivoting factorization A = U*D*U**T or
--  A = L*D*L**T to compute the solution to a complex system of linear
--  equations A * X = B, where A is an N-by-N symmetric matrix stored
--  in packed format and X and B are N-by-NRHS matrices.

procedure SPSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZSPSVX;


--  LAPACK driver routine (version 2.0) --
--  ZSYSV computes the solution to a complex system of linear equations
--     A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSV (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSYSV;


--  LAPACK driver routine (version 2.0) --
--  ZSYSVX uses the diagonal pivoting factorization to compute the
--  solution to a complex system of linear equations A * X = B,
--  where A is an N-by-N symmetric matrix and X and B are N-by-NRHS
--  matrices.

procedure SYSVX (
	FACT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZSYSVX;


--  LAPACK driver routine (version 2.0) --
--  SGEES computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure GEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_S_2;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VS	 : out Fortran_Real_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames SGEES;


--  LAPACK driver routine (version 2.0) --
--  SGEESX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure GEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_S_2;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	VS	 : out Fortran_Real_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Real;
	RCONDV	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames SGEESX;


--  LAPACK driver routine (version 2.0) --
--  CGEES computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure GEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_C_1;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : Fortran_Integer;
	W	 : Fortran_Complex_Vector;
	VS	 : Fortran_Complex_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : Fortran_Real_Vector;
	BWORK	 : Fortran_Logical_Vector;
	INFO	 : Fortran_Integer )
renames CGEES;


--  LAPACK driver routine (version 2.0) --
--  CGEESX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure GEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_C_1;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	VS	 : out Fortran_Complex_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Real;
	RCONDV	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames CGEESX;


--  LAPACK driver routine (version 2.0) --
--  DGEES computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure GEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_D_2;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VS	 : out Fortran_Double_Precision_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames DGEES;


--  LAPACK driver routine (version 2.0) --
--  DGEESX computes for an N-by-N real nonsymmetric matrix A, the
--  eigenvalues, the real Schur form T, and, optionally, the matrix of
--  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).

procedure GEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_D_2;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	VS	 : out Fortran_Double_Precision_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Double_Precision;
	RCONDV	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames DGEESX;


--  LAPACK driver routine (version 2.0) --
--  ZGEES computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure GEES (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 :  LFun_Z_1;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VS	 : out Fortran_Complex_Star_16_Matrix;
	LDVS	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEES;


--  LAPACK driver routine (version 2.0) --
--  ZGEESX computes for an N-by-N complex nonsymmetric matrix A, the
--  eigenvalues, the Schur form T, and, optionally, the matrix of Schur
--  vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).

procedure GEESX (
	JOBVS	 : Character;
	SORT	 : Character;
	L_SELECT	 : LFun_Z_1;
	SENSE	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	SDIM	 : out Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	VS	 : out Fortran_Complex_Star_16_Matrix;
	LDVS	 : Fortran_Integer;
	RCONDE	 : out Double_Precision;
	RCONDV	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	BWORK	 : in out Fortran_Logical_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEESX;


end ladrv1;
