------------------------------------------------------------------------------
--                                                                          --
--                            LAPADA   LIBRARY                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 0.1 $                              --
--                                                                          --
-- This specification is adapted from the Lapack Manual for use with        --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------
with Interfaces.Fortran; use  Interfaces.Fortran;
with labase; use  labase;

package lacmp1 is

--  LAPACK routine (version 2.0) --
--  CBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure BDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VT	 : Fortran_Complex_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CBDSQR;


--  LAPACK routine (version 2.0) --
--  CGBBRD reduces a complex general m-by-n band matrix A to real upper
--  bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure GBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Complex_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGBBRD;


--  LAPACK routine (version 2.0) --
--  CGBCON estimates the reciprocal of the condition number of a complex
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by CGBTRF.

procedure GBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGBCON;


--  LAPACK routine (version 2.0) --
--  CGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames CGBEQU;


--  LAPACK routine (version 2.0) --
--  CGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure GBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGBRFS;


--  LAPACK routine (version 2.0) --
--  CGBTF2 computes an LU factorization of a complex m-by-n band matrix
--  A using partial pivoting with row interchanges.

procedure GBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGBTF2;


--  LAPACK routine (version 2.0) --
--  CGBTRF computes an LU factorization of a complex m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGBTRF;


--  LAPACK routine (version 2.0) --
--  CGBTRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general band matrix A using the LU factorization computed
--  by CGBTRF.

procedure GBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGBTRS;


--  LAPACK routine (version 2.0) --
--  CGEBAK forms the right or left eigenvectors of a complex general
--  matrix by backward transformation on the computed eigenvectors of the
--  balanced matrix output by CGEBAL.

procedure GEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGEBAK;


--  LAPACK routine (version 2.0) --
--  CGEBAL balances a general complex matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure GEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGEBAL;


--  LAPACK routine (version 2.0) --
--  CGEBD2 reduces a complex general m by n matrix A to upper or lower
--  real bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure GEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Complex_Vector;
	TAUP	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGEBD2;


--  LAPACK routine (version 2.0) --
--  CGEBRD reduces a general complex M-by-N matrix A to upper or lower
--  bidiagonal form B by a unitary transformation: Q**H * A * P = B.

procedure GEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Complex_Vector;
	TAUP	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGEBRD;


--  LAPACK routine (version 2.0) --
--  CGECON estimates the reciprocal of the condition number of a general
--  complex matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by CGETRF.

procedure GECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGECON;


--  LAPACK routine (version 2.0) --
--  CGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames CGEEQU;


--  LAPACK routine (version 2.0) --
--  CGEHD2 reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure GEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGEHD2;


--  LAPACK routine (version 2.0) --
--  CGEHRD reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure GEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGEHRD;


--  LAPACK routine (version 2.0) --
--  CGELQ2 computes an LQ factorization of a complex m by n matrix A:
--  A = L * Q.

procedure GELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGELQ2;


--  LAPACK routine (version 2.0) --
--  CGELQF computes an LQ factorization of a complex M-by-N matrix A:
--  A = L * Q.

procedure GELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGELQF;


--  LAPACK routine (version 2.0) --
--  CGEQL2 computes a QL factorization of a complex m by n matrix A:
--  A = Q * L.

procedure GEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGEQL2;


--  LAPACK routine (version 2.0) --
--  CGEQLF computes a QL factorization of a complex M-by-N matrix A:
--  A = Q * L.

procedure GEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGEQLF;


--  LAPACK routine (version 2.0) --
--  CGEQR2 computes a QR factorization of a complex m by n matrix A:
--  A = Q * R.

procedure GEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGEQR2;


--  LAPACK routine (version 2.0) --
--  CGEQRF computes a QR factorization of a complex M-by-N matrix A:
--  A = Q * R.

procedure GEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGEQRF;


--  LAPACK routine (version 2.0) --
--  CGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure GERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGERFS;


--  LAPACK routine (version 2.0) --
--  CGERQ2 computes an RQ factorization of a complex m by n matrix A:
--  A = R * Q.

procedure GERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGERQ2;


--  LAPACK routine (version 2.0) --
--  CGERQF computes an RQ factorization of a complex M-by-N matrix A:
--  A = R * Q.

procedure GERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGERQF;


--  LAPACK routine (version 2.0) --
--  CGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure GETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGETF2;


--  LAPACK routine (version 2.0) --
--  CGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure GETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGETRF;


--  LAPACK routine (version 2.0) --
--  CGETRI computes the inverse of a matrix using the LU factorization
--  computed by CGETRF.

procedure GETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGETRI;


--  LAPACK routine (version 2.0) --
--  CGETRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by CGETRF.

procedure GETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGETRS;


--  LAPACK routine (version 2.0) --
--  CGGBAK forms the right or left eigenvectors of a complex generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  CGGBAL.

procedure GGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Real_Vector;
	RSCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGBAK;


--  LAPACK routine (version 2.0) --
--  CGGBAL balances a pair of general complex matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure GGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Real_Vector;
	RSCALE	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGGBAL;


--  LAPACK routine (version 2.0) --
--  CGGHRD reduces a pair of complex matrices (A,B) to generalized upper
--  Hessenberg form using unitary transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are unitary, and ' means conjugate transpose.

procedure GGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGHRD;


--  LAPACK routine (version 2.0) --
--  CGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure GGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGQRF;


--  LAPACK routine (version 2.0) --
--  CGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure GGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGGRQF;


--  LAPACK routine (version 2.0) --
--  CGGSVP computes unitary matrices U, V and Q such that

procedure GGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	TAU	 : in out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGGSVP;


--  LAPACK routine (version 2.0) --
--  CGTCON estimates the reciprocal of the condition number of a complex
--  tridiagonal matrix A using the LU factorization as computed by
--  CGTTRF.

procedure GTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CGTCON;


--  LAPACK routine (version 2.0) --
--  CGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure GTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DLF	 : Fortran_Complex_Vector;
	DF	 : Fortran_Complex_Vector;
	DUF	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGTRFS;


--  LAPACK routine (version 2.0) --
--  CGTSV  solves the equation

procedure GTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGTSV;


--  LAPACK routine (version 2.0) --
--  CGTSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure GTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DLF	 : Fortran_Complex_Vector;
	DF	 : Fortran_Complex_Vector;
	DUF	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CGTSVX;


--  LAPACK routine (version 2.0) --
--  CGTTRF computes an LU factorization of a complex tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure GTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : out Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CGTTRF;


--  LAPACK routine (version 2.0) --
--  CGTTRS solves one of the systems of equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by CGTTRF.

procedure GTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Vector;
	D	 : Fortran_Complex_Vector;
	DU	 : Fortran_Complex_Vector;
	DU2	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CGTTRS;


--  LAPACK routine (version 2.0) --
--  CHBGST reduces a complex Hermitian-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure HBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHBGST;


--  LAPACK routine (version 2.0) --
--  CHBTRD reduces a complex Hermitian band matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure HBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHBTRD;


--  LAPACK routine (version 2.0) --
--  CHECON estimates the reciprocal of the condition number of a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHETRF.

procedure HECON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHECON;


--  LAPACK routine (version 2.0) --
--  CHEGS2 reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure HEGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHEGS2;


--  LAPACK routine (version 2.0) --
--  CHEGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure HEGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHEGST;


--  LAPACK routine (version 2.0) --
--  CHERFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure HERFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHERFS;


--  LAPACK routine (version 2.0) --
--  CHETD2 reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q' * A * Q = T.

procedure HETD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHETD2;


--  LAPACK routine (version 2.0) --
--  CHETF2 computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure HETF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHETF2;


--  LAPACK routine (version 2.0) --
--  CHETRD reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure HETRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHETRD;


--  LAPACK routine (version 2.0) --
--  CHETRF computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure HETRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHETRF;


--  LAPACK routine (version 2.0) --
--  CHETRI computes the inverse of a complex Hermitian indefinite matrix
--  A using the factorization A = U*D*U**H or A = L*D*L**H computed by
--  CHETRF.

procedure HETRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHETRI;


--  LAPACK routine (version 2.0) --
--  CHETRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHETRF.

procedure HETRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHETRS;


--  LAPACK routine (version 2.0) --
--  CHGEQZ implements a single-shift version of the QZ
--  method for finding the generalized eigenvalues w(i)=ALPHA(i)/BETA(i)
--  of the equation

procedure HGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Vector;
	BETA	 : out Fortran_Complex_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHGEQZ;


--  LAPACK routine (version 2.0) --
--  CHPCON estimates the reciprocal of the condition number of a complex
--  Hermitian packed matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHPTRF.

procedure HPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHPCON;


--  LAPACK routine (version 2.0) --
--  CHPGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form, using packed storage.

procedure HPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	BP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHPGST;


--  LAPACK routine (version 2.0) --
--  CHPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure HPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CHPRFS;


--  LAPACK routine (version 2.0) --
--  CHPTRD reduces a complex Hermitian matrix A stored in packed form to
--  real symmetric tridiagonal form T by a unitary similarity
--  transformation: Q**H * A * Q = T.

procedure HPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHPTRD;


--  LAPACK routine (version 2.0) --
--  CHPTRF computes the factorization of a complex Hermitian packed
--  matrix A using the Bunch-Kaufman diagonal pivoting method:

procedure HPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHPTRF;


--  LAPACK routine (version 2.0) --
--  CHPTRI computes the inverse of a complex Hermitian indefinite matrix
--  A in packed storage using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by CHPTRF.

procedure HPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CHPTRI;


--  LAPACK routine (version 2.0) --
--  CHPTRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A stored in packed format using the factorization
--  A = U*D*U**H or A = L*D*L**H computed by CHPTRF.

procedure HPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHPTRS;


--  LAPACK routine (version 2.0) --
--  CHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a complex upper Hessenberg matrix H.

procedure HSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Fortran_Complex_Vector;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CHSEIN;


--  LAPACK routine (version 2.0) --
--  CHSEQR computes the eigenvalues of a complex upper Hessenberg
--  matrix H, and, optionally, the matrices T and Z from the Schur
--  decomposition H = Z T Z**H, where T is an upper triangular matrix
--  (the Schur form), and Z is the unitary matrix of Schur vectors.

procedure HSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CHSEQR;


--  LAPACK routine (version 2.0) --
--  Using the divide and conquer method, CLAED0 computes all eigenvalues
--  of a symmetric tridiagonal matrix which is one diagonal block of
--  those from reducing a dense or band Hermitian matrix and
--  corresponding eigenvectors of the dense or band matrix.

procedure LAED0 (
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Complex_Matrix;
	LDQS	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CLAED0;


--  LAPACK routine (version 2.0) --
--  CLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense or banded
--  Hermitian matrix that has been reduced to tridiagonal form.

procedure LAED7 (
	N	 : Fortran_Integer;
	CUTPNT	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	INDXQ	 : out Fortran_Integer_Vector;
	QSTORE	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CLAED7;


--  LAPACK routine (version 2.0) --
--  CLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED8 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Complex_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INDXQ	 : Fortran_Integer_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Real_Matrix;
	INFO	 : out Fortran_Integer )
renames CLAED8;


--  LAPACK routine (version 2.0) --
--  CLAHEF computes a partial factorization of a complex Hermitian
--  matrix A using the Bunch-Kaufman diagonal pivoting method. The
--  partial factorization has the form:

procedure LAHEF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CLAHEF;


--  LAPACK routine (version 2.0) --
--  CLASYF computes a partial factorization of a complex symmetric matrix
--  A using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure LASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CLASYF;


--  LAPACK routine (version 2.0) --
--  CLATZM applies a Householder matrix generated by CTZRQF to a matrix.

procedure LATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex;
	C1	 : Fortran_Complex_Matrix;
	C2	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector )
renames CLATZM;


--  LAPACK routine (version 2.0) --
--  CPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite band matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  CPBTRF.

procedure PBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPBCON;


--  LAPACK routine (version 2.0) --
--  CPBEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure PBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames CPBEQU;


--  LAPACK routine (version 2.0) --
--  CPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure PBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPBRFS;


--  LAPACK routine (version 2.0) --
--  CPBSTF computes a split Cholesky factorization of a complex
--  Hermitian positive definite band matrix A.

procedure PBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPBSTF;


--  LAPACK routine (version 2.0) --
--  CPBTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure PBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPBTF2;


--  LAPACK routine (version 2.0) --
--  CPBTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure PBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPBTRF;


--  LAPACK routine (version 2.0) --
--  CPBTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite band matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by CPBTRF.

procedure PBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPBTRS;


--  LAPACK routine (version 2.0) --
--  CPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite matrix using the
--  Cholesky factorization A = U**H*U or A = L*L**H computed by CPOTRF.

procedure POCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPOCON;


--  LAPACK routine (version 2.0) --
--  CPOEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure POEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames CPOEQU;


--  LAPACK routine (version 2.0) --
--  CPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure PORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPORFS;


--  LAPACK routine (version 2.0) --
--  CPOTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure POTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPOTF2;


--  LAPACK routine (version 2.0) --
--  CPOTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure POTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPOTRF;


--  LAPACK routine (version 2.0) --
--  CPOTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by CPOTRF.

procedure POTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPOTRI;


--  LAPACK routine (version 2.0) --
--  CPOTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A using the Cholesky factorization 
--  A = U**H*U or A = L*L**H computed by CPOTRF.

procedure POTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPOTRS;


--  LAPACK routine (version 2.0) --
--  CPPCON estimates the reciprocal of the condition number (in the 
--  1-norm) of a complex Hermitian positive definite packed matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  CPPTRF.

procedure PPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPPCON;


--  LAPACK routine (version 2.0) --
--  CPPEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure PPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames CPPEQU;


--  LAPACK routine (version 2.0) --
--  CPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure PPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPPRFS;


--  LAPACK routine (version 2.0) --
--  CPPTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A stored in packed format.

procedure PPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CPPTRF;


--  LAPACK routine (version 2.0) --
--  CPPTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by CPPTRF.

procedure PPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CPPTRI;


--  LAPACK routine (version 2.0) --
--  CPPTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**H*U or A = L*L**H computed by CPPTRF.

procedure PPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPPTRS;


--  LAPACK routine (version 2.0) --
--  CPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite tridiagonal matrix
--  using the factorization A = L*D*L**H or A = U**H*D*U computed by
--  CPTTRF.

procedure PTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPTCON;


--  LAPACK routine (version 2.0) --
--  CPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using SPTTRF and then calling CBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure PTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPTEQR;


--  LAPACK routine (version 2.0) --
--  CPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure PTRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPTRFS;


--  LAPACK routine (version 2.0) --
--  CPTSV computes the solution to a complex system of linear equations
--  A*X = B, where A is an N-by-N Hermitian positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure PTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPTSV;


--  LAPACK routine (version 2.0) --
--  CPTSVX uses the factorization A = L*D*L**H to compute the solution
--  to a complex system of linear equations A*X = B, where A is an
--  N-by-N Hermitian positive definite tridiagonal matrix and X and B
--  are N-by-NRHS matrices.

procedure PTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CPTSVX;


--  LAPACK routine (version 2.0) --
--  CPTTRF computes the factorization of a complex Hermitian positive
--  definite tridiagonal matrix A.

procedure PTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CPTTRF;


--  LAPACK routine (version 2.0) --
--  CPTTRS solves a system of linear equations A * X = B with a
--  Hermitian positive definite tridiagonal matrix A using the
--  factorization A = U**H*D*U or A = L*D*L**H computed by CPTTRF.

procedure PTTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CPTTRS;


--  LAPACK routine (version 2.0) --
--  CSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric packed matrix A using the
--  factorization A = U*D*U**T or A = L*D*L**T computed by CSPTRF.

procedure SPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CSPCON;


--  LAPACK routine (version 2.0) --
--  CSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	AFP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CSPRFS;


--  LAPACK routine (version 2.0) --
--  CSPTRF computes the factorization of a complex symmetric matrix A
--  stored in packed format using the Bunch-Kaufman diagonal pivoting
--  method:

procedure SPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CSPTRF;


--  LAPACK routine (version 2.0) --
--  CSPTRI computes the inverse of a complex symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by CSPTRF.

procedure SPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CSPTRI;


--  LAPACK routine (version 2.0) --
--  CSPTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by CSPTRF.

procedure SPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSPTRS;


--  LAPACK routine (version 2.0) --
--  CSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if CHETRD or CHPTRD or CHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSTEDC;


--  LAPACK routine (version 2.0) --
--  CSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure STEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Real_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CSTEIN;


--  LAPACK routine (version 2.0) --
--  CSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if CHETRD or CHPTRD or CHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Complex_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CSTEQR;


--  LAPACK routine (version 2.0) --
--  CSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by CSYTRF.

procedure SYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CSYCON;


--  LAPACK routine (version 2.0) --
--  CSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure SYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CSYRFS;


--  LAPACK routine (version 2.0) --
--  CSYTF2 computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure SYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames CSYTF2;


--  LAPACK routine (version 2.0) --
--  CSYTRF computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure SYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSYTRF;


--  LAPACK routine (version 2.0) --
--  CSYTRI computes the inverse of a complex symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  CSYTRF.

procedure SYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CSYTRI;


--  LAPACK routine (version 2.0) --
--  CSYTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by CSYTRF.

procedure SYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CSYTRS;


--  LAPACK routine (version 2.0) --
--  CTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure TBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTBCON;


--  LAPACK routine (version 2.0) --
--  CTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure TBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTBRFS;


--  LAPACK routine (version 2.0) --
--  CTBTRS solves a triangular system of the form

procedure TBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTBTRS;


--  LAPACK routine (version 2.0) --
--  CTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of complex upper triangular matrices (A,B).

procedure TGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTGEVC;


--  LAPACK routine (version 2.0) --
--  CTGSJA computes the generalized singular value decomposition (GSVD)
--  of two complex upper triangular (or trapezoidal) matrices A and B.

procedure TGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : Fortran_Complex_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Complex_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTGSJA;


--  LAPACK routine (version 2.0) --
--  CTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTPCON;


--  LAPACK routine (version 2.0) --
--  CTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure TPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTPRFS;


--  LAPACK routine (version 2.0) --
--  CTPTRI computes the inverse of a complex upper or lower triangular
--  matrix A stored in packed format.

procedure TPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CTPTRI;


--  LAPACK routine (version 2.0) --
--  CTPTRS solves a triangular system of the form

procedure TPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTPTRS;


--  LAPACK routine (version 2.0) --
--  CTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTRCON;


--  LAPACK routine (version 2.0) --
--  CTREVC computes some or all of the right and/or left eigenvectors of
--  a complex upper triangular matrix T.

procedure TREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTREVC;


--  LAPACK routine (version 2.0) --
--  CTREXC reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that the diagonal element of T with row index IFST
--  is moved to row ILST.

procedure TREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTREXC;


--  LAPACK routine (version 2.0) --
--  CTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure TRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTRRFS;


--  LAPACK routine (version 2.0) --
--  CTRSEN reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in
--  the leading positions on the diagonal of the upper triangular matrix
--  T, and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure TRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	W	 : out Fortran_Complex_Vector;
	M	 : out Fortran_Integer;
	S	 : out Real;
	SEP	 : out Real;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTRSEN;


--  LAPACK routine (version 2.0) --
--  CTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a complex upper triangular
--  matrix T (or of any matrix Q*T*Q**H with Q unitary).

procedure TRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Matrix;
	LDWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames CTRSNA;


--  LAPACK routine (version 2.0) --
--  CTRSYL solves the complex Sylvester matrix equation:

procedure TRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Real;
	INFO	 : out Fortran_Integer )
renames CTRSYL;


--  LAPACK routine (version 2.0) --
--  CTRTI2 computes the inverse of a complex upper or lower triangular
--  matrix.

procedure TRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTRTI2;


--  LAPACK routine (version 2.0) --
--  CTRTRI computes the inverse of a complex upper or lower triangular
--  matrix A.

procedure TRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTRTRI;


--  LAPACK routine (version 2.0) --
--  CTRTRS solves a triangular system of the form

procedure TRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CTRTRS;


--  LAPACK routine (version 2.0) --
--  CTZRQF reduces the M-by-N ( M<=N ) complex upper trapezoidal matrix A
--  to upper triangular form by means of unitary transformations.

procedure TZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CTZRQF;


--  LAPACK routine (version 2.0) --
--  CUNG2L generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure UNG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNG2L;


--  LAPACK routine (version 2.0) --
--  CUNG2R generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure UNG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNG2R;


--  LAPACK routine (version 2.0) --
--  CUNGBR generates one of the complex unitary matrices Q or P**H
--  determined by CGEBRD when reducing a complex matrix A to bidiagonal
--  form: A = Q * B * P**H.  Q and P**H are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure UNGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGBR;


--  LAPACK routine (version 2.0) --
--  CUNGHR generates a complex unitary matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  CGEHRD:

procedure UNGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGHR;


--  LAPACK routine (version 2.0) --
--  CUNGL2 generates an m-by-n complex matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure UNGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNGL2;


--  LAPACK routine (version 2.0) --
--  CUNGLQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure UNGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGLQ;


--  LAPACK routine (version 2.0) --
--  CUNGQL generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure UNGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGQL;


--  LAPACK routine (version 2.0) --
--  CUNGQR generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure UNGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGQR;


--  LAPACK routine (version 2.0) --
--  CUNGR2 generates an m by n complex matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure UNGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNGR2;


--  LAPACK routine (version 2.0) --
--  CUNGRQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure UNGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGRQ;


--  LAPACK routine (version 2.0) --
--  CUNGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  CHETRD:

procedure UNGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNGTR;


--  LAPACK routine (version 2.0) --
--  CUNM2L overwrites the general complex m-by-n matrix C with

procedure UNM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNM2L;


--  LAPACK routine (version 2.0) --
--  CUNM2R overwrites the general complex m-by-n matrix C with

procedure UNM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNM2R;


--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', CUNMBR overwrites the general complex M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'C':      Q**H * C       C * Q**H

procedure UNMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMBR;


--  LAPACK routine (version 2.0) --
--  CUNMHR overwrites the general complex M-by-N matrix C with

procedure UNMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMHR;


--  LAPACK routine (version 2.0) --
--  CUNML2 overwrites the general complex m-by-n matrix C with

procedure UNML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNML2;


--  LAPACK routine (version 2.0) --
--  CUNMLQ overwrites the general complex M-by-N matrix C with

procedure UNMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMLQ;


--  LAPACK routine (version 2.0) --
--  CUNMQL overwrites the general complex M-by-N matrix C with

procedure UNMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMQL;


--  LAPACK routine (version 2.0) --
--  CUNMQR overwrites the general complex M-by-N matrix C with

procedure UNMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMQR;


--  LAPACK routine (version 2.0) --
--  CUNMR2 overwrites the general complex m-by-n matrix C with

procedure UNMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUNMR2;


--  LAPACK routine (version 2.0) --
--  CUNMRQ overwrites the general complex M-by-N matrix C with

procedure UNMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMRQ;


--  LAPACK routine (version 2.0) --
--  CUNMTR overwrites the general complex M-by-N matrix C with

procedure UNMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames CUNMTR;


--  LAPACK routine (version 2.0) --
--  CUPGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  CHPTRD using packed storage:

procedure UPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	TAU	 : Fortran_Complex_Vector;
	Q	 : out Fortran_Complex_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUPGTR;


--  LAPACK routine (version 2.0) --
--  CUPMTR overwrites the general complex M-by-N matrix C with

procedure UPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Vector;
	TAU	 : Fortran_Complex_Vector;
	C	 : Fortran_Complex_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Vector;
	INFO	 : out Fortran_Integer )
renames CUPMTR;


--  LAPACK routine (version 2.0) --
--  DBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure BDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VT	 : Fortran_Double_Precision_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DBDSQR;


--  LAPACK routine (version 2.0) --
--  DDISNA computes the reciprocal condition numbers for the eigenvectors
--  of a real symmetric or complex Hermitian matrix or for the left or
--  right singular vectors of a general m-by-n matrix. The reciprocal
--  condition number is the 'gap' between the corresponding eigenvalue or
--  singular value and the nearest other one.

procedure DISNA (
	JOB	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DDISNA;


--  LAPACK routine (version 2.0) --
--  DGBBRD reduces a real general m-by-n band matrix A to upper
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure GBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Double_Precision_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGBBRD;


--  LAPACK routine (version 2.0) --
--  DGBCON estimates the reciprocal of the condition number of a real
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by DGBTRF.

procedure GBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGBCON;


--  LAPACK routine (version 2.0) --
--  DGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DGBEQU;


--  LAPACK routine (version 2.0) --
--  DGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure GBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGBRFS;


--  LAPACK routine (version 2.0) --
--  DGBTF2 computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGBTF2;


--  LAPACK routine (version 2.0) --
--  DGBTRF computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGBTRF;


--  LAPACK routine (version 2.0) --
--  DGBTRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general band matrix A using the LU factorization computed
--  by DGBTRF.

procedure GBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGBTRS;


--  LAPACK routine (version 2.0) --
--  DGEBAK forms the right or left eigenvectors of a real general matrix
--  by backward transformation on the computed eigenvectors of the
--  balanced matrix output by DGEBAL.

procedure GEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEBAK;


--  LAPACK routine (version 2.0) --
--  DGEBAL balances a general real matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure GEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGEBAL;


--  LAPACK routine (version 2.0) --
--  DGEBD2 reduces a real general m by n matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure GEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Double_Precision_Vector;
	TAUP	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGEBD2;


--  LAPACK routine (version 2.0) --
--  DGEBRD reduces a general real M-by-N matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.

procedure GEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Double_Precision_Vector;
	TAUP	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEBRD;


--  LAPACK routine (version 2.0) --
--  DGECON estimates the reciprocal of the condition number of a general
--  real matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by DGETRF.

procedure GECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGECON;


--  LAPACK routine (version 2.0) --
--  DGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DGEEQU;


--  LAPACK routine (version 2.0) --
--  DGEHD2 reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure GEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGEHD2;


--  LAPACK routine (version 2.0) --
--  DGEHRD reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure GEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEHRD;


--  LAPACK routine (version 2.0) --
--  DGELQ2 computes an LQ factorization of a real m by n matrix A:
--  A = L * Q.

procedure GELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGELQ2;


--  LAPACK routine (version 2.0) --
--  DGELQF computes an LQ factorization of a real M-by-N matrix A:
--  A = L * Q.

procedure GELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGELQF;


--  LAPACK routine (version 2.0) --
--  DGEQL2 computes a QL factorization of a real m by n matrix A:
--  A = Q * L.

procedure GEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGEQL2;


--  LAPACK routine (version 2.0) --
--  DGEQLF computes a QL factorization of a real M-by-N matrix A:
--  A = Q * L.

procedure GEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEQLF;


--  LAPACK routine (version 2.0) --
--  DGEQR2 computes a QR factorization of a real m by n matrix A:
--  A = Q * R.

procedure GEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGEQR2;


--  LAPACK routine (version 2.0) --
--  DGEQRF computes a QR factorization of a real M-by-N matrix A:
--  A = Q * R.

procedure GEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGEQRF;


--  LAPACK routine (version 2.0) --
--  DGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure GERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGERFS;


--  LAPACK routine (version 2.0) --
--  DGERQ2 computes an RQ factorization of a real m by n matrix A:
--  A = R * Q.

procedure GERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGERQ2;


--  LAPACK routine (version 2.0) --
--  DGERQF computes an RQ factorization of a real M-by-N matrix A:
--  A = R * Q.

procedure GERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGERQF;


--  LAPACK routine (version 2.0) --
--  DGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure GETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGETF2;


--  LAPACK routine (version 2.0) --
--  DGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure GETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGETRF;


--  LAPACK routine (version 2.0) --
--  DGETRI computes the inverse of a matrix using the LU factorization
--  computed by DGETRF.

procedure GETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGETRI;


--  LAPACK routine (version 2.0) --
--  DGETRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by DGETRF.

procedure GETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGETRS;


--  LAPACK routine (version 2.0) --
--  DGGBAK forms the right or left eigenvectors of a real generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  DGGBAL.

procedure GGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Double_Precision_Vector;
	RSCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGBAK;


--  LAPACK routine (version 2.0) --
--  DGGBAL balances a pair of general real matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure GGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Double_Precision_Vector;
	RSCALE	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGGBAL;


--  LAPACK routine (version 2.0) --
--  DGGHRD reduces a pair of real matrices (A,B) to generalized upper
--  Hessenberg form using orthogonal transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are orthogonal, and ' means transpose.

procedure GGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGHRD;


--  LAPACK routine (version 2.0) --
--  DGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure GGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGQRF;


--  LAPACK routine (version 2.0) --
--  DGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure GGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGGRQF;


--  LAPACK routine (version 2.0) --
--  DGGSVP computes orthogonal matrices U, V and Q such that

procedure GGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	TAU	 : in out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DGGSVP;


--  LAPACK routine (version 2.0) --
--  DGTCON estimates the reciprocal of the condition number of a real
--  tridiagonal matrix A using the LU factorization as computed by
--  DGTTRF.

procedure GTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGTCON;


--  LAPACK routine (version 2.0) --
--  DGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure GTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DLF	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	DUF	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGTRFS;


--  LAPACK routine (version 2.0) --
--  DGTSV  solves the equation

procedure GTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGTSV;


--  LAPACK routine (version 2.0) --
--  DGTSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B or A**T * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure GTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DLF	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	DUF	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGTSVX;


--  LAPACK routine (version 2.0) --
--  DGTTRF computes an LU factorization of a real tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure GTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : out Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DGTTRF;


--  LAPACK routine (version 2.0) --
--  DGTTRS solves one of the systems of equations
--     A*X = B  or  A'*X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by DGTTRF.

procedure GTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Double_Precision_Vector;
	D	 : Fortran_Double_Precision_Vector;
	DU	 : Fortran_Double_Precision_Vector;
	DU2	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DGTTRS;


--  LAPACK routine (version 2.0) --
--  DHGEQZ implements a single-/double-shift version of the QZ method for
--  finding the generalized eigenvalues

procedure HGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Double_Precision_Vector;
	ALPHAI	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DHGEQZ;


--  LAPACK routine (version 2.0) --
--  DHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a real upper Hessenberg matrix H.

procedure HSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Fortran_Double_Precision_Vector;
	WI	 : Fortran_Double_Precision_Vector;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DHSEIN;


--  LAPACK routine (version 2.0) --
--  DHSEQR computes the eigenvalues of a real upper Hessenberg matrix H
--  and, optionally, the matrices T and Z from the Schur decomposition
--  H = Z T Z**T, where T is an upper quasi-triangular matrix (the Schur
--  form), and Z is the orthogonal matrix of Schur vectors.

procedure HSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Double_Precision_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DHSEQR;


--  LAPACK routine (version 2.0) --
--  DLAED0 computes all eigenvalues and corresponding eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.

procedure LAED0 (
	ICOMPQ	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Double_Precision_Matrix;
	LDQS	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAED0;


--  LAPACK routine (version 2.0) --
--  DLAED1 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix.  This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
--  the case in which eigenvalues only or eigenvalues and eigenvectors
--  of a full symmetric matrix (which was reduced to tridiagonal form)
--  are desired.

procedure LAED1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAED1;


--  LAPACK routine (version 2.0) --
--  DLAED2 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny entry in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED2 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : out Fortran_Integer_Vector;
	W	 : out Fortran_Double_Precision_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	COLTYP	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAED2;


--  LAPACK routine (version 2.0) --
--  DLAED3 finds the roots of the secular equation, as defined by the
--  values in D, W, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to DLAED4 and then updates the eigenvectors by
--  multiplying the matrix of eigenvectors of the pair of eigensystems
--  being combined by the matrix of eigenvectors of the K-by-K system
--  which is solved here.

procedure LAED3 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	DLAMDA	 : Fortran_Double_Precision_Vector;
	Q2	 : Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : Fortran_Integer_Vector;
	CTOT	 : Fortran_Integer_Vector;
	W	 : Fortran_Double_Precision_Vector;
	S	 : in out Fortran_Double_Precision_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DLAED3;


--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th updated eigenvalue of a symmetric
--  rank-one modification to a diagonal matrix whose elements are
--  given in the array d, and that

procedure LAED4 (
	N	 : Fortran_Integer;
	I	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	V_DELTA	 : out Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	DLAM	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DLAED4;


--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th eigenvalue of a symmetric rank-one
--  modification of a 2-by-2 diagonal matrix

procedure LAED5 (
	I	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	V_DELTA	 : out Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	DLAM	 : out Double_Precision )
renames DLAED5;


--  LAPACK routine (version 2.0) --
--  DLAED6 computes the positive or negative root (closest to the origin)
--  of
--                   z(1)        z(2)        z(3)
--  f(x) =   rho + --------- + ---------- + ---------
--                  d(1)-x      d(2)-x      d(3)-x

procedure LAED6 (
	KNITER	 : Fortran_Integer;
	ORGATI	 : Logical;
	RHO	 : Double_Precision;
	D	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Vector;
	FINIT	 : Double_Precision;
	TAU	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DLAED6;


--  LAPACK routine (version 2.0) --
--  DLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense symmetric matrix
--  that has been reduced to tridiagonal form.  DLAED1 handles
--  the case in which all eigenvalues and eigenvectors of a symmetric
--  tridiagonal matrix are desired.

procedure LAED7 (
	ICOMPQ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : out Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	QSTORE	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAED7;


--  LAPACK routine (version 2.0) --
--  DLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED8 (
	ICOMPQ	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Double_Precision_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Double_Precision_Matrix;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAED8;


--  LAPACK routine (version 2.0) --
--  DLAED9 finds the roots of the secular equation, as defined by the
--  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to DLAED4 and then stores the new matrix of
--  eigenvectors for use in calculating the next level of Z vectors.

procedure LAED9 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	Q	 : in out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	DLAMDA	 : Fortran_Double_Precision_Vector;
	W	 : Fortran_Double_Precision_Vector;
	S	 : out Fortran_Double_Precision_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DLAED9;


--  LAPACK routine (version 2.0) --
--  DLAEDA computes the Z vector corresponding to the merge step in the
--  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
--  problem.

procedure LAEDA (
	N	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	Q	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Double_Precision_Vector;
	ZTEMP	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DLAEDA;


--  LAPACK routine (version 2.0) --
--  DLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
--  tridiagonal matrix and lambda is a scalar, as

procedure LAGTF (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Vector;
	LAMBDA	 : Double_Precision;
	B	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Vector;
	TOL	 : Double_Precision;
	D	 : out Fortran_Double_Precision_Vector;
	P_IN	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DLAGTF;


--  LAPACK routine (version 2.0) --
--  DLAMRG will create a permutation list which will merge the elements
--  of A (which is composed of two independently sorted sets) into a
--  single set which is sorted in ascending order.

procedure LAMRG (
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Vector;
	DTRD1	 : Fortran_Integer;
	DTRD2	 : Fortran_Integer;
	INDEX	 : out Fortran_Integer_Vector )
renames DLAMRG;


--  LAPACK routine (version 2.0) --
--     DLASQ1 computes the singular values of a real N-by-N bidiagonal
--     matrix with diagonal D and off-diagonal E. The singular values are
--     computed to high relative accuracy, barring over/underflow or
--     denormalization. The algorithm is described in

procedure LASQ1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DLASQ1;


--  LAPACK routine (version 2.0) --
--     DLASQ2 computes the singular values of a real N-by-N unreduced
--     bidiagonal matrix with squared diagonal elements in Q and
--     squared off-diagonal elements in E. The singular values are
--     computed to relative accuracy TOL, barring over/underflow or
--     denormalization.

procedure LASQ2 (
	M	 : Fortran_Integer;
	Q	 : out Fortran_Double_Precision_Vector;
	E	 : in out Fortran_Double_Precision_Vector;
	QQ	 : Fortran_Double_Precision_Vector;
	EE	 : Fortran_Double_Precision_Vector;
	EPS	 : Double_Precision;
	TOL2	 : Double_Precision;
	SMALL2	 : Double_Precision;
	SUP	 : Double_Precision;
	KEND	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DLASQ2;


--  LAPACK routine (version 2.0) --
--     DLASQ3 is the workhorse of the whole bidiagonal SVD algorithm.
--     This can be described as the differential qd with shifts.

procedure LASQ3 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	QQ	 : Fortran_Double_Precision_Vector;
	EE	 : Fortran_Double_Precision_Vector;
	SUP	 : Double_Precision;
	SIGMA	 : Double_Precision;
	KEND	 : Fortran_Integer;
	OFF	 : Fortran_Integer;
	IPHASE	 : Fortran_Integer;
	ICONV	 : Fortran_Integer;
	EPS	 : Double_Precision;
	TOL2	 : Double_Precision;
	SMALL2	 : Double_Precision )
renames DLASQ3;


--  LAPACK routine (version 2.0) --
--     DLASQ4 estimates TAU, the smallest eigenvalue of a matrix. This
--     routine improves the input value of SUP which is an upper bound
--     for the smallest eigenvalue for this matrix .

procedure LASQ4 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	TAU	 : out Double_Precision;
	SUP	 : Double_Precision )
renames DLASQ4;


--  LAPACK routine (version 2.0) --
--  Sort the numbers in D in increasing order (if ID = 'I') or
--  in decreasing order (if ID = 'D' ).

procedure LASRT (
	ID	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DLASRT;


--  LAPACK routine (version 2.0) --
--  DLASYF computes a partial factorization of a real symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure LASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Double_Precision_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DLASYF;


--  LAPACK routine (version 2.0) --
--  DLATZM applies a Householder matrix generated by DTZRQF to a matrix.

procedure LATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Double_Precision;
	C1	 : Fortran_Double_Precision_Matrix;
	C2	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector )
renames DLATZM;


--  LAPACK routine (version 2.0) --
--  DOPGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  DSPTRD using packed storage:

procedure OPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	TAU	 : Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DOPGTR;


--  LAPACK routine (version 2.0) --
--  DOPMTR overwrites the general real M-by-N matrix C with

procedure OPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DOPMTR;


--  LAPACK routine (version 2.0) --
--  DORG2L generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure ORG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORG2L;


--  LAPACK routine (version 2.0) --
--  DORG2R generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure ORG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORG2R;


--  LAPACK routine (version 2.0) --
--  DORGBR generates one of the real orthogonal matrices Q or P**T
--  determined by DGEBRD when reducing a real matrix A to bidiagonal
--  form: A = Q * B * P**T.  Q and P**T are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure ORGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGBR;


--  LAPACK routine (version 2.0) --
--  DORGHR generates a real orthogonal matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  DGEHRD:

procedure ORGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGHR;


--  LAPACK routine (version 2.0) --
--  DORGL2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure ORGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORGL2;


--  LAPACK routine (version 2.0) --
--  DORGLQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure ORGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGLQ;


--  LAPACK routine (version 2.0) --
--  DORGQL generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure ORGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGQL;


--  LAPACK routine (version 2.0) --
--  DORGQR generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure ORGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGQR;


--  LAPACK routine (version 2.0) --
--  DORGR2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure ORGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORGR2;


--  LAPACK routine (version 2.0) --
--  DORGRQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure ORGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGRQ;


--  LAPACK routine (version 2.0) --
--  DORGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  DSYTRD:

procedure ORGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORGTR;


--  LAPACK routine (version 2.0) --
--  DORM2L overwrites the general real m by n matrix C with

procedure ORM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORM2L;


--  LAPACK routine (version 2.0) --
--  DORM2R overwrites the general real m by n matrix C with

procedure ORM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORM2R;


--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', DORMBR overwrites the general real M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'T':      Q**T * C       C * Q**T

procedure ORMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMBR;


--  LAPACK routine (version 2.0) --
--  DORMHR overwrites the general real M-by-N matrix C with

procedure ORMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMHR;


--  LAPACK routine (version 2.0) --
--  DORML2 overwrites the general real m by n matrix C with

procedure ORML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORML2;


--  LAPACK routine (version 2.0) --
--  DORMLQ overwrites the general real M-by-N matrix C with

procedure ORMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMLQ;


--  LAPACK routine (version 2.0) --
--  DORMQL overwrites the general real M-by-N matrix C with

procedure ORMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMQL;


--  LAPACK routine (version 2.0) --
--  DORMQR overwrites the general real M-by-N matrix C with

procedure ORMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMQR;


--  LAPACK routine (version 2.0) --
--  DORMR2 overwrites the general real m by n matrix C with

procedure ORMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DORMR2;


--  LAPACK routine (version 2.0) --
--  DORMRQ overwrites the general real M-by-N matrix C with

procedure ORMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMRQ;


--  LAPACK routine (version 2.0) --
--  DORMTR overwrites the general real M-by-N matrix C with

procedure ORMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Double_Precision_Vector;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DORMTR;


--  LAPACK routine (version 2.0) --
--  DPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite band matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by DPBTRF.

procedure PBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPBCON;


--  LAPACK routine (version 2.0) --
--  DPBEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure PBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DPBEQU;


--  LAPACK routine (version 2.0) --
--  DPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure PBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Double_Precision_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPBRFS;


--  LAPACK routine (version 2.0) --
--  DPBSTF computes a split Cholesky factorization of a real
--  symmetric positive definite band matrix A.

procedure PBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPBSTF;


--  LAPACK routine (version 2.0) --
--  DPBTF2 computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure PBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPBTF2;


--  LAPACK routine (version 2.0) --
--  DPBTRF computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure PBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPBTRF;


--  LAPACK routine (version 2.0) --
--  DPBTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite band matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by DPBTRF.

procedure PBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPBTRS;


--  LAPACK routine (version 2.0) --
--  DPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by DPOTRF.

procedure POCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPOCON;


--  LAPACK routine (version 2.0) --
--  DPOEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure POEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DPOEQU;


--  LAPACK routine (version 2.0) --
--  DPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure PORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPORFS;


--  LAPACK routine (version 2.0) --
--  DPOTF2 computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure POTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPOTF2;


--  LAPACK routine (version 2.0) --
--  DPOTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure POTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPOTRF;


--  LAPACK routine (version 2.0) --
--  DPOTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by DPOTRF.

procedure POTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPOTRI;


--  LAPACK routine (version 2.0) --
--  DPOTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by DPOTRF.

procedure POTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPOTRS;


--  LAPACK routine (version 2.0) --
--  DPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite packed matrix using
--  the Cholesky factorization A = U**T*U or A = L*L**T computed by
--  DPPTRF.

procedure PPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPPCON;


--  LAPACK routine (version 2.0) --
--  DPPEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure PPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DPPEQU;


--  LAPACK routine (version 2.0) --
--  DPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure PPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DPPRFS;


--  LAPACK routine (version 2.0) --
--  DPPTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A stored in packed format.

procedure PPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPPTRF;


--  LAPACK routine (version 2.0) --
--  DPPTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by DPPTRF.

procedure PPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPPTRI;


--  LAPACK routine (version 2.0) --
--  DPPTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**T*U or A = L*L**T computed by DPPTRF.

procedure PPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPPTRS;


--  LAPACK routine (version 2.0) --
--  DPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite tridiagonal matrix
--  using the factorization A = L*D*L**T or A = U**T*D*U computed by
--  DPTTRF.

procedure PTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPTCON;


--  LAPACK routine (version 2.0) --
--  DPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using DPTTRF, and then calling DBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure PTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPTEQR;


--  LAPACK routine (version 2.0) --
--  DPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure PTRFS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPTRFS;


--  LAPACK routine (version 2.0) --
--  DPTSV computes the solution to a real system of linear equations
--  A*X = B, where A is an N-by-N symmetric positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure PTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPTSV;


--  LAPACK routine (version 2.0) --
--  DPTSVX uses the factorization A = L*D*L**T to compute the solution
--  to a real system of linear equations A*X = B, where A is an N-by-N
--  symmetric positive definite tridiagonal matrix and X and B are
--  N-by-NRHS matrices.

procedure PTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPTSVX;


--  LAPACK routine (version 2.0) --
--  DPTTRF computes the factorization of a real symmetric positive
--  definite tridiagonal matrix A.

procedure PTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DPTTRF;


--  LAPACK routine (version 2.0) --
--  DPTTRS solves a system of linear equations A * X = B with a
--  symmetric positive definite tridiagonal matrix A using the
--  factorization A = L*D*L**T or A = U**T*D*U computed by DPTTRF.
--  (The two forms are equivalent if A is real.)

procedure PTTRS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DPTTRS;


--  LAPACK routine (version 2.0) --
--  DSBGST reduces a real symmetric-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure SBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Double_Precision_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSBGST;


--  LAPACK routine (version 2.0) --
--  DSBTRD reduces a real symmetric band matrix A to symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSBTRD;


--  LAPACK routine (version 2.0) --
--  DSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric packed matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSPTRF.

procedure SPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSPCON;


--  LAPACK routine (version 2.0) --
--  DSPGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form, using packed storage.

procedure SPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	BP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSPGST;


--  LAPACK routine (version 2.0) --
--  DSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	AFP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSPRFS;


--  LAPACK routine (version 2.0) --
--  DSPTRD reduces a real symmetric matrix A stored in packed form to
--  symmetric tridiagonal form T by an orthogonal similarity
--  transformation: Q**T * A * Q = T.

procedure SPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSPTRD;


--  LAPACK routine (version 2.0) --
--  DSPTRF computes the factorization of a real symmetric matrix A stored
--  in packed format using the Bunch-Kaufman diagonal pivoting method:

procedure SPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSPTRF;


--  LAPACK routine (version 2.0) --
--  DSPTRI computes the inverse of a real symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by DSPTRF.

procedure SPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSPTRI;


--  LAPACK routine (version 2.0) --
--  DSPTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSPTRF.

procedure SPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSPTRS;


--  LAPACK routine (version 2.0) --
--  DSTEBZ computes the eigenvalues of a symmetric tridiagonal
--  matrix T.  The user may ask for all eigenvalues, all eigenvalues
--  in the half-open interval (VL, VU], or the IL-th through IU-th
--  eigenvalues.

procedure STEBZ (
	M_RANGE	 : Character;
	ORDER	 : Character;
	N	 : Fortran_Integer;
	VL	 : Double_Precision;
	VU	 : Double_Precision;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Double_Precision;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : out Fortran_Integer;
	NSPLIT	 : out Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	IBLOCK	 : out Fortran_Integer_Vector;
	ISPLIT	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSTEBZ;


--  LAPACK routine (version 2.0) --
--  DSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band real symmetric matrix can also be
--  found if DSYTRD or DSPTRD or DSBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSTEDC;


--  LAPACK routine (version 2.0) --
--  DSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure STEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Double_Precision_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSTEIN;


--  LAPACK routine (version 2.0) --
--  DSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band symmetric matrix can also be found
--  if DSYTRD or DSPTRD or DSBTRD has been used to reduce this matrix to
--  tridiagonal form.

procedure STEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Double_Precision_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSTEQR;


--  LAPACK routine (version 2.0) --
--  DSTERF computes all eigenvalues of a symmetric tridiagonal matrix
--  using the Pal-Walker-Kahan variant of the QL or QR algorithm.

procedure STERF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSTERF;


--  LAPACK routine (version 2.0) --
--  DSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by DSYTRF.

procedure SYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSYCON;


--  LAPACK routine (version 2.0) --
--  DSYGS2 reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SYGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYGS2;


--  LAPACK routine (version 2.0) --
--  DSYGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SYGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYGST;


--  LAPACK routine (version 2.0) --
--  DSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure SYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Double_Precision_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSYRFS;


--  LAPACK routine (version 2.0) --
--  DSYTD2 reduces a real symmetric matrix A to symmetric tridiagonal
--  form T by an orthogonal similarity transformation: Q' * A * Q = T.

procedure SYTD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSYTD2;


--  LAPACK routine (version 2.0) --
--  DSYTF2 computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method:

procedure SYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DSYTF2;


--  LAPACK routine (version 2.0) --
--  DSYTRD reduces a real symmetric matrix A to real symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SYTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYTRD;


--  LAPACK routine (version 2.0) --
--  DSYTRF computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure SYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYTRF;


--  LAPACK routine (version 2.0) --
--  DSYTRI computes the inverse of a real symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  DSYTRF.

procedure SYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DSYTRI;


--  LAPACK routine (version 2.0) --
--  DSYTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by DSYTRF.

procedure SYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DSYTRS;


--  LAPACK routine (version 2.0) --
--  DTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure TBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTBCON;


--  LAPACK routine (version 2.0) --
--  DTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure TBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTBRFS;


--  LAPACK routine (version 2.0) --
--  DTBTRS solves a triangular system of the form

procedure TBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Double_Precision_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTBTRS;


--  LAPACK routine (version 2.0) --
--  DTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of real upper triangular matrices (A,B).

procedure TGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DTGEVC;


--  LAPACK routine (version 2.0) --
--  DTGSJA computes the generalized singular value decomposition (GSVD)
--  of two real upper triangular (or trapezoidal) matrices A and B.

procedure TGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : Fortran_Double_Precision_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Double_Precision_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTGSJA;


--  LAPACK routine (version 2.0) --
--  DTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTPCON;


--  LAPACK routine (version 2.0) --
--  DTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure TPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTPRFS;


--  LAPACK routine (version 2.0) --
--  DTPTRI computes the inverse of a real upper or lower triangular
--  matrix A stored in packed format.

procedure TPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DTPTRI;


--  LAPACK routine (version 2.0) --
--  DTPTRS solves a triangular system of the form

procedure TPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Double_Precision_Vector;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTPTRS;


--  LAPACK routine (version 2.0) --
--  DTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTRCON;


--  LAPACK routine (version 2.0) --
--  DTREVC computes some or all of the right and/or left eigenvectors of
--  a real upper quasi-triangular matrix T.

procedure TREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DTREVC;


--  LAPACK routine (version 2.0) --
--  DTREXC reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that the diagonal block of T with row index IFST is
--  moved to row ILST.

procedure TREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DTREXC;


--  LAPACK routine (version 2.0) --
--  DTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure TRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Double_Precision_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTRRFS;


--  LAPACK routine (version 2.0) --
--  DTRSEN reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that a selected cluster of eigenvalues appears in
--  the leading diagonal blocks of the upper quasi-triangular matrix T,
--  and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure TRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Double_Precision_Matrix;
	LDQ	 : Fortran_Integer;
	WR	 : out Fortran_Double_Precision_Vector;
	WI	 : out Fortran_Double_Precision_Vector;
	M	 : out Fortran_Integer;
	S	 : out Double_Precision;
	SEP	 : out Double_Precision;
	WORK	 : in out Fortran_Double_Precision_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTRSEN;


--  LAPACK routine (version 2.0) --
--  DTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a real upper
--  quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q
--  orthogonal).

procedure TRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Double_Precision_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Double_Precision_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Double_Precision_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Matrix;
	LDWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames DTRSNA;


--  LAPACK routine (version 2.0) --
--  DTRSYL solves the real Sylvester matrix equation:

procedure TRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Double_Precision_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames DTRSYL;


--  LAPACK routine (version 2.0) --
--  DTRTI2 computes the inverse of a real upper or lower triangular
--  matrix.

procedure TRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTRTI2;


--  LAPACK routine (version 2.0) --
--  DTRTRI computes the inverse of a real upper or lower triangular
--  matrix A.

procedure TRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTRTRI;


--  LAPACK routine (version 2.0) --
--  DTRTRS solves a triangular system of the form

procedure TRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Double_Precision_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames DTRTRS;


--  LAPACK routine (version 2.0) --
--  DTZRQF reduces the M-by-N ( M<=N ) real upper trapezoidal matrix A
--  to upper triangular form by means of orthogonal transformations.

procedure TZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Double_Precision_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames DTZRQF;


--  LAPACK routine (version 2.0) --
--  SBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure BDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	VT	 : Fortran_Real_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SBDSQR;


--  LAPACK routine (version 2.0) --
--  SDISNA computes the reciprocal condition numbers for the eigenvectors
--  of a real symmetric or complex Hermitian matrix or for the left or
--  right singular vectors of a general m-by-n matrix. The reciprocal
--  condition number is the 'gap' between the corresponding eigenvalue or
--  singular value and the nearest other one.

procedure DISNA (
	JOB	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SDISNA;


--  LAPACK routine (version 2.0) --
--  SGBBRD reduces a real general m-by-n band matrix A to upper
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure GBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Real_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGBBRD;


--  LAPACK routine (version 2.0) --
--  SGBCON estimates the reciprocal of the condition number of a real
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by SGBTRF.

procedure GBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGBCON;


--  LAPACK routine (version 2.0) --
--  SGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames SGBEQU;


--  LAPACK routine (version 2.0) --
--  SGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure GBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGBRFS;


--  LAPACK routine (version 2.0) --
--  SGBTF2 computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGBTF2;


--  LAPACK routine (version 2.0) --
--  SGBTRF computes an LU factorization of a real m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGBTRF;


--  LAPACK routine (version 2.0) --
--  SGBTRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general band matrix A using the LU factorization computed
--  by SGBTRF.

procedure GBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGBTRS;


--  LAPACK routine (version 2.0) --
--  SGEBAK forms the right or left eigenvectors of a real general matrix
--  by backward transformation on the computed eigenvectors of the
--  balanced matrix output by SGEBAL.

procedure GEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEBAK;


--  LAPACK routine (version 2.0) --
--  SGEBAL balances a general real matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure GEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGEBAL;


--  LAPACK routine (version 2.0) --
--  SGEBD2 reduces a real general m by n matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

procedure GEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Real_Vector;
	TAUP	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGEBD2;


--  LAPACK routine (version 2.0) --
--  SGEBRD reduces a general real M-by-N matrix A to upper or lower
--  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.

procedure GEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAUQ	 : out Fortran_Real_Vector;
	TAUP	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEBRD;


--  LAPACK routine (version 2.0) --
--  SGECON estimates the reciprocal of the condition number of a general
--  real matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by SGETRF.

procedure GECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGECON;


--  LAPACK routine (version 2.0) --
--  SGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Real_Vector;
	C	 : out Fortran_Real_Vector;
	ROWCND	 : out Real;
	COLCND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames SGEEQU;


--  LAPACK routine (version 2.0) --
--  SGEHD2 reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure GEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGEHD2;


--  LAPACK routine (version 2.0) --
--  SGEHRD reduces a real general matrix A to upper Hessenberg form H by
--  an orthogonal similarity transformation:  Q' * A * Q = H .

procedure GEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEHRD;


--  LAPACK routine (version 2.0) --
--  SGELQ2 computes an LQ factorization of a real m by n matrix A:
--  A = L * Q.

procedure GELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGELQ2;


--  LAPACK routine (version 2.0) --
--  SGELQF computes an LQ factorization of a real M-by-N matrix A:
--  A = L * Q.

procedure GELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGELQF;


--  LAPACK routine (version 2.0) --
--  SGEQL2 computes a QL factorization of a real m by n matrix A:
--  A = Q * L.

procedure GEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGEQL2;


--  LAPACK routine (version 2.0) --
--  SGEQLF computes a QL factorization of a real M-by-N matrix A:
--  A = Q * L.

procedure GEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEQLF;


--  LAPACK routine (version 2.0) --
--  SGEQR2 computes a QR factorization of a real m by n matrix A:
--  A = Q * R.

procedure GEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGEQR2;


--  LAPACK routine (version 2.0) --
--  SGEQRF computes a QR factorization of a real M-by-N matrix A:
--  A = Q * R.

procedure GEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGEQRF;


--  LAPACK routine (version 2.0) --
--  SGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure GERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGERFS;


--  LAPACK routine (version 2.0) --
--  SGERQ2 computes an RQ factorization of a real m by n matrix A:
--  A = R * Q.

procedure GERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGERQ2;


--  LAPACK routine (version 2.0) --
--  SGERQF computes an RQ factorization of a real M-by-N matrix A:
--  A = R * Q.

procedure GERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGERQF;


--  LAPACK routine (version 2.0) --
--  SGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure GETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGETF2;


--  LAPACK routine (version 2.0) --
--  SGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure GETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGETRF;


--  LAPACK routine (version 2.0) --
--  SGETRI computes the inverse of a matrix using the LU factorization
--  computed by SGETRF.

procedure GETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGETRI;


--  LAPACK routine (version 2.0) --
--  SGETRS solves a system of linear equations
--     A * X = B  or  A' * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by SGETRF.

procedure GETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGETRS;


--  LAPACK routine (version 2.0) --
--  SGGBAK forms the right or left eigenvectors of a real generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  SGGBAL.

procedure GGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Real_Vector;
	RSCALE	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGBAK;


--  LAPACK routine (version 2.0) --
--  SGGBAL balances a pair of general real matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure GGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Real_Vector;
	RSCALE	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGGBAL;


--  LAPACK routine (version 2.0) --
--  SGGHRD reduces a pair of real matrices (A,B) to generalized upper
--  Hessenberg form using orthogonal transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are orthogonal, and ' means transpose.

procedure GGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGHRD;


--  LAPACK routine (version 2.0) --
--  SGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure GGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGQRF;


--  LAPACK routine (version 2.0) --
--  SGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure GGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGGRQF;


--  LAPACK routine (version 2.0) --
--  SGGSVP computes orthogonal matrices U, V and Q such that

procedure GGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	TAU	 : in out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SGGSVP;


--  LAPACK routine (version 2.0) --
--  SGTCON estimates the reciprocal of the condition number of a real
--  tridiagonal matrix A using the LU factorization as computed by
--  SGTTRF.

procedure GTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGTCON;


--  LAPACK routine (version 2.0) --
--  SGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure GTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DLF	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	DUF	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGTRFS;


--  LAPACK routine (version 2.0) --
--  SGTSV  solves the equation

procedure GTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGTSV;


--  LAPACK routine (version 2.0) --
--  SGTSVX uses the LU factorization to compute the solution to a real
--  system of linear equations A * X = B or A**T * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure GTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DLF	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	DUF	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGTSVX;


--  LAPACK routine (version 2.0) --
--  SGTTRF computes an LU factorization of a real tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure GTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : out Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SGTTRF;


--  LAPACK routine (version 2.0) --
--  SGTTRS solves one of the systems of equations
--     A*X = B  or  A'*X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by SGTTRF.

procedure GTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Real_Vector;
	D	 : Fortran_Real_Vector;
	DU	 : Fortran_Real_Vector;
	DU2	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SGTTRS;


--  LAPACK routine (version 2.0) --
--  SHGEQZ implements a single-/double-shift version of the QZ method for
--  finding the generalized eigenvalues

procedure HGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	ALPHAR	 : out Fortran_Real_Vector;
	ALPHAI	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SHGEQZ;


--  LAPACK routine (version 2.0) --
--  SHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a real upper Hessenberg matrix H.

procedure HSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : Fortran_Real_Vector;
	WI	 : Fortran_Real_Vector;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SHSEIN;


--  LAPACK routine (version 2.0) --
--  SHSEQR computes the eigenvalues of a real upper Hessenberg matrix H
--  and, optionally, the matrices T and Z from the Schur decomposition
--  H = Z T Z**T, where T is an upper quasi-triangular matrix (the Schur
--  form), and Z is the orthogonal matrix of Schur vectors.

procedure HSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Real_Matrix;
	LDH	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SHSEQR;


--  LAPACK routine (version 2.0) --
--  SLAED0 computes all eigenvalues and corresponding eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.

procedure LAED0 (
	ICOMPQ	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Real_Matrix;
	LDQS	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAED0;


--  LAPACK routine (version 2.0) --
--  SLAED1 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix.  This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and eigenvectors of a tridiagonal matrix.  SLAED7 handles
--  the case in which eigenvalues only or eigenvalues and eigenvectors
--  of a full symmetric matrix (which was reduced to tridiagonal form)
--  are desired.

procedure LAED1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAED1;


--  LAPACK routine (version 2.0) --
--  SLAED2 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny entry in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED2 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : out Fortran_Integer_Vector;
	W	 : out Fortran_Real_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	COLTYP	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAED2;


--  LAPACK routine (version 2.0) --
--  SLAED3 finds the roots of the secular equation, as defined by the
--  values in D, W, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to SLAED4 and then updates the eigenvectors by
--  multiplying the matrix of eigenvectors of the pair of eigensystems
--  being combined by the matrix of eigenvectors of the K-by-K system
--  which is solved here.

procedure LAED3 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	DLAMDA	 : Fortran_Real_Vector;
	Q2	 : Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	INDXC	 : Fortran_Integer_Vector;
	CTOT	 : Fortran_Integer_Vector;
	W	 : Fortran_Real_Vector;
	S	 : in out Fortran_Real_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SLAED3;


--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th updated eigenvalue of a symmetric
--  rank-one modification to a diagonal matrix whose elements are
--  given in the array d, and that

procedure LAED4 (
	N	 : Fortran_Integer;
	I	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	V_DELTA	 : out Fortran_Real_Vector;
	RHO	 : Real;
	DLAM	 : out Real;
	INFO	 : out Fortran_Integer )
renames SLAED4;


--  LAPACK routine (version 2.0) --
--  This subroutine computes the I-th eigenvalue of a symmetric rank-one
--  modification of a 2-by-2 diagonal matrix

procedure LAED5 (
	I	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	V_DELTA	 : out Fortran_Real_Vector;
	RHO	 : Real;
	DLAM	 : out Real )
renames SLAED5;


--  LAPACK routine (version 2.0) --
--  SLAED6 computes the positive or negative root (closest to the origin)
--  of
--                   z(1)        z(2)        z(3)
--  f(x) =   rho + --------- + ---------- + ---------
--                  d(1)-x      d(2)-x      d(3)-x

procedure LAED6 (
	KNITER	 : Fortran_Integer;
	ORGATI	 : Logical;
	RHO	 : Real;
	D	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Vector;
	FINIT	 : Real;
	TAU	 : out Real;
	INFO	 : out Fortran_Integer )
renames SLAED6;


--  LAPACK routine (version 2.0) --
--  SLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense symmetric matrix
--  that has been reduced to tridiagonal form.  SLAED1 handles
--  the case in which all eigenvalues and eigenvectors of a symmetric
--  tridiagonal matrix are desired.

procedure LAED7 (
	ICOMPQ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : out Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	QSTORE	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAED7;


--  LAPACK routine (version 2.0) --
--  SLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED8 (
	ICOMPQ	 : Fortran_Integer;
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	INDXQ	 : Fortran_Integer_Vector;
	RHO	 : Real;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Real_Vector;
	DLAMDA	 : out Fortran_Real_Vector;
	Q2	 : out Fortran_Real_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Real_Matrix;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAED8;


--  LAPACK routine (version 2.0) --
--  SLAED9 finds the roots of the secular equation, as defined by the
--  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
--  appropriate calls to SLAED4 and then stores the new matrix of
--  eigenvectors for use in calculating the next level of Z vectors.

procedure LAED9 (
	K	 : Fortran_Integer;
	KSTART	 : Fortran_Integer;
	KSTOP	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	Q	 : in out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Real;
	DLAMDA	 : Fortran_Real_Vector;
	W	 : Fortran_Real_Vector;
	S	 : out Fortran_Real_Matrix;
	LDS	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SLAED9;


--  LAPACK routine (version 2.0) --
--  SLAEDA computes the Z vector corresponding to the merge step in the
--  CURLVLth step of the merge process with TLVLS steps for the CURPBMth
--  problem.

procedure LAEDA (
	N	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Real_Matrix;
	Q	 : Fortran_Real_Vector;
	QPTR	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Real_Vector;
	ZTEMP	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SLAEDA;


--  LAPACK routine (version 2.0) --
--  SLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
--  tridiagonal matrix and lambda is a scalar, as

procedure LAGTF (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Vector;
	LAMBDA	 : Real;
	B	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Vector;
	TOL	 : Real;
	D	 : out Fortran_Real_Vector;
	P_IN	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SLAGTF;


--  LAPACK routine (version 2.0) --
--  SLAMRG will create a permutation list which will merge the elements
--  of A (which is composed of two independently sorted sets) into a
--  single set which is sorted in ascending order.

procedure LAMRG (
	N1	 : Fortran_Integer;
	N2	 : Fortran_Integer;
	A	 : Fortran_Real_Vector;
	STRD1	 : Fortran_Integer;
	STRD2	 : Fortran_Integer;
	INDEX	 : out Fortran_Integer_Vector )
renames SLAMRG;


--  LAPACK routine (version 2.0) --
--     SLASQ1 computes the singular values of a real N-by-N bidiagonal
--     matrix with diagonal D and off-diagonal E. The singular values are
--     computed to high relative accuracy, barring over/underflow or
--     denormalization. The algorithm is described in

procedure LASQ1 (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SLASQ1;


--  LAPACK routine (version 2.0) --
--     SLASQ2 computes the singular values of a real N-by-N unreduced
--     bidiagonal matrix with squared diagonal elements in Q and
--     squared off-diagonal elements in E. The singular values are
--     computed to relative accuracy TOL, barring over/underflow or
--     denormalization.

procedure LASQ2 (
	M	 : Fortran_Integer;
	Q	 : out Fortran_Real_Vector;
	E	 : in out Fortran_Real_Vector;
	QQ	 : Fortran_Real_Vector;
	EE	 : Fortran_Real_Vector;
	EPS	 : Real;
	TOL2	 : Real;
	SMALL2	 : Real;
	SUP	 : Real;
	KEND	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SLASQ2;


--  LAPACK routine (version 2.0) --
--     SLASQ3 is the workhorse of the whole bidiagonal SVD algorithm.
--     This can be described as the differential qd with shifts.

procedure LASQ3 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	QQ	 : Fortran_Real_Vector;
	EE	 : Fortran_Real_Vector;
	SUP	 : Real;
	SIGMA	 : Real;
	KEND	 : Fortran_Integer;
	OFF	 : Fortran_Integer;
	IPHASE	 : Fortran_Integer;
	ICONV	 : Fortran_Integer;
	EPS	 : Real;
	TOL2	 : Real;
	SMALL2	 : Real )
renames SLASQ3;


--  LAPACK routine (version 2.0) --
--     SLASQ4 estimates TAU, the smallest eigenvalue of a matrix. This
--     routine improves the input value of SUP which is an upper bound
--     for the smallest eigenvalue for this matrix .

procedure LASQ4 (
	N	 : Fortran_Integer;
	Q	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	TAU	 : out Real;
	SUP	 : Real )
renames SLASQ4;


--  LAPACK routine (version 2.0) --
--  Sort the numbers in D in increasing order (if ID = 'I') or
--  in decreasing order (if ID = 'D' ).

procedure LASRT (
	ID	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SLASRT;


--  LAPACK routine (version 2.0) --
--  SLASYF computes a partial factorization of a real symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure LASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Real_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SLASYF;


--  LAPACK routine (version 2.0) --
--  SLATZM applies a Householder matrix generated by STZRQF to a matrix.

procedure LATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Real_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Real;
	C1	 : Fortran_Real_Matrix;
	C2	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector )
renames SLATZM;


--  LAPACK routine (version 2.0) --
--  SOPGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  SSPTRD using packed storage:

procedure OPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	TAU	 : Fortran_Real_Vector;
	Q	 : out Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SOPGTR;


--  LAPACK routine (version 2.0) --
--  SOPMTR overwrites the general real M-by-N matrix C with

procedure OPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SOPMTR;


--  LAPACK routine (version 2.0) --
--  SORG2L generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure ORG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORG2L;


--  LAPACK routine (version 2.0) --
--  SORG2R generates an m by n real matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure ORG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORG2R;


--  LAPACK routine (version 2.0) --
--  SORGBR generates one of the real orthogonal matrices Q or P**T
--  determined by SGEBRD when reducing a real matrix A to bidiagonal
--  form: A = Q * B * P**T.  Q and P**T are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure ORGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGBR;


--  LAPACK routine (version 2.0) --
--  SORGHR generates a real orthogonal matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  SGEHRD:

procedure ORGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGHR;


--  LAPACK routine (version 2.0) --
--  SORGL2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure ORGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORGL2;


--  LAPACK routine (version 2.0) --
--  SORGLQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure ORGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGLQ;


--  LAPACK routine (version 2.0) --
--  SORGQL generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure ORGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGQL;


--  LAPACK routine (version 2.0) --
--  SORGQR generates an M-by-N real matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure ORGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGQR;


--  LAPACK routine (version 2.0) --
--  SORGR2 generates an m by n real matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure ORGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORGR2;


--  LAPACK routine (version 2.0) --
--  SORGRQ generates an M-by-N real matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure ORGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGRQ;


--  LAPACK routine (version 2.0) --
--  SORGTR generates a real orthogonal matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  SSYTRD:

procedure ORGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORGTR;


--  LAPACK routine (version 2.0) --
--  SORM2L overwrites the general real m by n matrix C with

procedure ORM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORM2L;


--  LAPACK routine (version 2.0) --
--  SORM2R overwrites the general real m by n matrix C with

procedure ORM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORM2R;


--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', SORMBR overwrites the general real M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'T':      Q**T * C       C * Q**T

procedure ORMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMBR;


--  LAPACK routine (version 2.0) --
--  SORMHR overwrites the general real M-by-N matrix C with

procedure ORMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMHR;


--  LAPACK routine (version 2.0) --
--  SORML2 overwrites the general real m by n matrix C with

procedure ORML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORML2;


--  LAPACK routine (version 2.0) --
--  SORMLQ overwrites the general real M-by-N matrix C with

procedure ORMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMLQ;


--  LAPACK routine (version 2.0) --
--  SORMQL overwrites the general real M-by-N matrix C with

procedure ORMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMQL;


--  LAPACK routine (version 2.0) --
--  SORMQR overwrites the general real M-by-N matrix C with

procedure ORMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMQR;


--  LAPACK routine (version 2.0) --
--  SORMR2 overwrites the general real m by n matrix C with

procedure ORMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SORMR2;


--  LAPACK routine (version 2.0) --
--  SORMRQ overwrites the general real M-by-N matrix C with

procedure ORMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMRQ;


--  LAPACK routine (version 2.0) --
--  SORMTR overwrites the general real M-by-N matrix C with

procedure ORMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Real_Vector;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SORMTR;


--  LAPACK routine (version 2.0) --
--  SPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite band matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by SPBTRF.

procedure PBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPBCON;


--  LAPACK routine (version 2.0) --
--  SPBEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure PBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames SPBEQU;


--  LAPACK routine (version 2.0) --
--  SPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure PBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Real_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPBRFS;


--  LAPACK routine (version 2.0) --
--  SPBSTF computes a split Cholesky factorization of a real
--  symmetric positive definite band matrix A.

procedure PBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPBSTF;


--  LAPACK routine (version 2.0) --
--  SPBTF2 computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure PBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPBTF2;


--  LAPACK routine (version 2.0) --
--  SPBTRF computes the Cholesky factorization of a real symmetric
--  positive definite band matrix A.

procedure PBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPBTRF;


--  LAPACK routine (version 2.0) --
--  SPBTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite band matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by SPBTRF.

procedure PBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPBTRS;


--  LAPACK routine (version 2.0) --
--  SPOCON estimates the reciprocal of the condition number (in the 
--  1-norm) of a real symmetric positive definite matrix using the
--  Cholesky factorization A = U**T*U or A = L*L**T computed by SPOTRF.

procedure POCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPOCON;


--  LAPACK routine (version 2.0) --
--  SPOEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure POEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames SPOEQU;


--  LAPACK routine (version 2.0) --
--  SPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure PORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPORFS;


--  LAPACK routine (version 2.0) --
--  SPOTF2 computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure POTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPOTF2;


--  LAPACK routine (version 2.0) --
--  SPOTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A.

procedure POTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPOTRF;


--  LAPACK routine (version 2.0) --
--  SPOTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by SPOTRF.

procedure POTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPOTRI;


--  LAPACK routine (version 2.0) --
--  SPOTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A using the Cholesky factorization
--  A = U**T*U or A = L*L**T computed by SPOTRF.

procedure POTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPOTRS;


--  LAPACK routine (version 2.0) --
--  SPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite packed matrix using
--  the Cholesky factorization A = U**T*U or A = L*L**T computed by
--  SPPTRF.

procedure PPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPPCON;


--  LAPACK routine (version 2.0) --
--  SPPEQU computes row and column scalings intended to equilibrate a
--  symmetric positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure PPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	S	 : out Fortran_Real_Vector;
	SCOND	 : out Real;
	AMAX	 : out Real;
	INFO	 : out Fortran_Integer )
renames SPPEQU;


--  LAPACK routine (version 2.0) --
--  SPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure PPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SPPRFS;


--  LAPACK routine (version 2.0) --
--  SPPTRF computes the Cholesky factorization of a real symmetric
--  positive definite matrix A stored in packed format.

procedure PPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPPTRF;


--  LAPACK routine (version 2.0) --
--  SPPTRI computes the inverse of a real symmetric positive definite
--  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
--  computed by SPPTRF.

procedure PPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPPTRI;


--  LAPACK routine (version 2.0) --
--  SPPTRS solves a system of linear equations A*X = B with a symmetric
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**T*U or A = L*L**T computed by SPPTRF.

procedure PPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPPTRS;


--  LAPACK routine (version 2.0) --
--  SPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a real symmetric positive definite tridiagonal matrix
--  using the factorization A = L*D*L**T or A = U**T*D*U computed by
--  SPTTRF.

procedure PTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPTCON;


--  LAPACK routine (version 2.0) --
--  SPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using SPTTRF, and then calling SBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure PTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPTEQR;


--  LAPACK routine (version 2.0) --
--  SPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure PTRFS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPTRFS;


--  LAPACK routine (version 2.0) --
--  SPTSV computes the solution to a real system of linear equations
--  A*X = B, where A is an N-by-N symmetric positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure PTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPTSV;


--  LAPACK routine (version 2.0) --
--  SPTSVX uses the factorization A = L*D*L**T to compute the solution
--  to a real system of linear equations A*X = B, where A is an N-by-N
--  symmetric positive definite tridiagonal matrix and X and B are
--  N-by-NRHS matrices.

procedure PTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	DF	 : Fortran_Real_Vector;
	EF	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Real;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPTSVX;


--  LAPACK routine (version 2.0) --
--  SPTTRF computes the factorization of a real symmetric positive
--  definite tridiagonal matrix A.

procedure PTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SPTTRF;


--  LAPACK routine (version 2.0) --
--  SPTTRS solves a system of linear equations A * X = B with a
--  symmetric positive definite tridiagonal matrix A using the
--  factorization A = L*D*L**T or A = U**T*D*U computed by SPTTRF.
--  (The two forms are equivalent if A is real.)

procedure PTTRS (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SPTTRS;


--  LAPACK routine (version 2.0) --
--  SSBGST reduces a real symmetric-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure SBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Real_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSBGST;


--  LAPACK routine (version 2.0) --
--  SSBTRD reduces a real symmetric band matrix A to symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSBTRD;


--  LAPACK routine (version 2.0) --
--  SSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric packed matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSPTRF.

procedure SPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSPCON;


--  LAPACK routine (version 2.0) --
--  SSPGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form, using packed storage.

procedure SPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	BP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSPGST;


--  LAPACK routine (version 2.0) --
--  SSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	AFP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSPRFS;


--  LAPACK routine (version 2.0) --
--  SSPTRD reduces a real symmetric matrix A stored in packed form to
--  symmetric tridiagonal form T by an orthogonal similarity
--  transformation: Q**T * A * Q = T.

procedure SPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSPTRD;


--  LAPACK routine (version 2.0) --
--  SSPTRF computes the factorization of a real symmetric matrix A stored
--  in packed format using the Bunch-Kaufman diagonal pivoting method:

procedure SPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSPTRF;


--  LAPACK routine (version 2.0) --
--  SSPTRI computes the inverse of a real symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by SSPTRF.

procedure SPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSPTRI;


--  LAPACK routine (version 2.0) --
--  SSPTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSPTRF.

procedure SPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSPTRS;


--  LAPACK routine (version 2.0) --
--  SSTEBZ computes the eigenvalues of a symmetric tridiagonal
--  matrix T.  The user may ask for all eigenvalues, all eigenvalues
--  in the half-open interval (VL, VU], or the IL-th through IU-th
--  eigenvalues.

procedure STEBZ (
	M_RANGE	 : Character;
	ORDER	 : Character;
	N	 : Fortran_Integer;
	VL	 : Real;
	VU	 : Real;
	IL	 : Fortran_Integer;
	IU	 : Fortran_Integer;
	ABSTOL	 : Real;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : out Fortran_Integer;
	NSPLIT	 : out Fortran_Integer;
	W	 : out Fortran_Real_Vector;
	IBLOCK	 : out Fortran_Integer_Vector;
	ISPLIT	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSTEBZ;


--  LAPACK routine (version 2.0) --
--  SSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band real symmetric matrix can also be
--  found if SSYTRD or SSPTRD or SSBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSTEDC;


--  LAPACK routine (version 2.0) --
--  SSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure STEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Real_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSTEIN;


--  LAPACK routine (version 2.0) --
--  SSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band symmetric matrix can also be found
--  if SSYTRD or SSPTRD or SSBTRD has been used to reduce this matrix to
--  tridiagonal form.

procedure STEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	Z	 : Fortran_Real_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSTEQR;


--  LAPACK routine (version 2.0) --
--  SSTERF computes all eigenvalues of a symmetric tridiagonal matrix
--  using the Pal-Walker-Kahan variant of the QL or QR algorithm.

procedure STERF (
	N	 : Fortran_Integer;
	D	 : Fortran_Real_Vector;
	E	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSTERF;


--  LAPACK routine (version 2.0) --
--  SSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a real symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by SSYTRF.

procedure SYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Real;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSYCON;


--  LAPACK routine (version 2.0) --
--  SSYGS2 reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SYGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYGS2;


--  LAPACK routine (version 2.0) --
--  SSYGST reduces a real symmetric-definite generalized eigenproblem
--  to standard form.

procedure SYGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYGST;


--  LAPACK routine (version 2.0) --
--  SSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure SYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Real_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSYRFS;


--  LAPACK routine (version 2.0) --
--  SSYTD2 reduces a real symmetric matrix A to symmetric tridiagonal
--  form T by an orthogonal similarity transformation: Q' * A * Q = T.

procedure SYTD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSYTD2;


--  LAPACK routine (version 2.0) --
--  SSYTF2 computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method:

procedure SYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames SSYTF2;


--  LAPACK routine (version 2.0) --
--  SSYTRD reduces a real symmetric matrix A to real symmetric
--  tridiagonal form T by an orthogonal similarity transformation:
--  Q**T * A * Q = T.

procedure SYTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Real_Vector;
	E	 : out Fortran_Real_Vector;
	TAU	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYTRD;


--  LAPACK routine (version 2.0) --
--  SSYTRF computes the factorization of a real symmetric matrix A using
--  the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure SYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYTRF;


--  LAPACK routine (version 2.0) --
--  SSYTRI computes the inverse of a real symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  SSYTRF.

procedure SYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames SSYTRI;


--  LAPACK routine (version 2.0) --
--  SSYTRS solves a system of linear equations A*X = B with a real
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by SSYTRF.

procedure SYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames SSYTRS;


--  LAPACK routine (version 2.0) --
--  STBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure TBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STBCON;


--  LAPACK routine (version 2.0) --
--  STBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure TBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STBRFS;


--  LAPACK routine (version 2.0) --
--  STBTRS solves a triangular system of the form

procedure TBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Real_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STBTRS;


--  LAPACK routine (version 2.0) --
--  STGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of real upper triangular matrices (A,B).

procedure TGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames STGEVC;


--  LAPACK routine (version 2.0) --
--  STGSJA computes the generalized singular value decomposition (GSVD)
--  of two real upper triangular (or trapezoidal) matrices A and B.

procedure TGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Real;
	TOLB	 : Real;
	ALPHA	 : out Fortran_Real_Vector;
	BETA	 : out Fortran_Real_Vector;
	U	 : Fortran_Real_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Real_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STGSJA;


--  LAPACK routine (version 2.0) --
--  STPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STPCON;


--  LAPACK routine (version 2.0) --
--  STPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure TPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STPRFS;


--  LAPACK routine (version 2.0) --
--  STPTRI computes the inverse of a real upper or lower triangular
--  matrix A stored in packed format.

procedure TPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames STPTRI;


--  LAPACK routine (version 2.0) --
--  STPTRS solves a triangular system of the form

procedure TPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Real_Vector;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STPTRS;


--  LAPACK routine (version 2.0) --
--  STRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STRCON;


--  LAPACK routine (version 2.0) --
--  STREVC computes some or all of the right and/or left eigenvectors of
--  a real upper quasi-triangular matrix T.

procedure TREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : Fortran_Integer;
	WORK	 : Fortran_Real_Vector;
	INFO	 : Fortran_Integer )
renames STREVC;


--  LAPACK routine (version 2.0) --
--  STREXC reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that the diagonal block of T with row index IFST is
--  moved to row ILST.

procedure TREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	WORK	 : in out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames STREXC;


--  LAPACK routine (version 2.0) --
--  STRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure TRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Real_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Real_Vector;
	BERR	 : out Fortran_Real_Vector;
	WORK	 : in out Fortran_Real_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STRRFS;


--  LAPACK routine (version 2.0) --
--  STRSEN reorders the real Schur factorization of a real matrix
--  A = Q*T*Q**T, so that a selected cluster of eigenvalues appears in
--  the leading diagonal blocks of the upper quasi-triangular matrix T,
--  and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure TRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Real_Matrix;
	LDQ	 : Fortran_Integer;
	WR	 : out Fortran_Real_Vector;
	WI	 : out Fortran_Real_Vector;
	M	 : out Fortran_Integer;
	S	 : out Real;
	SEP	 : out Real;
	WORK	 : in out Fortran_Real_Vector;
	LWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STRSEN;


--  LAPACK routine (version 2.0) --
--  STRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a real upper
--  quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q
--  orthogonal).

procedure TRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Real_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Real_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Real_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Real_Vector;
	SEP	 : out Fortran_Real_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Real_Matrix;
	LDWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames STRSNA;


--  LAPACK routine (version 2.0) --
--  STRSYL solves the real Sylvester matrix equation:

procedure TRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Real_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Real;
	INFO	 : out Fortran_Integer )
renames STRSYL;


--  LAPACK routine (version 2.0) --
--  STRTI2 computes the inverse of a real upper or lower triangular
--  matrix.

procedure TRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STRTI2;


--  LAPACK routine (version 2.0) --
--  STRTRI computes the inverse of a real upper or lower triangular
--  matrix A.

procedure TRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STRTRI;


--  LAPACK routine (version 2.0) --
--  STRTRS solves a triangular system of the form

procedure TRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Real_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames STRTRS;


--  LAPACK routine (version 2.0) --
--  STZRQF reduces the M-by-N ( M<=N ) real upper trapezoidal matrix A
--  to upper triangular form by means of orthogonal transformations.

procedure TZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Real_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Real_Vector;
	INFO	 : out Fortran_Integer )
renames STZRQF;


--  LAPACK routine (version 2.0) --
--  ZBDSQR computes the singular value decomposition (SVD) of a real
--  N-by-N (upper or lower) bidiagonal matrix B:  B = Q * S * P' (P'
--  denotes the transpose of P), where S is a diagonal matrix with
--  non-negative diagonal elements (the singular values of B), and Q
--  and P are orthogonal matrices.

procedure BDSQR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NCVT	 : Fortran_Integer;
	NRU	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	VT	 : Fortran_Complex_Star_16_Matrix;
	LDVT	 : Fortran_Integer;
	U	 : Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZBDSQR;


--  LAPACK routine (version 2.0) --
--  ZGBBRD reduces a complex general m-by-n band matrix A to real upper
--  bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure GBBRD (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	NCC	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	PT	 : out Fortran_Complex_Star_16_Matrix;
	LDPT	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBBRD;


--  LAPACK routine (version 2.0) --
--  ZGBCON estimates the reciprocal of the condition number of a complex
--  general band matrix A, in either the 1-norm or the infinity-norm,
--  using the LU factorization computed by ZGBTRF.

procedure GBCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBCON;


--  LAPACK routine (version 2.0) --
--  ZGBEQU computes row and column scalings intended to equilibrate an
--  M-by-N band matrix A and reduce its condition number.  R returns the
--  row scale factors and C the column scale factors, chosen to try to
--  make the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GBEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZGBEQU;


--  LAPACK routine (version 2.0) --
--  ZGBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is banded, and provides
--  error bounds and backward error estimates for the solution.

procedure GBRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBRFS;


--  LAPACK routine (version 2.0) --
--  ZGBTF2 computes an LU factorization of a complex m-by-n band matrix
--  A using partial pivoting with row interchanges.

procedure GBTF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBTF2;


--  LAPACK routine (version 2.0) --
--  ZGBTRF computes an LU factorization of a complex m-by-n band matrix A
--  using partial pivoting with row interchanges.

procedure GBTRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGBTRF;


--  LAPACK routine (version 2.0) --
--  ZGBTRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general band matrix A using the LU factorization computed
--  by ZGBTRF.

procedure GBTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	KL	 : Fortran_Integer;
	KU	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGBTRS;


--  LAPACK routine (version 2.0) --
--  ZGEBAK forms the right or left eigenvectors of a complex general
--  matrix by backward transformation on the computed eigenvectors of the
--  balanced matrix output by ZGEBAL.

procedure GEBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	SCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGEBAK;


--  LAPACK routine (version 2.0) --
--  ZGEBAL balances a general complex matrix A.  This involves, first,
--  permuting A by a similarity transformation to isolate eigenvalues
--  in the first 1 to ILO-1 and last IHI+1 to N elements on the
--  diagonal; and second, applying a diagonal similarity transformation
--  to rows and columns ILO to IHI to make the rows and columns as
--  close in norm as possible.  Both steps are optional.

procedure GEBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	SCALE	 : out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEBAL;


--  LAPACK routine (version 2.0) --
--  ZGEBD2 reduces a complex general m by n matrix A to upper or lower
--  real bidiagonal form B by a unitary transformation: Q' * A * P = B.

procedure GEBD2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Complex_Star_16_Vector;
	TAUP	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEBD2;


--  LAPACK routine (version 2.0) --
--  ZGEBRD reduces a general complex M-by-N matrix A to upper or lower
--  bidiagonal form B by a unitary transformation: Q**H * A * P = B.

procedure GEBRD (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAUQ	 : out Fortran_Complex_Star_16_Vector;
	TAUP	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGEBRD;


--  LAPACK routine (version 2.0) --
--  ZGECON estimates the reciprocal of the condition number of a general
--  complex matrix A, in either the 1-norm or the infinity-norm, using
--  the LU factorization computed by ZGETRF.

procedure GECON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGECON;


--  LAPACK routine (version 2.0) --
--  ZGEEQU computes row and column scalings intended to equilibrate an
--  M-by-N matrix A and reduce its condition number.  R returns the row
--  scale factors and C the column scale factors, chosen to try to make
--  the largest element in each row and column of the matrix B with
--  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

procedure GEEQU (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	R	 : out Fortran_Double_Precision_Vector;
	C	 : out Fortran_Double_Precision_Vector;
	ROWCND	 : out Double_Precision;
	COLCND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZGEEQU;


--  LAPACK routine (version 2.0) --
--  ZGEHD2 reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure GEHD2 (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEHD2;


--  LAPACK routine (version 2.0) --
--  ZGEHRD reduces a complex general matrix A to upper Hessenberg form H
--  by a unitary similarity transformation:  Q' * A * Q = H .

procedure GEHRD (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGEHRD;


--  LAPACK routine (version 2.0) --
--  ZGELQ2 computes an LQ factorization of a complex m by n matrix A:
--  A = L * Q.

procedure GELQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGELQ2;


--  LAPACK routine (version 2.0) --
--  ZGELQF computes an LQ factorization of a complex M-by-N matrix A:
--  A = L * Q.

procedure GELQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGELQF;


--  LAPACK routine (version 2.0) --
--  ZGEQL2 computes a QL factorization of a complex m by n matrix A:
--  A = Q * L.

procedure GEQL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEQL2;


--  LAPACK routine (version 2.0) --
--  ZGEQLF computes a QL factorization of a complex M-by-N matrix A:
--  A = Q * L.

procedure GEQLF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGEQLF;


--  LAPACK routine (version 2.0) --
--  ZGEQR2 computes a QR factorization of a complex m by n matrix A:
--  A = Q * R.

procedure GEQR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGEQR2;


--  LAPACK routine (version 2.0) --
--  ZGEQRF computes a QR factorization of a complex M-by-N matrix A:
--  A = Q * R.

procedure GEQRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGEQRF;


--  LAPACK routine (version 2.0) --
--  ZGERFS improves the computed solution to a system of linear
--  equations and provides error bounds and backward error estimates for
--  the solution.

procedure GERFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGERFS;


--  LAPACK routine (version 2.0) --
--  ZGERQ2 computes an RQ factorization of a complex m by n matrix A:
--  A = R * Q.

procedure GERQ2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGERQ2;


--  LAPACK routine (version 2.0) --
--  ZGERQF computes an RQ factorization of a complex M-by-N matrix A:
--  A = R * Q.

procedure GERQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGERQF;


--  LAPACK routine (version 2.0) --
--  ZGETF2 computes an LU factorization of a general m-by-n matrix A
--  using partial pivoting with row interchanges.

procedure GETF2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGETF2;


--  LAPACK routine (version 2.0) --
--  ZGETRF computes an LU factorization of a general M-by-N matrix A
--  using partial pivoting with row interchanges.

procedure GETRF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGETRF;


--  LAPACK routine (version 2.0) --
--  ZGETRI computes the inverse of a matrix using the LU factorization
--  computed by ZGETRF.

procedure GETRI (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGETRI;


--  LAPACK routine (version 2.0) --
--  ZGETRS solves a system of linear equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B
--  with a general N-by-N matrix A using the LU factorization computed
--  by ZGETRF.

procedure GETRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGETRS;


--  LAPACK routine (version 2.0) --
--  ZGGBAK forms the right or left eigenvectors of a complex generalized
--  eigenvalue problem A*x = lambda*B*x, by backward transformation on
--  the computed eigenvectors of the balanced pair of matrices output by
--  ZGGBAL.

procedure GGBAK (
	JOB	 : Character;
	SIDE	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	LSCALE	 : Fortran_Double_Precision_Vector;
	RSCALE	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGBAK;


--  LAPACK routine (version 2.0) --
--  ZGGBAL balances a pair of general complex matrices (A,B).  This
--  involves, first, permuting A and B by similarity transformations to
--  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
--  elements on the diagonal; and second, applying a diagonal similarity
--  transformation to rows and columns ILO to IHI to make the rows
--  and columns as close in norm as possible. Both steps are optional.

procedure GGBAL (
	JOB	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ILO	 : out Fortran_Integer;
	IHI	 : out Fortran_Integer;
	LSCALE	 : out Fortran_Double_Precision_Vector;
	RSCALE	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGGBAL;


--  LAPACK routine (version 2.0) --
--  ZGGHRD reduces a pair of complex matrices (A,B) to generalized upper
--  Hessenberg form using unitary transformations, where A is a
--  general matrix and B is upper triangular:  Q' * A * Z = H and
--  Q' * B * Z = T, where H is upper Hessenberg, T is upper triangular,
--  and Q and Z are unitary, and ' means conjugate transpose.

procedure GGHRD (
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGHRD;


--  LAPACK routine (version 2.0) --
--  ZGGQRF computes a generalized QR factorization of an N-by-M matrix A
--  and an N-by-P matrix B:

procedure GGQRF (
	N	 : Fortran_Integer;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGQRF;


--  LAPACK routine (version 2.0) --
--  ZGGRQF computes a generalized RQ factorization of an M-by-N matrix A
--  and a P-by-N matrix B:

procedure GGRQF (
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAUA	 : out Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TAUB	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGGRQF;


--  LAPACK routine (version 2.0) --
--  ZGGSVP computes unitary matrices U, V and Q such that

procedure GGSVP (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	K	 : out Fortran_Integer;
	L	 : out Fortran_Integer;
	U	 : out Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : out Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	TAU	 : in out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGGSVP;


--  LAPACK routine (version 2.0) --
--  ZGTCON estimates the reciprocal of the condition number of a complex
--  tridiagonal matrix A using the LU factorization as computed by
--  ZGTTRF.

procedure GTCON (
	NORM	 : Character;
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZGTCON;


--  LAPACK routine (version 2.0) --
--  ZGTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is tridiagonal, and provides
--  error bounds and backward error estimates for the solution.

procedure GTRFS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DLF	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Complex_Star_16_Vector;
	DUF	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGTRFS;


--  LAPACK routine (version 2.0) --
--  ZGTSV  solves the equation

procedure GTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGTSV;


--  LAPACK routine (version 2.0) --
--  ZGTSVX uses the LU factorization to compute the solution to a complex
--  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,
--  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS
--  matrices.

procedure GTSVX (
	FACT	 : Character;
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DLF	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Complex_Star_16_Vector;
	DUF	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZGTSVX;


--  LAPACK routine (version 2.0) --
--  ZGTTRF computes an LU factorization of a complex tridiagonal matrix A
--  using elimination with partial pivoting and row interchanges.

procedure GTTRF (
	N	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : out Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZGTTRF;


--  LAPACK routine (version 2.0) --
--  ZGTTRS solves one of the systems of equations
--     A * X = B,  A**T * X = B,  or  A**H * X = B,
--  with a tridiagonal matrix A using the LU factorization computed
--  by ZGTTRF.

procedure GTTRS (
	TRANS	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	DL	 : Fortran_Complex_Star_16_Vector;
	D	 : Fortran_Complex_Star_16_Vector;
	DU	 : Fortran_Complex_Star_16_Vector;
	DU2	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZGTTRS;


--  LAPACK routine (version 2.0) --
--  ZHBGST reduces a complex Hermitian-definite banded generalized
--  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
--  such that C has the same bandwidth as A.

procedure HBGST (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KA	 : Fortran_Integer;
	KB	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	BB	 : Fortran_Complex_Star_16_Matrix;
	LDBB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHBGST;


--  LAPACK routine (version 2.0) --
--  ZHBTRD reduces a complex Hermitian band matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure HBTRD (
	VECT	 : Character;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHBTRD;


--  LAPACK routine (version 2.0) --
--  ZHECON estimates the reciprocal of the condition number of a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHETRF.

procedure HECON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHECON;


--  LAPACK routine (version 2.0) --
--  ZHEGS2 reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure HEGS2 (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHEGS2;


--  LAPACK routine (version 2.0) --
--  ZHEGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form.

procedure HEGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHEGST;


--  LAPACK routine (version 2.0) --
--  ZHERFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure HERFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHERFS;


--  LAPACK routine (version 2.0) --
--  ZHETD2 reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q' * A * Q = T.

procedure HETD2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHETD2;


--  LAPACK routine (version 2.0) --
--  ZHETF2 computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure HETF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHETF2;


--  LAPACK routine (version 2.0) --
--  ZHETRD reduces a complex Hermitian matrix A to real symmetric
--  tridiagonal form T by a unitary similarity transformation:
--  Q**H * A * Q = T.

procedure HETRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHETRD;


--  LAPACK routine (version 2.0) --
--  ZHETRF computes the factorization of a complex Hermitian matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure HETRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHETRF;


--  LAPACK routine (version 2.0) --
--  ZHETRI computes the inverse of a complex Hermitian indefinite matrix
--  A using the factorization A = U*D*U**H or A = L*D*L**H computed by
--  ZHETRF.

procedure HETRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHETRI;


--  LAPACK routine (version 2.0) --
--  ZHETRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHETRF.

procedure HETRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHETRS;


--  LAPACK routine (version 2.0) --
--  ZHGEQZ implements a single-shift version of the QZ
--  method for finding the generalized eigenvalues w(i)=ALPHA(i)/BETA(i)
--  of the equation

procedure HGEQZ (
	JOB	 : Character;
	COMPQ	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	ALPHA	 : out Fortran_Complex_Star_16_Vector;
	BETA	 : out Fortran_Complex_Star_16_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHGEQZ;


--  LAPACK routine (version 2.0) --
--  ZHPCON estimates the reciprocal of the condition number of a complex
--  Hermitian packed matrix A using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHPTRF.

procedure HPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPCON;


--  LAPACK routine (version 2.0) --
--  ZHPGST reduces a complex Hermitian-definite generalized
--  eigenproblem to standard form, using packed storage.

procedure HPGST (
	ITYPE	 : Fortran_Integer;
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	BP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPGST;


--  LAPACK routine (version 2.0) --
--  ZHPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure HPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPRFS;


--  LAPACK routine (version 2.0) --
--  ZHPTRD reduces a complex Hermitian matrix A stored in packed form to
--  real symmetric tridiagonal form T by a unitary similarity
--  transformation: Q**H * A * Q = T.

procedure HPTRD (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	D	 : out Fortran_Double_Precision_Vector;
	E	 : out Fortran_Double_Precision_Vector;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPTRD;


--  LAPACK routine (version 2.0) --
--  ZHPTRF computes the factorization of a complex Hermitian packed
--  matrix A using the Bunch-Kaufman diagonal pivoting method:

procedure HPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPTRF;


--  LAPACK routine (version 2.0) --
--  ZHPTRI computes the inverse of a complex Hermitian indefinite matrix
--  A in packed storage using the factorization A = U*D*U**H or
--  A = L*D*L**H computed by ZHPTRF.

procedure HPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZHPTRI;


--  LAPACK routine (version 2.0) --
--  ZHPTRS solves a system of linear equations A*X = B with a complex
--  Hermitian matrix A stored in packed format using the factorization
--  A = U*D*U**H or A = L*D*L**H computed by ZHPTRF.

procedure HPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHPTRS;


--  LAPACK routine (version 2.0) --
--  ZHSEIN uses inverse iteration to find specified right and/or left
--  eigenvectors of a complex upper Hessenberg matrix H.

procedure HSEIN (
	SIDE	 : Character;
	EIGSRC	 : Character;
	INITV	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : Fortran_Complex_Star_16_Vector;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IFAILL	 : out Fortran_Integer_Vector;
	IFAILR	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZHSEIN;


--  LAPACK routine (version 2.0) --
--  ZHSEQR computes the eigenvalues of a complex upper Hessenberg
--  matrix H, and, optionally, the matrices T and Z from the Schur
--  decomposition H = Z T Z**H, where T is an upper triangular matrix
--  (the Schur form), and Z is the unitary matrix of Schur vectors.

procedure HSEQR (
	JOB	 : Character;
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	H	 : Fortran_Complex_Star_16_Matrix;
	LDH	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZHSEQR;


--  LAPACK routine (version 2.0) --
--  Using the divide and conquer method, ZLAED0 computes all eigenvalues
--  of a symmetric tridiagonal matrix which is one diagonal block of
--  those from reducing a dense or band Hermitian matrix and
--  corresponding eigenvectors of the dense or band matrix.

procedure LAED0 (
	QSIZ	 : Fortran_Integer;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	QSTORE	 : in out Fortran_Complex_Star_16_Matrix;
	LDQS	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZLAED0;


--  LAPACK routine (version 2.0) --
--  ZLAED7 computes the updated eigensystem of a diagonal
--  matrix after modification by a rank-one symmetric matrix. This
--  routine is used only for the eigenproblem which requires all
--  eigenvalues and optionally eigenvectors of a dense or banded
--  Hermitian matrix that has been reduced to tridiagonal form.

procedure LAED7 (
	N	 : Fortran_Integer;
	CUTPNT	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	TLVLS	 : Fortran_Integer;
	CURLVL	 : Fortran_Integer;
	CURPBM	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	RHO	 : Double_Precision;
	INDXQ	 : out Fortran_Integer_Vector;
	QSTORE	 : Fortran_Double_Precision_Vector;
	QPTR	 : Fortran_Integer_Vector;
	PRMPTR	 : Fortran_Integer_Vector;
	PERM	 : Fortran_Integer_Vector;
	GIVPTR	 : Fortran_Integer_Vector;
	GIVCOL	 : Fortran_Integer_Matrix;
	GIVNUM	 : Fortran_Double_Precision_Matrix;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZLAED7;


--  LAPACK routine (version 2.0) --
--  ZLAED8 merges the two sets of eigenvalues together into a single
--  sorted set.  Then it tries to deflate the size of the problem.
--  There are two ways in which deflation can occur:  when two or more
--  eigenvalues are close together or if there is a tiny element in the
--  Z vector.  For each such occurrence the order of the related secular
--  equation problem is reduced by one.

procedure LAED8 (
	K	 : out Fortran_Integer;
	N	 : Fortran_Integer;
	QSIZ	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	RHO	 : Double_Precision;
	CUTPNT	 : Fortran_Integer;
	Z	 : Fortran_Double_Precision_Vector;
	DLAMDA	 : out Fortran_Double_Precision_Vector;
	Q2	 : out Fortran_Complex_Star_16_Matrix;
	LDQ2	 : Fortran_Integer;
	W	 : out Fortran_Double_Precision_Vector;
	INDXP	 : in out Fortran_Integer_Vector;
	INDX	 : in out Fortran_Integer_Vector;
	INDXQ	 : Fortran_Integer_Vector;
	PERM	 : out Fortran_Integer_Vector;
	GIVPTR	 : out Fortran_Integer;
	GIVCOL	 : out Fortran_Integer_Matrix;
	GIVNUM	 : out Fortran_Double_Precision_Matrix;
	INFO	 : out Fortran_Integer )
renames ZLAED8;


--  LAPACK routine (version 2.0) --
--  ZLAHEF computes a partial factorization of a complex Hermitian
--  matrix A using the Bunch-Kaufman diagonal pivoting method. The
--  partial factorization has the form:

procedure LAHEF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Star_16_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZLAHEF;


--  LAPACK routine (version 2.0) --
--  ZLASYF computes a partial factorization of a complex symmetric matrix
--  A using the Bunch-Kaufman diagonal pivoting method. The partial
--  factorization has the form:

procedure LASYF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NB	 : Fortran_Integer;
	KB	 : out Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	W	 : in out Fortran_Complex_Star_16_Matrix;
	LDW	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZLASYF;


--  LAPACK routine (version 2.0) --
--  ZLATZM applies a Householder matrix generated by ZTZRQF to a matrix.

procedure LATZM (
	SIDE	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Vector;
	INCV	 : Fortran_Integer;
	TAU	 : Complex_Star_16;
	C1	 : Fortran_Complex_Star_16_Matrix;
	C2	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector )
renames ZLATZM;


--  LAPACK routine (version 2.0) --
--  ZPBCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite band matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  ZPBTRF.

procedure PBCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPBCON;


--  LAPACK routine (version 2.0) --
--  ZPBEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite band matrix A and reduce its condition
--  number (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure PBEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZPBEQU;


--  LAPACK routine (version 2.0) --
--  ZPBRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and banded, and provides error bounds and backward error estimates
--  for the solution.

procedure PBRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	AFB	 : Fortran_Complex_Star_16_Matrix;
	LDAFB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPBRFS;


--  LAPACK routine (version 2.0) --
--  ZPBSTF computes a split Cholesky factorization of a complex
--  Hermitian positive definite band matrix A.

procedure PBSTF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPBSTF;


--  LAPACK routine (version 2.0) --
--  ZPBTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure PBTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPBTF2;


--  LAPACK routine (version 2.0) --
--  ZPBTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite band matrix A.

procedure PBTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPBTRF;


--  LAPACK routine (version 2.0) --
--  ZPBTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite band matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by ZPBTRF.

procedure PBTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPBTRS;


--  LAPACK routine (version 2.0) --
--  ZPOCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite matrix using the
--  Cholesky factorization A = U**H*U or A = L*L**H computed by ZPOTRF.

procedure POCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPOCON;


--  LAPACK routine (version 2.0) --
--  ZPOEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A and reduce its condition number
--  (with respect to the two-norm).  S contains the scale factors,
--  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
--  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
--  choice of S puts the condition number of B within a factor N of the
--  smallest possible condition number over all possible diagonal
--  scalings.

procedure POEQU (
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZPOEQU;


--  LAPACK routine (version 2.0) --
--  ZPORFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite,
--  and provides error bounds and backward error estimates for the
--  solution.

procedure PORFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPORFS;


--  LAPACK routine (version 2.0) --
--  ZPOTF2 computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure POTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPOTF2;


--  LAPACK routine (version 2.0) --
--  ZPOTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A.

procedure POTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPOTRF;


--  LAPACK routine (version 2.0) --
--  ZPOTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by ZPOTRF.

procedure POTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPOTRI;


--  LAPACK routine (version 2.0) --
--  ZPOTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A using the Cholesky factorization
--  A = U**H*U or A = L*L**H computed by ZPOTRF.

procedure POTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPOTRS;


--  LAPACK routine (version 2.0) --
--  ZPPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite packed matrix using
--  the Cholesky factorization A = U**H*U or A = L*L**H computed by
--  ZPPTRF.

procedure PPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPPCON;


--  LAPACK routine (version 2.0) --
--  ZPPEQU computes row and column scalings intended to equilibrate a
--  Hermitian positive definite matrix A in packed storage and reduce
--  its condition number (with respect to the two-norm).  S contains the
--  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
--  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
--  This choice of S puts the condition number of B within a factor N of
--  the smallest possible condition number over all possible diagonal
--  scalings.

procedure PPEQU (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	S	 : out Fortran_Double_Precision_Vector;
	SCOND	 : out Double_Precision;
	AMAX	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZPPEQU;


--  LAPACK routine (version 2.0) --
--  ZPPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure PPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPPRFS;


--  LAPACK routine (version 2.0) --
--  ZPPTRF computes the Cholesky factorization of a complex Hermitian
--  positive definite matrix A stored in packed format.

procedure PPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZPPTRF;


--  LAPACK routine (version 2.0) --
--  ZPPTRI computes the inverse of a complex Hermitian positive definite
--  matrix A using the Cholesky factorization A = U**H*U or A = L*L**H
--  computed by ZPPTRF.

procedure PPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZPPTRI;


--  LAPACK routine (version 2.0) --
--  ZPPTRS solves a system of linear equations A*X = B with a Hermitian
--  positive definite matrix A in packed storage using the Cholesky
--  factorization A = U**H*U or A = L*L**H computed by ZPPTRF.

procedure PPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPPTRS;


--  LAPACK routine (version 2.0) --
--  ZPTCON computes the reciprocal of the condition number (in the
--  1-norm) of a complex Hermitian positive definite tridiagonal matrix
--  using the factorization A = L*D*L**H or A = U**H*D*U computed by
--  ZPTTRF.

procedure PTCON (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPTCON;


--  LAPACK routine (version 2.0) --
--  ZPTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric positive definite tridiagonal matrix by first factoring the
--  matrix using DPTTRF and then calling ZBDSQR to compute the singular
--  values of the bidiagonal factor.

procedure PTEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPTEQR;


--  LAPACK routine (version 2.0) --
--  ZPTRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is Hermitian positive definite
--  and tridiagonal, and provides error bounds and backward error
--  estimates for the solution.

procedure PTRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPTRFS;


--  LAPACK routine (version 2.0) --
--  ZPTSV computes the solution to a complex system of linear equations
--  A*X = B, where A is an N-by-N Hermitian positive definite tridiagonal
--  matrix, and X and B are N-by-NRHS matrices.

procedure PTSV (
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPTSV;


--  LAPACK routine (version 2.0) --
--  ZPTSVX uses the factorization A = L*D*L**H to compute the solution
--  to a complex system of linear equations A*X = B, where A is an
--  N-by-N Hermitian positive definite tridiagonal matrix and X and B
--  are N-by-NRHS matrices.

procedure PTSVX (
	FACT	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	DF	 : Fortran_Double_Precision_Vector;
	EF	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : out Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZPTSVX;


--  LAPACK routine (version 2.0) --
--  ZPTTRF computes the factorization of a complex Hermitian positive
--  definite tridiagonal matrix A.

procedure PTTRF (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZPTTRF;


--  LAPACK routine (version 2.0) --
--  ZPTTRS solves a system of linear equations A * X = B with a
--  Hermitian positive definite tridiagonal matrix A using the
--  factorization A = U**H*D*U or A = L*D*L**H computed by ZPTTRF.

procedure PTTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZPTTRS;


--  LAPACK routine (version 2.0) --
--  ZSPCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric packed matrix A using the
--  factorization A = U*D*U**T or A = L*D*L**T computed by ZSPTRF.

procedure SPCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZSPCON;


--  LAPACK routine (version 2.0) --
--  ZSPRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite
--  and packed, and provides error bounds and backward error estimates
--  for the solution.

procedure SPRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	AFP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZSPRFS;


--  LAPACK routine (version 2.0) --
--  ZSPTRF computes the factorization of a complex symmetric matrix A
--  stored in packed format using the Bunch-Kaufman diagonal pivoting
--  method:

procedure SPTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZSPTRF;


--  LAPACK routine (version 2.0) --
--  ZSPTRI computes the inverse of a complex symmetric indefinite matrix
--  A in packed storage using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by ZSPTRF.

procedure SPTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZSPTRI;


--  LAPACK routine (version 2.0) --
--  ZSPTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A stored in packed format using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by ZSPTRF.

procedure SPTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSPTRS;


--  LAPACK routine (version 2.0) --
--  ZSTEDC computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the divide and conquer method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEDC (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	LRWORK	 : Fortran_Integer;
	IWORK	 : in out Fortran_Integer_Vector;
	LIWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSTEDC;


--  LAPACK routine (version 2.0) --
--  ZSTEIN computes the eigenvectors of a real symmetric tridiagonal
--  matrix T corresponding to specified eigenvalues, using inverse
--  iteration.

procedure STEIN (
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	M	 : Fortran_Integer;
	W	 : Fortran_Double_Precision_Vector;
	IBLOCK	 : Fortran_Integer_Vector;
	ISPLIT	 : Fortran_Integer_Vector;
	Z	 : out Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	IWORK	 : in out Fortran_Integer_Vector;
	IFAIL	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZSTEIN;


--  LAPACK routine (version 2.0) --
--  ZSTEQR computes all eigenvalues and, optionally, eigenvectors of a
--  symmetric tridiagonal matrix using the implicit QL or QR method.
--  The eigenvectors of a full or band complex Hermitian matrix can also
--  be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this
--  matrix to tridiagonal form.

procedure STEQR (
	COMPZ	 : Character;
	N	 : Fortran_Integer;
	D	 : Fortran_Double_Precision_Vector;
	E	 : Fortran_Double_Precision_Vector;
	Z	 : Fortran_Complex_Star_16_Matrix;
	LDZ	 : Fortran_Integer;
	WORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZSTEQR;


--  LAPACK routine (version 2.0) --
--  ZSYCON estimates the reciprocal of the condition number (in the
--  1-norm) of a complex symmetric matrix A using the factorization
--  A = U*D*U**T or A = L*D*L**T computed by ZSYTRF.

procedure SYCON (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	ANORM	 : Double_Precision;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZSYCON;


--  LAPACK routine (version 2.0) --
--  ZSYRFS improves the computed solution to a system of linear
--  equations when the coefficient matrix is symmetric indefinite, and
--  provides error bounds and backward error estimates for the solution.

procedure SYRFS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	AF	 : Fortran_Complex_Star_16_Matrix;
	LDAF	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZSYRFS;


--  LAPACK routine (version 2.0) --
--  ZSYTF2 computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method:

procedure SYTF2 (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	INFO	 : out Fortran_Integer )
renames ZSYTF2;


--  LAPACK routine (version 2.0) --
--  ZSYTRF computes the factorization of a complex symmetric matrix A
--  using the Bunch-Kaufman diagonal pivoting method.  The form of the
--  factorization is

procedure SYTRF (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : out Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSYTRF;


--  LAPACK routine (version 2.0) --
--  ZSYTRI computes the inverse of a complex symmetric indefinite matrix
--  A using the factorization A = U*D*U**T or A = L*D*L**T computed by
--  ZSYTRF.

procedure SYTRI (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZSYTRI;


--  LAPACK routine (version 2.0) --
--  ZSYTRS solves a system of linear equations A*X = B with a complex
--  symmetric matrix A using the factorization A = U*D*U**T or
--  A = L*D*L**T computed by ZSYTRF.

procedure SYTRS (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	IPIV	 : Fortran_Integer_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZSYTRS;


--  LAPACK routine (version 2.0) --
--  ZTBCON estimates the reciprocal of the condition number of a
--  triangular band matrix A, in either the 1-norm or the infinity-norm.

procedure TBCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTBCON;


--  LAPACK routine (version 2.0) --
--  ZTBRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular band
--  coefficient matrix.

procedure TBRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTBRFS;


--  LAPACK routine (version 2.0) --
--  ZTBTRS solves a triangular system of the form

procedure TBTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	KD	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AB	 : Fortran_Complex_Star_16_Matrix;
	LDAB	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTBTRS;


--  LAPACK routine (version 2.0) --
--  ZTGEVC computes some or all of the right and/or left generalized
--  eigenvectors of a pair of complex upper triangular matrices (A,B).

procedure TGEVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTGEVC;


--  LAPACK routine (version 2.0) --
--  ZTGSJA computes the generalized singular value decomposition (GSVD)
--  of two complex upper triangular (or trapezoidal) matrices A and B.

procedure TGSJA (
	JOBU	 : Character;
	JOBV	 : Character;
	JOBQ	 : Character;
	M	 : Fortran_Integer;
	P	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	L	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	TOLA	 : Double_Precision;
	TOLB	 : Double_Precision;
	ALPHA	 : out Fortran_Double_Precision_Vector;
	BETA	 : out Fortran_Double_Precision_Vector;
	U	 : Fortran_Complex_Star_16_Matrix;
	LDU	 : Fortran_Integer;
	V	 : Fortran_Complex_Star_16_Matrix;
	LDV	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	NCYCLE	 : out Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTGSJA;


--  LAPACK routine (version 2.0) --
--  ZTPCON estimates the reciprocal of the condition number of a packed
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TPCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTPCON;


--  LAPACK routine (version 2.0) --
--  ZTPRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular packed
--  coefficient matrix.

procedure TPRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTPRFS;


--  LAPACK routine (version 2.0) --
--  ZTPTRI computes the inverse of a complex upper or lower triangular
--  matrix A stored in packed format.

procedure TPTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZTPTRI;


--  LAPACK routine (version 2.0) --
--  ZTPTRS solves a triangular system of the form

procedure TPTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTPTRS;


--  LAPACK routine (version 2.0) --
--  ZTRCON estimates the reciprocal of the condition number of a
--  triangular matrix A, in either the 1-norm or the infinity-norm.

procedure TRCON (
	NORM	 : Character;
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	RCOND	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTRCON;


--  LAPACK routine (version 2.0) --
--  ZTREVC computes some or all of the right and/or left eigenvectors of
--  a complex upper triangular matrix T.

procedure TREVC (
	SIDE	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTREVC;


--  LAPACK routine (version 2.0) --
--  ZTREXC reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that the diagonal element of T with row index IFST
--  is moved to row ILST.

procedure TREXC (
	COMPQ	 : Character;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	IFST	 : Fortran_Integer;
	ILST	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTREXC;


--  LAPACK routine (version 2.0) --
--  ZTRRFS provides error bounds and backward error estimates for the
--  solution to a system of linear equations with a triangular
--  coefficient matrix.

procedure TRRFS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	X	 : Fortran_Complex_Star_16_Matrix;
	LDX	 : Fortran_Integer;
	FERR	 : out Fortran_Double_Precision_Vector;
	BERR	 : out Fortran_Double_Precision_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTRRFS;


--  LAPACK routine (version 2.0) --
--  ZTRSEN reorders the Schur factorization of a complex matrix
--  A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in
--  the leading positions on the diagonal of the upper triangular matrix
--  T, and the leading columns of Q form an orthonormal basis of the
--  corresponding right invariant subspace.

procedure TRSEN (
	JOB	 : Character;
	COMPQ	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	Q	 : Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	W	 : out Fortran_Complex_Star_16_Vector;
	M	 : out Fortran_Integer;
	S	 : out Double_Precision;
	SEP	 : out Double_Precision;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTRSEN;


--  LAPACK routine (version 2.0) --
--  ZTRSNA estimates reciprocal condition numbers for specified
--  eigenvalues and/or right eigenvectors of a complex upper triangular
--  matrix T (or of any matrix Q*T*Q**H with Q unitary).

procedure TRSNA (
	JOB	 : Character;
	HOWMNY	 : Character;
	L_SELECT	 : Fortran_Logical_Vector;
	N	 : Fortran_Integer;
	T	 : Fortran_Complex_Star_16_Matrix;
	LDT	 : Fortran_Integer;
	VL	 : Fortran_Complex_Star_16_Matrix;
	LDVL	 : Fortran_Integer;
	VR	 : Fortran_Complex_Star_16_Matrix;
	LDVR	 : Fortran_Integer;
	S	 : out Fortran_Double_Precision_Vector;
	SEP	 : out Fortran_Double_Precision_Vector;
	MM	 : Fortran_Integer;
	M	 : out Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Matrix;
	LDWORK	 : Fortran_Integer;
	RWORK	 : in out Fortran_Double_Precision_Vector;
	INFO	 : out Fortran_Integer )
renames ZTRSNA;


--  LAPACK routine (version 2.0) --
--  ZTRSYL solves the complex Sylvester matrix equation:

procedure TRSYL (
	TRANA	 : Character;
	TRANB	 : Character;
	ISGN	 : Fortran_Integer;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	SCALE	 : out Double_Precision;
	INFO	 : out Fortran_Integer )
renames ZTRSYL;


--  LAPACK routine (version 2.0) --
--  ZTRTI2 computes the inverse of a complex upper or lower triangular
--  matrix.

procedure TRTI2 (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTRTI2;


--  LAPACK routine (version 2.0) --
--  ZTRTRI computes the inverse of a complex upper or lower triangular
--  matrix A.

procedure TRTRI (
	UPLO	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTRTRI;


--  LAPACK routine (version 2.0) --
--  ZTRTRS solves a triangular system of the form

procedure TRTRS (
	UPLO	 : Character;
	TRANS	 : Character;
	DIAG	 : Character;
	N	 : Fortran_Integer;
	NRHS	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	B	 : Fortran_Complex_Star_16_Matrix;
	LDB	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZTRTRS;


--  LAPACK routine (version 2.0) --
--  ZTZRQF reduces the M-by-N ( M<=N ) complex upper trapezoidal matrix A
--  to upper triangular form by means of unitary transformations.

procedure TZRQF (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZTZRQF;


--  LAPACK routine (version 2.0) --
--  ZUNG2L generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the last n columns of a product of k elementary
--  reflectors of order m

procedure UNG2L (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNG2L;


--  LAPACK routine (version 2.0) --
--  ZUNG2R generates an m by n complex matrix Q with orthonormal columns,
--  which is defined as the first n columns of a product of k elementary
--  reflectors of order m

procedure UNG2R (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNG2R;


--  LAPACK routine (version 2.0) --
--  ZUNGBR generates one of the complex unitary matrices Q or P**H
--  determined by ZGEBRD when reducing a complex matrix A to bidiagonal
--  form: A = Q * B * P**H.  Q and P**H are defined as products of
--  elementary reflectors H(i) or G(i) respectively.

procedure UNGBR (
	VECT	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGBR;


--  LAPACK routine (version 2.0) --
--  ZUNGHR generates a complex unitary matrix Q which is defined as the
--  product of IHI-ILO elementary reflectors of order N, as returned by
--  ZGEHRD:

procedure UNGHR (
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGHR;


--  LAPACK routine (version 2.0) --
--  ZUNGL2 generates an m-by-n complex matrix Q with orthonormal rows,
--  which is defined as the first m rows of a product of k elementary
--  reflectors of order n

procedure UNGL2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNGL2;


--  LAPACK routine (version 2.0) --
--  ZUNGLQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the first M rows of a product of K elementary
--  reflectors of order N

procedure UNGLQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGLQ;


--  LAPACK routine (version 2.0) --
--  ZUNGQL generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the last N columns of a product of K elementary
--  reflectors of order M

procedure UNGQL (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGQL;


--  LAPACK routine (version 2.0) --
--  ZUNGQR generates an M-by-N complex matrix Q with orthonormal columns,
--  which is defined as the first N columns of a product of K elementary
--  reflectors of order M

procedure UNGQR (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGQR;


--  LAPACK routine (version 2.0) --
--  ZUNGR2 generates an m by n complex matrix Q with orthonormal rows,
--  which is defined as the last m rows of a product of k elementary
--  reflectors of order n

procedure UNGR2 (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNGR2;


--  LAPACK routine (version 2.0) --
--  ZUNGRQ generates an M-by-N complex matrix Q with orthonormal rows,
--  which is defined as the last M rows of a product of K elementary
--  reflectors of order N

procedure UNGRQ (
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGRQ;


--  LAPACK routine (version 2.0) --
--  ZUNGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors of order N, as returned by
--  ZHETRD:

procedure UNGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNGTR;


--  LAPACK routine (version 2.0) --
--  ZUNM2L overwrites the general complex m-by-n matrix C with

procedure UNM2L (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNM2L;


--  LAPACK routine (version 2.0) --
--  ZUNM2R overwrites the general complex m-by-n matrix C with

procedure UNM2R (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNM2R;


--  LAPACK routine (version 2.0) --
--  If VECT = 'Q', ZUNMBR overwrites the general complex M-by-N matrix C
--  with
--                  SIDE = 'L'     SIDE = 'R'
--  TRANS = 'N':      Q * C          C * Q
--  TRANS = 'C':      Q**H * C       C * Q**H

procedure UNMBR (
	VECT	 : Character;
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMBR;


--  LAPACK routine (version 2.0) --
--  ZUNMHR overwrites the general complex M-by-N matrix C with

procedure UNMHR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	ILO	 : Fortran_Integer;
	IHI	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMHR;


--  LAPACK routine (version 2.0) --
--  ZUNML2 overwrites the general complex m-by-n matrix C with

procedure UNML2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNML2;


--  LAPACK routine (version 2.0) --
--  ZUNMLQ overwrites the general complex M-by-N matrix C with

procedure UNMLQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMLQ;


--  LAPACK routine (version 2.0) --
--  ZUNMQL overwrites the general complex M-by-N matrix C with

procedure UNMQL (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMQL;


--  LAPACK routine (version 2.0) --
--  ZUNMQR overwrites the general complex M-by-N matrix C with

procedure UNMQR (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMQR;


--  LAPACK routine (version 2.0) --
--  ZUNMR2 overwrites the general complex m-by-n matrix C with

procedure UNMR2 (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUNMR2;


--  LAPACK routine (version 2.0) --
--  ZUNMRQ overwrites the general complex M-by-N matrix C with

procedure UNMRQ (
	SIDE	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	K	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMRQ;


--  LAPACK routine (version 2.0) --
--  ZUNMTR overwrites the general complex M-by-N matrix C with

procedure UNMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	A	 : Fortran_Complex_Star_16_Matrix;
	LDA	 : Fortran_Integer;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	LWORK	 : Fortran_Integer;
	INFO	 : out Fortran_Integer )
renames ZUNMTR;


--  LAPACK routine (version 2.0) --
--  ZUPGTR generates a complex unitary matrix Q which is defined as the
--  product of n-1 elementary reflectors H(i) of order n, as returned by
--  ZHPTRD using packed storage:

procedure UPGTR (
	UPLO	 : Character;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	TAU	 : Fortran_Complex_Star_16_Vector;
	Q	 : out Fortran_Complex_Star_16_Matrix;
	LDQ	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUPGTR;


--  LAPACK routine (version 2.0) --
--  ZUPMTR overwrites the general complex M-by-N matrix C with

procedure UPMTR (
	SIDE	 : Character;
	UPLO	 : Character;
	TRANS	 : Character;
	M	 : Fortran_Integer;
	N	 : Fortran_Integer;
	AP	 : Fortran_Complex_Star_16_Vector;
	TAU	 : Fortran_Complex_Star_16_Vector;
	C	 : Fortran_Complex_Star_16_Matrix;
	LDC	 : Fortran_Integer;
	WORK	 : in out Fortran_Complex_Star_16_Vector;
	INFO	 : out Fortran_Integer )
renames ZUPMTR;


end lacmp1;
