(* ::Package:: *)

(* ShowSteps controls both the use of special definitions when defining rules AND the display of
	steps when simplify expressions. *) 
ShowSteps=True;
SimplifyFlag=True;


(* If func is a function defined using properly defined transformation rules,
   StepFunction[func] modifies the rules to display steps when the control
   variable ShowSteps is True. *)
StepFunction[func_] :=
  StepFunction[func,func];

StepFunction[func1_,func2_] :=
    Block[{lst,ShowStep,SimplifyFlag},
  lst=Map[Function[ModifyRule[#, SimplifyFlag]],DownValues[func1]];
  ClearDownValues[func1];
  SetDownValues[func2,ReplaceAll[lst,{func1->func2}]]]


ModifyRule[rule_RuleDelayed, flag_] :=
    Module[{lhsStrg,rhsStrg,condStrg,letStrg},
  If[Not[FreeQ[Defer[rule],ShowStep]] || Not[FreeQ[Defer[rule],Preprocess]],
    rule,
  lhsStrg=FormatLhs[rule];
  If[rule[[2,0]]===Condition,
    condStrg=FormatConditions[Extract[rule,{2,2},Defer]];
    If[rule[[2,1,0]]===Module || rule[[2,1,0]]===Block,
      letStrg=FormatLets[Extract[rule,{2,1,1},Defer]];
      If[rule[[2,1,2,0]]===Condition,
        condStrg=SpliceConditionString[condStrg,letStrg,FormatConditions[Extract[rule,{2,1,2,2},Defer]]];
		rhsStrg=FormatRhs[Extract[rule,{2,1,2,1},Defer]];
        ReplacePart[rule, ShowStep[condStrg,lhsStrg,rhsStrg,Extract[rule,{2,1,2,1},Hold]] /; flag,
			{2,1,2,1}],
      condStrg=SpliceConditionString[condStrg,letStrg,""];
	  rhsStrg=FormatRhs[Extract[rule,{2,1,2},Defer]];
      ReplacePart[rule, ShowStep[condStrg,lhsStrg,rhsStrg,Extract[rule,{2,1,2},Hold]] /; flag, {2,1,2}]],
    condStrg=SpliceConditionString[condStrg,"",""];
	rhsStrg=FormatRhs[Extract[rule,{2,1},Defer]];
    ReplacePart[rule, ShowStep[condStrg,lhsStrg,rhsStrg,Extract[rule,{2,1},Hold]] /; flag, {2,1}]],
  If[rule[[2,0]]===Module || rule[[2,0]]===Block,
    letStrg=FormatLets[Extract[rule,{2,1},Defer]];
    If[rule[[2,2,0]]===Condition,
      condStrg=FormatConditions[Extract[rule,{2,2,2},Defer]];
      condStrg=SpliceConditionString["",letStrg,condStrg];
	  rhsStrg=FormatRhs[Extract[rule,{2,2,1},Defer]];
      ReplacePart[rule, ShowStep[condStrg,lhsStrg,rhsStrg,Extract[rule,{2,2,1},Hold]] /; flag, {2,2,1}],
    condStrg=SpliceConditionString["",letStrg,""];
	rhsStrg=FormatRhs[Extract[rule,{2,2},Defer]];
    ReplacePart[rule, ShowStep[condStrg,lhsStrg,rhsStrg,Extract[rule,{2,2},Hold]] /; flag, {2,2}]],
  rhsStrg=FormatRhs[Extract[rule,2,Defer]];
  ReplacePart[rule, ShowStep["",lhsStrg,rhsStrg,Extract[rule,2,Hold]] /; flag, 2]]]]]


FormatConditions[conditions_] :=
  If[conditions[[1,0]]===Not && conditions[[1,1,0]]===FalseQ,
    FormatConditions[Extract[conditions,{1,1,1},Defer]],
  If[conditions[[1,0]]===FreeQ,
    "",
  If[conditions[[1,0]]===And && MemberQ[conditions,FreeQ,{3},Heads->True],
    FormatConditions[DeleteCondition[FreeQ,conditions]],
  If[conditions[[1,0]]===FunctionOfQ,
    "",
  If[conditions[[1,0]]===And && MemberQ[conditions,FunctionOfQ,{3},Heads->True],
    FormatConditions[DeleteCondition[FunctionOfQ,conditions]],
  If[conditions[[1,0]]===EasyDQ,
    "",
  If[conditions[[1,0]]===And && MemberQ[conditions,EasyDQ,{3},Heads->True],
    FormatConditions[DeleteCondition[EasyDQ,conditions]],
  ToConditionString[conditions] <> ","]]]]]]]

DeleteCondition[func_,conditions_] :=
  If[Quiet[Head[Extract[conditions,{1,3},Defer]]===Extract],
    If[Position[conditions,func,{3},1][[1,2]]==1,
      Extract[conditions,{1,2},Defer],
    Extract[conditions,{1,1},Defer]],
  Delete[conditions,{1,Position[conditions,func,{3},1][[1,2]]}]] 


FormatLets[let_] :=
  If[MatchQ[let,Defer[{u_}]],
    If[let[[1,1,0]]===Set &&
		  let[[1,1,2,0]]===Block &&
		  Extract[let,{1,1,2,1},Defer]===Defer[{ShowSteps=False}],
      If[let[[1,1,2,2,0]]===Simplify,
        ToConditionString[Extract[let,{1,1,1},Defer]] <> "=" <>
        ToConditionString[Extract[let,{1,1,2,2,1},Defer]] <> ", then",
      ToConditionString[Extract[let,{1,1,1},Defer]] <> "=" <>
      ToConditionString[Extract[let,{1,1,2,2},Defer]] <> ", then"],
    ToConditionString[Extract[let,{1,1},Defer]] <> ", then"],
  ToConditionString[let] <> ", then"]


FormatLhs[rule_] :=
  Module[{lhs=Extract[rule,{1,1},Defer],conditions,func,var},
  ( If[rule[[2,0]]===Condition,
	  conditions=Extract[rule,{2,2},Defer];
	  If[conditions[[1,0]]===FunctionOfQ,
	    func=conditions[[1,1]];
	    var=conditions[[1,2]];
        lhs=ReplaceVariable[lhs,var,func],
	  If[conditions[[1,0]]===And && MemberQ[conditions,FunctionOfQ,{3},Heads->True],
	    func=conditions[[1,Position[conditions,FunctionOfQ,{3},1][[1,2]],1]];
	    var=conditions[[1,Position[conditions,FunctionOfQ,{3},1][[1,2]],2]];
        lhs=ReplaceVariable[lhs,var,func]]]] );
  DropDefer[StringReplace[ToString[lhs, InputForm],{"_Symbol"->"", "_."->"", "_"->""}]]]

ReplaceVariable[lhs_,var_,func_] :=
  Block[{f},
  If[PatternEqualQ[lhs[[1,1]],var],
    ReplacePart[lhs,f[func],{1,1}],
  If[PatternEqualQ[lhs[[1,1,1]],var],
    ReplacePart[lhs,f[func],{1,1,1}],
  If[PatternEqualQ[lhs[[1,1,2]],var],
    ReplacePart[lhs,f[func],{1,1,2}],
  Print["Function of expression variable not found: ",lhs," ",var," ",func];
  Abort[]]]]]

PatternEqualQ[pattern_,var_] :=
  Head[pattern]===Pattern && pattern[[1]]===var


FormatRhs[rhs_] :=
  Block[{SubstFor,Rt,f},
  DropDefer[ToString[rhs /. {
		SubstFor[v_,u_,x_] -> f[x],
		Rt[u_,2] -> Sqrt[u],
		Rt[u_,n_] -> u^(1/n)
  }, InputForm]]]


DropDefer[strg_] :=
  StringDrop[StringDrop[strg,6],-1]


ToConditionString[conditions_] :=
  ToString[conditions /. {
	Not->not,
    SameQ->Equal,
    IndependentQ->independent,
    DependentQ->dependent,
    HalfIntegerQ->half\[Dash]integer,
    IntegerQ->integer,
    EvenQ->even,
    OddQ->odd,
    ZeroQ->zero,
	NonzeroQ->nonzero,
    FractionQ->fraction,
    RationalQ->real\[Dash]number,
    RealQ->real,
    PolynomialQ->polynomial,
    Numerator->numerator,
    Denominator->denominator,
    Exponent->exponent,
    RationalFunctionQ->rational\[Dash]function,
    SumQ->sum,
    NonsumQ->nonsum,
    PosQ->positive\[Dash]form,
    NegQ->negative\[Dash]form,
    FalseQ->false,
    NormalizeExpn->normalize,
	Expand->expand,
    Apart->partial\[Dash]fraction\[Dash]expansion,
(*  Not[FalseQ[u_]]->u, *)
    Rt[u_,2]->Sqrt[u],
    Rt[u_,n_]->u^(1/n)
      },StandardForm]


SpliceConditionString[cond1_,lets_,cond2_] :=
  If[cond2==="",
    If[lets==="",
      If[cond1==="",
        "",
      "If " <> cond1],
    If[cond1==="",
      "Let " <> lets,
    "If " <> cond1 <> " let " <> lets]],
  If[lets==="",
    If[cond1==="",
      "If " <> cond2,
    "If " <> cond1 <> " if " <> cond2],
  If[cond1==="",
    "Let " <> lets <> " if " <> cond2,
  "If " <> cond1 <> " let " <> lets <> " if " <> cond2]]]  


ShowStep[condStrg_,lhsStrg_,rhsStrg_,rhs_] :=
  If[ShowSteps,
    Print["Rule: ",condStrg];
    Print["  ",ToExpression["Defer["<>lhsStrg<>"]"]," \[LongRightArrow] ",ToExpression["Defer["<>rhsStrg<>"]"]];
    Block[{SimplifyFlag=False},
    ReleaseHold[rhs]],
  ReleaseHold[rhs]]
