(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    104021,       3465]
NotebookOptionsPosition[     96995,       3247]
NotebookOutlinePosition[     97336,       3262]
CellTagsIndexPosition[     97293,       3259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "assignment", " ", "designates", " ", "the", " ", 
    "integration", " ", "function", " ", 
    RowBox[{"(", 
     RowBox[{"Int", " ", "or", " ", "Integrate"}], ")"}], " ", "to", " ", 
    "be", " ", 
    RowBox[{"tested", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"IntegrationFunction", "=", "Integrate"}], ";"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"IntegrationFunction", "=", "Int"}], ";"}]}]], "Code"],

Cell[CellGroupData[{

Cell["Integration test program", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"IntegrationFunction", "===", "Int"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"ShowSteps", "=", "False"}], ";", "\n", "  ", 
     RowBox[{
     "Get", "[", 
      "\"\<C:\\\\RuleBasedIntegrator\\\\IndefiniteIntegrationRules.m\>\"", 
      "]"}], ";", "\n", "  ", 
     RowBox[{"MoveDownValues", "[", 
      RowBox[{"Integrate", ",", "Int"}], "]"}]}]}], "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IntegrationTest", "[", "fileName_", "]"}], ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"func", "=", "IntegrationFunction"}], ",", " ", 
       RowBox[{"deficiencyList", "=", 
        RowBox[{"{", "}"}]}], ",", " ", 
       RowBox[{"computeTime", "=", "0"}], ",", " ", "\n", "\t\t", 
       RowBox[{"timeouts", "=", "0"}], ",", " ", 
       RowBox[{"unintegrables", "=", "0"}], ",", " ", 
       RowBox[{"nonidenticals", "=", "0"}], ",", " ", 
       RowBox[{"incorrects", "=", "0"}], ",", " ", 
       RowBox[{"corrects", "=", "0"}], ",", "\n", "\t\t", "result", ",", " ", 
       "time", ",", " ", "tmp", ",", " ", "lst"}], "}"}], ",", "\n", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<Testing integration problems in \>\"", ",", "fileName", ",", 
         "\"\<IntegrationProblems.m\>\""}], "]"}], ";"}], " ", "*)"}], "\n", 
     "  ", 
     RowBox[{
      RowBox[{"lst", "=", 
       RowBox[{"Get", "[", 
        RowBox[{
        "\"\<C:\\\\RuleBasedIntegrator\\\\ProblemFiles\\\\\>\"", "<>", 
         RowBox[{"ToString", "[", "fileName", "]"}], "<>", "\"\<.m\>\""}], 
        "]"}]}], ";", "\n", "  ", 
      RowBox[{"ClearSystemCache", "[", "]"}], ";", "\n", "  ", 
      RowBox[{"Monitor", "[", "\n", "  ", 
       RowBox[{
        RowBox[{"Do", "[", "\n", "\t", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ";"}], " ", "*)"}], "\n", 
         "    ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"time", ",", "result"}], "}"}], "=", 
            RowBox[{"{", 
             RowBox[{"0.01", ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
           "    ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"time", ",", "result"}], "}"}], "=", 
            RowBox[{"TimeConstrained", "[", 
             RowBox[{
              RowBox[{"Timing", "[", 
               RowBox[{"func", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], "]"}], ",",
               "10", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "\"\<Timed out\>\""}], "}"}]}], "]"}]}], ";",
            "\n", "\t", 
           RowBox[{"result", "=", 
            RowBox[{"Simplify", "[", "result", "]"}]}], ";", "\n", "\t", 
           RowBox[{"computeTime", "=", 
            RowBox[{"computeTime", " ", "+", " ", "time"}]}], ";", "\n", "\n",
            "\t", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"result", "===", "\"\<Timed out\>\""}], ",", "\n", 
             "\t  ", 
             RowBox[{
              RowBox[{"timeouts", "++"}], ";", "\n", "      ", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"deficiencyList", ",", 
                RowBox[{"{", "\n", "\t    ", 
                 RowBox[{"\"\<Timed out after 10 seconds:\>\"", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
                  
                  RowBox[{"lst", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", " ", 
                  "\"\<???\>\""}], "}"}]}], "]"}]}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Not", "[", 
                RowBox[{"FreeQ", "[", 
                 RowBox[{"result", ",", "func"}], "]"}], "]"}], ",", "\n", 
               "\t  ", 
               RowBox[{
                RowBox[{"unintegrables", "++"}], ";", "\n", "      ", 
                RowBox[{"AppendTo", "[", 
                 RowBox[{"deficiencyList", ",", 
                  RowBox[{"{", "\n", "\t    ", 
                   RowBox[{"\"\<Unable to integrate:\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
                    
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", " ", 
                    "result"}], "}"}]}], "]"}]}], ",", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"Not", "[", 
                  RowBox[{
                   RowBox[{"FreeQ", "[", 
                    RowBox[{"result", ",", "Hypergeometric1F1"}], "]"}], " ", 
                   "&&", " ", 
                   RowBox[{"FreeQ", "[", 
                    RowBox[{"result", ",", "Hypergeometric2F1"}], "]"}], " ", 
                   "&&", "\n", "\t\t\t", 
                   RowBox[{"FreeQ", "[", 
                    RowBox[{"result", ",", "AppellF1"}], "]"}]}], "]"}], ",", 
                 "\n", "\t  ", 
                 RowBox[{
                  RowBox[{"nonidenticals", "++"}], ";", "\n", "      ", 
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"deficiencyList", ",", 
                    RowBox[{"{", "\n", "\t    ", 
                    RowBox[{
                    "\"\<Valid but unnecessarily complicated \
antiderivative:\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
                    
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", " ", 
                    "result"}], "}"}]}], "]"}]}], ",", "\n", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "Compare", " ", "derivative", " ", "of", " ", "result", " ",
                    "with", " ", "integrand"}], " ", "*)"}], "\n", 
                 RowBox[{"(*", "  ", 
                  RowBox[{
                   RowBox[{"tmp", "=", 
                    RowBox[{"D", "[", 
                    RowBox[{"result", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
                   "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TimeConstrained", "[", 
                    RowBox[{
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], 
                    ",", "5", ",", "False"}], "]"}], " ", "||", "\n", "\t\t", 
                    
                    RowBox[{"TimeConstrained", "[", 
                    RowBox[{
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{
                    RowBox[{"FullSimplify", "[", "tmp", "]"}], "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], 
                    ",", "5", ",", "False"}], "]"}]}], ","}], " "}]}], "*)"}],
                  "\n", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "Compare", " ", "result", " ", "with", " ", "desired", " ", 
                   "result"}], " ", "*)"}], "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"result", "===", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "\n", "\t\t", "||",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], ">=", "4"}], " ", "&&",
                     " ", 
                    RowBox[{"result", "===", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}]}]}], "\n", "    \t",
                     "||", " ", 
                    RowBox[{
                    RowBox[{"func", "===", "Integrate"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"LeafCount", "[", "result", "]"}], "<=", 
                    RowBox[{
                    RowBox[{"LeafCount", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}], "+", 
                    "6"}]}]}]}], ",", "\n", 
                   RowBox[{"(*", "      ", 
                    RowBox[{"||", " ", 
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"Simplify", "[", 
                    RowBox[{"result", "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], "]"}]}], 
                    " ", "*)"}], "\n", 
                   RowBox[{"(*", "\t  ", 
                    RowBox[{"||", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}], ">=", "4"}], " ", "&&",
                     " ", 
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"Simplify", "[", 
                    RowBox[{"result", "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}]}], "]"}], "]"}]}]}],
                     " ", "*)"}], "\n", 
                   RowBox[{"(*", "      ", 
                    RowBox[{
                    RowBox[{"||", " ", 
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"Simplify", "[", 
                    RowBox[{"D", "[", 
                    RowBox[{
                    RowBox[{"result", "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], "]"}], 
                    "]"}]}], ","}], " ", "*)"}], "\n", "\t  ", 
                   RowBox[{"corrects", "++"}], ",", "\n", "    ", 
                   RowBox[{
                    RowBox[{"tmp", "=", 
                    RowBox[{"D", "[", 
                    RowBox[{"result", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TimeConstrained", "[", 
                    RowBox[{
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], 
                    ",", "5", ",", "False"}], "]"}], " ", "||", "\n", "\t\t", 
                    
                    RowBox[{"TimeConstrained", "[", 
                    RowBox[{
                    RowBox[{"PossibleZeroQ", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{
                    RowBox[{"FullSimplify", "[", "tmp", "]"}], "-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], 
                    ",", "5", ",", "False"}], "]"}]}], ",", "\n", "\t  ", 
                    RowBox[{
                    RowBox[{"nonidenticals", "++"}], ";", "\n", "      ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"deficiencyList", ",", 
                    RowBox[{"{", "\n", "\t    ", 
                    RowBox[{
                    "\"\<Valid but unnecessarily complicated \
antiderivative:\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
                    
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", " ", 
                    "result"}], "}"}]}], "]"}]}], ",", "\n", "\t", 
                    RowBox[{
                    RowBox[{"incorrects", "++"}], ";", "\n", "    ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"deficiencyList", ",", 
                    RowBox[{"{", "\n", "        ", 
                    RowBox[{"\"\<Incorrect result:\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
                    
                    RowBox[{"lst", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", " ", 
                    "result"}], "}"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ",", "\n", "\n", "\t", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ",", "\n", 
        "  ", 
        RowBox[{"ProgressIndicator", "[", 
         RowBox[{"i", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}]}], "]"}], 
      ";", "\n", "  ", 
      RowBox[{"tmp", "=", 
       RowBox[{"ToString", "[", "fileName", "]"}]}], ";", "\n", "  ", 
      RowBox[{"tmp", "=", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"tmp", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<Functions\>\"", "->", "\"\<\>\""}], ",", 
           RowBox[{"\"\<Problems\>\"", "->", "\"\<\>\""}]}], "}"}]}], "]"}]}],
       ";", "\n", "  ", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"testStatistics", ",", " ", 
        RowBox[{"{", 
         RowBox[{
         "tmp", ",", "\n", "\t\t", "corrects", ",", "nonidenticals", ",", 
          "unintegrables", ",", "timeouts", ",", "incorrects", ",", 
          RowBox[{"Length", "[", "lst", "]"}], ",", "computeTime"}], "}"}]}], 
       "]"}], ";", "\n", "  ", 
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{"Print", ",", "#"}], "]"}], ";", 
          RowBox[{"Print", "[", "]"}]}], "]"}], ",", "deficiencyList"}], 
       "]"}]}]}], "]"}]}], ";"}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"testStatistics", "=", 
    RowBox[{"{", "}"}]}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintTestStatistics", "[", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", "testStatistics"}], ",", "total", ",", 
       "percentages"}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"lst", "=", 
       RowBox[{"Transpose", "[", "lst", "]"}]}], ";", "\n", "  ", 
      RowBox[{"lst", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Append", "[", 
           RowBox[{
            RowBox[{"First", "[", "lst", "]"}], ",", "\"\<TOTALS\>\""}], 
           "]"}], "}"}], ",", " ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"Append", "[", 
             RowBox[{"#", ",", 
              RowBox[{"Apply", "[", 
               RowBox[{"Plus", ",", "#"}], "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"Rest", "[", "lst", "]"}]}], "]"}]}], "]"}]}], ";", "\n", 
      "  ", 
      RowBox[{"lst", "=", 
       RowBox[{"Append", "[", 
        RowBox[{
         RowBox[{"Most", "[", "lst", "]"}], ",", 
         RowBox[{"Map2", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"N", "[", 
               RowBox[{"#1", "/", "#2"}], "]"}], ",", "3"}], "]"}], "]"}], 
           ",", 
           RowBox[{"Part", "[", 
            RowBox[{"lst", ",", 
             RowBox[{"-", "2"}]}], "]"}], ",", 
           RowBox[{"Part", "[", 
            RowBox[{"lst", ",", 
             RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}]}], ";", "\n", "  ",
       
      RowBox[{"lst", "=", 
       RowBox[{"Transpose", "[", "lst", "]"}]}], ";", "\n", "  ", 
      RowBox[{"total", "=", 
       RowBox[{
        RowBox[{"Last", "[", "lst", "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"-", "2"}], "]"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"percentages", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"#", "/", "total"}], "]"}], ",", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"Rest", "[", 
            RowBox[{"Last", "[", "lst", "]"}], "]"}], ",", 
           RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"percentages", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"N", "[", 
               RowBox[{"100", "*", "#"}], "]"}], ",", "3"}], "]"}], "]"}], 
           "<>", "\"\<%\>\""}], "]"}], ",", "percentages"}], "]"}]}], ";", 
      "\n", "  ", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"lst", ",", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", "\"\<PERCENTAGES\>\"", "}"}], ",", "percentages", ",", 
          
          RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}], "]"}], ";", "\n", "  ", 
      RowBox[{"lst", "=", 
       RowBox[{"Quiet", "[", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"Map", "[", 
            RowBox[{"ToString", ",", "#"}], "]"}], "]"}], ",", "lst"}], "]"}],
         "]"}]}], ";", "\n", "  ", 
      RowBox[{"PrependTo", "[", 
       RowBox[{"lst", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<File\>\"", ",", "\"\<Optimal\>\"", ",", "\"\<Nonidentical\>\"", 
          ",", "\"\<Nonintegrable\>\"", ",", "\"\<Timeouts\>\"", ",", "\n", 
          "\t\t\t", "\"\<Incorrect\>\"", ",", "\"\<Total\>\"", ",", 
          "\"\<Integrals/sec\>\""}], "}"}]}], "]"}], ";", "\n", "  ", 
      RowBox[{"lst", "=", 
       RowBox[{"Transpose", "[", "lst", "]"}]}], ";", "\n", "  ", 
      RowBox[{"Print", "[", "]"}], ";", "\n", "  ", 
      RowBox[{
      "Print", "[", 
       "\"\<               * * *  Indefinite Integration Test Suite Results  \
* * *\>\"", "]"}], ";", "\n", "  ", 
      RowBox[{"Print", "[", "]"}], ";", "\n", "  ", 
      RowBox[{"(", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"IntegrationFunction", "===", "Integrate"}], ",", "\n", 
         "      ", 
         RowBox[{
         "Print", "[", 
          "\"\< Integration function:  Mathematica's built-in Integrate \
function\>\"", "]"}], ",", "\n", "    ", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\< Integration function:  \>\"", ",", " ", 
           RowBox[{"Length", "[", 
            RowBox[{"DownValues", "[", "Int", "]"}], "]"}], ",", " ", 
           "\"\< user-defined transformation rules\>\""}], "]"}]}], "]"}], 
       " ", ")"}], ";", "\n", "  ", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Time and date of test:  \>\"", ",", 
        RowBox[{"DateString", "[", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Hour24\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\"", ",", 
           "\"\<  \>\"", ",", "\"\<Day\>\"", ",", "\"\< \>\"", ",", 
           "\"\<MonthName\>\"", ",", "\"\< 2008\>\""}], "}"}], "]"}]}], "]"}],
       ";", "\n", "  ", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<  Mathematica version:  \>\"", ",", "$Version"}], "]"}], 
      ";", "\n", "  ", 
      RowBox[{"Print", "[", "]"}], ";", "\n", "  ", 
      RowBox[{"Apply", "[", 
       RowBox[{"Print", ",", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"Column", "[", 
            RowBox[{"#", ",", "Center", ",", "1"}], "]"}], "]"}], ",", 
          "lst"}], "]"}]}], "]"}]}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Map2", "[", 
   RowBox[{"func_", ",", "lst1_", ",", "lst2_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Sow", "[", 
       RowBox[{"func", "[", 
        RowBox[{
         RowBox[{"lst1", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"lst2", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "lst1", "]"}]}], "}"}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Test integration problem files", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "PolynomialFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "RationalFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.4322719707381344`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "5"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x", "+", 
        SuperscriptBox["x", "4"]}], ")"}], "3"]], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"3", " ", "x"}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        SuperscriptBox["x", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "6"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x", "+", 
        SuperscriptBox["x", "4"]}], ")"}], "4"]]}], ",", "x"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.432271970778192*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "-", 
   RowBox[{"3", " ", "x"}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "4"], "-", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "6"]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x", "+", 
     SuperscriptBox["x", "4"]}], ")"}], "3"]]], "Print",
 CellChangeTimes->{3.4322719708382783`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["7", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x", "+", 
       SuperscriptBox["x", "4"]}], ")"}], "3"]}]], "-", 
  FractionBox[
   RowBox[{"63", " ", "x"}], 
   RowBox[{"22", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x", "+", 
       SuperscriptBox["x", "4"]}], ")"}], "3"]}]], "-", 
  FractionBox[
   RowBox[{"12", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x", "+", 
      SuperscriptBox["x", "4"]}], ")"}], "3"]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "3"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x", "+", 
      SuperscriptBox["x", "4"]}], ")"}], "3"]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "4"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x", "+", 
       SuperscriptBox["x", "4"]}], ")"}], "3"]}]], "-", 
  FractionBox[
   RowBox[{"10", " ", 
    SuperscriptBox["x", "6"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x", "+", 
      SuperscriptBox["x", "4"]}], ")"}], "3"]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x", "+", 
       SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x", "+", 
      SuperscriptBox["x", "4"]}], ")"}], "2"]], "+", 
  RowBox[{
   FractionBox["144", "11"], " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", "x", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "4"]], ",", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["828", "11"], " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", "x", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "4"]], ",", "x"}], "]"}]}], "+", 
  RowBox[{"18", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", "x", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "4"]], ",", "x"}], "]"}]}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", "x", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "3"]], ",", "x"}], "]"}]}], "-", 
  RowBox[{"20", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", "x", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "3"]], ",", "x"}], 
    "]"}]}]}]], "Print",
 CellChangeTimes->{3.4322719708883505`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432271970938422*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "AlgebraicFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322719820644207`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"], "+", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322719820944643`*^9}],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"ArcSin", "[", "x", "]"}]}]], "Print",
 CellChangeTimes->{3.4322719821545506`*^9}],

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "x"], "]"}]}]}]], "Print",
 CellChangeTimes->{3.432271982214637*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322719822647085`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "ExponentialFunctions", "]"}], 
  ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "LogarithmFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432271986941434*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", "x", "]"}]}]}], ")"}], "2"]], ",", "x"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4322719869714766`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["a", "b"]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      FractionBox["a", "b"], "+", 
      RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"b", " ", "x"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Log", "[", "x", "]"}]}]}]]}], 
  SuperscriptBox["b", "2"]]], "Print",
 CellChangeTimes->{3.4322719870315633`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", "x", "]"}]}]}], ")"}], "2"]], ",", "x"}], 
  "]"}]], "Print",
 CellChangeTimes->{3.4322719870816355`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432271987131707*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432271987181779*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", 
      SuperscriptBox["x", "2"]}], "]"}], "2"], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432271987231851*^9}],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"8", " ", "x"}], "-", 
  SuperscriptBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], "]"}]}], ")"}]}], "-", 
  RowBox[{"4", " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], "]"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", "x"}]}], "]"}]}]}]], "Print",
 CellChangeTimes->{3.432271987291938*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"8", "-", 
     RowBox[{"4", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], "]"}], "2"]}], ")"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}], "]"}], "x"], 
       ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{"1", "+", "x"}]}], "]"}]}]}]], "Print",
 CellChangeTimes->{3.4322719873420095`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322719873920813`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "TrigFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322720066698017`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272006699845*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "2"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], "2"]], "]"}]}]}]], "Print",\

 CellChangeTimes->{3.432272006749917*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"6", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "-", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"], "]"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"], "-", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.4322720068100033`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272006860075*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272006910147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"3", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}]]}]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322720069602194`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}], 
  SqrtBox[
   RowBox[{"Cos", "[", "x", "]"}]]]], "Print",
 CellChangeTimes->{3.4322720070203056`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sec", "[", 
        FractionBox["x", "2"], "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          FractionBox["1", 
           RowBox[{
            SqrtBox[
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "x"}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["x", "2"]}]}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["x", "2"]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"Tan", "[", 
         FractionBox["x", "2"], "]"}]}], "]"}], "+", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          FractionBox[
           SuperscriptBox["x", "2"], 
           RowBox[{
            SqrtBox[
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "x"}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["x", "2"]}]}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["x", "2"]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"Tan", "[", 
         FractionBox["x", "2"], "]"}]}], "]"}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox[
     RowBox[{"Cos", "[", "x", "]"}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sec", "[", 
        FractionBox["x", "2"], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]]}], ")"}]}]], "Print",
 CellChangeTimes->{3.432272007080392*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272007160507*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272007230608*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Csc", "[", "x", "]"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}]]}], 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"3", "/", "2"}]]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322720073107233`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"Cos", "[", "x", "]"}]]}], "+", 
     SqrtBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}]]}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]]}], 
   SqrtBox[
    RowBox[{"Cos", "[", "x", "]"}]]]}]], "Print",
 CellChangeTimes->{3.432272007380824*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sec", "[", 
        FractionBox["x", "2"], "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          FractionBox[
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "x"}], "-", 
             SuperscriptBox["x", "2"]}]], 
           RowBox[{"x", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["x", "2"]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"Tan", "[", 
         FractionBox["x", "2"], "]"}]}], "]"}], "+", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{"1", "+", 
              RowBox[{"2", " ", "x"}], "-", 
              SuperscriptBox["x", "2"]}]]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], ")"}], 
            RowBox[{"3", "/", "2"}]]], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"Tan", "[", 
         FractionBox["x", "2"], "]"}]}], "]"}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox[
     RowBox[{"Cos", "[", "x", "]"}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sec", "[", 
        FractionBox["x", "2"], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]]}], ")"}]}]], "Print",
 CellChangeTimes->{3.432272007470954*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322720075610833`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "InverseTrigFunctions", "]"}], 
  ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322720104852877`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "x"], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322720105353603`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], 
         RowBox[{"\[ImaginaryI]", "+", "a"}]], "]"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"b", " ", "x"}], 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", "a"}]]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}]}], ")"}]}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "x"}], 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "a"}]]}]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "x"}], 
        RowBox[{"\[ImaginaryI]", "+", "a"}]]}]}], "]"}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.4322720106254897`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", "a"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "a", "+", 
        RowBox[{"b", " ", "x"}]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}]}], "-", 
    RowBox[{
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", "+", "a", "+", 
        RowBox[{"b", " ", "x"}]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}]}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox["\[ImaginaryI]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox["\[ImaginaryI]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.4322720107056046`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322720107757053`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "HyperbolicFunctions", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "InverseHyperbolicFunctions", "]"}], 
  ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322720197986803`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "x"], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272019828723*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}]], "]"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"1", "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], 
         RowBox[{"1", "+", "a"}]], "]"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["1", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}]}], ")"}]}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"b", " ", "x"}], 
       RowBox[{"1", "-", "a"}]]}], "]"}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "x"}], 
        RowBox[{"1", "+", "a"}]]}]}], "]"}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.432272019878795*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Log", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"b", " ", "x"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}]}], " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "a", "+", 
        RowBox[{"b", " ", "x"}]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}]}], "+", 
    RowBox[{
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"b", " ", "x"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"1", "+", "a", "+", 
        RowBox[{"b", " ", "x"}]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}]}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox["1", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], "]"}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.432272019938882*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272019998968*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "SpecialFunctions", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "SimpleProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "FitzpatrickProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "MITProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "HughesHallettProblems", "]"}], 
  ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "EdwardsPenneyProblems", "]"}], 
  ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "StewartProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "GrossmanProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "AyersProblems", "]"}], ";"}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "HowardAntonProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "InternetProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272090450272*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272090480315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      FractionBox["x", "2"], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], "]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"Tan", "[", 
    FractionBox["x", "2"], "]"}], "]"}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      FractionBox["x", "2"], "]"}], "2"], " ", 
    RowBox[{"Tan", "[", 
     FractionBox["x", "2"], "]"}]}], "]"}]}]], "Print",
 CellChangeTimes->{3.4322720905103583`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]], ",", "x"}], "]"}], "+", 
  RowBox[{"Int", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]}]], "Print",
 CellChangeTimes->{3.432272090530387*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272090580459*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "NorthTexasProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272093054016*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"Csc", "[", "x", "]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"Sec", "[", "x", "]"}], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}]}], ",", "x"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4322720930840592`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"x", "-", 
     RowBox[{"2", " ", 
      RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}]}], 
  SqrtBox[
   RowBox[{"Csc", "[", "x", "]"}]]]], "Print",
 CellChangeTimes->{3.4322720931341314`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SqrtBox[
      RowBox[{"Csc", "[", "x", "]"}]]}], ",", "x"}], "]"}], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sec", "[", "x", "]"}], "+", 
      FractionBox[
       RowBox[{"EllipticE", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"\[Pi]", "-", 
            RowBox[{"2", " ", "x"}]}], ")"}]}], ",", "2"}], "]"}], 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"3", "/", "2"}]]]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"Csc", "[", "x", "]"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Print",
 CellChangeTimes->{3.4322720931942177`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272093254304*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "SpivakProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.4322720960583363`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"Sin", "[", "x", "]"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "3"]}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322720960583363`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"Sin", "[", "x", "]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}]}], ")"}], " ", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Print",
 CellChangeTimes->{3.432272096128437*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"Sin", "[", "x", "]"}]], " ", "x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], ",", "x"}], "]"}], "-", 
  RowBox[{"Subst", "[", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "x"}], 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}]]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]], ",", "x"}], "]"}], 
    ",", "x", ",", 
    RowBox[{"Tan", "[", 
     FractionBox["x", "2"], "]"}]}], "]"}], "+", 
  RowBox[{"Subst", "[", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "x"}], 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}]]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], "2"]], ",", "x"}], "]"}], ",", "x", 
    ",", 
    RowBox[{"Tan", "[", 
     FractionBox["x", "2"], "]"}]}], "]"}]}]], "Print",
 CellChangeTimes->{3.4322720961885233`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322720962486095`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "ThomasProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322721116207137`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"a", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272111650757*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["2"]}], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}]]], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    RowBox[{"Cos", "[", "x", "]"}]}]], " ", 
  RowBox[{"Csc", "[", 
   FractionBox["x", "2"], "]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}]}], "+", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]]}], "]"}]}]], "Print",
 CellChangeTimes->{3.432272111710843*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"Cos", "[", "x", "]"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         FractionBox["x", "2"], "]"}], "2"]}]], 
     SqrtBox["2"]], "]"}], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]]], " ", 
   RowBox[{"Cot", "[", 
    FractionBox["x", "2"], "]"}], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       FractionBox["x", "2"], "]"}], "2"]}]], " ", 
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}], "2"]]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "x", "]"}]}]]]], "Print",
 CellChangeTimes->{3.4322721117408867`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272111780944*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "WisconsinProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.4322721155864162`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["x", "x"]], " ", 
    SuperscriptBox["x", 
     RowBox[{"2", " ", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}]}], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322721155864162`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   SuperscriptBox["x", "x"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "x"]}], ")"}]}]], "Print",
 CellChangeTimes->{3.432272115616459*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      SuperscriptBox["x", "x"]], " ", 
     SuperscriptBox["x", 
      RowBox[{"2", " ", "x"}]]}], ",", "x"}], "]"}], "+", 
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      SuperscriptBox["x", "x"]], " ", 
     SuperscriptBox["x", 
      RowBox[{"2", " ", "x"}]], " ", 
     RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}]}]], "Print",
 CellChangeTimes->{3.432272115656517*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322721157366323`*^9}],

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.432272115806733*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272115886848*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
  SqrtBox[
   RowBox[{"1", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]]]], "Print",
 CellChangeTimes->{3.432272115916891*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SqrtBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "2"]]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"Tan", "[", 
        FractionBox["x", "2"], "]"}], "]"}]}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          FractionBox["x", "2"], "]"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], "+", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox["2"], "+", 
       RowBox[{"Tan", "[", 
        FractionBox["x", "2"], "]"}]}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{"Tan", "[", 
        FractionBox["x", "2"], "]"}]}], "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]}]], "Print",
 CellChangeTimes->{3.4322721159569488`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272115986992*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272116047078*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox["1", "x"]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}]}], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272116107165*^9}],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "/", "x"}]]}]], "Print",
 CellChangeTimes->{3.432272116167251*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox["1", "x"]}]], ",", "x"}], "]"}], "-", 
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       FractionBox["1", "x"]}]], " ", 
     RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}]}]], "Print",
 CellChangeTimes->{3.4322721161872797`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322721162173233`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "NewProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322721687027936`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"3", " ", "x"}], "]"}], "2"]}], 
    RowBox[{"x", "+", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"3", " ", "x"}], "]"}], "3"]}]}]], ",", "x"}], "}"}]], "Print",\

 CellChangeTimes->{3.4322721687328367`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}]}], 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{"Log", "[", 
      RowBox[{"3", " ", "x"}], "]"}], "+", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"3", " ", "x"}], "]"}], "2"]}], "]"}]}]}]], "Print",
 CellChangeTimes->{3.432272168792923*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Log", "[", 
        RowBox[{"3", " ", "x"}], "]"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"Log", "[", 
       RowBox[{"3", " ", "x"}], "]"}], "+", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"3", " ", "x"}], "]"}], "2"]}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"3", " ", "x"}], "]"}], "3"]}], "]"}]}]}], ")"}]}]], "Print",\

 CellChangeTimes->{3.4322721688229666`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322721688530097`*^9}],

Cell[BoxData["\<\"Valid but unnecessarily complicated antiderivative:\"\>"], \
"Print",
 CellChangeTimes->{3.4322721689231105`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], "3"]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322721689831967`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"256", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"19", "+", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"11", " ", "x"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "36"}], "+", 
       RowBox[{"25", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}]]}]}], 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}]}]]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "36"}], "+", 
       RowBox[{"25", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], "+", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}]]}]}], 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}]}]]], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"14", "+", 
       RowBox[{"11", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"14", "+", 
       RowBox[{"11", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}]}], 
   ")"}]}]], "Print",
 CellChangeTimes->{3.4322721690532975`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"256", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "8"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]]}], "+", 
    RowBox[{"152", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]], " ", "x"}], "-", 
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"88", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]], " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}], 
       RowBox[{"1", "+", 
        SqrtBox["2"]}]]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "14"}], "+", 
       RowBox[{"11", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SqrtBox["2"]}], ")"}]}]]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}]]}]}], 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}]}]]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}], 
       RowBox[{"1", "+", 
        SqrtBox["2"]}]]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "14"}], "+", 
       RowBox[{"11", " ", 
        SqrtBox["2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], "+", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}]]}]}], 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}]}]]], "]"}]}], "+", 
    RowBox[{"14", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"11", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"22", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"11", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"14", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"11", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"28", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"22", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"14", " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"11", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SqrtBox["2"]}], ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}]]}], "+", "x"}], "]"}]}]}], 
   ")"}]}]], "Print",
 CellChangeTimes->{3.4322721691133842`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272169183485*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.4322721693236866`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "4"]}]]}]]}]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.4322721694739027`*^9}],

Cell[BoxData[
 RowBox[{"ArcCot", "[", 
  FractionBox[
   SqrtBox[
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}]]}]], "x"], "]"}]], "Print",
 CellChangeTimes->{3.4322721696141043`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "4"]}]]}]]}]], ",", "x"}], "]"}]], "Print",
 CellChangeTimes->{3.432272169664176*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272169724262*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegrationTest", "[", "ApostolProblems", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.432272172848755*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"ArcTan", "[", "x", "]"}]], " ", "x"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272172848755*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcTan", "[", "x", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]]}]]], "Print",
 CellChangeTimes->{3.4322721729388847`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"ArcTan", "[", "x", "]"}]], " ", "x"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "x"}], "]"}]], "Print",
 CellChangeTimes->{3.432272173019*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322721730991154`*^9}],

Cell[BoxData["\<\"Unable to integrate:\"\>"], "Print",
 CellChangeTimes->{3.4322721731592016`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ArcTan", "[", "x", "]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "x"}], "}"}]], "Print",
 CellChangeTimes->{3.432272173219288*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcTan", "[", "x", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]]}]]], "Print",
 CellChangeTimes->{3.432272173279374*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ArcTan", "[", "x", "]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "x"}], "]"}]], "Print",
 CellChangeTimes->{3.432272173339461*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272173389533*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintTestStatistics", "[", "]"}], ";"}]], "Code"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272173499691*^9}],

Cell[BoxData["\<\"               * * *  Indefinite Integration Test Suite \
Results  * * *\"\>"], "Print",
 CellChangeTimes->{3.43227217351972*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.432272173569792*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" Integration function:  \"\>", "\[InvisibleSpace]", "906", 
   "\[InvisibleSpace]", "\<\" user-defined transformation rules\"\>"}],
  SequenceForm[
  " Integration function:  ", 906, " user-defined transformation rules"],
  Editable->False]], "Print",
 CellChangeTimes->{3.432272173689965*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Time and date of test:  \"\>", 
   "\[InvisibleSpace]", "\<\"22:56  05 October 2008\"\>"}],
  SequenceForm["Time and date of test:  ", "22:56  05 October 2008"],
  Editable->False]], "Print",
 CellChangeTimes->{3.432272173740037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Mathematica version:  \"\>", 
   "\[InvisibleSpace]", "\<\"6.0 for Microsoft Windows (32-bit) (March 13, \
2008)\"\>"}],
  SequenceForm[
  "  Mathematica version:  ", 
   "6.0 for Microsoft Windows (32-bit) (March 13, 2008)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.432272173740037*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.4322721737500515`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[GridBox[{
      {"\<\"File\"\>"},
      {"\<\"Polynomial\"\>"},
      {"\<\"Rational\"\>"},
      {"\<\"Algebraic\"\>"},
      {"\<\"Exponential\"\>"},
      {"\<\"Logarithm\"\>"},
      {"\<\"Trig\"\>"},
      {"\<\"InverseTrig\"\>"},
      {"\<\"Hyperbolic\"\>"},
      {"\<\"InverseHyperbolic\"\>"},
      {"\<\"Special\"\>"},
      {"\<\"Simple\"\>"},
      {"\<\"Fitzpatrick\"\>"},
      {"\<\"MIT\"\>"},
      {"\<\"HughesHallett\"\>"},
      {"\<\"EdwardsPenney\"\>"},
      {"\<\"Stewart\"\>"},
      {"\<\"Grossman\"\>"},
      {"\<\"Ayers\"\>"},
      {"\<\"HowardAnton\"\>"},
      {"\<\"Internet\"\>"},
      {"\<\"NorthTexas\"\>"},
      {"\<\"Spivak\"\>"},
      {"\<\"Thomas\"\>"},
      {"\<\"Wisconsin\"\>"},
      {"\<\"New\"\>"},
      {"\<\"Apostol\"\>"},
      {"\<\"TOTALS\"\>"},
      {"\<\"PERCENTAGES\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Optimal\"\>"},
      {"\<\"22\"\>"},
      {"\<\"71\"\>"},
      {"\<\"133\"\>"},
      {"\<\"45\"\>"},
      {"\<\"46\"\>"},
      {"\<\"146\"\>"},
      {"\<\"31\"\>"},
      {"\<\"29\"\>"},
      {"\<\"25\"\>"},
      {"\<\"36\"\>"},
      {"\<\"62\"\>"},
      {"\<\"48\"\>"},
      {"\<\"29\"\>"},
      {"\<\"380\"\>"},
      {"\<\"553\"\>"},
      {"\<\"358\"\>"},
      {"\<\"414\"\>"},
      {"\<\"405\"\>"},
      {"\<\"422\"\>"},
      {"\<\"122\"\>"},
      {"\<\"92\"\>"},
      {"\<\"88\"\>"},
      {"\<\"496\"\>"},
      {"\<\"85\"\>"},
      {"\<\"484\"\>"},
      {"\<\"89\"\>"},
      {"\<\"4711\"\>"},
      {"\<\"99.6%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Nonidentical\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"1\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"1\"\>"},
      {"\<\"2\"\>"},
      {"\<\"0\"\>"},
      {"\<\"8\"\>"},
      {"\<\"0.169%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Nonintegrable\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"2\"\>"},
      {"\<\"2\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"1\"\>"},
      {"\<\"1\"\>"},
      {"\<\"1\"\>"},
      {"\<\"0\"\>"},
      {"\<\"2\"\>"},
      {"\<\"1\"\>"},
      {"\<\"2\"\>"},
      {"\<\"13\"\>"},
      {"\<\"0.275%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Timeouts\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0.%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Incorrect\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0\"\>"},
      {"\<\"0.%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Total\"\>"},
      {"\<\"22\"\>"},
      {"\<\"72\"\>"},
      {"\<\"134\"\>"},
      {"\<\"45\"\>"},
      {"\<\"48\"\>"},
      {"\<\"149\"\>"},
      {"\<\"32\"\>"},
      {"\<\"29\"\>"},
      {"\<\"26\"\>"},
      {"\<\"36\"\>"},
      {"\<\"62\"\>"},
      {"\<\"48\"\>"},
      {"\<\"29\"\>"},
      {"\<\"380\"\>"},
      {"\<\"553\"\>"},
      {"\<\"358\"\>"},
      {"\<\"414\"\>"},
      {"\<\"405\"\>"},
      {"\<\"422\"\>"},
      {"\<\"123\"\>"},
      {"\<\"93\"\>"},
      {"\<\"89\"\>"},
      {"\<\"497\"\>"},
      {"\<\"88\"\>"},
      {"\<\"487\"\>"},
      {"\<\"91\"\>"},
      {"\<\"4732\"\>"},
      {"\<\"100.%\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"], "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"\<\"Integrals/sec\"\>"},
      {"\<\"122.\"\>"},
      {"\<\"46.4\"\>"},
      {"\<\"24.1\"\>"},
      {"\<\"55.6\"\>"},
      {"\<\"51.\"\>"},
      {"\<\"26.3\"\>"},
      {"\<\"52.5\"\>"},
      {"\<\"29.3\"\>"},
      {"\<\"66.7\"\>"},
      {"\<\"50.6\"\>"},
      {"\<\"1030.\"\>"},
      {"\<\"229.\"\>"},
      {"\<\"223.\"\>"},
      {"\<\"234.\"\>"},
      {"\<\"114.\"\>"},
      {"\<\"82.3\"\>"},
      {"\<\"87.7\"\>"},
      {"\<\"110.\"\>"},
      {"\<\"103.\"\>"},
      {"\<\"54.8\"\>"},
      {"\<\"89.3\"\>"},
      {"\<\"71.2\"\>"},
      {"\<\"80.\"\>"},
      {"\<\"43.1\"\>"},
      {"\<\"31.9\"\>"},
      {"\<\"71.\"\>"},
      {"\<\"67.2\"\>"},
      {"\<\"\"\>"}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Column"]}],
  SequenceForm[
   Column[{
    "File", "Polynomial", "Rational", "Algebraic", "Exponential", "Logarithm",
      "Trig", "InverseTrig", "Hyperbolic", "InverseHyperbolic", "Special", 
     "Simple", "Fitzpatrick", "MIT", "HughesHallett", "EdwardsPenney", 
     "Stewart", "Grossman", "Ayers", "HowardAnton", "Internet", "NorthTexas", 
     "Spivak", "Thomas", "Wisconsin", "New", "Apostol", "TOTALS", 
     "PERCENTAGES"}, Center, 1], 
   Column[{
    "Optimal", "22", "71", "133", "45", "46", "146", "31", "29", "25", "36", 
     "62", "48", "29", "380", "553", "358", "414", "405", "422", "122", "92", 
     "88", "496", "85", "484", "89", "4711", "99.6%"}, Center, 1], 
   Column[{
    "Nonidentical", "0", "0", "1", "0", "0", "1", "1", "0", "1", "0", "0", 
     "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "2", 
     "0", "8", "0.169%"}, Center, 1], 
   Column[{
    "Nonintegrable", "0", "1", "0", "0", "2", "2", "0", "0", "0", "0", "0", 
     "0", "0", "0", "0", "0", "0", "0", "0", "1", "1", "1", "0", "2", "1", 
     "2", "13", "0.275%"}, Center, 1], 
   Column[{
    "Timeouts", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0", "0.%"}, Center, 1], 
   Column[{
    "Incorrect", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0", "0.%"}, Center, 1], 
   Column[{
    "Total", "22", "72", "134", "45", "48", "149", "32", "29", "26", "36", 
     "62", "48", "29", "380", "553", "358", "414", "405", "422", "123", "93", 
     "89", "497", "88", "487", "91", "4732", "100.%"}, Center, 1], 
   Column[{
    "Integrals/sec", "122.", "46.4", "24.1", "55.6", "51.", "26.3", "52.5", 
     "29.3", "66.7", "50.6", "1030.", "229.", "223.", "234.", "114.", "82.3", 
     "87.7", "110.", "103.", "54.8", "89.3", "71.2", "80.", "43.1", "31.9", 
     "71.", "67.2", ""}, Center, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.432272173800123*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (March 13, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 522, 15, 101, "Code"],
Cell[CellGroupData[{
Cell[1115, 40, 46, 0, 46, "Subsection"],
Cell[1164, 42, 450, 12, 122, "Code"],
Cell[1617, 56, 16516, 375, 1288, "Code"],
Cell[18136, 433, 6368, 168, 672, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[24541, 606, 52, 0, 35, "Subsection"],
Cell[24596, 608, 103, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[24724, 614, 101, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[24850, 620, 98, 1, 27, "Print"],
Cell[24951, 623, 1055, 35, 51, "Print"],
Cell[26009, 660, 403, 13, 51, "Print"],
Cell[26415, 675, 2903, 101, 147, "Print"],
Cell[29321, 778, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29446, 785, 102, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[29573, 791, 131, 2, 27, "Print"],
Cell[29707, 795, 318, 11, 53, "Print"],
Cell[30028, 808, 126, 3, 27, "Print"],
Cell[30157, 813, 293, 10, 50, "Print"],
Cell[30453, 825, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[30558, 830, 107, 3, 56, "Code"],
Cell[CellGroupData[{
Cell[30690, 837, 102, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[30817, 843, 96, 1, 27, "Print"],
Cell[30916, 846, 284, 10, 47, "Print"],
Cell[31203, 858, 507, 17, 59, "Print"],
Cell[31713, 877, 291, 10, 47, "Print"],
Cell[32007, 889, 76, 1, 27, "Print"],
Cell[32086, 892, 96, 1, 27, "Print"],
Cell[32185, 895, 225, 7, 33, "Print"],
Cell[32413, 904, 927, 31, 27, "Print"],
Cell[33343, 937, 946, 32, 43, "Print"],
Cell[34292, 971, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34419, 978, 97, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[34541, 984, 131, 2, 27, "Print"],
Cell[34675, 988, 342, 11, 50, "Print"],
Cell[35020, 1001, 516, 18, 48, "Print"],
Cell[35539, 1021, 703, 22, 43, "Print"],
Cell[36245, 1045, 76, 1, 27, "Print"],
Cell[36324, 1048, 96, 1, 27, "Print"],
Cell[36423, 1051, 392, 13, 51, "Print"],
Cell[36818, 1066, 288, 10, 56, "Print"],
Cell[37109, 1078, 2147, 68, 121, "Print"],
Cell[39259, 1148, 76, 1, 27, "Print"],
Cell[39338, 1151, 96, 1, 27, "Print"],
Cell[39437, 1154, 393, 13, 53, "Print"],
Cell[39833, 1169, 643, 23, 56, "Print"],
Cell[40479, 1194, 1965, 63, 177, "Print"],
Cell[42447, 1259, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42574, 1266, 107, 3, 56, "Code"],
Cell[CellGroupData[{
Cell[42706, 1273, 131, 2, 27, "Print"],
Cell[42840, 1277, 226, 7, 43, "Print"],
Cell[43069, 1286, 1423, 43, 86, "Print"],
Cell[44495, 1331, 2557, 79, 90, "Print"],
Cell[47055, 1412, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[47160, 1417, 103, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[47288, 1423, 113, 3, 56, "Code"],
Cell[CellGroupData[{
Cell[47426, 1430, 131, 2, 27, "Print"],
Cell[47560, 1434, 225, 7, 43, "Print"],
Cell[47788, 1443, 1299, 42, 84, "Print"],
Cell[49090, 1487, 2401, 80, 88, "Print"],
Cell[51494, 1569, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[51597, 1574, 100, 2, 56, "Code"],
Cell[51700, 1578, 98, 2, 56, "Code"],
Cell[51801, 1582, 103, 2, 56, "Code"],
Cell[51907, 1586, 95, 2, 56, "Code"],
Cell[52005, 1590, 108, 3, 56, "Code"],
Cell[52116, 1595, 108, 3, 56, "Code"],
Cell[52227, 1600, 99, 2, 56, "Code"],
Cell[52329, 1604, 100, 2, 56, "Code"],
Cell[52432, 1608, 97, 2, 56, "Code"],
Cell[52532, 1612, 103, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[52660, 1618, 100, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[52785, 1624, 96, 1, 27, "Print"],
Cell[52884, 1627, 348, 11, 47, "Print"],
Cell[53235, 1640, 675, 22, 42, "Print"],
Cell[53913, 1664, 711, 22, 47, "Print"],
Cell[54627, 1688, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54752, 1695, 102, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[54879, 1701, 96, 1, 27, "Print"],
Cell[54978, 1704, 410, 14, 33, "Print"],
Cell[55391, 1720, 266, 9, 50, "Print"],
Cell[55660, 1731, 824, 27, 71, "Print"],
Cell[56487, 1760, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56612, 1767, 98, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[56735, 1773, 98, 1, 27, "Print"],
Cell[56836, 1776, 459, 14, 30, "Print"],
Cell[57298, 1792, 325, 10, 27, "Print"],
Cell[57626, 1804, 1246, 41, 62, "Print"],
Cell[58875, 1847, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59002, 1854, 98, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[59125, 1860, 131, 2, 27, "Print"],
Cell[59259, 1864, 270, 9, 57, "Print"],
Cell[59532, 1875, 732, 28, 57, "Print"],
Cell[60267, 1905, 1087, 39, 92, "Print"],
Cell[61357, 1946, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61482, 1953, 101, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[61608, 1959, 98, 1, 27, "Print"],
Cell[61709, 1962, 354, 11, 33, "Print"],
Cell[62066, 1975, 247, 8, 30, "Print"],
Cell[62316, 1985, 538, 17, 33, "Print"],
Cell[62857, 2004, 78, 1, 27, "Print"],
Cell[62938, 2007, 129, 2, 27, "Print"],
Cell[63070, 2011, 329, 11, 52, "Print"],
Cell[63402, 2024, 321, 11, 52, "Print"],
Cell[63726, 2037, 1287, 43, 112, "Print"],
Cell[65016, 2082, 76, 1, 27, "Print"],
Cell[65095, 2085, 96, 1, 27, "Print"],
Cell[65194, 2088, 322, 11, 41, "Print"],
Cell[65519, 2101, 154, 5, 27, "Print"],
Cell[65676, 2108, 461, 16, 41, "Print"],
Cell[66140, 2126, 78, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66267, 2133, 95, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[66387, 2139, 131, 2, 27, "Print"],
Cell[66521, 2143, 418, 15, 50, "Print"],
Cell[66942, 2160, 624, 22, 65, "Print"],
Cell[67569, 2184, 1032, 35, 55, "Print"],
Cell[68604, 2221, 78, 1, 27, "Print"],
Cell[68685, 2224, 131, 2, 27, "Print"],
Cell[68819, 2228, 308, 11, 54, "Print"],
Cell[69130, 2241, 3720, 136, 333, "Print"],
Cell[72853, 2379, 8624, 315, 636, "Print"],
Cell[81480, 2696, 76, 1, 27, "Print"],
Cell[81559, 2699, 98, 1, 27, "Print"],
Cell[81660, 2702, 417, 15, 58, "Print"],
Cell[82080, 2719, 282, 10, 56, "Print"],
Cell[82365, 2731, 422, 15, 58, "Print"],
Cell[82790, 2748, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82915, 2755, 99, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[83039, 2761, 96, 1, 27, "Print"],
Cell[83138, 2764, 373, 12, 51, "Print"],
Cell[83514, 2778, 346, 12, 53, "Print"],
Cell[83863, 2792, 377, 12, 51, "Print"],
Cell[84243, 2806, 78, 1, 27, "Print"],
Cell[84324, 2809, 98, 1, 27, "Print"],
Cell[84425, 2812, 346, 11, 51, "Print"],
Cell[84774, 2825, 323, 11, 53, "Print"],
Cell[85100, 2838, 353, 11, 51, "Print"],
Cell[85456, 2851, 76, 1, 27, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85581, 2858, 84, 2, 56, "Code"],
Cell[CellGroupData[{
Cell[85690, 2864, 76, 1, 27, "Print"],
Cell[85769, 2867, 147, 2, 27, "Print"],
Cell[85919, 2871, 76, 1, 27, "Print"],
Cell[85998, 2874, 342, 7, 27, "Print"],
Cell[86343, 2883, 282, 6, 27, "Print"],
Cell[86628, 2891, 349, 9, 27, "Print"],
Cell[86980, 2902, 78, 1, 27, "Print"],
Cell[87061, 2905, 9894, 337, 711, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

