(* ::Package:: *)

(* This assignment designates the integration function (Int or Integrate) to be tested. *)
(* IntegrationFunction=Integrate; *)
IntegrationFunction=Int;


(* ::Subsection::Closed:: *)
(*Integration test program*)


If[IntegrationFunction===Int,
  ShowSteps=False;
  Get["C:\\RuleBasedIntegrator\\IndefiniteIntegrationRules.m"];
  MoveDownValues[Integrate,Int]];


IntegrationTest[fileName_]:=
  Module[{func=IntegrationFunction, deficiencyList={}, computeTime=0, 
		timeouts=0, unintegrables=0, nonidenticals=0, incorrects=0, corrects=0,
		result, time, tmp, lst},
  (* Print["Testing integration problems in ",fileName,"IntegrationProblems.m"]; *)
  lst=Get["C:\\RuleBasedIntegrator\\ProblemFiles\\"<>ToString[fileName]<>".m"];
  ClearSystemCache[];
  Monitor[
  Do[
	(* Print[lst[[i]]]; *)
    {time,result}={0.01,lst[[i,3]]};
    {time,result}=TimeConstrained[Timing[func[lst[[i,1]],lst[[i,2]]]],10,{0,"Timed out"}];
	result=Simplify[result];
	computeTime=computeTime + time;

	If[result==="Timed out",
	  timeouts++;
      AppendTo[deficiencyList,{
	    "Timed out after 10 seconds:", {lst[[i,1]],lst[[i,2]]}, lst[[i,3]], "???"}],
    If[Not[FreeQ[result,func]],
	  unintegrables++;
      AppendTo[deficiencyList,{
	    "Unable to integrate:", {lst[[i,1]],lst[[i,2]]}, lst[[i,3]], result}],
    If[Not[FreeQ[result,Hypergeometric1F1] && FreeQ[result,Hypergeometric2F1] &&
			FreeQ[result,AppellF1]],
	  nonidenticals++;
      AppendTo[deficiencyList,{
	    "Valid but unnecessarily complicated antiderivative:", {lst[[i,1]],lst[[i,2]]}, lst[[i,3]], result}],
(* Compare derivative of result with integrand *)
(*  tmp=D[result,lst[[i,2]]];
    If[TimeConstrained[PossibleZeroQ[FullSimplify[tmp-lst[[i,1]]]],5,False] ||
		TimeConstrained[PossibleZeroQ[FullSimplify[FullSimplify[tmp]-lst[[i,1]]]],5,False], *)
(* Compare result with desired result *)
    If[result===lst[[i,3]]
		|| Length[lst[[i]]]>=4 && result===lst[[i,4]]
    	|| func===Integrate && LeafCount[result]<=LeafCount[lst[[i,3]]]+6,
(*      || PossibleZeroQ[Simplify[result-lst[[i,3]]]] *)
(*	  || Length[lst[[i]]]>=4 && PossibleZeroQ[Simplify[result-lst[[i,4]]]] *)
(*      || PossibleZeroQ[Simplify[D[result-lst[[i,3]],lst[[i,2]]]]], *)
	  corrects++,
    tmp=D[result,lst[[i,2]]];
    If[TimeConstrained[PossibleZeroQ[FullSimplify[tmp-lst[[i,1]]]],5,False] ||
		TimeConstrained[PossibleZeroQ[FullSimplify[FullSimplify[tmp]-lst[[i,1]]]],5,False],
	  nonidenticals++;
      AppendTo[deficiencyList,{
	    "Valid but unnecessarily complicated antiderivative:", {lst[[i,1]],lst[[i,2]]}, lst[[i,3]], result}],
	incorrects++;
    AppendTo[deficiencyList,{
        "Incorrect result:", {lst[[i,1]],lst[[i,2]]}, lst[[i,3]], result}]]]]]],

	{i,1,Length[lst]}],
  ProgressIndicator[i,{1,Length[lst]}]];
  tmp=ToString[fileName];
  tmp=StringReplace[tmp,{"Functions"->"","Problems"->""}];
  AppendTo[testStatistics, {tmp,
		corrects,nonidenticals,unintegrables,timeouts,incorrects,Length[lst],computeTime}];
  Scan[Function[Scan[Print,#];Print[]],deficiencyList]];


testStatistics={};

PrintTestStatistics[] :=
  Module[{lst=testStatistics,total,percentages},
  lst=Transpose[lst];
  lst=Join[{Append[First[lst],"TOTALS"]}, Map[Function[Append[#,Apply[Plus,#]]],Rest[lst]]];
  lst=Append[Most[lst],Map2[Function[NumberForm[N[#1/#2],3]],Part[lst,-2],Part[lst,-1]]];
  lst=Transpose[lst];
  total=Last[lst][[-2]];
  percentages=Map[Function[#/total],Drop[Rest[Last[lst]],-1]];
  percentages=Map[Function[ToString[NumberForm[N[100*#],3]]<>"%"],percentages];
  AppendTo[lst,Join[{"PERCENTAGES"},percentages,{""}]];
  lst=Quiet[Map[Function[Map[ToString,#]],lst]];
  PrependTo[lst,{"File","Optimal","Nonidentical","Nonintegrable","Timeouts",
			"Incorrect","Total","Integrals/sec"}];
  lst=Transpose[lst];
  Print[];
  Print["               * * *  Indefinite Integration Test Suite Results  * * *"];
  Print[];
  ( If[IntegrationFunction===Integrate,
      Print[" Integration function:  Mathematica's built-in Integrate function"],
    Print[" Integration function:  ", Length[DownValues[Int]], " user-defined transformation rules"]] );
  Print["Time and date of test:  ",DateString[{"Hour24",":","Minute","  ","Day"," ","MonthName"," 2008"}]];
  Print["  Mathematica version:  ",$Version];
  Print[];
  Apply[Print,Map[Function[Column[#,Center,1]],lst]]]

Map2[func_,lst1_,lst2_] :=
  Reap[Do[Sow[func[lst1[[i]],lst2[[i]]]],{i,Length[lst1]}]][[2,1]]


(* ::Subsection:: *)
(*Test integration problem files*)


IntegrationTest[PolynomialFunctions];


IntegrationTest[RationalFunctions];


IntegrationTest[AlgebraicFunctions];


IntegrationTest[ExponentialFunctions];


IntegrationTest[LogarithmFunctions];


IntegrationTest[TrigFunctions];


IntegrationTest[InverseTrigFunctions];


IntegrationTest[HyperbolicFunctions];


IntegrationTest[InverseHyperbolicFunctions];


IntegrationTest[SpecialFunctions];


IntegrationTest[SimpleProblems];


IntegrationTest[FitzpatrickProblems];


IntegrationTest[MITProblems];


IntegrationTest[HughesHallettProblems];


IntegrationTest[EdwardsPenneyProblems];


IntegrationTest[StewartProblems];


IntegrationTest[GrossmanProblems];


IntegrationTest[AyersProblems];


IntegrationTest[HowardAntonProblems];


IntegrationTest[InternetProblems];


IntegrationTest[NorthTexasProblems];


IntegrationTest[SpivakProblems];


IntegrationTest[ThomasProblems];


IntegrationTest[WisconsinProblems];


IntegrationTest[NewProblems];


IntegrationTest[ApostolProblems];


PrintTestStatistics[];
