(* ::Package:: *)

(* ::Title:: *)
(*Indefinite Integration Rules (873)*)


(* ::Subsection::Closed:: *)
(*Load utility functions*)


Unprotect[Integrate];
DownValues[Integrate]={};
If[$Input==="",
  Get["C:\\Mathematica\\Rules\\Current\\UtilityFunctions.m"],
Get[ToFileName[DirectoryName[$Input], "UtilityFunctions.m"]]];
ShowSteps=(ShowSteps===True);


(* ::Section::Closed:: *)
(*Rational & Algebraic Function Rules (182)*)


(* ::Subsection::Closed:: *)
(*a + b x^n + c x^p + \[CenterEllipsis]		Integrands that are sums of monomials (6)*)


(* ::Subsubsection::Closed:: *)
(*a				Constants (1)*)


(* CRC 1 *)
Integrate[a_,x_Symbol] :=
   a*x /;
IndependentQ[a,x]


(* ::Subsubsection::Closed:: *)
(*a x^n				Products of constants and monomials (2)*)


(* GR5 2.01.2, CRC 9 *)
Integrate[a_./x_,x_Symbol] :=
  a*Log[x] /;
IndependentQ[a,x]


(* GR5 2.02.1&2.01.1, CRC 2&7 *)
Integrate[a_.*x_^n_.,x_Symbol] :=
  a*x^(n+1)/(n+1) /;
IndependentQ[{a,n},x] && NonzeroQ[n+1]


(* ::Subsubsection::Closed:: *)
(*a + b x^n + c x^p + \[CenterEllipsis]		Sums of products of constants and monomials (2)*)


(* CRC 1,2,4,7 *)
(* Integrate[a+b*x+c*x^2+\[CenterEllipsis],x] --> a*x+b*x^2/2+c*x^3/3+\[CenterEllipsis] *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  ShowStep["","Integrate[a+b*x+c*x^2+\[CenterEllipsis],x]","a*x+b*x^2/2+c*x^3/3+\[CenterEllipsis]",Hold[
  Map[Function[#*x/(Exponent[#,x]+1)],u]]] /;
SimplifyFlag && MonomialSumQ[u,x] && PolynomialQ[u,x],

Integrate[u_,x_Symbol] :=
  Map[Function[x*#/(Exponent[#,x]+1)],u] /;
MonomialSumQ[u,x] && PolynomialQ[u,x]]


(* CRC 1,2,4,7,9 *)
(* Integrate[a+b/x+c*x^m+\[CenterEllipsis],x] --> a*x+b*Log[x]+c*x^(m+1)/(m+1)+\[CenterEllipsis] *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  ShowStep["","Integrate[a+b/x+c*x^m+\[CenterEllipsis],x]","a*x+b*Log[x]+c*x^(m+1)/(m+1)+\[CenterEllipsis]",Hold[
  Map[Function[If[ZeroQ[Exponent[#,x]+1], #*x*Log[x], #*x/(Exponent[#,x]+1)]],u]]] /;
SimplifyFlag && MonomialSumQ[u,x] && Not[PolynomialQ[u,x]],

Integrate[u_,x_Symbol] :=
  Map[Function[If[ZeroQ[Exponent[#,x]+1], #*x*Log[x], #*x/(Exponent[#,x]+1)]],u] /;
MonomialSumQ[u,x] && Not[PolynomialQ[u,x]]]


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x^n+c x^p+\[CenterEllipsis])	Products of monomials and sums of monomials (1)*)


(* Integrate[x^m*(a+b*x^n+c*x^p+\[CenterEllipsis]),x] --> Integrate[a*x^m+b*x^(m+n)+c*x^(m+p)+\[CenterEllipsis],x] *)
If[ShowSteps,

Integrate[x_^m_.*u_,x_Symbol] :=
  ShowStep["","Integrate[x^m*(a+b*x^n+c*x^p+\[CenterEllipsis]),x]","Integrate[a*x^m+b*x^(m+n)+c*x^(m+p)+\[CenterEllipsis],x]",Hold[
  Integrate[Map[Function[x^m*#],u],x]]] /;
SimplifyFlag && FreeQ[m,x] && MonomialSumQ[u,x],

Integrate[x_^m_.*u_,x_Symbol] :=
  Integrate[Map[Function[x^m*#],u],x] /;
FreeQ[m,x] && MonomialSumQ[u,x]]


(* ::Subsection::Closed:: *)
(*a u				Integrands having constant factors (1)*)


(* CRC 23 *)
Integrate[(a_.+b_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(n+1)/(b*(n+1)) /;
FreeQ[{a,b,n},x] && NonzeroQ[n+1]


(* CRC 2 *)
(* Integrate[a*u,x] --> a*Integrate[u,x] *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=ConstantFactor[u,x]},
  ShowStep["","Integrate[a*u,x]","a*Integrate[u,x]",Hold[
  lst[[1]]*Integrate[lst[[2]],x]]] /;
 lst[[1]]=!=1] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{lst=ConstantFactor[u,x]},
  lst[[1]]*Integrate[lst[[2]],x] /;
 lst[[1]]=!=1]]


(* ::Subsection::Closed:: *)
(*a + b x				Integrands involving one linear binomial (21)*)


(* ::Subsubsection::Closed:: *)
(*(a+b x)^n			Powers of linears (2)*)


(* CRC 27 *)
Integrate[1/(a_+b_.*x_),x_Symbol] :=
  Log[a+b*x]/b /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*1 / (x (a+b x)^p)		Reciprocal of product of variable and power of linears (3)*)


(* GR5 2.118.1, CRC 84 *)
Integrate[1/(x_*(a_+b_.*x_)),x_Symbol] :=
  -Log[(a+b*x)/x]/a /;
FreeQ[{a,b},x]


(* GR5 2.224.5', CRC 135' *)
Integrate[1/(x_*Sqrt[a_+b_.*x_]),x_Symbol] :=
  -2*ArcTanh[Sqrt[a+b*x]/Rt[a,2]]/Rt[a,2] /;
FreeQ[{a,b},x] && PosQ[a]


(* GR5 2.224.6, CRC 136' *)
Integrate[1/(x_*Sqrt[a_+b_.*x_]),x_Symbol] :=
  2*ArcTan[Sqrt[a+b*x]/Rt[-a,2]]/Rt[-a,2] /;
FreeQ[{a,b},x] && PosQ[-a]


(* ::Subsubsection::Closed:: *)
(*1 / (Sqrt[x] (a+b x)^p)		Reciprocal of product of square-root of variable and power of linears (6)*)


(* CRC 135' *)
Integrate[1/(Sqrt[x_]*(a_+b_.*x_)),x_Symbol] :=
  -2*ArcTanh[Sqrt[x]/Rt[-a/b,2]]/(b*Rt[-a/b,2]) /;
FreeQ[{a,b},x] && PosQ[-a/b]


(* CRC 136' *)
Integrate[1/(Sqrt[x_]*(a_+b_.*x_)),x_Symbol] :=
  2*Rt[a/b,2]*ArcTan[Sqrt[x]/Rt[a/b,2]]/a /;
FreeQ[{a,b},x] && PosQ[a/b]


Integrate[1/(Sqrt[x_]*Sqrt[a_+b_.*x_]),x_Symbol] :=
  2*ArcSinh[Rt[b,2]*Sqrt[x]/Sqrt[a]]/Rt[b,2] /;
FreeQ[{a,b},x] && PosQ[b] && RationalQ[a] && a>0


Integrate[1/(Sqrt[x_]*Sqrt[a_.+b_.*x_]),x_Symbol] :=
  2*Rt[b,2]*ArcTanh[Rt[b,2]*Sqrt[x]/Sqrt[a+b*x]]/b /;
FreeQ[{a,b},x] && PosQ[b]


Integrate[1/(Sqrt[x_]*Sqrt[a_+b_.*x_]),x_Symbol] :=
  2*ArcSin[Rt[-b,2]*Sqrt[x]/Sqrt[a]]/Rt[-b,2] /;
FreeQ[{a,b},x] && PosQ[-b] && RationalQ[a] && a>0


Integrate[1/(Sqrt[x_]*Sqrt[a_.+b_.*x_]),x_Symbol] :=
  -2*Rt[-b,2]*ArcTan[Rt[-b,2]*Sqrt[x]/Sqrt[a+b*x]]/b /;
FreeQ[{a,b},x] && PosQ[-b]


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x)^n			Products of monomials and powers of linears (10)*)


(* GR5 2.110.6, CRC 88c *)
Integrate[x_^m_*(a_+b_.*x_)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x)^(n+1)/(a*(m+1)) /;
FreeQ[{a,b,m,n},x] && ZeroQ[m+n+2] && NonzeroQ[m+1]


Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  Integrate[Expand[x^m*(a+b*x)^n],x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && n>0


(* GR5 2.110.3 *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x)^n/(m+1)-
    b*n/(m+1)*Integrate[x^(m+1)*(a+b*x)^(n-1),x] /;
FreeQ[{a,b},x] && IntegerQ[m] && FractionQ[n] && n>0 && m<-1


(* GR5 2.110.4' *)
(* Subtracting off (b*x)^m term eliminates superfluous constant term *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  ((a+b*x)^m-(b*x)^m)/(m*b^(m+1)*(a+b*x)^m)+
    Integrate[x^(m-1)*(a+b*x)^(n+1),x]/b /;
FreeQ[{a,b},x] && IntegerQ[{m,n}] && m>0 && m+n+1==0


(* GR5 2.110.4' *)
(* Subtracting off binomial term eliminates superfluous constant term *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  (x^m*(a+b*x)^(n+1)-Binomial[n+1,m+n+1]*a^(m+n+1)/b^m)/(b*(n+1))-
    m/(b*(n+1))*Integrate[x^(m-1)*(a+b*x)^(n+1),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n}] && m>0 && n<-1 && m+n+1>0


(* GR5 2.110.4 *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  x^m*(a+b*x)^(n+1)/(b*(n+1))-
    m/(b*(n+1))*Integrate[x^(m-1)*(a+b*x)^(n+1),x] /;
FreeQ[{a,b},x] && IntegerQ[m] && RationalQ[n] && m>0 && n<-1


(* GR5 2.110.5, CRC 88a *)
(* Note: If n is fractional, CRC 88a and 88c are preferred over CRC 88b or 88d since they lead
	to many different fractional powers. *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  x^m*(a+b*x)^(n+1)/(b*(m+n+1))-
    a*m/(b*(m+n+1))*Integrate[x^(m-1)*(a+b*x)^n,x] /;
FreeQ[{a,b,n},x] && RationalQ[m] && m>0 && NonzeroQ[m+n+1]


(* GR5 2.110.6, CRC 88c *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x)^(n+1)/(a*(m+1))-
    b*(m+n+2)/(a*(m+1))*Integrate[x^(m+1)*(a+b*x)^n,x] /;
FreeQ[{a,b,n},x] && RationalQ[m] && m<-1


(* GR5 2.110.1, CRC 88b *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x)^n/(m+n+1)+
    n*a/(m+n+1)*Integrate[x^m*(a+b*x)^(n-1),x] /;
FreeQ[{a,b,m},x] && FractionQ[n] && n>0 && NonzeroQ[m+n+1]


(* GR5 2.110.2, CRC 88d *)
Integrate[x_^m_.*(a_+b_.*x_)^n_,x_Symbol] :=
  -x^(m+1)*(a+b*x)^(n+1)/(a*(n+1))+
    (m+n+2)/(a*(n+1))*Integrate[x^m*(a+b*x)^(n+1),x] /;
FreeQ[{a,b,m},x] && RationalQ[n] && n<-1 && NonzeroQ[m+n+2]


(* ::Subsection::Closed:: *)
(*a + b x; c + d x			Integrands involving two linear binomials (25)*)


(* ::Subsubsection::Closed:: *)
(*(a+b x)^m (c+d x)^n		Products of powers of linears (15)*)


Integrate[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n*Log[a+b*x]/b /;
FreeQ[{a,b,c,d,m,n},x] && ZeroQ[b*c-a*d] && ZeroQ[m+n+1]


Integrate[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n/(b*(m+n+1)) /;
FreeQ[{a,b,c,d,m,n},x] && ZeroQ[b*c-a*d] && NonzeroQ[m+n+1]


(* GR5 2.152, CRC 58 *)
Integrate[(a_+b_.*x_)/(c_+d_.*x_),x_Symbol] :=
  b*x/d-(b*c-a*d)*Log[c+d*x]/d^2 /;
FreeQ[{a,b,c,d},x] && NonzeroQ[b*c-a*d]


(* GR5 2.154, CRC 52 *)
Integrate[1/((a_+b_.*x_)*(c_+d_.*x_)),x_Symbol] :=
  Log[a+b*x]/(b*c-a*d)-Log[c+d*x]/(b*c-a*d) /;
FreeQ[{a,b,c,d},x] && NonzeroQ[b*c-a*d]


Integrate[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_+b_.*x_]),x_Symbol] :=
  ArcCosh[b*x/a]/b /;
FreeQ[{a,b,c},x] && ZeroQ[a+c] && PositiveQ[a]


Integrate[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  2*Rt[b/d,2]*ArcTanh[Rt[b/d,2]*Sqrt[c+d*x]/Sqrt[a+b*x]]/b /;
FreeQ[{a,b,c,d},x] && PosQ[b/d]


Integrate[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  -2*Rt[-b/d,2]*ArcTan[Rt[-b/d,2]*Sqrt[c+d*x]/Sqrt[a+b*x]]/b /;
FreeQ[{a,b,c,d},x] && PosQ[-b/d]


(* CRC 135' *)
Integrate[1/((a_+b_.*x_)*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  -2*ArcTanh[Sqrt[c+d*x]/Rt[(b*c-a*d)/b,2]]/(b*Rt[(b*c-a*d)/b,2]) /;
FreeQ[{a,b,c,d},x] && PosQ[(b*c-a*d)/b]


(* CRC 136' *)
Integrate[1/((a_+b_.*x_)*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  2*Rt[(a*d-b*c)/b,2]*ArcTan[Sqrt[c+d*x]/Rt[(a*d-b*c)/b,2]]/(a*d-b*c) /;
FreeQ[{a,b,c,d},x] && PosQ[(a*d-b*c)/b]


(* GR5 2.155', CRC 59a' *)
Integrate[(a_.+b_.*x_)^m_*(c_.+d_.*x_.)^n_,x_Symbol] :=
  -(a+b*x)^(m+1)*(c+d*x)^(n+1)/((n+1)*(b*c-a*d)) /;
FreeQ[{a,b,c,d,m,n},x] && NonzeroQ[b*c-a*d] && ZeroQ[m+n+2] && NonzeroQ[n+1] && NonzeroQ[n-1]


(* GR5 2.153.3, CRC 59c *)
Integrate[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^m*(c+d*x)^(n+1)/(d*(n+1))-
    m*b/(d*(n+1))*Integrate[(a+b*x)^(m-1)*(c+d*x)^(n+1),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && m>0 && n<-1


(* GR5 2.151, CRC 59b *)
Integrate[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n/(b*(m+n+1))+
    n*(b*c-a*d)/(b*(m+n+1))*Integrate[(a+b*x)^m*(c+d*x)^(n-1),x] /;
FreeQ[{a,b,c,d,m},x] && RationalQ[n] && NonzeroQ[b*c-a*d] && NonzeroQ[m+n+1] && n>=0 &&
  (Not[RationalQ[m]] || -1<=m<=0 || n<=m || m+n+1<0)


(* GR5 2.155, CRC 59a *)
Integrate[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  -(a+b*x)^(m+1)*(c+d*x)^(n+1)/((n+1)*(b*c-a*d))+
    (m+n+2)*b/((n+1)*(b*c-a*d))*Integrate[(a+b*x)^m*(c+d*x)^(n+1),x] /;
FreeQ[{a,b,c,d,m},x] && RationalQ[n] && NonzeroQ[b*c-a*d] && NonzeroQ[m+n+2] && n<-1 &&
  (Not[RationalQ[m]] || -1<=m<=0 || m<=n || m+n+1>=0)


Integrate[(a_.+b_.*x_)^m_/(c_+d_.*x_),x_Symbol] :=
  Module[{p=Denominator[m]},
    p*Subst[Integrate[x^(m*p+p-1)/(b*c-a*d+d*x^p),x],x,(a+b*x)^(1/p)]] /;
FreeQ[{a,b,c,d},x] && RationalQ[m] && -1<m<0


Integrate[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  Module[{p=Denominator[m]},
    p*Subst[Integrate[x^(m*p+p-1)/(b-d*x^p),x],x,(a+b*x)^(1/p)/(c+d*x)^(1/p)]] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && -1<m<0 && m+n==-1


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x)^n (c+d x)^n	Products of monomials and powers of two linears (10)*)


Integrate[x_^m_*(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_,x_Symbol] :=
  Integrate[x^m*(a*d+b*c+2*b*d*x)^(2*n),x]/(4*b*d)^n /;
FreeQ[{a,b,c,d,m},x] && IntegerQ[n] && ZeroQ[a*d-b*c]


(* GR5 2.156, CRC 53 *)
Integrate[x_/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  a*Log[a+b*x]/(b*(a*d-b*c))-c*Log[c+d*x]/(d*(a*d-b*c)) /;
FreeQ[{a,b,c,d},x] && NonzeroQ[a*d-b*c]


Integrate[1/(x_*(a_+b_.*x_)*(c_+d_.*x_)),x_Symbol] :=
  b*Log[a+b*x]/(a*(a*d-b*c))-d*Log[c+d*x]/(c*(a*d-b*c))+Log[x]/(a*c) /;
FreeQ[{a,b,c,d},x] && NonzeroQ[a*d-b*c]


(* GR5 2.265b *)
Integrate[(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_/x_,x_Symbol] :=
  (a+b*x)^n*(c+d*x)^n/(2*n)+
    (a*d+b*c)/2*Integrate[(a+b*x)^(n-1)*(c+d*x)^(n-1),x]+
    a*c*Integrate[(a+b*x)^(n-1)*(c+d*x)^(n-1)/x,x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n>0


(* GR5 2.268b, CRC 122 *)
Integrate[(a_+b_.*x_)^n_*(c_+d_.*x_)^n_/x_,x_Symbol] :=
  -(a+b*x)^(n+1)*(c+d*x)^(n+1)/(2*a*c*(n+1))-
    (a*d+b*c)/(2*a*c)*Integrate[(a+b*x)^n*(c+d*x)^n,x]+
    1/(a*c)*Integrate[(a+b*x)^(n+1)*(c+d*x)^(n+1)/x,x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n<-1


(* GR5 2.174.2 *)
Integrate[x_^m_*(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_,x_Symbol] :=
  x^(m-1)*(a+b*x)^(n+1)*(c+d*x)^(n+1)/(2*b*d*(n+1))-
    (a*d+b*c)/(2*b*d)*Integrate[x^(m-1)*(a+b*x)^n*(c+d*x)^n,x]+
    1/(b*d)*Integrate[x^(m-2)*(a+b*x)^(n+1)*(c+d*x)^(n+1),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && m+2*n+1==0 && m>1


(* GR5 2.174.1', CRC 119' *)
Integrate[x_*(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(n+1)*(c+d*x)^(n+1)/(2*b*d*(n+1))-
    (a*d+b*c)/(2*b*d)*Integrate[(a+b*x)^n*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,n},x] && NonzeroQ[n+1]


(* GR5 2.174.1', CRC 119' *)
Integrate[x_^m_*(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_,x_Symbol] :=
  x^(m-1)*(a+b*x)^(n+1)*(c+d*x)^(n+1)/(b*d*(n+1))+
    a*c/(b*d)*Integrate[x^(m-2)*(a+b*x)^n*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && m>1 && m+n==0


(* GR5 2.174.1, CRC 119 *)
Integrate[x_^m_*(a_.+b_.*x_)^n_*(c_.+d_.*x_)^n_,x_Symbol] :=
  x^(m-1)*(a+b*x)^(n+1)*(c+d*x)^(n+1)/(b*d*(m+2*n+1))-
    (m+n)*(a*d+b*c)/(b*d*(m+2*n+1))*Integrate[x^(m-1)*(a+b*x)^n*(c+d*x)^n,x]-
    a*c*(m-1)/(b*d*(m+2*n+1))*Integrate[x^(m-2)*(a+b*x)^n*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,n},x] && RationalQ[m] && NonzeroQ[m+2*n+1] && m>1


(* GR5 2.176, CRC 123 *)
Integrate[x_^m_*(a_+b_.*x_)^n_*(c_+d_.*x_)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x)^(n+1)*(c+d*x)^(n+1)/(a*c*(m+1))-
    (m+n+2)/(m+1)*((a*d+b*c)/(a*c))*Integrate[x^(m+1)*(a+b*x)^n*(c+d*x)^n,x]-
    (m+2*n+3)/(m+1)*(b*d/(a*c))*Integrate[x^(m+2)*(a+b*x)^n*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,n},x] && RationalQ[m] && m<-1


(* ::Subsection::Closed:: *)
(*a + b x^n			Integrands involving binomials (44)*)


(* ::Subsubsection::Closed:: *)
(*(a+b x^2)^p			Powers of square binomials (8)*)


(* CRC 60 *)
Integrate[1/(a_+b_.*x_^2),x_Symbol] :=
  Rt[a/b,2]/a*ArcTan[x/Rt[a/b,2]] /;
FreeQ[{a,b},x] && PosQ[a/b]


(* CRC 61b *)
Integrate[1/(a_+b_.*x_^2),x_Symbol] :=
  Rt[-a/b,2]/a*ArcTanh[x/Rt[-a/b,2]] /;
FreeQ[{a,b},x] && PosQ[-a/b]


(* CRC 60' *)
Integrate[1/(a_+b_.*(x_^m_)^n_),x_Symbol] :=
  Rt[a/b,2]*ArcTan[x*Sqrt[(x^m)^n/x^2]/Rt[a/b,2]]/(a*Sqrt[(x^m)^n/x^2]) /;
FreeQ[{a,b,m,n},x] && m*n===2 && PosQ[a/b]


(* CRC 61b' *)
Integrate[1/(a_+b_.*(x_^m_)^n_),x_Symbol] :=
  Rt[-a/b,2]*ArcTanh[x*Sqrt[(x^m)^n/x^2]/Rt[-a/b,2]]/(a*Sqrt[(x^m)^n/x^2]) /;
FreeQ[{a,b,m,n},x] && m*n===2 && PosQ[-a/b]


Integrate[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  ArcSinh[Rt[b,2]*x/Sqrt[a]]/Rt[b,2] /;
FreeQ[{a,b},x] && PosQ[b] && RationalQ[a] && a>0


(* CRC 279 *)
Integrate[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  ArcSin[Rt[-b,2]*x/Sqrt[a]]/Rt[-b,2] /;
FreeQ[{a,b},x] && PosQ[-b] && RationalQ[a] && a>0


(* CRC 278 *)
Integrate[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  Log[Rt[b,2]*x+Sqrt[a+b*x^2]]/Rt[b,2] /;
FreeQ[{a,b},x] && PosQ[b] && Not[RationalQ[a] && a>0]


Integrate[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  -ArcTan[Sqrt[a+b*x^2]/(Rt[-b,2]*x)]/Rt[-b,2] /;
FreeQ[{a,b},x] && PosQ[-b] && Not[RationalQ[a] && a>0]


(* ::Subsubsection::Closed:: *)
(*1 / (a+b x^n)			Reciprocals of binomials (4)*)


Integrate[1/(a_.+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[a/b,n]^(n-1))*
    Sum[2*ArcTan[(x/Rt[a/b,n]-Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*Pi]-
	  Log[x^2-2*x*Rt[a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[a/b,n]^2]*Cos[(2*k-1)/n*Pi],
	{k,1,n/2}] /;
FreeQ[{a,b},x] && EvenQ[n] && n>0 && PosQ[a/b]


Integrate[1/(a_.+b_.*x_^n_),x_Symbol] :=
  Integrate[1/(x^(n/2)-Rt[-a/b,2]),x]/(2*b*Rt[-a/b,2])-
  Integrate[1/(x^(n/2)+Rt[-a/b,2]),x]/(2*b*Rt[-a/b,2]) /;
FreeQ[{a,b},x] && EvenQ[n] && n>0 && PosQ[-a/b]


Integrate[1/(a_.+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[a/b,n]^(n-1))*
    (Log[x+Rt[a/b,n]]+
      Sum[2*ArcTan[(x/Rt[a/b,n]-Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*Pi]-
	    Log[x^2-2*x*Rt[a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[a/b,n]^2]*Cos[(2*k-1)/n*Pi],
	  {k,1,(n-1)/2}]) /;
FreeQ[{a,b},x] && OddQ[n] && n>0 && PosQ[a/b]


Integrate[1/(a_.+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[-a/b,n]^(n-1))*
    (Log[x-Rt[-a/b,n]]-
      Sum[2*ArcTan[(x/Rt[-a/b,n]+Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*Pi]+
	    Log[x^2+2*x*Rt[-a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[-a/b,n]^2]*Cos[(2*k-1)/n*Pi],
	  {k,1,(n-1)/2}]) /;
FreeQ[{a,b},x] && OddQ[n] && n>0 && PosQ[-a/b]


(* ::Subsubsection::Closed:: *)
(*(a+b x^n)^p			Powers of binomials (6)*)


(* GR5 2.110.2', CRC 88d' *)
Integrate[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x*(a+b*x^n)^(p+1)/a /;
FreeQ[{a,b,n,p},x] && ZeroQ[n*(p+1)+1]


(* GR5 2.110.1, CRC 88b *)
Integrate[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x*(a+b*x^n)^p/(p*n+1)+
    p*n*a/(p*n+1)*Integrate[(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,n},x] && FractionQ[p] && p>0 && NonzeroQ[p*n+1]


(* GR5 2.110.2, CRC 88d *)
Integrate[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -x*(a+b*x^n)^(p+1)/(n*(p+1)*a)+
    (n*(p+1)+1)/(n*(p+1)*a)*Integrate[(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,n},x] && RationalQ[p] && p<-1


(* Transforms negative degree binomials into positive degree binomials *) 
Integrate[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Integrate[x^(p*n)*(b+a*x^(-n))^p,x] /;
FreeQ[{a,b},x] && RationalQ[n] && IntegerQ[p] && n<0 && p<0


(* Transforms fractional power p of binomial into an integer *)
Integrate[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Denominator[p]},
  q*a^(p+1/n)/n*
	Subst[Integrate[x^(q/n-1)/(1-b*x^q)^(p+1/n+1),x],x,x^(n/q)/(a+b*x^n)^(1/q)]] /;
FreeQ[{a,b},x] && RationalQ[{p,n}] && -1<p<0 && IntegerQ[p+1/n]


(* Transforms improper binomials into proper binomials *)
Integrate[(a_.+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Numerator[1/n]},
  q*Subst[Integrate[x^(q-1)*(a+b*x^(q*n))^p,x],x,x^(1/q)]] /;
FreeQ[{a,b,p},x] && FractionOrNegativeQ[n] && Not[IntegerQ[p] && (p>0 || n<0)]


(* ::Subsubsection::Closed:: *)
(*x^m / (a+b x^n)		Quotients of monomials by binomials (5)*)


(* CRC 27' *)
Integrate[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Log[a+b*x^n]/(b*n) /;
FreeQ[{a,b,m,n},x] && ZeroQ[m-n+1]


Integrate[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[a/b,n]^(n-m-1))*
    Sum[2*ArcTan[(x/Rt[a/b,n]-Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*(m+1)*Pi]-
	  Log[x^2-2*x*Rt[a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[a/b,n]^2]*Cos[(2*k-1)/n*(m+1)*Pi],
	{k,1,n/2}] /;
FreeQ[{a,b},x] && IntegerQ[m] && EvenQ[n] && 0<m<n && GCD[m+1,n]==1 && PosQ[a/b]


Integrate[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Integrate[x^m/(x^(n/2)-Rt[-a/b,2]),x]/(2*b*Rt[-a/b,2])-
  Integrate[x^m/(x^(n/2)+Rt[-a/b,2]),x]/(2*b*Rt[-a/b,2]) /;
FreeQ[{a,b},x] && RationalQ[m] && EvenQ[n] && 0<m<n && GCD[m+1,n]==1 && PosQ[-a/b]


Integrate[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[a/b,n]^(n-m-1))*
    ((-1)^m*Log[x+Rt[a/b,n]]+
      Sum[2*ArcTan[(x/Rt[a/b,n]-Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*(m+1)*Pi]-
	    Log[x^2-2*x*Rt[a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[a/b,n]^2]*Cos[(2*k-1)/n*(m+1)*Pi],
	  {k,1,(n-1)/2}]) /;
FreeQ[{a,b},x] && IntegerQ[m] && OddQ[n] && 0<m<n && GCD[m+1,n]==1 && PosQ[a/b]


Integrate[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  1/(n*b*Rt[-a/b,n]^(n-m-1))*
    (Log[x-Rt[-a/b,n]]-
      (-1)^m*Sum[2*ArcTan[(x/Rt[-a/b,n]+Cos[(2*k-1)/n*Pi])/Sin[(2*k-1)/n*Pi]]*Sin[(2*k-1)/n*(m+1)*Pi]+
		   Log[x^2+2*x*Rt[-a/b,n]*Cos[(2*k-1)/n*Pi]+Rt[-a/b,n]^2]*Cos[(2*k-1)/n*(m+1)*Pi],
		 {k,1,(n-1)/2}]) /;
FreeQ[{a,b},x] && IntegerQ[m] && OddQ[n] && 0<m<n && GCD[m+1,n]==1 && PosQ[-a/b]


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x^n)^p		Products of monomials and powers of binomials (19)*)


(* Reduces binomial to a linear, even for fractional and symbolic n and p *)
Integrate[(a_+b_.*x_^n_)^p_/x_,x_Symbol] :=
  Subst[Integrate[(a+b*x)^p/x,x],x,x^n]/n /;
FreeQ[{a,b,n,p},x] && RationalQ[p] && -1<=p<0


(* CRC 23' *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (a+b*x^n)^(p+1)/(b*n*(p+1)) /;
FreeQ[{a,b,m,n,p},x] && ZeroQ[m-n+1] && NonzeroQ[p+1]


(* GR5 2.110.6', CRC 88c' *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^(p+1)/(a*(m+1)) /;
FreeQ[{a,b,m,n,p},x] && ZeroQ[m+n*(p+1)+1] && NonzeroQ[m+1] && (Not[p===-3] || Not[IntegerQ[n]])


Integrate[x_^m_.*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  Integrate[Expand[x^m*(a+b*x^n)^p],x] /;
FreeQ[{a,b,m,n},x] && IntegerQ[p] && p>0


Integrate[1/(x_^2*Sqrt[a_.+b_./x_^2]),x_Symbol] :=
  -Rt[a/b,2]*ArcCsch[Rt[a/b,2]*x]/Sqrt[a] /;
FreeQ[{a,b},x] && PositiveQ[a] && PosQ[a/b]


Integrate[1/(x_^2*Sqrt[a_.+b_./x_^2]),x_Symbol] :=
  -Rt[-a/b,2]*ArcCsc[Rt[-a/b,2]*x]/Sqrt[a] /;
FreeQ[{a,b},x] && PositiveQ[a] && PosQ[-a/b]


(* Transforms negative degree binomials into positive degree binomials *) 
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Integrate[x^(m+n*p)*(b+a*x^(-n))^p,x] /;
FreeQ[{a,b},x] && RationalQ[n] && IntegerQ[p] && n<0 && p<0


(* GR5 2.110.3 *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^p/(m+1)-
    b*n*p/(m+1)*Integrate[x^(m+n)*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n}] && FractionQ[p] && p>0 && (n>0 && m<-1 || n<0 && m>1)


(* GR5 2.110.4' *)
(* Subtracting off (b*x^n)^(-1-p) term eliminates superfluous constant term *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  b^p*((a+b*x^n)^(-1-p)-(b*x^n)^(-1-p))/(n*(-1-p)*(a+b*x^n)^(-1-p))+
    Integrate[x^(m-n)*(a+b*x^n)^(p+1),x]/b /;
FreeQ[{a,b},x] && IntegerQ[{m,n,p}] && (0<n<=m || m<=n<0) && m+n*p+1==0


(* GR5 2.110.4' *)
(* Subtracting off binomial term eliminates superfluous constant term *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (x^(m-n+1)*(a+b*x^n)^(p+1)-Binomial[p+1,(m+1)/n+p]*a^((m+1)/n+p)/b^((m+1)/n-1))/(b*n*(p+1))-
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n,p}] && (0<n<=m || m<=n<0) && p<-1 && m+n*p+1>0 && IntegerQ[(m+1)/n]


(* GR5 2.110.4 *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m-n+1)*(a+b*x^n)^(p+1)/(b*n*(p+1))-
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n}] && RationalQ[p] && (0<n<=m || m<=n<0) && p<-1


(* GR5 2.110.1, CRC 88b *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^p/(m+n*p+1)+
    n*p*a/(m+n*p+1)*Integrate[x^m*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,m,n},x] && FractionQ[p] && p>0 && NonzeroQ[m+n*p+1]


(* GR5 2.110.2, CRC 88d *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -x^(m+1)*(a+b*x^n)^(p+1)/(a*n*(p+1))+
    (m+n*(p+1)+1)/(a*n*(p+1))*Integrate[x^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p<-1 && NonzeroQ[m+n*(p+1)+1]


(* GR5 2.110.5, CRC 88a *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m-n+1)*(a+b*x^n)^(p+1)/(b*(n*p+m+1))-
    a*(m-n+1)/(b*(n*p+m+1))*Integrate[x^(m-n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,p},x] && IntegerQ[{m,n}] && (0<n<=m || m<=n<0) && NonzeroQ[n*p+m+1] &&
  (Not[RationalQ[p]] || -1<=p<0)


(* GR5 2.110.6, CRC 88c *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^(p+1)/(a*(m+1))-
    b*(m+n*(p+1)+1)/(a*(m+1))*Integrate[x^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,p},x] && IntegerQ[{m,n}] && (n>0 && m<-1 || n<0 && m>1) &&
  (Not[RationalQ[p]] || -1<=p<0 || ZeroQ[m+n*p+1])


(* Transforms fractional power p of binomial into an integer *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Denominator[p]},
  q*a^(p+(m+1)/n)/n*
	Subst[Integrate[x^(q*(m+1)/n-1)/(1-b*x^q)^(p+(m+1)/n+1),x],x,x^(n/q)/(a+b*x^n)^(1/q)]] /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && -1<p<0 && IntegerQ[p+(m+1)/n] && GCD[m+1,n]==1


(* Transforms improper binomials into proper binomials *)
Integrate[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Sign[n]*LCM[Denominator[m],Denominator[n]]},
  q*Subst[Integrate[x^(q*m+q-1)*(a+b*x^(q*n))^p,x],x,x^(1/q)]] /;
FreeQ[{a,b,p},x] && RationalQ[{m,n}] && (FractionQ[m] || FractionOrNegativeQ[n]) &&
	Not[IntegerQ[p] && (p>0 || n<0)]


(* Transforms integrand factor into a monomial times a binomial *)
Integrate[u_.*x_^m_./(a_.*x_^n_.+b_.*x_^p_),x_Symbol] :=
  Integrate[u*x^(m-n)/(a+b*x^(p-n)),x] /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && 0<n<=p

Integrate[u_.*(v_.*x_^m_.+w_)/(a_.*x_^n_.+b_.*x_^p_),x_Symbol] :=
  Integrate[u*v*x^(m-n)/(a+b*x^(p-n)),x] +
    Integrate[u*w/(a*x^n+b*x^p),x] /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && 0<n<=p && Not[PolynomialQ[w,x]]


Integrate[u_.*x_^m_.*(v_.*x_^n_.+w_),x_Symbol] :=
  Integrate[u*v*x^(m+n),x] +
    Integrate[u*w*x^m,x] /;
FreeQ[{m,n},x] && Not[PolynomialQ[w,x]]


(* ::Subsubsection::Closed:: *)
(*1 / Sqrt[x^m (a+b x^n)]	Reciprocals of squareroots of products of monomials and binomials (2)*)


Integrate[1/Sqrt[x_^m_.*(a_.+b_.*x_^n_.)],x_Symbol] :=
  2*Log[Sqrt[x^m*(a+b*x^n)]+x*Rt[b,2]]/(n*Rt[b,2])-m*Log[x]/(n*Rt[b,2]) /;
FreeQ[{a,b,n,m},x] && m+n===2 && PosQ[b]


Integrate[1/Sqrt[x_^m_.*(a_.+b_.*x_^n_.)],x_Symbol] :=
  2*ArcTan[x*Rt[-b,2]/Sqrt[x^m*(a+b*x^n)]]/(n*Rt[-b,2]) /;
FreeQ[{a,b,n,m},x] && m+n===2 && PosQ[-b]


(* ::Subsection::Closed:: *)
(*a + b x^n; c + d x^p		Integrands involving two binomials (10)*)


(* ::Subsubsection::Closed:: *)
(*(a+b x^n)^p (c+d x^n)^q	Products of powers of binomials (6)*)


Integrate[1/((a_.+b_.*x_^2)*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  x/Sqrt[c+d*x^2] /;
FreeQ[{a,b,c,d},x] && ZeroQ[a*d-b*c]


Integrate[1/((a_+b_.*x_^2)*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  ArcTanh[x*Rt[(a*d-b*c)/a,2]/Sqrt[c+d*x^2]]/(a*Rt[(a*d-b*c)/a,2]) /;
FreeQ[{a,b,c,d},x] && PosQ[(a*d-b*c)/a]


Integrate[1/((a_+b_.*x_^2)*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  ArcTan[x*Rt[(b*c-a*d)/a,2]/Sqrt[c+d*x^2]]/(a*Rt[(b*c-a*d)/a,2]) /;
FreeQ[{a,b,c,d},x] && PosQ[(b*c-a*d)/a]


Integrate[(a_.+b_.*x_^n_)^p_*(c_.+d_.*x_^n_)^q_.,x_Symbol] :=
  (a*d-b*c)/d*Integrate[(a+b*x^n)^(p-1)*(c+d*x^n)^q,x]+
    b/d*Integrate[(a+b*x^n)^(p-1)*(c+d*x^n)^(q+1),x] /;
FreeQ[{a,b,c,d,n},x] && RationalQ[{p,q}] && p>0 && q<=-1


Integrate[(a_.+b_.*x_^n_)^p_.*(c_.+d_.*x_^n_)^q_.,x_Symbol] :=
  b/(b*c-a*d)*Integrate[(a+b*x^n)^p*(c+d*x^n)^(q+1),x]-
    d/(b*c-a*d)*Integrate[(a+b*x^n)^(p+1)*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,n},x] && RationalQ[{p,q}] && p<-1 && q<=-1 && NonzeroQ[b*c-a*d]


(* This simplification should be done automatically by the built-in evaluator!. *)
Integrate[u_.*(a_+b_.*x_^n_.)^p_*(c_+d_.*x_^n_.)^q_,x_Symbol] :=
  (d/b)^q*Integrate[u*(a+b*x^n)^(p+q),x] /;
FreeQ[{a,b,c,d,n,p},x] && IntegerQ[q] && ZeroQ[b*c-a*d]


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x^n) / (c+d x^p)	Products of monomials and quotients of binomials (4)*)


Integrate[(a_.+b_.*x_^n_.)/(x_*(c_+d_.*x_^p_.)),x_Symbol] :=
  a*Log[x]/c+
    Integrate[x^(n-1)*(b*c-a*d*x^(p-n))/(c+d*x^p),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{n,p}] && 0<n<=p

(* Factoring out x from denominator should be done by normalization routine! *) 
Integrate[(a_.+b_.*x_^n_.)/(c_*x_+d_.*x_^p_.),x_Symbol] :=
  a*Log[x]/c+
    Integrate[x^(n-1)*(b*c-a*d*x^(p-n-1))/(c+d*x^(p-1)),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{n,p}] && 0<n<=p-1


Integrate[(a_.+b_.*x_^n_.)/(x_*(c_+d_.*x_^p_.)),x_Symbol] :=
  a*Log[x]/c+
    Integrate[x^(p-1)*(-a*d+b*c*x^(n-p))/(c+d*x^p),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{n,p}] && 0<p<=n

(* Factoring out x from denominator should be done by normalization routine! *) 
Integrate[(a_.+b_.*x_^n_.)/(c_*x_+d_.*x_^p_.),x_Symbol] :=
  a*Log[x]/c+
    Integrate[x^(p-2)*(-a*d+b*c*x^(n-p+1))/(c+d*x^(p-1)),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{n,p}] && 0<p-1<=n


Integrate[x_^m_*(a_.+b_.*x_^n_.)/(c_+d_.*x_^p_.),x_Symbol] :=
  a*x^(m+1)/(c*(m+1))+
    Integrate[x^(m+n)*(b*c-a*d*x^(p-n))/(c+d*x^p),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n,p}] && m<-1 && 0<n<=p


Integrate[x_^m_*(a_.+b_.*x_^n_.)/(c_+d_.*x_^p_.),x_Symbol] :=
  a*x^(m+1)/(c*(m+1))+
    Integrate[x^(m+p)*(-a*d+b*c*x^(n-p))/(c+d*x^p),x]/c /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n,p}] && m<-1 && 0<p<=n


(* ::Subsection::Closed:: *)
(*a + b x + c x^2			Integrands involving quadratic trinomials (31)*)


(* ::Subsubsection::Closed:: *)
(*u (a^2+2 a b x+b^2 x^2)^m		Products of monomials and powers of perfect squares of linears (1)*)


Integrate[u_.*(a_.+b_.*x_+c_.*x_^2)^m_,x_Symbol] :=
  Integrate[u*(b+2*c*x)^(2*m),x]/(4*c)^m /;
FreeQ[{a,b,c},x] && ZeroQ[b^2-4*a*c] && IntegerQ[m] && (m<0 || u===1)


(* ::Subsubsection::Closed:: *)
(*x^m / (a+b x+c x^2)			Quotients of monomials by quadratic trinomials (8)*)


(* GR5 2.172.4, CRC 109 *)
Integrate[1/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  2*ArcTan[(b+2*c*x)/Rt[4*a*c-b^2,2]]/Rt[4*a*c-b^2,2] /;
FreeQ[{a,b,c},x] && PosQ[4*a*c-b^2]


(* GR5 2.172.2, CRC 110a *)
Integrate[1/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  -2*ArcTanh[(b+2*c*x)/Rt[b^2-4*a*c,2]]/Rt[b^2-4*a*c,2] /;
FreeQ[{a,b,c},x] && PosQ[b^2-4*a*c]


(* Necessary because splitting integrand into a sum using CRC 114 leads to the Log of a
	quadratic plus an ArcTan or ArcTanh, instead of 2 Logs of linears. *)
(* Calls Integrate instead of Log directly so constant factors are removed! *)
Integrate[x_/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  Module[{q=Rt[b^2-4*a*c,2]},
  (1-b/q)*Integrate[1/(b-q+2*c*x),x]+
	(1+b/q)*Integrate[1/(b+q+2*c*x),x]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


(* GR5 2.175.1, CRC 114 *)
Integrate[x_/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  Log[a+b*x+c*x^2]/(2*c)-
    b/(2*c)*Integrate[1/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c},x]


Integrate[1/(x_*(a_+b_.*x_+c_.*x_^2)),x_Symbol] :=
  Log[x]/a-
    1/a*Integrate[(b+c*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c},x]


(* GR5 2.174.1, CRC 119 *)
Integrate[x_^m_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  x^(m-1)/(c*(m-1))-
    1/c*Integrate[x^(m-2)*(a+b*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c},x] && RationalQ[m] && m>1


(* GR5 2.265c *)
Integrate[x_^m_/(b_.*x_+c_.*x_^2),x_Symbol] :=
  x^m/(b*m)-
    c/b*Integrate[x^(m+1)/(b*x+c*x^2),x] /;
FreeQ[{b,c},x] && RationalQ[m] && m<-1


(* GR5 2.176, CRC 123 *)
Integrate[x_^m_/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  x^(m+1)/(a*(m+1))-
    1/a*Integrate[x^(m+1)*(b+c*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c},x] && RationalQ[m] && m<-1


(* ::Subsubsection::Closed:: *)
(*x^m (d+e x) / (a+b x+c x^2)		Products of monomials and quotients of linears by quadratic trinomials (4)*)


(* These way kool, and to my knowledge original, rules reduce the degree of monomial without
	increasing the complexity of the integrands. *)


(* Calls Integrate instead of Log directly so constant factors are removed! *)
Integrate[(d_+e_.*x_)/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  Module[{q=Rt[b^2-4*a*c,2]},
  (e+(2*c*d-b*e)/q)*Integrate[1/(b-q+2*c*x),x]+
	(e-(2*c*d-b*e)/q)*Integrate[1/(b+q+2*c*x),x]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && NonzeroQ[2*c*d-b*e]


Integrate[(d_+e_.*x_)/(x_*(a_+b_.*x_+c_.*x_^2)),x_Symbol] :=
  d*Log[x]/a-
    1/a*Integrate[(b*d-a*e+c*d*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x]


Integrate[x_^m_.*(d_.+e_.*x_)/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*x^m/(c*m)-
    1/c*Integrate[x^(m-1)*(a*e+(b*e-c*d)*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && RationalQ[m] && m>0


Integrate[x_^m_.*(d_.+e_.*x_)/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  d*x^(m+1)/(a*(m+1))-
    1/a*Integrate[x^(m+1)*(b*d-a*e+c*d*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && RationalQ[m] && m<-1


(* ::Subsubsection::Closed:: *)
(*(a+b x+c x^2)^n			Powers of quadratic trinomials (7)*)


(* GR5 2.261.2, CRC 237b *)
Integrate[1/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  ArcSinh[(b+2*c*x)/Sqrt[4*a*c-b^2]]/Sqrt[c] /;
FreeQ[{a,b,c},x] && PositiveQ[c] && PositiveQ[4*a*c-b^2]


(* GR5 2.261.1, CRC 237a *)
Integrate[1/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  Log[b/(2*Rt[c,2])+Rt[c,2]*x+Sqrt[a+b*x+c*x^2]]/Rt[c,2] /;
FreeQ[{a,b,c},x] && PosQ[c]


(* GR5 2.261.3, CRC 238 *)
Integrate[1/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  -ArcSin[(b+2*c*x)/Sqrt[b^2-4*a*c]]/Sqrt[-c] /;
FreeQ[{a,b,c},x] && NegativeQ[c] && PositiveQ[b^2-4*a*c]


(* CRC 238' *)
Integrate[1/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  ArcTan[(-2*c*x-b)/(2*Rt[-c,2]*Sqrt[a+b*x+c*x^2])]/Rt[-c,2] /;
FreeQ[{a,b,c},x] && PosQ[-c]


(* GR5 2.264.5, CRC 239 *)
Integrate[1/(a_.+b_.*x_+c_.*x_^2)^(3/2),x_Symbol] :=
  -2*(b+2*c*x)/((b^2-4*a*c)*Sqrt[a+b*x+c*x^2]) /;
FreeQ[{a,b,c},x]


(* GR5 2.260.2, CRC 245 *)
Integrate[(a_.+b_.*x_+c_. x_^2)^n_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^n/(2*c*(2*n+1))+
    n*(4*a*c-b^2)/(2*c*(2*n+1))Integrate[(a+b*x+c*x^2)^(n-1),x] /;
FreeQ[{a,b,c},x] && FractionQ[n] && n>0


(* GR5 2.171.3, GR5 2.263.3, CRC 113,241 *)
Integrate[(a_.+b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^(n+1)/((n+1)*(b^2-4*a*c))-
    2*c*(2*n+3)/((n+1)*(b^2-4*a*c))*Integrate[(a+b*x+c*x^2)^(n+1),x] /;
FreeQ[{a,b,c},x] && RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*(a+b x+c x^2)^n / x			Quotients of powers of quadratic trinomials by integration variable (5)*)


(* GR5 2.266.1', CRC 258' *)
Integrate[1/(x_*Sqrt[a_+b_.*x_^n_.+c_.*x_^m_.]),x_Symbol] :=
  Log[x]/Rt[a,2]-Log[2*a+b*x^n+2*Rt[a,2]*Sqrt[a+b*x^n+c*x^m]]/(n*Rt[a,2]) /;
FreeQ[{a,b,c,m,n},x] && 2*n===m && PosQ[a]


(* GR5 2.266.3, CRC 259 *)
Integrate[1/(x_*Sqrt[a_+b_.*x_^n_.+c_.*x_^m_.]),x_Symbol] :=
  ArcTan[(2*a+b*x^n)/(2*Rt[-a,2]*Sqrt[a+b*x^n+c*x^m])]/(n*Rt[-a,2]) /;
FreeQ[{a,b,c,m,n},x] && 2*n===m && PosQ[-a]


(* GR5 2.266.7, CRC 260 *)
Integrate[1/(x_*Sqrt[b_.*x_^n_.+c_.*x_^m_.]),x_Symbol] :=
  -2*Sqrt[b*x^n+c*x^m]/(b*n*x^n) /;
FreeQ[{b,c,m,n},x] && 2*n===m


(* GR5 2.265b *)
Integrate[(a_.+b_.*x_+c_.*x_^2)^n_/x_,x_Symbol] :=
  (a+b*x+c*x^2)^n/(2*n)+
    b/2*Integrate[(a+b*x+c*x^2)^(n-1),x]+
    a*Integrate[(a+b*x+c*x^2)^(n-1)/x,x] /;
FreeQ[{a,b,c},x] && FractionQ[n] && n>0


(* GR5 2.268b, CRC 122 *)
Integrate[(a_+b_.*x_+c_.*x_^2)^n_/x_,x_Symbol] :=
  -(a+b*x+c*x^2)^(n+1)/(2*(n+1)*a)-
    b/(2*a)*Integrate[(a+b*x+c*x^2)^n,x]+
    1/a*Integrate[(a+b*x+c*x^2)^(n+1)/x,x] /;
FreeQ[{a,b,c},x] && RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x+c x^2)^n			Products of monomials and powers of quadratic trinomials (6)*)


(* GR5 2.174.2' *)
Integrate[x_^m_*(a_.+b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  -x^(m-1)*(a+b*x+c*x^2)^(n+1)/(c*(m-1))-
    b/(2*c)*Integrate[x^(m-1)*(a+b*x+c*x^2)^n,x]+
    1/c*Integrate[x^(m-2)*(a+b*x+c*x^2)^(n+1),x] /;
FreeQ[{a,b,c},x] && RationalQ[{m,n}] && n<-1 && ZeroQ[2*n+m+1]


(* GR5 2.174.1', CRC 119' *)
Integrate[x_*(a_.+b_.*x_+c_. x_^2)^n_,x_Symbol] :=
  (a+b*x+c*x^2)^(n+1)/(2*c*(n+1))-
    b/(2*c)*Integrate[(a+b*x+c*x^2)^n,x] /;
FreeQ[{a,b,c,n},x] && Not[IntegerQ[n] && n>=-1]


(* GR5 2.174.1', CRC 119' *)
Integrate[x_^m_*(a_.+b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  x^(m-1)*(a+b*x+c*x^2)^(n+1)/(c*(n+1))+
    a/c*Integrate[x^(m-2)*(a+b*x+c*x^2)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[m] && m>1 && ZeroQ[m+n] && Not[IntegerQ[n] && n>0]


(* GR5 2.174.1, CRC 119 *)
Integrate[x_^m_*(a_.+b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  x^(m-1)*(a+b*x+c*x^2)^(n+1)/(c*(2*n+m+1))-
    b*(m+n)/(c*(2*n+m+1))*Integrate[x^(m-1)*(a+b*x+c*x^2)^n,x]-
    a*(m-1)/(c*(2*n+m+1))*Integrate[x^(m-2)*(a+b*x+c*x^2)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[m] && m>1 && NonzeroQ[2*n+m+1] &&
		NonzeroQ[m+n] && Not[IntegerQ[n] && n>=-1]


(* GR5 2.265c *)
Integrate[x_^m_*(b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  x^m*(b*x+c*x^2)^(n+1)/((m+n+1)*b)-
    (m+2*(n+1))/(m+n+1)*(c/b)*Integrate[x^(m+1)*(b*x+c*x^2)^n,x] /;
FreeQ[{b,c,n},x] && RationalQ[m] && m<-1 && Not[IntegerQ[n] && n>=-1]


(* GR5 2.176, CRC 123 *)
Integrate[x_^m_*(a_+b_.*x_+c_.*x_^2)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x+c*x^2)^(n+1)/((m+1)*a)-
    (m+n+2)/(m+1)*(b/a)*Integrate[x^(m+1)*(a+b*x+c*x^2)^n,x]-
    (m+2*n+3)/(m+1)*(c/a)*Integrate[x^(m+2)*(a+b*x+c*x^2)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[m] && m<-1 && Not[IntegerQ[n] && n>=-1]


(* ::Subsection::Closed:: *)
(*a + b x^n + c x^(2n)		Integrands involving symmetric trinomials (18)*)


(* ::Subsubsection::Closed:: *)
(*u (a^2+2 a b x^n+b^2 x^(2 n))^m	Products involving powers of perfect squares of binomials (1)*)


Integrate[u_.*(a_.+b_.*x_^n_+c_.*x_^p_.)^m_,x_Symbol] :=
  Integrate[u*(b+2*c*x^n)^(2*m),x]/(4*c)^m /;
FreeQ[{a,b,c,n,p},x] && p===2*n && ZeroQ[b^2-4*a*c] && IntegerQ[m] && m<0


(* ::Subsubsection::Closed:: *)
(*(a+b x^k+c x^(2k))^n			Powers of symmetric trinomials (2)*)


(* GR5 2.161.1a' *)
Integrate[1/(a_+b_.*x_^k_+c_.*x_^j_.),x_Symbol] :=
  Module[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Integrate[1/(b-q+2*c*x^k),x]-
	2*c/q*Integrate[1/(b+q+2*c*x^k),x]] /;
FreeQ[{a,b,c,j,k},x] && j===2*k && NonzeroQ[b^2-4*a*c] && Not[NegativeQ[b^2-4*a*c]]


(* GR5 2.161.5' (GR5 2.161.4 is a special case.) *)
(* Previously undiscovered rule??? *)
Integrate[(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  -x*(b^2-2*a*c+b*c*x^k)*(a+b*x^k+c*x^j)^(n+1)/(k*a*(n+1)*(b^2-4*a*c)) +
    (k*(n+1)*(b^2-4*a*c)+b^2-2*a*c)/(k*a*(n+1)*(b^2-4*a*c))*Integrate[(a+b*x^k+c*x^j)^(n+1),x] +
    (k*(2*n+3)+1)*b*c/(k*a*(n+1)*(b^2-4*a*c))*Integrate[x^k*(a+b*x^k+c*x^j)^(n+1),x] /;
FreeQ[{a,b,c,j,k},x] && RationalQ[n] && j===2*k && n<-1 && NonzeroQ[b^2-4*a*c]


(* ::Subsubsection::Closed:: *)
(*x^m / (a+b x^k+c x^(2k))		Quotients of monomials by symmetric trinomials (4)*)


(* GR5 2.177.1', CRC 120' *)
(* This rule does not use the obvious substitution u=x^k on the whole integrand reducing it
	to 1/(x*(a+b*x+c*x^2)) so that Log[x] instead of Log[x^k] appears in the result *)
Integrate[1/(x_*(a_+b_.*x_^k_+c_.*x_^j_.)),x_Symbol] :=
  Log[x]/a-
    1/(a*k)*Subst[Integrate[(b+c*x)/(a+b*x+c*x^2),x],x,x^k] /;
(*  1/a*Integrate[x^(k-1)*(b+c*x^k)/(a+b*x^k+c*x^j),x] /; *)
FreeQ[{a,b,c,j,k},x] && j===2*k


(* GR5 2.161.3' *)
Integrate[x_^k_/(a_+b_.*x_^k_+c_.*x_^j_.),x_Symbol] :=
  Module[{q=Rt[b^2-4*a*c,2]},
  (1-b/q)*Integrate[1/(b-q+2*c*x^k),x]+
	(1+b/q)*Integrate[1/(b+q+2*c*x^k),x]] /;
FreeQ[{a,b,c,j,k},x] && j===2*k && NonzeroQ[b^2-4*a*c] && Not[NegativeQ[b^2-4*a*c]]


(* GR5 2.174.1', CRC 119' *)
Integrate[x_^m_./(a_+b_.*x_^k_+c_.*x_^j_),x_Symbol] :=
  x^(m-j+1)/(c*(m-j+1))-
    1/c*Integrate[x^(m-j)*(a+b*x^k)/(a+b*x^k+c*x^(2k)),x] /;
FreeQ[{a,b,c,j,k},x] && j===2*k && RationalQ[{m,k}] && 0<j<m+1


(* GR5 2.176', CRC 123' *)
Integrate[x_^m_/(a_+b_.*x_^k_+c_.*x_^j_),x_Symbol] :=
  x^(m+1)/(a*(m+1))-
    1/a*Integrate[x^(m+k)*(b+c*x^k)/(a+b*x^k+c*x^j),x] /;
FreeQ[{a,b,c,j,k},x] && j===2*k && RationalQ[{m,k}] && m<-1 && k>0


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x^k+c x^(2k))^n		Products of monomials and powers of symmetric trinomials (7)*)


(* GR5 2.160.4 *)
Integrate[x_^m_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x^k+c*x^j)^n/(m+j*n+1) +
    a*j*n/(m+j*n+1)*Integrate[x^m*(a+b*x^k+c*x^j)^(n-1),x] +
    b*k*n/(m+j*n+1)*Integrate[x^(m+k)*(a+b*x^k+c*x^j)^(n-1),x] /;
FreeQ[{a,b,c},x] && RationalQ[{j,k,m,n}] && j==2*k && j>0 && m<-1 && n>1 && NonzeroQ[m+j*n+1]


(* GR5 2.160.3' *)
Integrate[x_^m_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x^(m-j+1)*(a+b*x^k+c*x^j)^(n+1)/(c*k*(n+1)) +
    a/c*Integrate[x^(m-j)*(a+b*x^k+c*x^j)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[{j,k,m}] && j===2*k && 0<j<=m && NonzeroQ[n+1] &&
		ZeroQ[m+k*(n-1)+1] && Not[IntegerQ[n] && n>=-1]


(* GR5 2.160.3 (GR5 2.174.1 is a special case.) *)
Integrate[x_^m_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x^(m-j+1)*(a+b*x^k+c*x^j)^(n+1)/(c*(m+j*n+1)) -
    b*(m+k*(n-1)+1)/(c*(m+j*n+1))*Integrate[x^(m-k)*(a+b*x^k+c*x^j)^n,x] -
    a*(m-j+1)/(c*(m+j*n+1))*Integrate[x^(m-j)*(a+b*x^k+c*x^j)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[{j,k,m}] && j==2*k && 0<j<=m && NonzeroQ[m+j*n+1] &&
		NonzeroQ[m+k*(n-1)+1] && Not[IntegerQ[n] && n>=-1]


(* GR5 2.160.2 *)
Integrate[x_^m_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x^k+c*x^j)^n/(m+1) -
    b*k*n/(m+1)*Integrate[x^(m+k)*(a+b*x^k+c*x^j)^(n-1),x] -
    c*j*n/(m+1)*Integrate[x^(m+j)*(a+b*x^k+c*x^j)^(n-1),x] /;
FreeQ[{a,b,c},x] && RationalQ[{j,k,m,n}] && j==2*k && j>0 && m<-1 && n>1


(* GR5 2.160.1 (GR5 2.161.6 is a special case.) *)
Integrate[x_^m_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x^(m+1)*(a+b*x^k+c*x^j)^(n+1)/(a*(m+1)) -
    b*(m+1+k*(n+1))/(a*(m+1))*Integrate[x^(m+k)*(a+b*x^k+c*x^j)^n,x] -
    c*(m+1+j*(n+1))/(a*(m+1))*Integrate[x^(m+j)*(a+b*x^k+c*x^j)^n,x] /;
FreeQ[{a,b,c,n},x] && RationalQ[{j,k,m}] && j==2*k && j>0 && m<-1 && Not[RationalQ[n] && n>1]


(* Previously undiscovered rules??? *)
Integrate[x_^k_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x*(b+2*c*x^k)*(a+b*x^k+c*x^j)^n/(2*c*(k*(2*n+1)+1)) - 
    b*Integrate[(a+b*x^k+c*x^j)^n, x]/(2*c*(k*(2*n+1)+1)) - 
    k*n*(b^2-4*a*c)/(2*c*(k*(2*n+1)+1))*Integrate[x^k*(a+b*x^k+c*x^j)^(n-1), x] /;
FreeQ[{a,b,c,j,k},x] && RationalQ[n] && j===2*k && n>0 && NonzeroQ[b^2-4*a*c] &&
	NonzeroQ[k*(2*n+1)+1]


Integrate[x_^k_*(a_+b_.*x_^k_+c_.*x_^j_.)^n_,x_Symbol] :=
  x*(b+2*c*x^k)*(a+b*x^k+c*x^j)^(n+1)/(k*(n+1)*(b^2-4*a*c)) - 
    b/(k*(n+1)*(b^2-4*a*c))*Integrate[(a+b*x^k+c*x^j)^(n+1),x] -
    2*c*(k*(2*n+3)+1)/(k*(n+1)*(b^2-4*a*c))*Integrate[x^k*(a+b*x^k+c*x^j)^(n+1),x] /;
FreeQ[{a,b,c,j,k},x] && RationalQ[n] && j===2*k && n<-1 && NonzeroQ[b^2-4*a*c]


(* ::Subsubsection::Closed:: *)
(*x^m (d+e x^k) / (a+b x^k+c x^(2k))	Products of monomials and quotients of binomials by symmetric trinomials (4)*)


(* These way kool, and to my knowledge original, rules reduce the degree of monomial without
	increasing the complexity of the integrands. *)


Integrate[(d_+e_.*x_^k_)/(a_+b_.*x_^k_+c_.*x_^j_.),x_Symbol] :=
  Module[{q=Rt[b^2-4*a*c,2]},
  (e+(2*c*d-b*e)/q)*Integrate[1/(b-q+2*c*x^k),x]+
	(e-(2*c*d-b*e)/q)*Integrate[1/(b+q+2*c*x^k),x]] /;
FreeQ[{a,b,c,d,e,j,k},x] && j===2*k && NonzeroQ[b^2-4*a*c] && Not[NegativeQ[b^2-4*a*c]]


(* This rule does not use the obvious substitution u=x^k on the whole integrand reducing it
	to (d+e*x)/(x*(a+b*x+c*x^2)) so that Log[x] instead of Log[x^k] appears in the result *)
Integrate[(d_.+e_.*x_^k_)/(x_*(a_+b_.*x_^k_+c_.*x_^j_.)),x_Symbol] :=
  d*Log[x]/a-
    1/(a*k)*Subst[Integrate[(b*d-a*e+c*d*x)/(a+b*x+c*x^2),x],x,x^k] /;
(*  1/a*Integrate[x^(k-1)*(b*d-a*e+c*d*x^k)/(a+b*x^k+c*x^j),x] /; *)
FreeQ[{a,b,c,d,e,j,k},x] && j===2*k


Integrate[x_^m_.*(d_.+e_.*x_^k_)/(a_+b_.*x_^k_+c_.*x_^j_.),x_Symbol] :=
  e*x^(m-k+1)/(c*(m-k+1))-
    1/c*Integrate[x^(m-k)*(a*e+(b*e-c*d)*x^k)/(a+b*x^k+c*x^j),x] /;
FreeQ[{a,b,c,d,e,j,k},x] && j===2*k && RationalQ[{m,k}] && 0<k<m+1


Integrate[x_^m_*(d_.+e_.*x_^k_)/(a_+b_.*x_^k_+c_.*x_^j_.),x_Symbol] :=
  d*x^(m+1)/(a*(m+1))-
    1/a*Integrate[x^(m+k)*(b*d-a*e+c*d*x^k)/(a+b*x^k+c*x^j),x] /;
FreeQ[{a,b,c,d,e,j,k},x] && j===2*k && RationalQ[{m,k}] && m<-1 && k>0


(* ::Subsection::Closed:: *)
(*a + b x^2 + c x^4		Integrands involving quartic trinomials (3)*)


(* ::Subsubsection::Closed:: *)
(*(a+b x^2+c x^4)^n			Products of monomials and powers of quartic trinomials (2)*)


Integrate[Sqrt[b_.*x_^2+c_.*x_^4],x_Symbol] :=
  (b*x^2+c*x^4)^(3/2)/(3*c*x^3) /;
FreeQ[{b,c},x]


(* GR5 2.161.1b? *)
Integrate[1/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Module[{q=2*Rt[a/c,2]-b/c},
  1/(2*c*Rt[a/c,2]*Rt[q,2])*
	(Integrate[(x+Rt[q,2])/(x^2+x*Rt[q,2]+Rt[a/c,2]),x]-
	 Integrate[(x-Rt[q,2])/(x^2-x*Rt[q,2]+Rt[a/c,2]),x]) /;
 PosQ[q]] /;  
FreeQ[{a,b,c},x] && PosQ[a/c] && NegativeQ[b^2-4*a*c]


(* ::Subsubsection::Closed:: *)
(*x^m (a+b x^2+c x^4)^n		Products of monomials and powers of quartic trinomials (1)*)


Integrate[x_^m_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Module[{q=2*Rt[a/c,2]-b/c},
  1/(2*c*Rt[a/c,2]*Rt[q,2])*
	(Integrate[x^m*(x+Rt[q,2])/(x^2+x*Rt[q,2]+Rt[a/c,2]),x]-
	 Integrate[x^m*(x-Rt[q,2])/(x^2-x*Rt[q,2]+Rt[a/c,2]),x]) /;
 PosQ[q]] /;  
FreeQ[{a,b,c,m},x] && Not[OddQ[m]] && PosQ[a/c] && NegativeQ[b^2-4*a*c]


(* ::Subsection::Closed:: *)
(*x^m ((a+b x)/(c+d x))^n		Products of monomials and powers of quotients of linears (3)*)


Integrate[(e_.*(a_.+b_.*x_)/(c_.+d_.*x_))^n_,x_Symbol] :=
  Module[{p=Denominator[n]},
  e*p*(b*c-a*d)*Subst[Integrate[x^(p*n+p-1)/(b*e-d*x^p)^2,x],x,(e*(a+b*x)/(c+d*x))^(1/p)]] /;
FreeQ[{a,b,c,d,e},x] && FractionQ[n] && NonzeroQ[b*c-a*d]


Integrate[x_^m_.*(e_.*(a_.+b_.*x_)/(c_.+d_.*x_))^n_,x_Symbol] :=
  Module[{p=Denominator[n]},
  e*p*(b*c-a*d)*Subst[Integrate[x^(p*n+p-1)*(-a*e+c*x^p)^m/(b*e-d*x^p)^(m+2),x],x,
			(e*(a+b*x)/(c+d*x))^(1/p)]] /;
FreeQ[{a,b,c,d,e},x] && IntegerQ[m] && FractionQ[n] && NonzeroQ[b*c-a*d]


Integrate[(f_+g_.*x_)^m_*(e_.*(a_.+b_.*x_)/(c_.+d_.*x_))^n_,x_Symbol] :=
  Subst[Integrate[x^m*(e*(a-b*f/g+b/g*x)/(c-d*f/g+d/g*x))^n,x],x,f+g*x]/g /;
FreeQ[{a,b,c,d,e,f,g},x] && IntegerQ[m] && m<0 && FractionQ[n] && NonzeroQ[b*c-a*d]


(* ::Subsection::Closed:: *)
(*P(x)/Q(x)^n			Quotient of polynomials and powers of polynomials (1)*)


(* Finds one term of the rational part of the antiderivative, thereby reducing the degree of
	the polynomial in the numerator of the integrand.  Equivalent to the Ostrogradskiy-Hermite
	method (GR5 2.104) but without the need to solve a system of linear equations. *) 
(* If m+1>=n and m+1-n*p!=0, let c=pm/(qm*(m+1-n*p)), then Integrate[Pm[x]/Qn[x]^p,x] -->
	c*x^(m-n+1)/Qn[x]^(p-1)+
		Integrate[(Pm[x]-c*x^(m-n)*((m-n+1)*Qn[x]+(1-p)*x*D[Qn[x],x]))/Qn[x]^p,x] *)
If[ShowSteps,

Integrate[u_*v_^p_,x_Symbol] :=
  Module[{m=Exponent[u,x],n=Exponent[v,x]},
  ShowStep["If m+1>=n and m+1-n*p!=0, let c=pm/(qm*(m+1-n*p)), then",
	"Integrate[Pm[x]/Qn[x]^p,x]",
	"c*x^(m-n+1)/Qn[x]^(p-1)+Integrate[(Pm[x]-c*x^(m-n)*((m-n+1)*Qn[x]+(1-p)*x*D[Qn[x],x]))/Qn[x]^p,x]",
	Hold[
  Module[{c=Coefficient[u,x,m]/(Coefficient[v,x,n]*(m+1+n*p))},
  c*x^(m-n+1)*v^(p+1)+
    Integrate[Simplify[u-c*x^(m-n)*((m-n+1)*v+(p+1)*x*D[v,x])]*v^p,x]]]] /;
 m+1>=n && m+1+n*p!=0] /;
SimplifyFlag && RationalQ[p] && p<-1 && PolynomialQ[{u,v},x] && Exponent[v,x]>1,

Integrate[u_*v_^p_,x_Symbol] :=
  Module[{m=Exponent[u,x],n=Exponent[v,x]},
  Module[{c=Coefficient[u,x,m]/(Coefficient[v,x,n]*(m+1+n*p))},
  c*x^(m-n+1)*v^(p+1)+
    Integrate[Simplify[u-c*x^(m-n)*((m-n+1)*v+(p+1)*x*D[v,x])]*v^p,x]] /;
 m+1>=n && m+1+n*p!=0] /;
RationalQ[p] && p<-1 && PolynomialQ[{u,v},x] && Exponent[v,x]>1]


(* ::Subsection::Closed:: *)
(*x^m (a+b u)/(c+d u)		Products of monomials and quotients of linear functions of u(x) (4)*)


Integrate[(a_.+b_.*u_)/(c_.+d_.*u_),x_Symbol] :=
  b*x/d /;
FreeQ[{a,b,c,d},x] && ZeroQ[a*d-b*c]


Integrate[x_^m_.*(a_.+b_.*u_)/(c_.+d_.*u_),x_Symbol] :=
  b/d*Integrate[x^m,x] /;
FreeQ[{a,b,c,d,m},x] && ZeroQ[a*d-b*c]


Integrate[(a_.+b_.*u_)/(c_.+d_.*u_),x_Symbol] :=
  b*x/d+
    (a*d-b*c)/d*Integrate[1/(c+d*u),x] /;
FreeQ[{a,b,c,d},x] && NonzeroQ[a*d-b*c] &&
	Not[a===0 && (PowerQ[u] && RationalQ[u[[2]]] && u[[2]]<0 || MatchQ[u,f_^(g_.+h_.*x)])]


Integrate[x_^m_.*(a_.+b_.*u_)/(c_.+d_.*u_),x_Symbol] :=
  b/d*Integrate[x^m,x]+
    (a*d-b*c)/d*Integrate[x^m/(c+d*u),x] /;
FreeQ[{a,b,c,d,m},x] && NonzeroQ[a*d-b*c] &&
	Not[a===0 && (PowerQ[u] && RationalQ[u[[2]]] && u[[2]]<0 || MatchQ[u,f_^(g_.+h_.*x)])]


(* ::Subsection::Closed:: *)
(*u + v				Sums (1)*)


(* CRC 2,4 *)
(* Integrate[a*u+b*v+\[CenterEllipsis],x] --> a*Integrate[u,x]+b*Integrate[v,x]+\[CenterEllipsis] *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  ShowStep["","Integrate[a*u+b*v+\[CenterEllipsis],x]","a*Integrate[u,x]+b*Integrate[v,x]+\[CenterEllipsis]",Hold[
  Map[Function[IndependentFactors[#,x]*Integrate[DependentFactors[#,x],x]],u]]] /;
SimplifyFlag && SumQ[u],

Integrate[u_,x_Symbol] :=
  Map[Function[IndependentFactors[#,x]*Integrate[DependentFactors[#,x],x]],u] /;
SumQ[u]]


(* ::Subsection::Closed:: *)
(*Sqrt[a x+Sqrt[b+a^2 x^2]]	Nested square roots (2)*)


Integrate[Sqrt[a_.*x_+Sqrt[b_+c_.*x_^2]], x_Symbol] :=
  2*(2*a*x-Sqrt[b+c*x^2])*Sqrt[a*x+Sqrt[b+c*x^2]]/(3*a) /;
FreeQ[{a,b,c},x] && c===a^2


Integrate[Sqrt[a_.*x_-Sqrt[b_+c_.*x_^2]], x_Symbol] :=
  2*(2*a*x+Sqrt[b+c*x^2])*Sqrt[a*x-Sqrt[b+c*x^2]]/(3*a) /;
FreeQ[{a,b,c},x] && c===a^2


(* ::Subsection::Closed:: *)
(*Sqrt[a+Sqrt[a^2+b x^2]]	Nested square roots (2)*)


Integrate[Sqrt[a_+Sqrt[c_+b_.*x_^2]], x_Symbol] :=
  2*Sqrt[a+Sqrt[a^2+b*x^2]]*(-a^2+b*x^2+a*Sqrt[a^2+b*x^2])/(3*b*x) /;
FreeQ[{a,b,c},x] && c===a^2


Integrate[Sqrt[a_-Sqrt[c_+b_.*x_^2]], x_Symbol] :=
  2*Sqrt[a-Sqrt[a^2+b*x^2]]*(-a^2+b*x^2-a*Sqrt[a^2+b*x^2])/(3*b*x) /;
FreeQ[{a,b,c},x] && c===a^2


(* ::Subsection::Closed:: *)
(*u / (v+Sqrt[w])			Rationalization of denominators (9)*)


Integrate[u_./(a_.*x_^m_.+b_.*Sqrt[c_.*x_^n_]),x_Symbol] :=
  Integrate[u*(a*x^m-b*Sqrt[c*x^n])/(a^2*x^(2*m)-b^2*c*x^n),x] /;
FreeQ[{a,b,c,m,n},x]


Integrate[u_./(e_.*Sqrt[a_.+b_.*x_^n_.]+f_.*Sqrt[c_.+d_.*x_^n_.]),x_Symbol] :=
  Integrate[u*(e*Sqrt[a+b*x^n]-f*Sqrt[c+d*x^n]),x]/(a*e^2-c*f^2) /;
FreeQ[{a,b,c,d,e,f,n},x] && ZeroQ[b*e^2-d*f^2]


Integrate[u_./(e_.*Sqrt[a_.+b_.*x_^n_.]+f_.*Sqrt[c_.+d_.*x_^n_.]),x_Symbol] :=
  Integrate[u*(e*Sqrt[a+b*x^n]-f*Sqrt[c+d*x^n])/x^n,x]/(b*e^2-d*f^2) /;
FreeQ[{a,b,c,d,e,f,n},x] && ZeroQ[a*e^2-c*f^2]


Integrate[u_./(a_+b_.*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  -a/(b^2*d)*Integrate[u/x^n,x] +
    Integrate[u*Sqrt[c+d*x^n]/x^n,x]/(b*d) /;
FreeQ[{a,b,c,d,n},x] && a^2===b^2*c


Integrate[u_./(a_.*x_^m_.+b_.*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  -a/(b^2*c)*Integrate[u*x^m,x] +
    Integrate[u*Sqrt[c+d*x^n],x]/(b*c) /;
FreeQ[{a,b,c,d,m,n},x] && n===2*m && a^2===b^2*d


Integrate[u_./(a_+b_.*x_^m_.+c_.*Sqrt[d_+e_.*x_^n_]),x_Symbol] :=
  Integrate[u/x^m,x]/(2*b) +
    Integrate[u,x]/(2*a) -
    c/(2*a*b)*Integrate[u*Sqrt[d+e*x^n]/x^m,x] /;
FreeQ[{a,b,c,d,m,n},x] && n===2*m && a^2===c^2*d && b^2===c^2*e


Integrate[u_./(a_+b_.*x_^m_.+c_.*Sqrt[d_+e_.*x_^n_]),x_Symbol] :=
  a/b^2*Integrate[u/x^(2*m),x] +
    Integrate[u/x^m,x]/b -
    c/b^2*Integrate[u*Sqrt[d+e*x^n]/x^(2*m),x] /;
FreeQ[{a,b,c,d,m,n},x] && n===m && a^2===c^2*d && 2*a*b===c^2*e


(* Integrate[u_./(e_.*Sqrt[a_.+b_.*x_]+f_.*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  Integrate[u*(e*Sqrt[a+b*x]-f*Sqrt[c+d*x])/(a*e^2-c*f^2+(b*e^2-d*f^2)*x),x] /;
FreeQ[{a,b,c,d,e,f},x] *)


Integrate[u_./(a_.*x_+b_.*Sqrt[c_.+d_.*x_^2]),x_Symbol] :=
  a*Integrate[x*u/(-b^2*c+(a^2-b^2*d)*x^2),x]-
    b*Integrate[u*Sqrt[c+d*x^2]/(-b^2*c+(a^2-b^2*d)*x^2),x] /;
FreeQ[{a,b,c,d},x]


Integrate[u_./(e_.*Sqrt[(a_.+b_.*x_^n_.)^p_.]+f_.*Sqrt[(a_.+b_.*x_^n_.)^q_.]),x_Symbol] :=
  Integrate[u*(e*Sqrt[(a+b*x^n)^p]-f*Sqrt[(a+b*x^n)^q])/(e^2*(a+b*x^n)^p-f^2*(a+b*x^n)^q),x] /;
FreeQ[{a,b,e,f},x] && IntegerQ[{n,p,q}]


(* Integrate[u_./(v_+a_.*Sqrt[w_]),x_Symbol] :=
  Integrate[u*v/(v^2-a^2*w),x]-
    a*Integrate[u*Sqrt[w]/(v^2-a^2*w),x] /;
FreeQ[a,x] && PolynomialQ[v,x] *)


(* Integrate[u_./(a_.*x_+b_.*Sqrt[c_+d_.*x_]),x_Symbol] :=
  Integrate[(a*x*u-b*u*Sqrt[c+d*x])/(-b^2*c-b^2*d*x+a^2*x^2),x] /;
FreeQ[{a,b,c,d},x] *)


(* ::Subsection::Closed:: *)
(*u Sqrt[c+d x]/(a+b x)		Rationalization of numerator (1)*)


Integrate[u_.*Sqrt[c_+d_.*x_^2]/(a_+b_.*x_),x_Symbol] :=
  Integrate[(u*a-u*b*x)/Sqrt[c+d*x^2],x] /;
FreeQ[{a,b,c,d},x] && c===a^2 && d===-b^2


(* ::Section::Closed:: *)
(*Elementary Function Rules (571)*)


(* ::Subsection::Closed:: *)
(*Exponential Functions (46)*)


(* ::Subsubsection::Closed:: *)
(*f^(a+b x^n)			Exponentials of binomials (5)*)


(* GR5 2.311, CRC 519 *)
Integrate[E^x_,x_Symbol] :=
  E^x

Integrate[E^(a_.+b_.*x_),x_Symbol] :=
  E^(a+b*x)/b /;
FreeQ[{a,b},x]

Integrate[f_^(a_.+b_.*x_),x_Symbol] :=
  f^(a+b*x)/(b*Log[f]) /;
FreeQ[{a,b,f},x]


Integrate[E^(x_^2),x_Symbol] :=
  Sqrt[Pi]*Erfi[x]/2

Integrate[f_^(a_.+b_.*x_^2),x_Symbol] :=
  f^a*Sqrt[Pi]*Erfi[x*Rt[b*Log[f],2]]/(2*Rt[b*Log[f],2]) /;
FreeQ[{a,b,f},x] && PosQ[b*Log[f]]


Integrate[E^(-x_^2),x_Symbol] :=
  Sqrt[Pi]*Erf[x]/2

Integrate[f_^(a_.+b_.*x_^2),x_Symbol] :=
  f^a*Sqrt[Pi]*Erf[x*Rt[-b*Log[f],2]]/(2*Rt[-b*Log[f],2]) /;
FreeQ[{a,b,f},x] && PosQ[-b*Log[f]]


(* Transforms improper binomials into proper binomials *)
Integrate[f_^(a_.+b_.*x_^n_),x_Symbol] :=
  Module[{q=Numerator[1/n]},
  q*Subst[Integrate[x^(q-1)*f^(a+b*x^(q*n)),x],x,x^(1/q)]] /;
FreeQ[{a,b,f},x] && FractionOrNegativeQ[n]


Integrate[f_^(a_.+b_.*x_^n_),x_Symbol] :=
  -f^a*x*Gamma[1/n,-b*Log[f]*x^n]/(n*(-b*Log[f]*x^n)^(1/n)) /;
FreeQ[{a,b,f,n},x] && Not[FractionOrNegativeQ[n] || ZeroQ[n-1] || n===2]


(* ::Subsubsection::Closed:: *)
(*f^(a+b x^n) g^(c+d x^n)	Products of two exponentials of binomials (5)*)


Integrate[f_^(a_.+b_.*x_)*g_^(c_.+d_.*x_),x_Symbol] :=
  (f^(a+b*x)*g^(c+d*x))/(b*Log[f]+d*Log[g]) /;
FreeQ[{a,b,c,d,f,g},x]


Integrate[f_^(a_.+b_.*x_^2)*g_^(c_.+d_.*x_^2),x_Symbol] :=
  f^a*g^c*Sqrt[Pi]*Erfi[x*Rt[b*Log[f]+d*Log[g],2]]/(2*Rt[b*Log[f]+d*Log[g],2]) /;
FreeQ[{a,b,c,d,f,g},x] && PosQ[b*Log[f]+d*Log[g]]


Integrate[f_^(a_.+b_.*x_^2)*g_^(c_.+d_.*x_^2),x_Symbol] :=
  f^a*g^c*Sqrt[Pi]*Erf[x*Rt[-b*Log[f]-d*Log[g],2]]/(2*Rt[-b*Log[f]-d*Log[g],2]) /;
FreeQ[{a,b,c,d,f,g},x] && PosQ[-b*Log[f]-d*Log[g]]


(* Transforms improper binomials into proper binomials *)
Integrate[f_^(a_.+b_.*x_^n_)*g_^(c_.+d_.*x_^n_),x_Symbol] :=
  Module[{q=Numerator[1/n]},
  q*Subst[Integrate[x^(q-1)*f^(a+b*x^(q*n))*g^(c+d*x^(q*n)),x],x,x^(1/q)]] /;
FreeQ[{a,b,c,d,f,g},x] && FractionOrNegativeQ[n]


Integrate[f_^(a_.+b_.*x_^n_)*g_^(c_.+d_.*x_^n_),x_Symbol] :=
  -f^a*g^c*x*Gamma[1/n,-(b*Log[f]+d*Log[g])*x^n]/
	(n*(-(b*Log[f]+d*Log[g])*x^n)^(1/n)) /;
FreeQ[{a,b,c,d,f,g,n},x] && Not[FractionOrNegativeQ[n] || ZeroQ[n-1] || n===2]


(* ::Subsubsection::Closed:: *)
(*f^(a+b x^n) g^(c+d x^n) ...	Products of multiple exponentials of binomials (1)*)
(**)


(* Should generalize to handle any number of exponential of linear factors *)
Integrate[f_^(a_.+b_.*x_)*g_^(c_.+d_.*x_)*h_^(r_.+s_.*x_),x_Symbol] :=
  (f^(a+b*x)*g^(c+d*x)*h^(r+s*x))/(b*Log[f]+d*Log[g]+s*Log[h]) /;
FreeQ[{a,b,c,d,f,g,h,r,s},x]


(* ::Subsubsection::Closed:: *)
(*x^m f^(a+b x^n)		Products of monomials and exponentials of binomials (8)*)


(* Should generalize to handle any number of exponential of linear factors *)
Integrate[f_^(a_.+b_.*x_^n_.)/x_,x_Symbol] :=
  (f^a*ExpIntegralEi[b*x^n*Log[f]])/n /;
FreeQ[{a,b,f,n},x]


Integrate[f_^(a_.+b_.*x_)/Sqrt[x_],x_Symbol] :=
  f^a*Sqrt[Pi]*Erfi[Sqrt[x]*Rt[b*Log[f],2]]/Rt[b*Log[f],2] /;
FreeQ[{a,b,f},x] && PosQ[b*Log[f]]


Integrate[f_^(a_.+b_.*x_)/Sqrt[x_],x_Symbol] :=
  f^a*Sqrt[Pi]*Erf[Sqrt[x]*Rt[-b*Log[f],2]]/Rt[-b*Log[f],2] /;
FreeQ[{a,b,f},x] && PosQ[-b*Log[f]]


(* GR5 2.321.1, CRC 521 *)
Integrate[x_^m_.*f_^(a_.+b_.*x_^n_.),x_Symbol] :=
  x^(m-n+1)*f^(a+b*x^n)/(b*n*Log[f])-
    (m-n+1)/(b*n*Log[f])*Integrate[x^(m-n)*f^(a+b*x^n),x] /;
FreeQ[{a,b,f},x] && IntegerQ[{m,n}] && n>0 && m>=n


(* GR5 2.324.1, CRC 523 *)
Integrate[x_^m_.*f_^(a_.+b_.*x_^n_.),x_Symbol] :=
  x^(m+1)*f^(a+b*x^n)/(m+1)-
    b*n*Log[f]/(m+1)*Integrate[x^(m+n)*f^(a+b*x^n),x] /;
FreeQ[{a,b,f},x] && IntegerQ[{m,n}] && n>0 && m<-1


(* Transforms improper binomials into proper binomials *)
Integrate[x_^m_.*f_^(a_.+b_.*x_^n_.),x_Symbol] :=
  Module[{q=Sign[n]*LCM[Denominator[m],Denominator[n]]},
    q*Subst[Integrate[x^(q*m+q-1)*f^(a+b*x^(q*n)),x],x,x^(1/q)]] /;
FreeQ[{a,b,f},x] && RationalQ[{m,n}] && (FractionQ[m] || FractionOrNegativeQ[n]) &&
  m!=-1 &&
  Not[m==-1/2 && n==1]


Integrate[x_^m_.*f_^(a_.+b_.*x_^n_.),x_Symbol] :=
  -f^a*x^(m+1)*Gamma[(m+1)/n,-b*x^n*Log[f]]/(n*(-b*x^n*Log[f])^((m+1)/n)) /;
FreeQ[{a,b,f,m,n},x] &&
  NonzeroQ[m+1] &&
  Not[m===-1/2 && ZeroQ[n-1]] &&
  Not[IntegerQ[{m,n}] && n>0 && (m<-1 || m>=n)] &&
  Not[RationalQ[{m,n}] && (FractionQ[m] || FractionOrNegativeQ[n])]


Integrate[(a_.+b_.*x_)^m_*f_^(c_.+d_.*x_),x_Symbol] :=
  Subst[Integrate[x^m*f^(c-a*d/b+d*x/b),x],x,a+b*x]/b /;
FreeQ[{a,b,c,d,f,m},x] && Not[a===0 && b===1]


(* ::Subsubsection::Closed:: *)
(*x^m f^(a+b x^n) g^(c+d x^n)	Products of monomials and two exponentials of binomials (1)*)
(**)


(* GR5 2.321.1, CRC 521 *)
Integrate[x_^m_.*f_^(a_.+b_.*x_^n_.)*g_^(c_.+d_.*x_^n_.),x_Symbol] :=
  x^(m-n+1)*f^(a+b*x^n)*g^(c+d*x^n)/(n*(b*Log[f]+d*Log[g]))-
    (m-n+1)/(n*(b*Log[f]+d*Log[g]))*Integrate[x^(m-n)*f^(a+b*x^n)*g^(c+d*x^n),x] /;
FreeQ[{a,b,c,d,f,g},x] && IntegerQ[{m,n}] && n>0 && m>=n


(* ::Subsubsection::Closed:: *)
(*f^(a+b x+c x^2)		Exponentials of quadratics (2)*)


Integrate[f_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Sqrt[Pi]*f^((4*a*c-b^2)/(4*c))*Erfi[(b+2*c*x)*Rt[c*Log[f],2]/(2*c)]/
    (2*Rt[c*Log[f],2]) /;
FreeQ[{a,b,c,f},x] && PosQ[c*Log[f]]


Integrate[f_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Sqrt[Pi]*f^((4*a*c-b^2)/(4*c))*Erf[(b+2*c*x)*Rt[-c*Log[f],2]/(2*c)]/
    (2*Rt[-c*Log[f],2]) /;
FreeQ[{a,b,c,f},x] && PosQ[-c*Log[f]]


(* ::Subsubsection::Closed:: *)
(*x^m f^(a+b x+c x^2)		Products of monomials and exponentials of quadratics (3)*)
(**)


Integrate[x_*f_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  f^(a+b*x+c*x^2)/(2*c*Log[f])-
    b/(2*c)*Integrate[f^(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,f},x]


Integrate[x_^m_*f_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  x^(m-1)*f^(a+b*x+c*x^2)/(2*c*Log[f])-
    b/(2*c)*Integrate[x^(m-1)*f^(a+b*x+c*x^2),x]-
    (m-1)/(2*c*Log[f])*Integrate[x^(m-2)*f^(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,f},x] && RationalQ[m] && m>1


Integrate[x_^m_*f_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  x^(m+1)*f^(a+b*x+c*x^2)/(m+1)-
    b*Log[f]/(m+1)*Integrate[x^(m+1)*f^(a+b*x+c*x^2),x]-
    2*c*Log[f]/(m+1)*Integrate[x^(m+2)*f^(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,f},x] && RationalQ[m] && m<-1


(* ::Subsubsection::Closed:: *)
(*f^(c (a+b x)^n)			Exponentials of powers of linears (5)*)


Integrate[f_^(c_.*(a_.+b_.*x_)^2),x_Symbol] :=
  Sqrt[Pi]*Erfi[(a+b*x)*Rt[c*Log[f],2]]/(2*b*Rt[c*Log[f],2]) /;
FreeQ[{a,b,c,f},x] && PosQ[c*Log[f]]


Integrate[f_^(c_.*(a_.+b_.*x_)^2),x_Symbol] :=
  Sqrt[Pi]*Erf[(a+b*x)*Rt[-c*Log[f],2]]/(2*b*Rt[-c*Log[f],2]) /;
FreeQ[{a,b,c,f},x] && PosQ[-c*Log[f]]


(* Should be generalized for arbitrary fractional powers of linear. *)
Integrate[f_^(c_.*Sqrt[a_.+b_.*x_]),x_Symbol] :=
  2*f^(c*Sqrt[a+b*x])*(-1+c*Sqrt[a+b*x]*Log[f])/(b*c^2*Log[f]^2) /;
FreeQ[{a,b,c,f},x]


Integrate[f_^(c_./(a_.+b_.*x_)^2),x_Symbol] :=
  f^(c/(a+b*x)^2)*
    (a+b*x-Sqrt[Pi]*Rt[c*Log[f],2]*Erfi[Rt[c*Log[f],2]/(a+b*x)]/f^(c/(a+b*x)^2))/b /;
FreeQ[{a,b,c,f},x]


Integrate[f_^(c_.*(a_.+b_.*x_)^n_),x_Symbol] :=
  -f^(c*(a+b*x)^n)*(a+b*x)*Gamma[1/n,-c*(a+b*x)^n*Log[f]]/
    (b*n*(-c*(a+b*x)^n*Log[f])^(1/n)*f^(c*(a+b*x)^n)) /;
FreeQ[{a,b,c,f,n},x] && Not[n===2] && Not[n===-2]


(* ::Subsubsection::Closed:: *)
(*x^m f^(c (a+b x)^n)		Products of monomials and exponentials of powers of linears (2)*)
(**)


Integrate[x_^m_*f_^(c_.*(a_.+b_.*x_)^2),x_Symbol] :=
  Integrate[x^m*f^(a^2*c+2*a*b*c*x+b^2*c*x^2),x] /;
FreeQ[{a,b,c,f},x] && FractionOrNegativeQ[m] && (m>1 || m<-1)


Integrate[x_^m_.*f_^(c_.*(a_.+b_.*x_)^n_),x_Symbol] :=
  Integrate[Expand[b^m*x^m-(a+b*x)^m,x]*f^(c*(a+b*x)^n),x]/b^m+
    Integrate[(f^(c*(a+b*x)^n)*(a+b*x)^m),x]/b^m /;
FreeQ[{a,b,c,f,n},x] && IntegerQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*x^m / (c+d f^(a+b x))		Quotients of monomials by linear exponentials of linears (2)*)
(**)


Integrate[x_^m_./(c_+d_.*f_^(a_.+b_.*x_)), x_Symbol] :=
  x^(m+1)/(c*(m+1)) -
    d/c*Integrate[x^m*f^(a+b*x)/(c+d*f^(a+b*x)),x] /;
FreeQ[{a,b,c,d,f},x] && RationalQ[m] && m>0


Integrate[x_^m_.*f_^(a_.+b_.*x_)/(c_+d_.*f_^(a_.+b_.*x_)), x_Symbol] :=
  -x^m*PolyLog[1,-d*f^(a+b*x)/c]/(b*d*Log[f]) +
    m*Integrate[x^(m-1)*PolyLog[1,-d*f^(a + b*x)/c],x]/(b*d*Log[f]) /;
FreeQ[{a,b,c,d,f},x] && RationalQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*f^((a+b x^4)/x^2)		Exponentials of quotients of binomials and monomials (1)*)
(**)


Integrate[f_^((a_.+b_.*x_^4)/x_^2),x_Symbol] :=
  Sqrt[Pi]*Exp[2*Sqrt[-a*Log[f]]*Sqrt[-b*Log[f]]]*Erf[(Sqrt[-a*Log[f]]+Sqrt[-b*Log[f]]*x^2)/x]/
      (4*Sqrt[-b*Log[f]])-
    Sqrt[Pi]*Exp[-2*Sqrt[-a*Log[f]]*Sqrt[-b*Log[f]]]*Erf[(Sqrt[-a*Log[f]]-Sqrt[-b*Log[f]]*x^2)/x]/
      (4*Sqrt[-b*Log[f]]) /;
FreeQ[{a,b,f},x]


(* ::Subsubsection::Closed:: *)
(*f^(a Log[u])			Exponentials of logarithms (1)  *)


Integrate[f_^(a_.*Log[u_]),x_Symbol] :=
  Integrate[u^(a*Log[f]),x] /;
FreeQ[{a,f},x]


(* ::Subsubsection::Closed:: *)
(*E^ArcHyper[u]		Exponentials of inverse hyperbolic functions (6)  *)


Integrate[E^(n_.*ArcSinh[u_]), x_Symbol] :=
  Integrate[(u+Sqrt[1+u^2])^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


Integrate[E^(n_.*ArcCosh[u_]), x_Symbol] :=
  Integrate[(u+Sqrt[-1+u]*Sqrt[1+u])^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


Integrate[E^(n_.*ArcTanh[u_]), x_Symbol] :=
  Integrate[(Sqrt[1+u]/Sqrt[1-u])^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


Integrate[E^(n_.*ArcCoth[u_]), x_Symbol] :=
  Integrate[(u*Sqrt[1-1/u^2]/(-1+u))^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


Integrate[E^(n_.*ArcSech[u_]), x_Symbol] :=
  Integrate[((1+Sqrt[1-u]/Sqrt[1/(1+u)])/u)^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


Integrate[E^(n_.*ArcCsch[u_]), x_Symbol] :=
  Integrate[(1/u+Sqrt[1+1/u^2])^n,x] /;
IntegerQ[n] && PolynomialQ[u,x]


(* ::Subsubsection::Closed:: *)
(*f^(c ArcTrig[a+b x])		Exponentials of inverse trig functions of linears (2)*)


Integrate[f_^(c_.*ArcSin[x_]),x_Symbol] :=
  f^(c*ArcSin[x])*(x+c*Sqrt[1-x^2]*Log[f])/(1+c^2*Log[f]^2) /;
FreeQ[{c,f},x]


Integrate[f_^(c_.*ArcCos[x_]),x_Symbol] :=
  f^(c*ArcCos[x])*(x-c*Sqrt[1-x^2]*Log[f])/(1+c^2*Log[f]^2) /;
FreeQ[{c,f},x]


(* ::Subsubsection::Closed:: *)
(*f^(c ArcHyper[a+b x])		Exponentials of inverse hyperbolic functions of linears (2)*)


Integrate[f_^(c_.*ArcSinh[x_]),x_Symbol] :=
  f^(c*ArcSinh[x])*(-x+c*Sqrt[1+x^2]*Log[f])/(-1+c^2*Log[f]^2) /;
FreeQ[{c,f},x]


Integrate[f_^(c_.*ArcCosh[x_]),x_Symbol] :=
  f^(c*ArcCosh[x])*(-x+c*Sqrt[(-1+x)/(1+x)]*(1+x)*Log[f])/(-1+c^2*Log[f]^2) /;
FreeQ[{c,f},x]


(* ::Subsection::Closed:: *)
(*Logarithm Function (50)*)


(* ::Subsubsection::Closed:: *)
(*Log[a x^n]^p			Powers of logarithms of monomials (11)*)


(* CRC 485 *)
Integrate[Log[a_.*x_^n_.],x_Symbol] :=
  -n*x + x*Log[a*x^n] /;
FreeQ[{a,n},x]


Integrate[1/Log[a_.*x_],x_Symbol] :=
  LogIntegral[a*x]/a /;
FreeQ[a,x]


(* CRC 492 *)
Integrate[1/Log[a_.*x_^n_],x_Symbol] :=
  x*ExpIntegralEi[Log[a*x^n]/n]/(n*(a*x^n)^(1/n)) /;
FreeQ[{a,n},x]


Integrate[1/Sqrt[Log[a_.*x_^n_.]],x_Symbol] :=
  -Sqrt[Pi]*x*Erf[Sqrt[Log[a*x^n]]/Rt[-n,2]]/(Rt[-n,2]*(a*x^n)^(1/n)) /;
FreeQ[{a,n},x] && PosQ[-n]


Integrate[1/Sqrt[Log[a_.*x_^n_.]],x_Symbol] :=
  Sqrt[Pi]*x*Erfi[Sqrt[Log[a*x^n]]/Rt[n,2]]/(Rt[n,2]*(a*x^n)^(1/n)) /;
FreeQ[{a,n},x] && PosQ[n]


Integrate[1/Sqrt[-Log[a_.*x_^n_.]],x_Symbol] :=
  Sqrt[Pi]*x*Erfi[Sqrt[-Log[a*x^n]]/Rt[-n,2]]/(Rt[-n,2]*(a*x^n)^(1/n)) /;
FreeQ[{a,n},x] && PosQ[-n]


Integrate[1/Sqrt[-Log[a_.*x_^n_.]],x_Symbol] :=
  -Sqrt[Pi]*x*Erf[Sqrt[-Log[a*x^n]]/Rt[n,2]]/(Rt[n,2]*(a*x^n)^(1/n)) /;
FreeQ[{a,n},x] && PosQ[n]


(* GR5 2.711.1, CRC 490 *)
Integrate[Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x*Log[a*x^n]^p-
    n*p*Integrate[Log[a*x^n]^(p-1),x] /;
FreeQ[{a,n},x] && RationalQ[p] && p>0


Integrate[Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x*Log[a*x^n]^(p+1)/(n*(p+1))-
    1/(n*(p+1))*Integrate[Log[a*x^n]^(p+1),x] /;
FreeQ[{a,n},x] && RationalQ[p] && p<-1


Integrate[Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x*Gamma[p+1,-Log[a*x^n]/n]*Log[a*x^n]^p/((a*x^n)^(1/n)*(-Log[a*x^n]/n)^p) /;
FreeQ[{a,n,p},x]


(* Need a rule for arbitrarily deep nesting of powers! *) 
Integrate[Log[a_.*(b_.*x_^n_.)^p_]^q_.,x_Symbol] :=
  Subst[Integrate[Log[x^(n*p)]^q,x],x^(n*p),a*(b*x^n)^p] /;
FreeQ[{a,b,n,p,q},x]

Integrate[Log[a_.*(b_.*(c_.*x_^n_.)^p_)^q_]^r_.,x_Symbol] :=
  Subst[Integrate[Log[x^(n*p*q)]^r,x],x^(n*p*q),a*(b*(c*x^n)^p)^q] /;
FreeQ[{a,b,c,n,p,q,r},x]


(* ::Subsubsection::Closed:: *)
(*x^m Log[a x^n]^p		Products of monomials and powers of logarithms of monomials (9)*)
(**)


(* GR5 2.721.3, CRC 493 *)
Integrate[1/(x_*Log[a_.*x_^n_.]),x_Symbol] :=
  Log[Log[a*x^n]]/n /;
FreeQ[{a,n},x]


(* GR5 2.721.2, CRC 491 *)
Integrate[Log[a_.*x_^n_.]^p_./x_,x_Symbol] :=
  Log[a*x^n]^(p+1)/(n*(p+1)) /;
FreeQ[{a,n,p},x] && NonzeroQ[p+1]


(* GR5 2.723.1, CRC 488 *)
Integrate[x_^m_.*Log[a_.*x_^n_.],x_Symbol] :=
  -n*x^(m+1)/(m+1)^2+
    x^(m+1)*Log[a*x^n]/(m+1) /;
FreeQ[{a,m,n},x] && NonzeroQ[m+1]


Integrate[x_^m_./Log[a_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ExpIntegralEi[(m+1)*Log[a*x^n]/n]/(n*(a*x^n)^((m+1)/n)) /;
FreeQ[{a,m,n},x] && NonzeroQ[m+1]


Integrate[x_^m_./Sqrt[Log[a_.*x_^n_.]],x_Symbol] :=
  Sqrt[Pi]*x^(m+1)*Erf[Rt[-(m+1)/n,2]*Sqrt[Log[a*x^n]]]/(n*Rt[-(m+1)/n,2]*(a*x^n)^((m+1)/n)) /;
FreeQ[{a,m,n},x] && NonzeroQ[m+1]


(* GR5 2.721.1, CRC 496 *)
Integrate[x_^m_.*Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x^(m+1)*Log[a*x^n]^p/(m+1)-
    n*p/(m+1)*Integrate[x^m*Log[a*x^n]^(p-1),x] /;
FreeQ[{a,m,n},x] && RationalQ[p] && NonzeroQ[m+1] && p>0


(* GR5 2.724.1, CRC 495 *)
Integrate[x_^m_.*Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x^(m+1)*Log[a*x^n]^(p+1)/(n*(p+1))-
    (m+1)/(n*(p+1))*Integrate[x^m*Log[a*x^n]^(p+1),x] /;
FreeQ[{a,m,n},x] && RationalQ[p] && p<-1


Integrate[x_^m_.*Log[a_.*x_^n_.]^p_,x_Symbol] :=
  x^(m+1)*Gamma[p+1,-(m+1)*Log[a*x^n]/n]*Log[a*x^n]^p/
  ((m+1)*(a*x^n)^((m+1)/n)*(-(m+1)*Log[a*x^n]/n)^p) /;
FreeQ[{a,m,n,p},x] && NonzeroQ[m+1]


(* Need a rule for arbitrarily deep nesting of powers! *) 
Integrate[x_^m_.*Log[a_.*(b_.*x_^n_.)^p_]^q_.,x_Symbol] :=
  Subst[Integrate[x^m*Log[x^(n*p)]^q,x],x^(n*p),a*(b*x^n)^p] /;
FreeQ[{a,b,m,n,p,q},x]

Integrate[x_^m_.*Log[a_.*(b_.*(c_.*x_^n_.)^p_)^q_]^r_.,x_Symbol] :=
  Subst[Integrate[x^m*Log[x^(n*p*q)]^r,x],x^(n*p*q),a*(b*(c*x^n)^p)^q] /;
FreeQ[{a,b,c,m,n,p,q,r},x]


(* ::Subsubsection::Closed:: *)
(*Log[c (a+b x)^n]^p		Powers of logarithms of powers of linears (2)*)


(* CRC 499 *)
Integrate[Log[c_.*(a_.+b_.*x_)^n_.],x_Symbol] :=
  -n*x + (a+b*x)*Log[c*(a+b*x)^n]/b /;
FreeQ[{a,b,c,n},x]


(* GR5 2.711.1, CRC 490 *)
Integrate[Log[c_.*(a_.+b_.*x_)^n_.]^p_,x_Symbol] :=
  (a+b*x)*Log[c*(a+b*x)^n]^p/b -
    n*p*Integrate[Log[c*(a+b*x)^n]^(p-1),x] /;
FreeQ[{a,b,c,n},x] && IntegerQ[p] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Log[c (a+b x)^n]^p	Products of monomials and powers of logarithms of monomials (6)*)
(**)


Integrate[Log[1+b_.*x_]/x_,x_Symbol] :=
  -PolyLog[2,-b*x] /;
FreeQ[b,x]


Integrate[Log[c_.*(a_+b_.*x_)^n_.]/x_,x_Symbol] :=
  Log[x]*(Log[c*(a+b*x)^n] -
	n*Log[(a+b*x)/a]) -
    n*PolyLog[2,-b*x/a] /;
FreeQ[{a,b,c,n},x] && RationalQ[b] && b>0


Integrate[Log[c_.*(a_+b_.*x_)^n_.]/x_,x_Symbol] :=
  Log[c*(a+b*x)^n]*Log[-b*x/a] +
    n*PolyLog[2,1+b*x/a] /;
FreeQ[{a,b,c,n},x]


(* CRC 488 *)
Integrate[x_^m_.*Log[c_.*(a_+b_.*x_)^n_.],x_Symbol] :=
  x^(m+1)*Log[c*(a+b*x)^n]/(m+1) -
    b*n/(m+1)*Integrate[x^(m+1)/(a+b*x),x] /;
FreeQ[{a,b,c,m,n},x] && IntegerQ[m] && m>0


Integrate[x_^m_.*Log[c_.*(a_+b_.*x_)^n_.]^p_,x_Symbol] :=
  x^(m+1)*Log[c*(a+b*x)^n]^p/(m+1) +
    a*n*p/(m+1)*Integrate[x^m*Log[c*(a+b*x)^n]^(p-1)/(a+b*x),x] -
    n*p/(m+1)*Integrate[x^m*Log[c*(a+b*x)^n]^(p-1),x] /;
FreeQ[{a,b,c,n},x] && IntegerQ[{m,n}] && m>0 && p>0


Integrate[x_^m_.*Log[c_.*(a_+b_.*x_)^n_.]^p_.,x_Symbol] :=
  Subst[Integrate[(-a/b+x/b)^m*Log[c*x^n]^p,x],x,a+b*x]/b /;
FreeQ[{a,b,c,n,p},x] && IntegerQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*(a+b Log[x])^n			Powers of linear sums of logarithms (1)*)
(**)


Integrate[1/(a_.+b_.*Log[x_]),x_Symbol] :=
  ExpIntegralEi[a/b+Log[x]]/(E^(a/b)*b) /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*Log[a+b x] / (c+d x+e x^2)	Quotient of logarithms of linears by quadratics (2)*)
(**)


Integrate[Log[a_.+b_.*x_]/(c_.+d_.*x_^2),x_Symbol] :=
  Module[{r=Rt[-c*d,2]},
  d/(2*r)*Integrate[Log[a+b*x]/(-r+d*x),x]-
    d/(2*r)*Integrate[Log[a+b*x]/(r+d*x),x]] /;
FreeQ[{a,b,c,d},x]


Integrate[Log[a_.+b_.*x_]/(c_.+d_.*x_+e_.*x_^2),x_Symbol] :=
  Module[{r=Rt[d^2-4*c*e,2]},
  2*e/r*Integrate[Log[a+b*x]/(d-r+2*e*x),x]-
    2*e/r*Integrate[Log[a+b*x]/(d+r+2*e*x),x]] /;
FreeQ[{a,b,c,d,e},x]


(* ::Subsubsection::Closed:: *)
(*x^m Log[1+c f^(a+b x)]	Products of monomials and logarithms of 1 plus exponentials (2)*)


Integrate[Log[1+c_.*f_^(a_.+b_.*x_)],x_Symbol] :=
  -PolyLog[2,-c*f^(a+b*x)]/(b*Log[f]) /;
FreeQ[{a,b,c},x]


Integrate[x_^m_.*Log[1+c_.*f_^(a_.+b_.*x_)],x_Symbol] :=
  -x^m*PolyLog[2,-c*f^(a+b*x)]/(b*Log[f]) +
    m/(b*Log[f])*Integrate[x^(m-1)*PolyLog[2,-c*f^(a+b*x)],x] /;
FreeQ[{a,b,c},x] && RationalQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*Log[x]^m PolyLog[n,a x] / x	Quotients of products of powers of logarithms and polylogarithms by x (4)*)
(**)


(* Note that Log[1+a*x] == -PolyLog[1,-a*x]. *)
Integrate[Log[x_]^m_.*Log[1+a_.*x_]/x_,x_Symbol] :=
  -Log[x]^m*PolyLog[2,-a*x]+
    m*Integrate[Log[x]^(m-1)*PolyLog[2,-a*x]/x,x] /;
FreeQ[a,x] && RationalQ[m] && m>0


Integrate[Log[x_]^m_.*PolyLog[n_,a_.*x_]/x_,x_Symbol] :=
  Log[x]^m*PolyLog[n+1,a*x]-
    m*Integrate[Log[x]^(m-1)*PolyLog[n+1,a*x]/x,x] /;
FreeQ[{a,n},x] && RationalQ[m] && m>0


Integrate[Log[a_+b_.*x_]^m_./x_,x_Symbol] :=
  Subst[Log[x]^m*Log[1-x/a] -
    m*Integrate[Log[x]^(m-1)*Log[1-x/a]/x,x],x,a+b*x] /;
FreeQ[{a,b},x] && RationalQ[m] && m>0


Integrate[Log[a_+b_.*x_]^m_.*Log[c_.*x_]/(a_+b_.*x_),x_Symbol] :=
  Subst[Integrate[Log[x]^m*Log[1-x/a]/x,x],x,a+b*x]/b /;
FreeQ[{a,b,c},x] && RationalQ[m] && m>0 && ZeroQ[c+b/a]


(* ::Subsubsection::Closed:: *)
(*Log[u] / x			Quotients of logarithms by x (4)*)


Integrate[Log[b_.*x_+c_.*x_^2]/x_,x_Symbol] :=
  -Log[x]*(Log[x]/2-Log[b*x+c*x^2]+Log[1+c*x/b])-
    PolyLog[2,-c*x/b] /;
FreeQ[{b,c},x]

Integrate[Log[b_.*x_^n_+c_.*x_^p_.]/x_,x_Symbol] :=
  -Log[x^n]*(Log[x^n]/2-Log[b*x^n+c*x^p]+Log[1+c*x^n/b])/n-
    PolyLog[2,-c*x^n/b]/n /;
FreeQ[{b,c,n,p},x] && p===2*n


Integrate[Log[a_+b_.*x_+c_.*x_^2]/x_,x_Symbol] :=
  Module[{q=Sqrt[b^2-4*a*c]},
  -Log[x]*(Log[1+2*c*x/(b-q)]+Log[1+2*c*x/(b+q)]-Log[a+b*x+c*x^2])-
    PolyLog[2,-2*c*x/(b-q)]-
    PolyLog[2,-2*c*x/(b+q)]] /;
FreeQ[{a,b,c},x]

Integrate[Log[a_+b_.*x_^n_+c_.*x_^p_.]/x_,x_Symbol] :=
  Module[{q=Sqrt[b^2-4*a*c]},
  -Log[x]*(Log[1+2*c*x^n/(b-q)]+Log[1+2*c*x^n/(b+q)]-Log[a+b*x^n+c*x^p])-
    PolyLog[2,-2*c*x^n/(b-q)]/n-
    PolyLog[2,-2*c*x^n/(b+q)]/n] /;
FreeQ[{a,b,c,n,p},x] && p===2*n


(* Need to generalize for Log[f(x^n)]/x! *)
(* Reduces binomial to a linear, even for fractional and symbolic n and p *)
Integrate[Log[c_.*(a_+b_.*x_^n_)^p_.]/x_,x_Symbol] :=
  Subst[Integrate[Log[c*(a+b*x)^p]/x,x],x,x^n]/n /;
FreeQ[{a,b,c,n,p},x]


(* Way kool rule!  More generally valid for any integrand of the form f((a+b*x)/(c+d*x))/x. *)
Integrate[Log[(a_.+b_.*x_)/(c_.+d_.*x_)]^m_./x_,x_Symbol] :=
  Subst[Integrate[Log[a/c+x/c]^m/x,x],x,(b*c-a*d)*x/(c+d*x)] -
    Subst[Integrate[Log[b/d+x/d]^m/x,x],x,-(b*c-a*d)/(c+d*x)] /;
FreeQ[{a,b,c,d},x] && IntegerQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*Log[u] / (a+b x)		Quotients of powers of logarithms by linears (1)*)
(**)


Integrate[Log[u_]^n_./(a_.+b_.*x_),x_Symbol] :=
  Subst[Integrate[Log[Subst[u,x,-a/b+x/b]]^n/x,x],x,a+b*x]/b /;
FreeQ[{a,b,n},x] && Not[a===0 && b===1] && InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*v Log[u]			Products of integrable expressions and logarithms (4)*)


(* Uses integration by parts to transform integrand into an algebraic function, based on the
	fact that the derivative of an algebraic function is an algebraic function. *)
Integrate[Log[u_],x_Symbol] :=
  x*Log[u] -
    Integrate[x*D[u,x]/u,x] /;
InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*Log[u_],x_Symbol] :=
  x^(m+1)*Log[u]/(m+1) -
    Integrate[x^(m+1)*D[u,x]/u,x]/(m+1) /;
RationalQ[m] && m!=-1 && InverseFunctionFreeQ[u,x]


Integrate[(a_+b_.*x_)^m_.*Log[u_],x_Symbol] :=
  (a+b*x)^(m+1)*Log[u]/(b*(m+1)) -
    Integrate[(a+b*x)^(m+1)*D[u,x]/u,x]/(b*(m+1)) /;
FreeQ[{a,b},x] && RationalQ[m] && m!=-1 && InverseFunctionFreeQ[u,x]


Integrate[v_*Log[u_],x_Symbol] :=
  Module[{w=Block[{ShowSteps=False}, Integrate[v,x]]},  
  w*Log[u] -
    Integrate[w*D[u,x]/u,x] /;
 InverseFunctionFreeQ[w,x]] /;
InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*v Log[u]^n			Products of integrable expressions and powers of logarithms (4)*)


(* Uses integration by parts to reduce the degree of the log factor in the integrand while
	keeping the remaining factors an algebraic function. *)
Integrate[Log[u_]^n_,x_Symbol] :=
  x*Log[u]^n -
    n*Integrate[x*Log[u]^(n-1)*D[u,x]/u,x] /;
IntegerQ[n] && n>0 && InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*Log[u_]^n_,x_Symbol] :=
  x^(m+1)*Log[u]^n/(m+1) -
    Integrate[x^(m+1)*Log[u]^(n-1)*D[u,x]/u,x]/(m+1) /;
RationalQ[m] && m!=-1 && IntegerQ[n] && n>0 && InverseFunctionFreeQ[u,x]


Integrate[(a_+b_.*x_)^m_.*Log[u_]^n_,x_Symbol] :=
  (a+b*x)^(m+1)*Log[u]^n/(b*(m+1)) -
    n*Integrate[(a+b*x)^(m+1)*Log[u]^(n-1)*D[u,x]/u,x]/(b*(m+1)) /;
FreeQ[{a,b},x] && RationalQ[m] && m!=-1 && IntegerQ[n] && n>0 && InverseFunctionFreeQ[u,x]


Integrate[v_*Log[u_]^n_,x_Symbol] :=
  Module[{w=Block[{ShowSteps=False}, Integrate[v,x]]},  
  w*Log[u]^n -
    n*Integrate[w*Log[u]^(n-1)*D[u,x]/u,x] /;
 InverseFunctionFreeQ[w,x]] /;
IntegerQ[n] && n>0 && InverseFunctionFreeQ[u,x]


(* ::Subsection::Closed:: *)
(*Trigonometric Functions (188)*)


(* ::Subsubsection::Closed:: *)
(*Sin[x]^n			Powers of sines (5)*)


(* GR5 2.01.5, CRC 290 *)
Integrate[Sin[x_],x_Symbol] :=
  -Cos[x]


Integrate[Sqrt[Sin[x_]],x_Symbol] :=
  -2*EllipticE[(Pi/2-x)/2,2]


Integrate[1/Sqrt[Sin[x_]],x_Symbol] :=
  -2*EllipticF[(Pi/2-x)/2,2]


(* GR5 2.513.5, CRC 296 *)
Integrate[Sin[x_]^2,x_Symbol] :=
  x/2-Cos[x]*Sin[x]/2

(* GR5 2.510.2, CRC 299 *)
Integrate[Sin[x_]^n_,x_Symbol] :=
  -Sin[x]^(n-1)*Cos[x]/n+
    (n-1)/n*Integrate[Sin[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.3, CRC 309 *)
Integrate[Sin[x_]^n_,x_Symbol] :=
  Sin[x]^(n+1)*Cos[x]/(n+1)+
    (n+2)/(n+1)*Integrate[Sin[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Cos[x]^n			Powers of cosines (5)*)


(* GR5 2.01.5, CRC 291 *)
Integrate[Cos[x_],x_Symbol] :=
  Sin[x]


Integrate[Sqrt[Cos[x_]],x_Symbol] :=
  2*EllipticE[x/2,2]


Integrate[1/Sqrt[Cos[x_]],x_Symbol] :=
  2*EllipticF[x/2,2]


(* GR5 2.513.11, CRC 302 *)
Integrate[Cos[x_]^2,x_Symbol] :=
  x/2+Cos[x]*Sin[x]/2

(* GR5 2.510.5, CRC 305 *)
Integrate[Cos[x_]^n_,x_Symbol] :=
  Sin[x]*Cos[x]^(n-1)/n+
    (n-1)/n*Integrate[Cos[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.6, CRC 305 *)
Integrate[Cos[x_]^n_,x_Symbol] :=
  -Sin[x]*Cos[x]^(n+1)/(n+1)+
    (n+2)/(n+1)*Integrate[Cos[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Tan[x]^n			Powers of tangents (3)*)


(* GR5 2.526.17, CRC 292 *)
Integrate[Tan[x_],x_Symbol] :=
  -Log[Cos[x]]


(* GR5 2.526.22, CRC 420 *)
Integrate[Tan[x_]^2,x_Symbol] :=
  -x+Tan[x]

(* GR5 2.510.1, CRC 423 *)
Integrate[Tan[x_]^n_,x_Symbol] :=
  Tan[x]^(n-1)/(n-1)-
    Integrate[Tan[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.4, CRC 427' *)
Integrate[Tan[x_]^n_,x_Symbol] :=
  Tan[x]^(n+1)/(n+1)-
    Integrate[Tan[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Cot[x]^n			Powers of cotangents (3)*)


(* GR5 2.526.33, CRC 293 *)
Integrate[Cot[x_],x_Symbol] :=
  Log[Sin[x]]


(* GR5 2.526.38, CRC 424 *)
Integrate[Cot[x_]^2,x_Symbol] :=
  -x-Cot[x]

(* GR5 2.510.4, CRC 427 *)
Integrate[Cot[x_]^n_,x_Symbol] :=
  -Cot[x]^(n-1)/(n-1)-
    Integrate[Cot[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.1, CRC 423' *)
Integrate[Cot[x_]^n_,x_Symbol] :=
  -Cot[x]^(n+1)/(n+1)-
    Integrate[Cot[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Sec[x]^n			Powers of secants (5)*)


(* GR5 2.526.9', CRC 294' *)
Integrate[Sec[x_],x_Symbol] :=
  ArcTanh[Sin[x]]


Integrate[Sqrt[Sec[x_]],x_Symbol] :=
  2*Sqrt[Cos[x]]*EllipticF[x/2,2]*Sqrt[Sec[x]]


Integrate[1/Sqrt[Sec[x_]],x_Symbol] :=
  2*EllipticE[x/2,2]/(Sqrt[Cos[x]]*Sqrt[Sec[x]])


(* GR5 2.526.10, CRC 312 *)
Integrate[Sec[x_]^2,x_Symbol] :=
  Tan[x]

(* GR5 2.510.6, CRC 313 *)
Integrate[Sec[x_]^n_,x_Symbol] :=
  Sin[x]*Sec[x]^(n-1)/(n-1)+
    (n-2)/(n-1)*Integrate[Sec[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.5, CRC 305 *)
Integrate[Sec[x_]^n_,x_Symbol] :=
  -Sin[x]*Sec[x]^(n+1)/n+
    (n+1)/n*Integrate[Sec[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Csc[x]^n			Powers of cosecants (5)*)
(**)


(* GR5 2.526.1, CRC 295 *)
Integrate[Csc[x_],x_Symbol] :=
  -ArcTanh[Cos[x]]


Integrate[Sqrt[Csc[x_]],x_Symbol] :=
  -2*Sqrt[Csc[x]]*EllipticF[(Pi/2-x)/2,2]*Sqrt[Sin[x]]


Integrate[1/Sqrt[Csc[x_]],x_Symbol] :=
  -2*Sqrt[Csc[x]]*EllipticE[(Pi/2-x)/2,2]*Sqrt[Sin[x]]


(* GR5 2.526.2, CRC 308 *)
Integrate[Csc[x_]^2,x_Symbol] :=
  -Cot[x]

(* GR5 2.510.3, CRC 309 *)
Integrate[Csc[x_]^n_,x_Symbol] :=
  -Cos[x]*Csc[x]^(n-1)/(n-1)+
    (n-2)/(n-1)*Integrate[Csc[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.510.2, CRC 299 *)
Integrate[Csc[x_]^n_,x_Symbol] :=
  Cos[x]*Csc[x]^(n+1)/n+
    (n+1)/n*Integrate[Csc[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Sin[x]^m Cos[x]^n		Products of powers of sines and cosines (8)*)


Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  Sin[x]^(m+1)*Cos[x]^(n+1)/(m+1) /;
FreeQ[{m,n},x] && ZeroQ[m+n+2] && NonzeroQ[m+1]


(* GR5 2.510.1 *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  -Sin[x]^(m-1)*Cos[x]^(n+1)/(n+1)+
    (m-1)/(n+1)*Integrate[Sin[x]^(m-2)*Cos[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1


(* GR5 2.510.4 *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  Sin[x]^(m+1)*Cos[x]^(n-1)/(m+1)+
    (n-1)/(m+1)*Integrate[Sin[x]^(m+2)*Cos[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1


(* GR5 2.510.2, CRC 323b *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  -Sin[x]^(m-1)*Cos[x]^(n+1)/(m+n)+
    (m-1)/(m+n)*Integrate[Sin[x]^(m-2)*Cos[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n]


(* GR5 2.510.5, CRC 323a *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  Sin[x]^(m+1)*Cos[x]^(n-1)/(m+n)+
    (n-1)/(m+n)*Integrate[Sin[x]^m*Cos[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n]


(* GR5 2.510.3, CRC 334a *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  Sin[x]^(m+1)*Cos[x]^(n+1)/(m+1)+
    (m+n+2)/(m+1)*Integrate[Sin[x]^(m+2)*Cos[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1


(* GR5 2.510.6, CRC 334b *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  -Sin[x]^(m+1)*Cos[x]^(n+1)/(n+1)+
    (m+n+2)/(n+1)*Integrate[Sin[x]^m*Cos[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1


(* Kool rule *)
(* Replace with a more general collect fractional power rule?! *)
Integrate[Sin[x_]^m_*Cos[x_]^n_,x_Symbol] :=
  Subst[Integrate[x^(1/m)/(1+x^(2/m)),x],x,Sin[x]^m*Cos[x]^n]/m /;
FractionQ[{m,n}] && ZeroQ[m+n] && IntegerQ[1/m]


(* ::Subsubsection::Closed:: *)
(*Csc[x]^m Sec[x]^n		Products of powers of cosecants and secants (8)*)


(* GR5 2.526.49, CRC 329 *)
Integrate[Csc[x_]*Sec[x_],x_Symbol] :=
  Log[Tan[x]]


Integrate[Csc[x_]^m_*Sec[x_]^n_,x_Symbol] :=
  Csc[x]^(m-1)*Sec[x]^(n-1)/(n-1) /;
FreeQ[{m,n},x] && ZeroQ[m+n-2]


(* GR5 2.510.1 *)
Integrate[Csc[x_]^m_*Sec[x_]^n_,x_Symbol] :=
  -Csc[x]^(m-1)*Sec[x]^(n+1)/(m-1)+
    (n+1)/(m-1)*Integrate[Csc[x]^(m-2)*Sec[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1


(* GR5 2.510.4 *)
Integrate[Csc[x_]^m_*Sec[x_]^n_,x_Symbol] :=
  Csc[x]^(m+1)*Sec[x]^(n-1)/(n-1)+
    (m+1)/(n-1)*Integrate[Csc[x]^(m+2)*Sec[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1


(* GR5 2.510.3, CRC 334a *)
Integrate[Csc[x_]^m_*Sec[x_]^n_.,x_Symbol] :=
  -Csc[x]^(m-1)*Sec[x]^(n-1)/(m-1)+
    (m+n-2)/(m-1)*Integrate[Csc[x]^(m-2)*Sec[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1


(* GR5 2.510.6, CRC 334b *)
Integrate[Csc[x_]^m_.*Sec[x_]^n_,x_Symbol] :=
  Csc[x]^(m-1)*Sec[x]^(n-1)/(n-1)+
    (m+n-2)/(n-1)*Integrate[Csc[x]^m*Sec[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1


(* GR5 2.510.2, CRC 323b *)
Integrate[Csc[x_]^m_*Sec[x_]^n_.,x_Symbol] :=
  Csc[x]^(m+1)*Sec[x]^(n-1)/(m+n)+
    (m+1)/(m+n)*Integrate[Csc[x]^(m+2)*Sec[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n]


(* GR5 2.510.5, CRC 323a *)
Integrate[Csc[x_]^m_.*Sec[x_]^n_,x_Symbol] :=
  -Csc[x]^(m-1)*Sec[x]^(n+1)/(m+n)+
    (n+1)/(m+n)*Integrate[Csc[x]^m*Sec[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n]


(* ::Subsubsection::Closed:: *)
(*Sin[x]^m Tan[x]^n		Products of powers of sines and tangents (8)*)


(* GR5 2.526.18', CRC 327' *)
Integrate[Sin[x_]*Tan[x_],x_Symbol] :=
  -Sin[x]+2*ArcTanh[Tan[x/2]]


Integrate[Sin[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sin[x]^m*Tan[x]^(n-1)/(n-1) /;
FreeQ[{m,n},x] && ZeroQ[m+n-1]


(* GR5 2.510.5, CRC 323a *)
Integrate[Sin[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sin[x]^m*Tan[x]^(n+1)/m-
    (n+1)/m*Integrate[Sin[x]^(m-2)*Tan[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.6, CRC 334b *)
Integrate[Sin[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sin[x]^(m+2)*Tan[x]^(n-1)/(n-1)-
    (m+2)/(n-1)*Integrate[Sin[x]^(m+2)*Tan[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.2, CRC 323b *)
Integrate[Sin[x_]^m_*Tan[x_]^n_.,x_Symbol]:=
  -Sin[x]^m*Tan[x]^(n-1)/m+
    (m+n-1)/m*Integrate[Sin[x]^(m-2)*Tan[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.1 *)
Integrate[Sin[x_]^m_.*Tan[x_]^n_,x_Symbol] :=
  Sin[x]^m*Tan[x]^(n-1)/(n-1)-
    (m+n-1)/(n-1)*Integrate[Sin[x]^m*Tan[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.3, CRC 334a *)
Integrate[Sin[x_]^m_*Tan[x_]^n_.,x_Symbol]:=
  Sin[x]^(m+2)*Tan[x]^(n-1)/(m+n+1)+
    (m+2)/(m+n+1)*Integrate[Sin[x]^(m+2)*Tan[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.4 *)
Integrate[Sin[x_]^m_.*Tan[x_]^n_,x_Symbol]:=
  Sin[x]^m*Tan[x]^(n+1)/(m+n+1)-
    (n+1)/(m+n+1)*Integrate[Sin[x]^m*Tan[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* ::Subsubsection::Closed:: *)
(*Sec[x]^m Tan[x]^n		Products of powers of secants and tangents (8)*)


Integrate[Sec[x_]^2*Tan[x_]^n_,x_Symbol] :=
  Tan[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^m*Tan[x]^(n+1)/(n+1) /;
FreeQ[{m,n},x] && ZeroQ[m+n+1]


(* GR5 2.510.3, CRC 334a *)
Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^(m-2)*Tan[x]^(n+1)/(n+1)-
    (m-2)/(n+1)*Integrate[Sec[x]^(m-2)*Tan[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[EvenQ[m]]


(* GR5 2.510.2, CRC 323b *)
Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^m*Tan[x]^(n-1)/m-
    (n-1)/m*Integrate[Sec[x]^(m+2)*Tan[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[EvenQ[m]]


(* GR5 2.510.6, CRC 334b *)
Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^(m-2)*Tan[x]^(n+1)/(m+n-1)+
    (m-2)/(m+n-1)*Integrate[Sec[x]^(m-2)*Tan[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.510.1 *)
Integrate[Sec[x_]^m_.*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^m*Tan[x]^(n-1)/(m+n-1)-
    (n-1)/(m+n-1)*Integrate[Sec[x]^m*Tan[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.510.5, CRC 323a *)
Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  -Sec[x]^m*Tan[x]^(n+1)/m+
    (m+n+1)/m*Integrate[Sec[x]^(m+2)*Tan[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && Not[EvenQ[m]]


(* GR5 2.510.4 *)
Integrate[Sec[x_]^m_*Tan[x_]^n_,x_Symbol] :=
  Sec[x]^m*Tan[x]^(n+1)/(n+1)-
    (m+n+1)/(n+1)*Integrate[Sec[x]^m*Tan[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && Not[EvenQ[m]]


(* ::Subsubsection::Closed:: *)
(*Cos[x]^m Cot[x]^n		Products of powers of cosines and cotangents (8)*)


Integrate[Cos[x_]*Cot[x_],x_Symbol] :=
  Cos[x]+Integrate[Csc[x],x]


Integrate[Cos[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  Cos[x]^m*Cot[x]^(n-1)/m /;
FreeQ[{m,n},x] && ZeroQ[m+n-1]


(* GR5 2.510.2, CRC 323b *)
Integrate[Cos[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  -Cos[x]^m*Cot[x]^(n+1)/m-
    (n+1)/m*Integrate[Cos[x]^(m-2)*Cot[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.3, CRC 334a *)
Integrate[Cos[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  -Cos[x]^(m+2)*Cot[x]^(n-1)/(n-1)-
    (m+2)/(n-1)*Integrate[Cos[x]^(m+2)*Cot[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.5, CRC 323a *)
Integrate[Cos[x_]^m_*Cot[x_]^n_.,x_Symbol] :=
  Cos[x]^m*Cot[x]^(n-1)/m+
    (m+n-1)/m*Integrate[Cos[x]^(m-2)*Cot[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.4 *)
Integrate[Cos[x_]^m_.*Cot[x_]^n_,x_Symbol] :=
  -Cos[x]^m*Cot[x]^(n-1)/(n-1)-
    (m+n-1)/(n-1)*Integrate[Cos[x]^m*Cot[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.6, CRC 334b *)
Integrate[Cos[x_]^m_*Cot[x_]^n_.,x_Symbol] :=
  -Cos[x]^(m+2)*Cot[x]^(n-1)/(m+n+1)+
    (m+2)/(m+n+1)*Integrate[Cos[x]^(m+2)*Cot[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.510.1 *)
Integrate[Cos[x_]^m_.*Cot[x_]^n_,x_Symbol] :=
  -Cos[x]^m*Cot[x]^(n+1)/(m+n+1)-
    (n+1)/(m+n+1)*Integrate[Cos[x]^m*Cot[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* ::Subsubsection::Closed:: *)
(*Csc[x]^m Cot[x]^n		Products of powers of cosecants and cotangents (8)*)
(**)


Integrate[Csc[x_]^2*Cot[x_]^n_,x_Symbol] :=
  -Cot[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[Csc[x_]^m_.*Cot[x_]^n_,x_Symbol] :=
  Csc[x]^m*Cot[x]^(n+1)/m /;
FreeQ[{m,n},x] && ZeroQ[m+n+1]


(* GR5 2.510.6, CRC 334b *)
Integrate[Csc[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  -Csc[x]^(m-2)*Cot[x]^(n+1)/(n+1)-
    (m-2)/(n+1)*Integrate[Csc[x]^(m-2)*Cot[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[EvenQ[m]]


(* GR5 2.510.5, CRC 323a *)
Integrate[Csc[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  -Csc[x]^m*Cot[x]^(n-1)/m-
    (n-1)/m*Integrate[Csc[x]^(m+2)*Cot[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[EvenQ[m]]


(* GR5 2.510.3, CRC 334a *)
Integrate[Csc[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  -Csc[x]^(m-2)*Cot[x]^(n+1)/(m+n-1)+
    (m-2)/(m+n-1)*Integrate[Csc[x]^(m-2)*Cot[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.510.4 *)
Integrate[Csc[x_]^m_.*Cot[x_]^n_,x_Symbol] :=
  -Csc[x]^m*Cot[x]^(n-1)/(m+n-1)-
    (n-1)/(m+n-1)*Integrate[Csc[x]^m*Cot[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.510.2, CRC 323b *)
Integrate[Csc[x_]^m_*Cot[x_]^n_,x_Symbol] :=
  Csc[x]^m*Cot[x]^(n+1)/m+
    (m+n+1)/m*Integrate[Csc[x]^(m+2)*Cot[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && Not[EvenQ[m]]


(* GR5 2.510.1 *)
Integrate[Csc[x_]^m_.*Cot[x_]^n_,x_Symbol] :=
  -Csc[x]^m*Cot[x]^(n+1)/(n+1)-
    (m+n+1)/(n+1)*Integrate[Csc[x]^m*Cot[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && Not[EvenQ[m]]


(* ::Subsubsection::Closed:: *)
(*x^m Sin[a+b x^n]^p		Products of monomials and powers of sines of binomials (10)*)


Integrate[Sin[b_.*x_^2],x_Symbol] :=
  FresnelS[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2] /;
FreeQ[b,x]


Integrate[Sin[a_+b_.*x_^2],x_Symbol] :=
  Cos[a]*FresnelS[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2]+
  Sin[a]*FresnelC[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2] /;
FreeQ[{a,b},x]


Integrate[Sin[b_.*x_^n_.]/x_,x_Symbol] :=
  SinIntegral[b*x^n]/n /;
FreeQ[{b,n},x]


Integrate[Sin[a_+b_.*x_^n_.]/x_,x_Symbol] :=
  Sin[a]*CosIntegral[b*x^n]/n+Cos[a]*SinIntegral[b*x^n]/n /;
FreeQ[{a,b,n},x]


(* CRC 392 *)
Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.],x_Symbol] :=
  -x^(m-n+1)*Cos[a+b*x^n]/(b*n)+
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Cos[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 405 *)
Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*Sin[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)*Cos[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && n>0 && m<-1


(* GR5 2.631.2' *)
Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  n*Sin[a+b*x^n]^p/(b^2*n^2*p^2)-
    x^n*Cos[a+b*x^n]*Sin[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Sin[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>1 && ZeroQ[m-2*n+1]


(* GR5 2.631.2 *)
Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  (m-n+1)*x^(m-2*n+1)*Sin[a+b*x^n]^p/(b^2*n^2*p^2)-
    x^(m-n+1)*Cos[a+b*x^n]*Sin[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Sin[a+b*x^n]^(p-2),x]-
    (m-n+1)*(m-2*n+1)/(b^2*n^2*p^2)*Integrate[x^(m-2*n)*Sin[a+b*x^n]^p,x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && 0<2*n<m+1


(* GR5 2.638.1 *)
Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -b*n*p*x^(m+n+1)*Sin[a+b*x^n]^(p-1)*Cos[a+b*x^n]/((m+1)*(m+n+1))+
    x^(m+1)*Sin[a+b*x^n]^p/(m+1)-
    b^2*n^2*p^2/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Sin[a+b*x^n]^p,x]+
    b^2*n^2*p*(p-1)/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Sin[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && n>0 && m<-1 && m+n+1!=0


Integrate[(a_.+b_.*x_)^m_*Sin[c_.+d_.*x_]^p_.,x_Symbol] :=
  Subst[Integrate[x^m*Sin[c-a*d/b+d*x/b]^p,x],x,a+b*x]/b /;
FreeQ[{a,b,c,d,m},x] && RationalQ[p] && Not[a===0 && b===1]


(* ::Subsubsection::Closed:: *)
(*x^m Cos[a+b x^n]^p		Products of monomials and powers of cosines of binomials (10)*)


Integrate[Cos[b_.*x_^2],x_Symbol] :=
  FresnelC[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2] /;
FreeQ[b,x]


Integrate[Cos[a_+b_.*x_^2],x_Symbol] :=
  Cos[a]*FresnelC[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2]-
  Sin[a]*FresnelS[Rt[2*b/Pi,2]*x]/Rt[2*b/Pi,2] /;
FreeQ[{a,b},x]


Integrate[Cos[b_.*x_^n_.]/x_,x_Symbol] :=
  CosIntegral[b*x^n]/n /;
FreeQ[{b,n},x]


Integrate[Cos[a_+b_.*x_^n_.]/x_,x_Symbol] :=
  Cos[a]*CosIntegral[b*x^n]/n-Sin[a]*SinIntegral[b*x^n]/n /;
FreeQ[{a,b,n},x]


(* CRC 396 *)
Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m-n+1)*Sin[a+b*x^n]/(b*n)-
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Sin[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 406 *)
Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*Cos[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)*Sin[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && n>0 && m<-1


(* GR5 2.631.3' *)
Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  n*Cos[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^n*Sin[a+b*x^n]*Cos[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Cos[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>1 && ZeroQ[m-2*n+1]


(* GR5 2.631.3 *)
Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  (m-n+1)*x^(m-2*n+1)*Cos[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^(m-n+1)*Sin[a+b*x^n]*Cos[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Cos[a+b*x^n]^(p-2),x]-
    (m-n+1)*(m-2*n+1)/(b^2*n^2*p^2)*Integrate[x^(m-2*n)*Cos[a+b*x^n]^p,x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && 0<2*n<m+1


(* GR5 2.638.2 *)
Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  b*n*p*x^(m+n+1)*Sin[a+b*x^n]*Cos[a+b*x^n]^(p-1)/((m+1)*(m+n+1))+
    x^(m+1)*Cos[a+b*x^n]^p/(m+1)-
    b^2*n^2*p^2/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Cos[a+b*x^n]^p,x]+
    b^2*n^2*p*(p-1)/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Cos[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && n>0 && m<-1 && m+n+1!=0


Integrate[(a_.+b_.*x_)^m_*Cos[c_.+d_.*x_]^p_.,x_Symbol] :=
  Subst[Integrate[x^m*Cos[c-a*d/b+d*x/b]^p,x],x,a+b*x]/b /;
FreeQ[{a,b,c,d,m},x] && RationalQ[p] && Not[a===0 && b===1]


(* ::Subsubsection::Closed:: *)
(*x^m Tan[a+b x^n]^p		Products of monomials and powers of tangents of binomials (2)*)


Integrate[x_^m_.*Tan[a_.+b_.*x_^n_.],x_Symbol] :=
  -I*Integrate[x^m,x] +
    2*I*Integrate[x^m/(1+E^(2*I*(a+b*x^n))),x] /;
FreeQ[{a,b,m,n},x] && NonzeroQ[m-n+1]


Integrate[x_^m_.*Tan[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  -Integrate[x^m,x] +
    Integrate[x^m*Sec[a+b*x^n]^2,x] /;
FreeQ[{a,b,m,n},x]

Integrate[x_^m_.*Tan[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -Integrate[x^m*Tan[a+b*x^n]^(p-2),x] +
    Integrate[x^m*Sec[a+b*x^n]^2*Tan[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Cot[a+b x^n]^p		Products of monomials and powers of cotangents of binomials (2)*)


Integrate[x_^m_.*Cot[a_.+b_.*x_^n_.],x_Symbol] :=
  I*Integrate[x^m,x] -
    2*I*Integrate[x^m/(1-E^(2*I*(a+b*x^n))),x] /;
FreeQ[{a,b,m,n},x] && NonzeroQ[m-n+1]


Integrate[x_^m_.*Cot[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  -Integrate[x^m,x] +
    Integrate[x^m*Csc[a+b*x^n]^2,x] /;
FreeQ[{a,b,m,n},x]

Integrate[x_^m_.*Cot[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -Integrate[x^m*Cot[a+b*x^n]^(p-2),x] +
    Integrate[x^m*Csc[a+b*x^n]^2*Cot[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Sec[a+b x^n]^p		Products of monomials and powers of secants of binomials (4)*)


(* CRC 430 *)
Integrate[x_^m_.*Sec[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  x^(m-n+1)*Tan[a+b*x^n]/(b*n)-
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Tan[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 431 *)
Integrate[x_*Sec[a_.+b_.*x_]^p_,x_Symbol] :=
  -Sec[a+b*x]^(p-2)/(b^2*(p-1)*(p-2))+
    x*Tan[a+b*x]*Sec[a+b*x]^(p-2)/(b*(p-1))+
    (p-2)/(p-1)*Integrate[x*Sec[a+b*x]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>1 && p!=2


(* GR5 2.643.2 *)
Integrate[Sec[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  Tan[a+b*x^n]*Sec[a+b*x^n]^(p-2)/(b*n*(p-1)*x^(n-1))+
    (n-1)*Sec[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2)*x^(2*n-1))+
    (p-2)/(p-1)*Integrate[Sec[a+b*x^n]^(p-2),x]+
    (n-1)*(2*n-1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Sec[a+b*x^n]^(p-2)/x^(2*n),x] /;
FreeQ[{a,b},x] && RationalQ[p] && IntegerQ[n] && n>0 && p>1 && p!=2


(* GR5 2.643.2 *)
Integrate[x_^m_.*Sec[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  x^(m-n+1)*Tan[a+b*x^n]*Sec[a+b*x^n]^(p-2)/(b*n*(p-1))-
    (m-n+1)*x^(m-2*n+1)*Sec[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (p-2)/(p-1)*Integrate[x^m*Sec[a+b*x^n]^(p-2),x]+
    (m-n+1)*(m-2*n+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^(m-2*n)*Sec[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[{m,p}] && IntegerQ[n] && n>0 && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Csc[a+b x^n]^p		Products of monomials and powers of cosecants of binomials (4)*)
(**)


(* CRC 428 *)
Integrate[x_^m_.*Csc[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  -x^(m-n+1)*Cot[a+b*x^n]/(b*n)+
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Cot[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 429 *)
Integrate[x_*Csc[a_.+b_.*x_]^p_,x_Symbol] :=
  -Csc[a+b*x]^(p-2)/(b^2*(p-1)*(p-2))-
    x*Cot[a+b*x]*Csc[a+b*x]^(p-2)/(b*(p-1))+
    (p-2)/(p-1)*Integrate[x*Csc[a+b*x]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>1 && p!=2


(* GR5 2.643.1 *)
Integrate[Csc[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -Cot[a+b*x^n]*Csc[a+b*x^n]^(p-2)/(b*n*(p-1)*x^(n-1))+
    (n-1)*Csc[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2)*x^(2*n-1))+
    (p-2)/(p-1)*Integrate[Csc[a+b*x^n]^(p-2),x]+
    (n-1)*(2*n-1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Csc[a+b*x^n]^(p-2)/x^(2*n),x] /;
FreeQ[{a,b},x] && RationalQ[p] && IntegerQ[n] && p>1 && p!=2


(* GR5 2.643.1 *)
Integrate[x_^m_.*Csc[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -x^(m-n+1)*Cot[a+b*x^n]*Csc[a+b*x^n]^(p-2)/(b*n*(p-1))-
    (m-n+1)*x^(m-2*n+1)*Csc[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (p-2)/(p-1)*Integrate[x^m*Csc[a+b*x^n]^(p-2),x]+
    (m-n+1)*(m-2*n+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^(m-2*n)*Csc[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[{m,p}] && IntegerQ[n] && n>0 && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Sin[a+b x^n] Cos[a+b x^n]^p	Products of monomials, sines and powers of cosines of binomials (1)*)


Integrate[x_^m_.*Sin[a_.+b_.*x_^n_.]*Cos[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -x^(m-n+1)*Cos[a+b*x^n]^(p+1)/(b*n*(p+1))+
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*Cos[a+b*x^n]^(p+1),x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>0 && Not[p===-1]


(* ::Subsubsection::Closed:: *)
(*x^m Cos[a+b x^n] Sin[a+b x^n]^p	Products of monomials, cosines and powers of sines of binomials (1)*)


Integrate[x_^m_.*Cos[a_.+b_.*x_^n_.]*Sin[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  x^(m-n+1)*Sin[a+b*x^n]^(p+1)/(b*n*(p+1))-
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*Sin[a+b*x^n]^(p+1),x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>0 && Not[p===-1]


(* ::Subsubsection::Closed:: *)
(*x^m Tan[a+b x^n] Sec[a+b x^n]^p	Products of monomials, tangents and powers of secants of binomials (1)*)


Integrate[x_^m_.*Tan[a_.+b_.*x_^n_.]^q_.*Sec[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  x^(m-n+1)*Sec[a+b*x^n]^p/(b*n*p)-
    (m-n+1)/(b*n*p)*Integrate[x^(m-n)*Sec[a+b*x^n]^p,x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>=0 && q===1 (* Required so InputForm is matchable *)


(* ::Subsubsection::Closed:: *)
(*x^m Cot[a+b x^n] Csc[a+b x^n]^p	Products of monomials, cotangents and powers of cosecants of binomials (1)*)
(**)


Integrate[x_^m_.*Cot[a_.+b_.*x_^n_.]^q_.*Csc[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  -x^(m-n+1)*Csc[a+b*x^n]^p/(b*n*p)+
    (m-n+1)/(b*n*p)*Integrate[x^(m-n)*Csc[a+b*x^n]^p,x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>=0 && q===1 (* Required so InputForm is matchable *)


(* ::Subsubsection::Closed:: *)
(*Log[x] Sin[a+b x]^p		Products of logarithms and powers of sines of linears (1)*)


(* Need to generalize this! *)
Integrate[Log[x_]*Sin[a_.+b_.*x_],x_Symbol] :=
  -Log[x]*Cos[a+b*x]/b+
    Integrate[Cos[a+b*x]/x,x]/b /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*Log[x] Cos[a+b x]^p		Products of logarithms and powers of cosines of linears (1)*)
(**)


(* Need to generalize this! *)
Integrate[Log[x_]*Cos[a_.+b_.*x_],x_Symbol] :=
  Log[x]*Sin[a+b*x]/b-
    Integrate[Sin[a+b*x]/x,x]/b /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*Trg[m z]^m Trg[n z]^n	Products of trig functions involving multiple angles (6)*)
(**)


Integrate[Sin[a_.+b_.*x_]^m_.*Cos[c_.+d_.*x_]^n_.,x_Symbol] :=
  2^m*Integrate[Sin[c+d*x]^m*Cos[c+d*x]^(m+n),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && a===2*c && b===2*d


Integrate[Sin[a_.+b_.*x_]^m_.*Sin[c_.+d_.*x_]^n_.,x_Symbol] :=
  2^m*Integrate[Sin[c+d*x]^(m+n)*Cos[c+d*x]^m,x] /;
FreeQ[{a,b,c,d},x] && RationalQ[{m,n}] && a===2*c && b===2*d


Integrate[u_.*Sin[a_.+b_.*x_]*Csc[c_.+d_.*x_],x_Symbol] :=
  2*Integrate[u*Cos[c+d*x],x] /;
FreeQ[{a,b,c,d},x] && a===2*c && b===2*d


Integrate[u_.*Sin[a_.+b_.*x_]*Csc[c_.+d_.*x_],x_Symbol] :=
  Module[{n=b/d},
  2*Integrate[u*Cos[(n-1)*c+(n-1)*d*x],x]+
    Integrate[u*Sin[(n-2)*c+(n-2)*d*x]*Csc[c+d*x],x] /;
 IntegerQ[n] && n>2 && a===n*c] /;
FreeQ[{a,b,c,d},x]


Integrate[u_.*Cos[a_.+b_.*x_]*Sec[c_.+d_.*x_],x_Symbol] :=
  2*Integrate[u*Cos[c+d*x],x]-
    Integrate[u*Sec[c+d*x],x] /;
FreeQ[{a,b,c,d},x] && a===2*c && b===2*d


Integrate[u_.*Cos[a_.+b_.*x_]*Sec[c_.+d_.*x_],x_Symbol] :=
  Module[{n=b/d},
  2*Integrate[u*Cos[(n-1)*c+(n-1)*d*x],x]-
    Integrate[u*Cos[(n-2)*c+(n-2)*d*x]*Sec[c+d*x],x] /;
 IntegerQ[n] && n>1 && a===n*c] /;
FreeQ[{a,b,c,d},x]


(* ::Subsubsection::Closed:: *)
(*(1+Sin[x])^n			Powers of one plus sines (5)*)


Integrate[1/(1+Sin[x_]),x_Symbol] :=
  -Cos[x]/(1+Sin[x])


Integrate[Sqrt[1+Sin[x_]],x_Symbol] :=
  -2*Cos[x]/Sqrt[1+Sin[x]]


Integrate[1/Sqrt[1+Sin[x_]],x_Symbol] :=
  2*Sqrt[2]*ArcTanh[(-1+Tan[x/4])/Sqrt[2]]*(Cos[x/2]+Sin[x/2])/Sqrt[1+Sin[x]]


Integrate[(1+Sin[x_])^n_,x_Symbol] :=
  -Cos[x]*(1+Sin[x])^(n-1)/n+
    (2*n-1)/n*Integrate[(1+Sin[x])^(n-1),x] /;
RationalQ[n] && n>1


Integrate[(1+Sin[x_])^n_,x_Symbol] :=
  Cos[x]*(1+Sin[x])^n/(2*n+1)+
    (n+1)/(2*n+1)*Integrate[(1+Sin[x])^(n+1),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*(1-Sin[x])^n			Powers of one minus sines (5)*)


Integrate[1/(1-Sin[x_]),x_Symbol] :=
  Cos[x]/(1-Sin[x])


Integrate[Sqrt[1-Sin[x_]],x_Symbol] :=
  2*Cos[x]/Sqrt[1-Sin[x]]


Integrate[1/Sqrt[1-Sin[x_]],x_Symbol] :=
  2*Sqrt[2]*ArcTanh[(1+Tan[x/4])/Sqrt[2]]*(Cos[x/2]-Sin[x/2])/Sqrt[1-Sin[x]]


Integrate[(1-Sin[x_])^n_,x_Symbol] :=
  Cos[x]*(1-Sin[x])^(n-1)/n+
    (2*n-1)/n*Integrate[(1-Sin[x])^(n-1),x] /;
RationalQ[n] && n>1


Integrate[(1-Sin[x_])^n_,x_Symbol] :=
  -Cos[x]*(1-Sin[x])^n/(2*n+1)+
    (n+1)/(2*n+1)*Integrate[(1-Sin[x])^(n+1),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*(1+Cos[x])^n			Powers of one plus cosines (5)*)


Integrate[1/(1+Cos[x_]),x_Symbol] :=
  Sin[x]/(1+Cos[x])


Integrate[Sqrt[1+Cos[x_]],x_Symbol] :=
  2*Sin[x]/Sqrt[1+Cos[x]]


Integrate[1/Sqrt[1+Cos[x_]],x_Symbol] :=
  2*ArcTanh[Sin[x/2]]*Cos[x/2]/Sqrt[1+Cos[x]]


Integrate[(1+Cos[x_])^n_,x_Symbol] :=
  Sin[x]*(1+Cos[x])^(n-1)/n+
    (2*n-1)/n*Integrate[(1+Cos[x])^(n-1),x] /;
RationalQ[n] && n>1


Integrate[(1+Cos[x_])^n_,x_Symbol] :=
  -Sin[x]*(1+Cos[x])^n/(2*n+1)+
    (n+1)/(2*n+1)*Integrate[(1+Cos[x])^(n+1),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*(1-Cos[x])^n			Powers of one minus cosines (5)*)
(**)


Integrate[1/(1-Cos[x_]),x_Symbol] :=
  -Sin[x]/(1-Cos[x])


Integrate[Sqrt[1-Cos[x_]],x_Symbol] :=
  -2*Sin[x]/Sqrt[1-Cos[x]]


Integrate[1/Sqrt[1-Cos[x_]],x_Symbol] :=
  -2*ArcTanh[Cos[x/2]]*Sin[x/2]/Sqrt[1-Cos[x]]


Integrate[(1-Cos[x_])^n_,x_Symbol] :=
  -Sin[x]*(1-Cos[x])^(n-1)/n+
    (2*n-1)/n*Integrate[(1-Cos[x])^(n-1),x] /;
RationalQ[n] && n>1


Integrate[(1-Cos[x_])^n_,x_Symbol] :=
  Sin[x]*(1-Cos[x])^n/(2*n+1)+
    (n+1)/(2*n+1)*Integrate[(1-Cos[x])^(n+1),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*x / (1\[PlusMinus]Sin[a+b x])		Powers of one plus or minus sines of linears (2)*)


Integrate[x_/(1+Sin[a_.+b_.*x_]),x_Symbol] :=
  Log[1+Sin[a+b*x]]/b^2-x*Cos[a+b*x]/(b*(1+Sin[a+b*x])) /;
FreeQ[{a,b},x]


Integrate[x_/(1-Sin[a_.+b_.*x_]),x_Symbol] :=
  x*Cos[a+b*x]/(b*(1-Sin[a+b*x]))+Log[1-Sin[a+b*x]]/b^2 /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*x / (1\[PlusMinus]Cos[a+b x])		Powers of one plus or minus cosines of linears (2)*)
(**)


Integrate[x_/(1+Cos[a_.+b_.*x_]),x_Symbol] :=
  Log[1+Cos[a+b*x]]/b^2+x*Sin[a+b*x]/(b*(1+Cos[a+b*x])) /;
FreeQ[{a,b},x]


Integrate[x_/(1-Cos[a_.+b_.*x_]),x_Symbol] :=
  -x*Sin[a+b*x]/(b*(1-Cos[a+b*x]))+Log[1-Cos[a+b*x]]/b^2 /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*x^m Sin[a+b Log[c x^n]]^p	Products of monomials and powers of sines of logarithms (4)*)


Integrate[Sin[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  x*Sin[a+b*Log[c*x^n]]/(b^2*n^2+1)-
    b*n*x*Cos[a+b*Log[c*x^n]]/(b^2*n^2+1) /;
FreeQ[{a,b,c,n},x] && NonzeroQ[b^2*n^2+1]


(* CRC 498 *)
Integrate[x_^m_.*Sin[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  (m+1)*x^(m+1)*Sin[a+b*Log[c*x^n]]/(b^2*n^2+(m+1)^2)-
    b*n*x^(m+1)*Cos[a+b*Log[c*x^n]]/(b^2*n^2+(m+1)^2) /;
FreeQ[{a,b,c,m,n},x] && NonzeroQ[b^2*n^2+(m+1)^2]


Integrate[Sin[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  x*Sin[a+b*Log[c*x^n]]^p/(b^2*n^2*p^2+1)-
    b*p*n*x*Cos[a+b*Log[c*x^n]]*Sin[a+b*Log[c*x^n]]^(p-1)/(b^2*n^2*p^2+1)+
    b^2*p*n^2*(p-1)/(b^2*n^2*p^2+1)*Integrate[Sin[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,n},x] && RationalQ[p] && p>1 && NonzeroQ[b^2*n^2*p^2+1]


Integrate[x_^m_.*Sin[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  (m+1)*x^(m+1)*Sin[a+b*Log[c*x^n]]^p/(b^2*n^2*p^2+(m+1)^2)-
    b*p*n*x^(m+1)*Cos[a+b*Log[c*x^n]]*Sin[a+b*Log[c*x^n]]^(p-1)/(b^2*n^2*p^2+(m+1)^2)+
    b^2*p*n^2*(p-1)/(b^2*n^2*p^2+(m+1)^2)*Integrate[x^m*Sin[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,m,n},x] && RationalQ[p] && p>1 && NonzeroQ[b^2*n^2*p^2+(m+1)^2]


(* ::Subsubsection::Closed:: *)
(*x^m Cos[a+b Log[c x^n]]^p	Products of monomials and powers of cosines of logarithms (4)*)


Integrate[Cos[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  x*Cos[a+b*Log[c*x^n]]/(b^2*n^2+1)+
    b*n*x*Sin[a+b*Log[c*x^n]]/(b^2*n^2+1) /;
FreeQ[{a,b,c,n},x] && NonzeroQ[b^2*n^2+1]


(* CRC 497 *)
Integrate[x_^m_.*Cos[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  (m+1)*x^(m+1)*Cos[a+b*Log[c*x^n]]/(b^2*n^2+(m+1)^2)+
    b*n*x^(m+1)*Sin[a+b*Log[c*x^n]]/(b^2*n^2+(m+1)^2) /;
FreeQ[{a,b,c,m,n},x] && NonzeroQ[b^2*n^2+(m+1)^2]


Integrate[Cos[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  x*Cos[a+b*Log[c*x^n]]^p/(b^2*n^2*p^2+1)+
    b*p*n*x*Cos[a+b*Log[c*x^n]]^(p-1)*Sin[a+b*Log[c*x^n]]/(b^2*n^2*p^2+1)+
    b^2*p*n^2*(p-1)/(b^2*n^2*p^2+1)*Integrate[Cos[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,n},x] && RationalQ[p] && p>1 && NonzeroQ[b^2*n^2*p^2+1]


Integrate[x_^m_.*Cos[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  (m+1)*x^(m+1)*Cos[a+b*Log[c*x^n]]^p/(b^2*n^2*p^2+(m+1)^2)+
    b*p*n*x^(m+1)*Cos[a+b*Log[c*x^n]]^(p-1)*Sin[a+b*Log[c*x^n]]/(b^2*n^2*p^2+(m+1)^2)+
    b^2*p*n^2*(p-1)/(b^2*n^2*p^2+(m+1)^2)*Integrate[x^m*Cos[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,m,n},x] && RationalQ[p] && p>1 && NonzeroQ[b^2*n^2*p^2+(m+1)^2]


(* ::Subsubsection::Closed:: *)
(*x^m Sec[a+b Log[c x^n]]^p	Products of monomials and powers of secants of logarithms (2)*)


Integrate[Sec[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  x*Tan[a+b*Log[c*x^n]]*Sec[a+b*Log[c*x^n]]^(p-2)/(b*n*(p-1))-
    x*Sec[a+b*Log[c*x^n]]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (b^2*n^2*(p-2)^2+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Sec[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,n},x] && RationalQ[p] && p>1 && p!=2


Integrate[x_^m_.*Sec[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  x^(m+1)*Tan[a+b*Log[c*x^n]]*Sec[a+b*Log[c*x^n]]^(p-2)/(b*n*(p-1))-
    (m+1)*x^(m+1)*Sec[a+b*Log[c*x^n]]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (b^2*n^2*(p-2)^2+(m+1)^2)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^m*Sec[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,m,n},x] && RationalQ[p] && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Csc[a+b Log[c x^n]]^p	Products of monomials and powers of cosecants of logarithms (2)*)
(**)


Integrate[Csc[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  -x*Cot[a+b*Log[c*x^n]]*Csc[a+b*Log[c*x^n]]^(p-2)/(b*n*(p-1))-
    x*Csc[a+b*Log[c*x^n]]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (b^2*n^2*(p-2)^2+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Csc[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,n},x] && RationalQ[p] && p>1 && p!=2


Integrate[x_^m_.*Csc[a_.+b_.*Log[c_.*x_^n_.]]^p_,x_Symbol] :=
  -x^(m+1)*Cot[a+b*Log[c*x^n]]*Csc[a+b*Log[c*x^n]]^(p-2)/(b*n*(p-1))-
    (m+1)*x^(m+1)*Csc[a+b*Log[c*x^n]]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (b^2*n^2*(p-2)^2+(m+1)^2)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^m*Csc[a+b*Log[c*x^n]]^(p-2),x] /;
FreeQ[{a,b,c,m,n},x] && RationalQ[p] && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Sin[a x^n Log[b x]^p Log[b x]^p		Products of sines and powers of logarithms (3)*)


Integrate[Sin[a_.*x_*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  -Cos[a*x*Log[b*x]^p]/a-
    p*Integrate[Sin[a*x*Log[b*x]^p]*Log[b*x]^(p-1),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>0


Integrate[Sin[a_.*x_^n_*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  -x^(1-n)*Cos[a*x^n*Log[b*x]^p]/(a*n)-
    p/n*Integrate[Sin[a*x^n*Log[b*x]^p]*Log[b*x]^(p-1),x]+
    (1-n)/(a*n)*Integrate[x^(-n)*Cos[a*x^n*Log[b*x]^p],x] /;
FreeQ[{a,b},x] && RationalQ[{n,p}] && p>0


Integrate[x_^m_*Sin[a_.*x_^n_.*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  -x^(m-n+1)*Cos[a*x^n*Log[b*x]^p]/(a*n)-
    p/n*Integrate[x^m*Sin[a*x^n*Log[b*x]^p]*Log[b*x]^(p-1),x]+
    (m-n+1)/(a*n)*Integrate[x^(m-n)*Cos[a*x^n*Log[b*x]^p],x] /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Cos[a x^n Log[b x]^p Log[b x]^p	Products of cosines and powers of logarithms (3)*)
(**)


Integrate[Cos[a_.*x_*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  Sin[a*x*Log[b*x]^p]/a-
    p*Integrate[Cos[a*x*Log[b*x]^p]*Log[b*x]^(p-1),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>0


Integrate[Cos[a_.*x_^n_*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  x^(1-n)*Sin[a*x^n*Log[b*x]^p]/(a*n)-
    p/n*Integrate[Cos[a*x^n*Log[b*x]^p]*Log[b*x]^(p-1),x]-
    (1-n)/(a*n)*Integrate[x^(-n)*Sin[a*x^n*Log[b*x]^p],x] /;
FreeQ[{a,b},x] && RationalQ[{n,p}] && p>0


Integrate[x_^m_*Cos[a_.*x_^n_.*Log[b_.*x_]^p_.]*Log[b_.*x_]^p_.,x_Symbol] :=
  x^(m-n+1)*Sin[a*x^n*Log[b*x]^p]/(a*n)-
    p/n*Integrate[x^m*Cos[a*x^n*Log[b*x]^p]*Log[b*x]^(p-1),x]-
    (m-n+1)/(a*n)*Integrate[x^(m-n)*Sin[a*x^n*Log[b*x]^p],x] /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p>0


(* ::Subsubsection::Closed:: *)
(*1 / (a+b Trig[x]^n)		Reciprocals of binomial trig functions (4)*)


Integrate[1/(a_.+b_.*Tan[x_]),x_Symbol] :=
  (a*x+b*Log[a*Cos[x]+b*Sin[x]])/(a^2+b^2) /;
FreeQ[{a,b},x] && NonzeroQ[a^2+b^2]


Integrate[1/(a_.+b_.*Cot[x_]),x_Symbol] :=
  (a*x-b*Log[b*Cos[x]+a*Sin[x]])/(a^2+b^2) /;
FreeQ[{a,b},x] && NonzeroQ[a^2+b^2]


Integrate[1/(a_.+b_.*Tan[x_]^2),x_Symbol] :=
  (x-(Sqrt[b]*ArcTan[(Sqrt[b]*Tan[x])/Sqrt[a]])/Sqrt[a])/(a-b) /;
FreeQ[{a,b},x] && NonzeroQ[a-b]


Integrate[1/(a_.+b_.*Cot[x_]^2),x_Symbol] :=
  (x+(Sqrt[b]*ArcTan[(Sqrt[b]*Cot[x])/Sqrt[a]])/Sqrt[a])/(a-b) /;
FreeQ[{a,b},x] && NonzeroQ[a-b]


(* ::Subsubsection::Closed:: *)
(*u / (a+b Trig[v])		Quotients of expressions by sums involving trig functions (2)*)
(**)


Integrate[u_./(a_+b_.*Sec[v_]),x_Symbol] :=
  Integrate[u,x]/a-b*Integrate[u/(b+a*Cos[v]),x]/a /;
FreeQ[{a,b},x] && Not[v===x && u===Tan[x]]


Integrate[u_./(a_+b_.*Csc[v_]),x_Symbol] :=
  Integrate[u,x]/a-b*Integrate[u/(b+a*Sin[v]),x]/a /;
FreeQ[{a,b},x] && Not[v===x && u===Cot[x]]


(* ::Subsubsection::Closed:: *)
(*v (1+Trig[u]^2)^n		Simplify one plus or minus the square of trig functions (6)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
(* Should generalize this for any subexpression of the form w-w*Trig[u]^2 *)
Integrate[v_.*(w_+t_.*Sin[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Cos[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Cos[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Sin[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Tan[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Sec[u]^2)^n,x] /;
ZeroQ[w-t]


Integrate[v_.*(w_+t_.*Cot[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Csc[u]^2)^n,x] /;
ZeroQ[w-t]


Integrate[v_.*(w_+t_.*Sec[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(t*Tan[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Csc[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(t*Cot[u]^2)^n,x] /;
ZeroQ[w+t]


(* ::Subsubsection::Closed:: *)
(*v Trig[u]^(2n) / (1+Trig[u])^n	Simplify trig function squared over one plus or minus trig function (4)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[v_.*Sin[u_]^m_*(a_+a_.*Cos[u_])^n_.,x_Symbol] :=
  Integrate[v*a^n*(1-Cos[u])^(m/2),x] /;
FreeQ[a,x] && IntegerQ[{m,n}] && m===-2*n


Integrate[v_.*Sin[u_]^m_*(a_-a_.*Cos[u_])^n_.,x_Symbol] :=
  Integrate[v*a^n*(1+Cos[u])^(m/2),x] /;
FreeQ[a,x] && IntegerQ[{m,n}] && m===-2*n


Integrate[v_.*Cos[u_]^m_*(a_+a_.*Sin[u_])^n_.,x_Symbol] :=
  Integrate[v*a^n*(1-Sin[u])^(m/2),x] /;
FreeQ[a,x] && IntegerQ[{m,n}] && m===-2*n


Integrate[v_.*Cos[u_]^m_*(a_-a_.*Sin[u_])^n_.,x_Symbol] :=
  Integrate[v*a^n*(1+Sin[u])^(m/2),x] /;
FreeQ[a,x] && IntegerQ[{m,n}] && m===-2*n


(* ::Subsubsection::Closed:: *)
(*v (a Trig[u]^m+b Trig[u]^m)^n  Simplify sum of powers of trig functions (4)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[v_.*(a_.*Tan[u_]^2+b_.*Sec[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(b+(a+b)*Tan[u]^2)^n,x] /;
FreeQ[{a,b},x]


Integrate[v_.*(a_.*Cot[u_]^2+b_.*Csc[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(b+(a+b)*Cot[u]^2)^n,x] /;
FreeQ[{a,b},x]


Integrate[v_.*(a_.*Sec[u_]^m_.+b_.*Tan[u_]^m_.)^n_,x_Symbol] :=
  Integrate[v*(a+b*Sin[u]^m)^n/Cos[u]^(m*n),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n}]


Integrate[v_.*(a_.*Csc[u_]^m_.+b_.*Cot[u_]^m_.)^n_,x_Symbol] :=
  Integrate[v*(a+b*Cos[u]^m)^n/Sin[u]^(m*n),x] /;
FreeQ[{a,b},x] && IntegerQ[{m,n}]


(* ::Subsubsection::Closed:: *)
(*v Trig[u]^2/(a+b Trig[u]^2)	  Simplify quotients of squares of trig functions by binomials of trig functions (4)*)
(**)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[v_.*Cos[u_]^2/(a_.+b_.*Sin[u_]^2),x_Symbol] :=
  Integrate[v/(a+(a+b)*Tan[u]^2),x] /;
FreeQ[{a,b},x]


Integrate[v_.*Sin[u_]^2/(a_.+b_.*Cos[u_]^2),x_Symbol] :=
  Integrate[v/(a+(a+b)*Cot[u]^2),x] /;
FreeQ[{a,b},x]


Integrate[v_.*Cos[u_]^n_./(a_.*Cos[u_]^n_.+b_.*Sin[u_]^n_.),x_Symbol] :=
  Integrate[v/(a+b*Tan[u]^n),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


Integrate[v_.*Sin[u_]^n_./(a_.*Cos[u_]^n_.+b_.*Sin[u_]^n_.),x_Symbol] :=
  Integrate[v/(b+a*Cot[u]^n),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* ::Subsubsection::Closed:: *)
(*1/(v Trig[u]+w Trig[u])		Simplify reciprocals of sums of trig functions (2)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[(v_.*Sec[u_]+w_.*Tan[u_])^n_,x_Symbol] :=
  Integrate[Cos[u]^(-n)*(v+w*Sin[u])^n,x] /;
IntegerQ[n] && n<0


Integrate[(v_.*Csc[u_]+w_.*Cot[u_])^n_,x_Symbol] :=
  Integrate[Sin[u]^(-n)*(v+w*Cos[u])^n,x] /;
IntegerQ[n] && n<0


(* ::Subsubsection::Closed:: *)
(*v (a+b Trig[u]^m) / (c+d Trig[u]^n)	Expand quotients of linear sums of trig functions (2)*)


(* This partial fraction expansion of trig functions should be done by the Apart in
	NormalizeExpression! *)
Integrate[v_.*(a_.+b_.*Sec[u_]^m_.)/(c_+d_.*Cos[u_]^n_.),x_Symbol] :=
  b/c*Integrate[v*Sec[u]^m,x] +
    Integrate[v*(a*c-b*d*Sec[u]^(m-n))/(c+d*Cos[u]^n),x]/c /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && 0<n<=m


Integrate[v_.*(a_.+b_.*Csc[u_]^m_.)/(c_+d_.*Sin[u_]^n_.),x_Symbol] :=
  b/c*Integrate[v*Csc[u]^m,x] +
    Integrate[v*(a*c-b*d*Csc[u]^(m-n))/(c+d*Sin[u]^n),x]/c /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && 0<n<=m


(* ::Subsection::Closed:: *)
(*Products of Exponential and Trigonometric Functions (8)*)


(* ::Subsubsection::Closed:: *)
(*Exp[a + b x] Sin[c + d x]^n	Products of exponentials and powers of sines of linears (2)*)


(* CRC 533 *)
Integrate[E^(a_.+b_.*x_)*Sin[c_.+d_.*x_],x_Symbol] :=
  E^(a+b*x)*(b*Sin[c+d*x]-d*Cos[c+d*x])/(b^2+d^2) /;
FreeQ[{a,b,c,d},x]


(* CRC 542 *)
Integrate[E^(a_.+b_.*x_)*Sin[c_.+d_.*x_]^n_,x_Symbol] :=
  E^(a+b*x)*Sin[c+d*x]^(n-1)*(b*Sin[c+d*x]-d*n*Cos[c+d*x])/(b^2+d^2*n^2)+
    n*(n-1)*d^2/(b^2+d^2*n^2)*Integrate[E^(a+b*x)*Sin[c+d*x]^(n-2),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*Exp[a + b x] Cos[c + d x]^n	Products of exponentials and powers of cosines of linears (2)*)


(* CRC 538 *)
Integrate[E^(a_.+b_.*x_)*Cos[c_.+d_.*x_],x_Symbol] :=
  E^(a+b*x)*(b*Cos[c+d*x]+d*Sin[c+d*x])/(b^2+d^2) /;
FreeQ[{a,b,c,d},x]


(* CRC 543 *)
Integrate[E^(a_.+b_.*x_)*Cos[c_.+d_.*x_]^n_,x_Symbol] :=
  E^(a+b*x)*Cos[c+d*x]^(n-1)*(b*Cos[c+d*x]+d*n*Sin[c+d*x])/(b^2+d^2*n^2)+
    n*(n-1)*d^2/(b^2+d^2*n^2)*Integrate[E^(a+b*x)*Cos[c+d*x]^(n-2),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*Exp[a + b x] Sec[c + d x]^n	Products of exponentials and powers of secants of linears (1)*)


(* CRC 552 *)
Integrate[E^(a_.+b_.*x_)*Sec[c_.+d_.*x_]^n_,x_Symbol] :=
  E^(a+b*x)*(d*(n-2)*Sin[c+d*x]-b*Cos[c+d*x])*Sec[c+d*x]^(n-1)/(d^2*(n-1)*(n-2))+
(b^2+d^2*(n-2)^2)/(d^2*(n-1)*(n-2))*Integrate[E^(a+b*x)*Sec[c+d*x]^(n-2),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n>1 && n!=2


(* ::Subsubsection::Closed:: *)
(*Exp[a + b x] Csc[c + d x]^n	Products of exponentials and powers of cosecants of linears (1)*)
(**)


(* CRC 551 *)
Integrate[E^(a_.+b_.*x_)*Csc[c_.+d_.*x_]^n_,x_Symbol] :=
  E^(a+b*x)*(d*(n-2)*Cos[c+d*x]+b*Sin[c+d*x])*Csc[c+d*x]^(n-1)/(d^2*(1-n)*(n-2))+
    (b^2+d^2*(n-2)^2)/(d^2*(n-1)*(n-2))*Integrate[E^(a+b*x)*Csc[c+d*x]^(n-2),x] /;
FreeQ[{a,b,c,d},x] && RationalQ[n] && n>1 && n!=2


(* ::Subsubsection::Closed:: *)
(*x^m Exp[a + b x] Sin[c + d x]^n	Products of monomials, exponentials and powers of sines of linears (1)*)


Integrate[x_^m_.*E^(a_.+b_.*x_)*Sin[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[E^(a+b*x)*Sin[c+d*x]^n,x]]},
  x^m*u-m*Integrate[x^(m-1)*u,x]] /;
FreeQ[{a,b,c,d},x] && RationalQ[m] && IntegerQ[n] && m>0 && n>0


(* ::Subsubsection::Closed:: *)
(*x^m Exp[a + b x] Cos[c + d x]^n	Products of exponentials and powers of cosines of linears (1)*)


Integrate[x_^m_.*E^(a_.+b_.*x_)*Cos[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[E^(a+b*x)*Cos[c+d*x]^n,x]]},
  x^m*u-m*Integrate[x^(m-1)*u,x]] /;
FreeQ[{a,b,c,d},x] && RationalQ[m] && IntegerQ[n] && m>0 && n>0


(* ::Subsection::Closed:: *)
(*Inverse Trigonometric Functions (79)*)


(* ::Subsubsection::Closed:: *)
(*x^m ArcSin[a x]		Products of monomials and arcsines (3)*)


(* GR5 2.813.1, CRC 441 *)
Integrate[ArcSin[a_.*x_],x_Symbol] :=
  x*ArcSin[a*x]+Sqrt[1-a^2*x^2]/a /;
FreeQ[a,x]


Integrate[ArcSin[a_.*x_]/x_,x_Symbol] :=
  ArcSin[a*x]*Log[1-(I*a*x+Sqrt[1-a^2*x^2])^2]-
    I*(ArcSin[a*x]^2+PolyLog[2,(I*a*x+Sqrt[1-a^2*x^2])^2])/2 /;
FreeQ[a,x]


(* GR5 2.831, CRC 453 *)
Integrate[x_^m_.*ArcSin[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcSin[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/Sqrt[1-a^2*x^2],x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCos[a x]		Products of monomials and arccosines (3)*)


(* GR5 2.814.1, CRC 442 *)
Integrate[ArcCos[a_.*x_],x_Symbol] :=
  x*ArcCos[a*x]-Sqrt[1-a^2*x^2]/a /;
FreeQ[a,x]


Integrate[ArcCos[a_.*x_]/x_,x_Symbol] :=
  ArcCos[a*x]*Log[1-1/(I*a*x+Sqrt[1-a^2*x^2])^2]-
    I*(ArcCos[a*x]^2+PolyLog[2,1/(I*a*x+Sqrt[1-a^2*x^2])^2])/2 /;
FreeQ[a,x]


(* GR5 2.832, CRC 454 *)
Integrate[x_^m_.*ArcCos[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCos[a*x]/(m+1)+
    a/(m+1)*Integrate[x^(m+1)/Sqrt[1-a^2*x^2],x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcTan[a x]		Products of monomials and arctangents (3)*)


(* GR5 2.822.1, CRC 443 *)
Integrate[ArcTan[a_.*x_],x_Symbol] :=
  x*ArcTan[a*x]-Log[1+a^2*x^2]/(2*a) /;
FreeQ[a,x]


Integrate[ArcTan[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  I*Integrate[Log[1-I*(a+b*x^n)]/x,x]/2-
    I*Integrate[Log[1+I*(a+b*x^n)]/x,x]/2 /;
FreeQ[{a,b,n},x]

(* Integrate[ArcTan[a_.+b_.*x_]/x_,x_Symbol] :=
  Log[x]*ArcTan[a+b*x] -
    b*Integrate[Log[x]/(1+(a+b*x)^2),x] /;
FreeQ[{a,b},x] *)


(* GR5 2.851, CRC 456 *)
Integrate[x_^m_.*ArcTan[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcTan[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/(1+a^2*x^2),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCot[a x]		Products of monomials and arccotangents (3)*)


(* GR5 2.822.2, CRC 444 *)
Integrate[ArcCot[a_.*x_],x_Symbol] :=
  x*ArcCot[a*x]+Log[1+a^2*x^2]/(2*a) /;
FreeQ[a,x]


Integrate[ArcCot[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  I*Integrate[Log[1-I/(a+b*x^n)]/x,x]/2-
    I*Integrate[Log[1+I/(a+b*x^n)]/x,x]/2 /;
FreeQ[{a,b,n},x]

(* Integrate[ArcCot[a_.+b_.*x_]/x_,x_Symbol] :=
  Log[x]*ArcCot[a+b*x] +
    b*Integrate[Log[x]/(1+(a+b*x)^2),x] /;
FreeQ[{a,b},x] *)


(* GR5 2.852, CRC 458 *)
Integrate[x_^m_.*ArcCot[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCot[a*x]/(m+1)+
    a/(m+1)*Integrate[x^(m+1)/(1+a^2*x^2),x] /;
FreeQ[{a,m},x] NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcSec[a x]		Products of monomials and arcsecants (3)*)


(* CRC 445' *)
Integrate[ArcSec[a_.*x_],x_Symbol] :=
  x*ArcSec[a*x]-ArcTanh[Sqrt[1-1/(a^2*x^2)]]/a /;
FreeQ[a,x]


Integrate[ArcSec[a_.*x_]/x_,x_Symbol] :=
  -ArcSec[a*x]*Log[1-1/(I/(a*x)+Sqrt[1-1/(a^2*x^2)])^2]+
    I*(ArcSec[a*x]^2+PolyLog[2,1/(I/(a*x)+Sqrt[1-1/(a^2*x^2)])^2])/2 /;
FreeQ[a,x]


(* CRC 474' *)
Integrate[x_^m_.*ArcSec[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcSec[a*x]/(m+1)-
    1/(a*(m+1))*Integrate[x^(m+1)/(x^2*Sqrt[1-1/(a^2*x^2)]),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCsc[a x]		Products of monomials and arccosecants (3)*)
(**)


(* CRC 446' *)
Integrate[ArcCsc[a_.*x_],x_Symbol] :=
  x*ArcCsc[a*x]+ArcTanh[Sqrt[1-1/(a^2*x^2)]]/a /;
FreeQ[a,x]


Integrate[ArcCsc[a_.*x_]/x_,x_Symbol] :=
  -ArcCsc[a*x]*Log[1-(I/(a*x)+Sqrt[1-1/(a^2*x^2)])^2]+
    I*(ArcCsc[a*x]^2+PolyLog[2,(I/(a*x)+Sqrt[1-1/(a^2*x^2)])^2])/2 /;
FreeQ[a,x]


(* CRC 477' *)
Integrate[x_^m_.*ArcCsc[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCsc[a*x]/(m+1)+
    1/(a*(m+1))*Integrate[x^(m+1)/(x^2*Sqrt[1-1/(a^2*x^2)]),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*ArcSin[a x]^n			Powers of arcsines (4)*)


Integrate[1/ArcSin[a_.*x_],x_Symbol] :=
  CosIntegral[ArcSin[a*x]]/a /;
FreeQ[a,x]


Integrate[1/ArcSin[a_.*x_]^2,x_Symbol] :=
  -Sqrt[1-a^2*x^2]/(a*ArcSin[a*x])-
    SinIntegral[ArcSin[a*x]]/a /;
FreeQ[a,x]


(* CRC 465 *)
Integrate[ArcSin[a_.*x_]^n_,x_Symbol] :=
  x*ArcSin[a*x]^n+
    n/a*Sqrt[1-a^2*x^2]*ArcSin[a*x]^(n-1)-
    n*(n-1)*Integrate[ArcSin[a*x]^(n-2),x] /;
FreeQ[a,x] && RationalQ[n] && n>1


Integrate[ArcSin[a_.*x_]^n_,x_Symbol] :=
  x*ArcSin[a*x]^(n+2)/((n+1)*(n+2))+
    Sqrt[1-a^2*x^2]*ArcSin[a*x]^(n+1)/(a*(n+1))-
    1/((n+1)*(n+2))*Integrate[ArcSin[a*x]^(n+2),x] /;
FreeQ[a,x] && RationalQ[n] && n<-1 && n!=-2


(* ::Subsubsection::Closed:: *)
(*ArcCos[a x]^n			Powers of arccosines (4)*)
(**)


Integrate[1/ArcCos[a_.*x_],x_Symbol] :=
  -SinIntegral[ArcCos[a*x]]/a /;
FreeQ[a,x]


Integrate[1/ArcCos[a_.*x_]^2,x_Symbol] :=
  Sqrt[1-a^2*x^2]/(a*ArcCos[a*x])-
    CosIntegral[ArcCos[a*x]]/a /;
FreeQ[a,x]


(* CRC 466 *)
Integrate[ArcCos[a_.*x_]^n_,x_Symbol] :=
  x*ArcCos[a*x]^n-
    n/a*Sqrt[1-a^2*x^2]*ArcCos[a*x]^(n-1)-
    n*(n-1)*Integrate[ArcCos[a*x]^(n-2),x] /;
FreeQ[a,x] && RationalQ[n] && n>1


Integrate[ArcCos[a_.*x_]^n_,x_Symbol] :=
  x*ArcCos[a*x]^(n+2)/((n+1)*(n+2))-
    Sqrt[1-a^2*x^2]*ArcCos[a*x]^(n+1)/(a*(n+1))-
    1/((n+1)*(n+2))*Integrate[ArcCos[a*x]^(n+2),x] /;
FreeQ[a,x] && RationalQ[n] && n<-1 && n!=-2


(* ::Subsubsection::Closed:: *)
(*(1-x^2)^(m/2) ArcSin[x]^n	Products of half-integer powers of binomials and powers of arcsines (4)*)


Integrate[1/(Sqrt[1-x_^2]*ArcSin[x_]),x_Symbol] :=
  Log[ArcSin[x]]


Integrate[ArcSin[x_]^n_./Sqrt[1-x_^2],x_Symbol] :=
  ArcSin[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1-x_^2)^m_.*ArcSin[x_],x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcSin[x]-
    Integrate[u/Sqrt[1-x^2],x]] /;
HalfIntegerQ[m] && m!=-1/2


Integrate[(1-x_^2)^m_.*ArcSin[x_]^n_,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcSin[x]^n-
    n*Integrate[Expand[u*ArcSin[x]^(n-1)/Sqrt[1-x^2]],x]] /;
HalfIntegerQ[m] && m!=-1/2 && IntegerQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*(1-x^2)^(m/2) ArcCos[x]^n	Products of half-integer powers of binomials and powers of arccosines (4)*)


Integrate[1/(Sqrt[1-x_^2]*ArcCos[x_]),x_Symbol] :=
  -Log[ArcCos[x]]


Integrate[ArcCos[x_]^n_./Sqrt[1-x_^2],x_Symbol] :=
  -ArcCos[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1-x_^2)^m_.*ArcCos[x_],x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcCos[x]+
    Integrate[u/Sqrt[1-x^2],x]] /;
HalfIntegerQ[m] && m!=-1/2


Integrate[(1-x_^2)^m_.*ArcCos[x_]^n_,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcCos[x]^n+
    n*Integrate[Expand[u*ArcCos[x]^(n-1)/Sqrt[1-x^2]],x]] /;
HalfIntegerQ[m] && m!=-1/2 && IntegerQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*(1+x^2)^m ArcTan[x]^n	Products of powers of binomials and powers of arctangents (3)*)


Integrate[1/((1+x_^2)*ArcTan[x_]),x_Symbol] :=
  Log[ArcTan[x]]


Integrate[ArcTan[x_]^n_./(1+x_^2),x_Symbol] :=
  ArcTan[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1+x_^2)^m_*ArcTan[x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcTan[x]^n-
    n*Integrate[u*ArcTan[x]^(n-1)/(1+x^2),x]] /;
IntegerQ[{m,n}] && m<-1 && n>0


(* Integrate[(1+x_^2)^m_*ArcTan[x_]^n_.,x_Symbol] :=
  ? /;
IntegerQ[{m,n}] && m<-1 && n<-1 *)


(* ::Subsubsection::Closed:: *)
(*(1+x^2)^m ArcCot[x]^n	Products of powers of binomials and powers of arccotangents (3)*)


Integrate[1/((1+x_^2)*ArcCot[x_]),x_Symbol] :=
  -Log[ArcCot[x]]


Integrate[ArcCot[x_]^n_./(1+x_^2),x_Symbol] :=
  -ArcCot[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1+x_^2)^m_*ArcCot[x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcCot[x]^n+
    n*Integrate[u*ArcCot[x]^(n-1)/(1+x^2),x]] /;
IntegerQ[{m,n}] && m<-1 && n>0


(* ::Subsubsection::Closed:: *)
(*(1+x^2)^m ArcCot[x]^n ArcTan[x]^p	Products of powers of binomials, arccotangents and arctangents (6)*)
(**)


Integrate[1/((1+x_^2)*ArcCot[x_]*ArcTan[x_]),x_Symbol] :=
  (-Log[ArcCot[x]]+Log[ArcTan[x]])/(ArcCot[x]+ArcTan[x])


Integrate[ArcCot[x_]^n_.*ArcTan[x_]^p_./(1+x_^2),x_Symbol] :=
  -ArcCot[x]^(n+1)*ArcTan[x]^p/(n+1)+
    p/(n+1)*Integrate[ArcCot[x]^(n+1)*ArcTan[x]^(p-1)/(1+x^2),x] /;
IntegerQ[{n,p}] && 0<p<=n


Integrate[ArcCot[x_]^n_.*ArcTan[x_]^p_/(1+x_^2),x_Symbol] :=
  ArcCot[x]^n*ArcTan[x]^(p+1)/(p+1)+
    n/(p+1)*Integrate[ArcCot[x]^(n-1)*ArcTan[x]^(p+1)/(1+x^2),x] /;
IntegerQ[{n,p}] && 0<n<p


Integrate[(1+x_^2)^m_*ArcCot[x_]^n_.*ArcTan[x_]^p_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcCot[x]^n*ArcTan[x]^p-
    p*Integrate[u*ArcCot[x]^n*ArcTan[x]^(p-1)/(1+x^2),x]+
    n*Integrate[u*ArcCot[x]^(n-1)*ArcTan[x]^p/(1+x^2),x]] /;
IntegerQ[{m,p,n}] && m<-1 && p>0 && n>0


Integrate[ArcTan[x_]^n_./(1+x_^2),x_Symbol] :=
  ArcTan[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1+x_^2)^m_*ArcTan[x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcTan[x]^n-
    n*Integrate[u*ArcTan[x]^(n-1)/(1+x^2),x]] /;
IntegerQ[{m,n}] && m<-1 && n>0


(* Integrate[(1+x_^2)^m_*ArcTan[x_]^n_.,x_Symbol] :=
  ? /;
IntegerQ[{m,n}] && m<-1 && n<-1 *)


(* ::Subsubsection::Closed:: *)
(*x^m ArcSin[a+b x^n]		Products of monomials and arcsines of binomials (2)*)


Integrate[ArcSin[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcSin[a+b*x^n]-
    b*n*Integrate[x^n/Sqrt[1-(a+b*x^n)^2],x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* GR5 2.831, CRC 453' *)
Integrate[x_^m_.*ArcSin[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcSin[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/Sqrt[1-(a+b*x^n)^2],x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCos[a+b x^n]		Products of monomials and arccosines of binomials (2)*)


Integrate[ArcCos[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCos[a+b*x^n]+
    b*n*Integrate[x^n/Sqrt[1-(a+b*x^n)^2],x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* GR5 2.832, CRC 454' *)
Integrate[x_^m_.*ArcCos[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCos[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)/Sqrt[1-(a+b*x^n)^2],x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcTan[a+b x^n]		Products of monomials and arctangents of binomials (2)*)


Integrate[ArcTan[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcTan[a+b*x^n]-
    b*n*Integrate[x^n/(1+(a+b*x^n)^2),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* GR5 2.851, CRC 456' *)
Integrate[x_^m_.*ArcTan[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcTan[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/(1+(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCot[a+b x^n]		Products of monomials and arccotangents of binomials (2)*)


Integrate[ArcCot[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCot[a+b*x^n]+
    b*n*Integrate[x^n/(1+(a+b*x^n)^2),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* GR5 2.852, CRC 458' *)
Integrate[x_^m_.*ArcCot[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCot[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)/(1+(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcSec[a+b x^n]		Products of monomials and arcsecants of binomials (2)*)


Integrate[ArcSec[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcSec[a+b*x^n]-
    b*n*Integrate[x^n/((a+b*x^n)^2*Sqrt[1-1/(a+b*x^n)^2]),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 474' *)
Integrate[x_^m_.*ArcSec[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcSec[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/(Sqrt[1-1/(a+b*x^n)^2]*(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCsc[a+b x^n]		Products of monomials and arccosecants of binomials (2)*)
(**)


Integrate[ArcCsc[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCsc[a+b*x^n]+
    b*n*Integrate[x^n/((a+b*x^n)^2*Sqrt[1-1/(a+b*x^n)^2]),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 477' *)
Integrate[x_^m_.*ArcCsc[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCsc[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)/(Sqrt[1-1/(a+b*x^n)^2]*(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x ArcTan[a+b x]^n		Products of x and powers of arctangents of linears (2)*)


Integrate[x_*ArcTan[b_.*x_]^n_,x_Symbol] :=
  ((b*x)^2+1)*ArcTan[b*x]^n/(2*b^2)-
    n/(2*b)*Integrate[ArcTan[b*x]^(n-1),x] /;
FreeQ[b,x] && RationalQ[n] && n>1


Integrate[x_*ArcTan[a_.+b_.*x_]^n_,x_Symbol] :=
  ((a+b*x)^2+1)*ArcTan[a+b*x]^n/(2*b^2)-
    n/(2*b)*Integrate[ArcTan[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcTan[a+b*x]^n,x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*x ArcCot[a+b x]^n		Products of x and powers of arccotangents of linears (2)*)
(**)


Integrate[x_*ArcCot[b_.*x_]^n_,x_Symbol] :=
  ((b*x)^2+1)*ArcCot[b*x]^n/(2*b^2)+
    n/(2*b)*Integrate[ArcCot[b*x]^(n-1),x] /;
FreeQ[b,x] && RationalQ[n] && n>1


Integrate[x_*ArcCot[a_.+b_.*x_]^n_,x_Symbol] :=
  ((a+b*x)^2+1)*ArcCot[a+b*x]^n/(2*b^2)+
    n/(2*b)*Integrate[ArcCot[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcCot[a+b*x]^n,x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*x ArcSin[a+b x]^n/Sqrt[1-(a+b x)^2]	Products of x and powers of arcsines of linears divided by sqrt of linear (2)*)


Integrate[x_*ArcSin[b_.*x_]^n_/Sqrt[1-c_.*x_^2],x_Symbol] :=
  -Sqrt[1-c*x^2]*ArcSin[b*x]^n/b^2+
    n/b*Integrate[ArcSin[b*x]^(n-1),x] /;
FreeQ[{b,c},x] && c===b^2 && RationalQ[n] && n>1


Integrate[x_*ArcSin[a_.+b_.*x_]^n_/Sqrt[1-(a_.+b_.*x_)^2],x_Symbol] :=
  -Sqrt[1-(a+b*x)^2]*ArcSin[a+b*x]^n/b^2+
    n/b*Integrate[ArcSin[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcSin[a+b*x]^n/Sqrt[1-(a+b*x)^2],x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*x ArcCos[a+b x]^n/Sqrt[1-(a+b x)^2]	Products of x and powers of arccosines of linears divided by sqrt of linear (2)*)
(**)


Integrate[x_*ArcCos[b_.*x_]^n_/Sqrt[1-c_*x_^2],x_Symbol] :=
  -Sqrt[1-c*x^2]*ArcCos[b*x]^n/b^2-
    n/b*Integrate[ArcCos[b*x]^(n-1),x] /;
FreeQ[{b,c},x] && c===b^2 && RationalQ[n] && n>1


Integrate[x_*ArcCos[a_.+b_.*x_]^n_/Sqrt[1-(a_.+b_.*x_)^2],x_Symbol] :=
  -Sqrt[1-(a+b*x)^2]*ArcCos[a+b*x]^n/b^2-
    n/b*Integrate[ArcCos[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcCos[a+b*x]^n/Sqrt[1-(a+b*x)^2],x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*u ArcTan[u]			Products of easily integrable functions and arctangents of algebraic functions (3)*)


(* Integration by parts transforms integrand into an algebraic function. *)
Integrate[ArcTan[u_],x_Symbol] :=
  x*ArcTan[u]-
    Integrate[x*D[u,x]/(1+u^2),x] /;
InverseFunctionFreeQ[u,x] && Not[LinearQ[u,x]]


Integrate[(a_.+b_.*x_)^p_.*ArcTan[u_],x_Symbol] :=
  (a+b*x)^(p+1)*ArcTan[u]/(b*(p+1))-
    Integrate[(a+b*x)^(p+1)*D[u,x]/(1+u^2),x]/(b*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[p] && p!=-1 && InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*(a_.+b_.*x_^n_.)^p_.*ArcTan[u_],x_Symbol] :=
  (a+b*x^n)^(p+1)*ArcTan[u]/(b*n*(p+1))-
    Integrate[(a+b*x^n)^(p+1)*D[u,x]/(1+u^2),x]/(b*n*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p!=-1 && m==n-1 && InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*u ArcCot[u]			Products of easily integrable functions and arccotangents of algebraic functions (3)*)
(**)


(* Integration by parts transforms integrand into an algebraic function. *)
Integrate[ArcCot[u_],x_Symbol] :=
  x*ArcCot[u]+
    Integrate[x*D[u,x]/(1+u^2),x] /;
InverseFunctionFreeQ[u,x] && Not[LinearQ[u,x]]


Integrate[(a_.+b_.*x_)^p_.*ArcCot[u_],x_Symbol] :=
  (a+b*x)^(p+1)*ArcCot[u]/(b*(p+1))+
    Integrate[(a+b*x)^(p+1)*D[u,x]/(1+u^2),x]/(b*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[p] && p!=-1 && InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*(a_.+b_.*x_^n_.)^p_.*ArcCot[u_],x_Symbol] :=
  (a+b*x^n)^(p+1)*ArcCot[u]/(b*n*(p+1))+
    Integrate[(a+b*x^n)^(p+1)*D[u,x]/(1+u^2),x]/(b*n*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p!=-1 && m==n-1 && InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*f[ArcTan[Sqrt[b/a x]] / (a+b x^2)	Quotients of functions of arctangent of monomials by linears (1)*)


(* Need to generalize for arbitrary functions of ArcTan[Sqrt[b/a]*x] *)
Integrate[f_[ArcTan[c_.*x_]]/(a_+b_.*x_^2),x_Symbol] :=
  Subst[Integrate[f[x],x],x,ArcTan[c*x]]/(a*Sqrt[b/a]) /;
FreeQ[{a,b,c,f},x] && c===Sqrt[b/a]


(* ::Subsubsection::Closed:: *)
(*u ArcTrig[c / (a+b x^n)]	Inverse trig functions of reciprocals of binomials (6)*)


Integrate[u_.*ArcSin[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCsc[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCos[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcSec[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcTan[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCot[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCot[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcTan[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcSec[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCos[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCsc[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcSin[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


(* ::Subsection::Closed:: *)
(*Hyperbolic Functions (128)*)


(* ::Subsubsection::Closed:: *)
(*Sinh[x]^n			Powers of hyperbolic sines (5)*)


(* GR5 2.01.20, CRC 554 *)
Integrate[Sinh[x_],x_Symbol] :=
  Cosh[x]


Integrate[Sqrt[Sinh[x_]],x_Symbol] :=
  2*EllipticE[(Pi/2-I*x)/2,2]*Sqrt[I*Sinh[x]]/Sqrt[Sinh[x]]


Integrate[1/Sqrt[Sinh[x_]],x_Symbol] :=
  -2*EllipticF[(Pi/2-I*x)/2,2]*Sqrt[Sinh[x]]/Sqrt[I*Sinh[x]]


(* GR5 2.414.2, CRC 566 *)
Integrate[Sinh[x_]^2,x_Symbol] :=
  -x/2+Cosh[x]*Sinh[x]/2

(* GR5 2.411.2, CRC 567b *)
Integrate[Sinh[x_]^n_,x_Symbol] :=
  Sinh[x]^(n-1)*Cosh[x]/n-
    (n-1)/n*Integrate[Sinh[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.5, CRC 568a *)
Integrate[Sinh[x_]^n_,x_Symbol] :=
  Sinh[x]^(n+1)*Cosh[x]/(n+1)-
    (n+2)/(n+1)*Integrate[Sinh[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Cosh[x]^n			Powers of hyperbolic cosines (5)*)


(* GR5 2.01.21, CRC 555 *)
Integrate[Cosh[x_],x_Symbol] :=
  Sinh[x]


Integrate[Sqrt[Cosh[x_]],x_Symbol] :=
  -2*I*EllipticE[(I*x)/2,2]


Integrate[1/Sqrt[Cosh[x_]],x_Symbol] :=
  -2*I*EllipticF[(I*x)/2,2]


(* GR5 2.414.9, CRC 572 *)
Integrate[Cosh[x_]^2,x_Symbol] :=
  x/2+Cosh[x]*Sinh[x]/2

(* GR5 2.411.1, CRC 305h *)
Integrate[Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]*Cosh[x]^(n-1)/n+
    (n-1)/n*Integrate[Cosh[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.6, CRC 568b *)
Integrate[Cosh[x_]^n_,x_Symbol] :=
  -Sinh[x]*Cosh[x]^(n+1)/(n+1)+
    (n+2)/(n+1)*Integrate[Cosh[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Tanh[x]^n			Powers of hyperbolic tangents (3)*)


(* GR5 2.243.17, CRC 556 *)
Integrate[Tanh[x_],x_Symbol] :=
  Log[Cosh[x]]


(* GR5 2.423.22, CRC 569 *)
Integrate[Tanh[x_]^2,x_Symbol] :=
  x-Tanh[x]

(* GR5 2.411.3, CRC 570 *)
Integrate[Tanh[x_]^n_,x_Symbol] :=
  -Tanh[x]^(n-1)/(n-1)+
    Integrate[Tanh[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.4, CRC 574' *)
Integrate[Tanh[x_]^n_,x_Symbol] :=
  Tanh[x]^(n+1)/(n+1)+
    Integrate[Tanh[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Coth[x]^n			Powers of hyperbolic cotangents (3)*)


(* GR5 2.423.33, CRC 557 *)
Integrate[Coth[x_],x_Symbol] :=
  Log[Sinh[x]]


(* GR5 2.423.38, CRC 573 *)
Integrate[Coth[x_]^2,x_Symbol] :=
  x-Coth[x]

(* GR5 2.411.4, CRC 574 *)
Integrate[Coth[x_]^n_,x_Symbol] :=
  -Coth[x]^(n-1)/(n-1)+
    Integrate[Coth[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.3, CRC 570' *)
Integrate[Coth[x_]^n_,x_Symbol] :=
  Coth[x]^(n+1)/(n+1)+
    Integrate[Coth[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Sech[x]^n			Powers of hyperbolic secants (5)*)


(* GR5 2.423.9', CRC 558'h *)
Integrate[Sech[x_],x_Symbol] :=
  ArcTan[Sinh[x]]


Integrate[Sqrt[Sech[x_]],x_Symbol] :=
  -2*I*Sqrt[Cosh[x]]*EllipticF[(I*x)/2,2]*Sqrt[Sech[x]]


Integrate[1/Sqrt[Sech[x_]],x_Symbol] :=
  -2*I*EllipticE[(I*x)/2,2]/(Sqrt[Cosh[x]]*Sqrt[Sech[x]])


(* GR5 2.423.10, CRC 571 *)
Integrate[Sech[x_]^2,x_Symbol] :=
  Tanh[x]

(* GR5 2.411.6, CRC 568b *)
Integrate[Sech[x_]^n_,x_Symbol] :=
  Sinh[x]*Sech[x]^(n-1)/(n-1)+
    (n-2)/(n-1)*Integrate[Sech[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.1, CRC 567a *)
Integrate[Sech[x_]^n_,x_Symbol] :=
  -Sinh[x]*Sech[x]^(n+1)/n+
    (n+1)/n*Integrate[Sech[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Csch[x]^n			Powers of hyperbolic cosecants (5)*)
(**)


(* GR5 2.423.1', CRC 559' *)
Integrate[Csch[x_],x_Symbol] :=
  -ArcCoth[Cosh[x]]


Integrate[Sqrt[Csch[x_]],x_Symbol] :=
  2*Csch[x]^(3/2)*EllipticF[(Pi/2-I*x)/2,2]*(I*Sinh[x])^(3/2)


Integrate[1/Sqrt[Csch[x_]],x_Symbol] :=
  2*Sqrt[Csch[x]]*EllipticE[(Pi/2-I*x)/2,2]*Sqrt[I*Sinh[x]]


(* GR5 2.423.2, CRC 575 *)
Integrate[Csch[x_]^2,x_Symbol] :=
  -Coth[x]

(* GR5 2.411.5, CRC 568a *)
Integrate[Csch[x_]^n_,x_Symbol] :=
  -Cosh[x]*Csch[x]^(n-1)/(n-1)-
    (n-2)/(n-1)*Integrate[Csch[x]^(n-2),x] /;
RationalQ[n] && n>1


(* GR5 2.411.2, CRC 567b *)
Integrate[Csch[x_]^n_,x_Symbol] :=
  -Cosh[x]*Csch[x]^(n+1)/n-
    (n+1)/n*Integrate[Csch[x]^(n+2),x] /;
RationalQ[n] && n<-1


(* ::Subsubsection::Closed:: *)
(*Sinh[x]^m Cosh[x]^n		Products of powers of hyperbolic sines and cosines (8)*)


Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m+1)*Cosh[x]^(n+1)/(m+1) /;
FreeQ[{m,n},x] && ZeroQ[m+n+2] && NonzeroQ[m+1]


(* GR5 2.411.3 *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m-1)*Cosh[x]^(n+1)/(n+1)-
    (m-1)/(n+1)*Integrate[Sinh[x]^(m-2)*Cosh[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1


(* GR5 2.411.4 *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m+1)*Cosh[x]^(n-1)/(m+1)-
    (n-1)/(m+1)*Integrate[Sinh[x]^(m+2)*Cosh[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1


(* GR5 2.411.2, CRC 567b *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m-1)*Cosh[x]^(n+1)/(m+n)-
    (m-1)/(m+n)*Integrate[Sinh[x]^(m-2)*Cosh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n]


(* GR5 2.411.1, CRC 567a *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m+1)*Cosh[x]^(n-1)/(m+n)+
    (n-1)/(m+n)*Integrate[Sinh[x]^m*Cosh[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n]


(* GR5 2.411.5, CRC 568a *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m+1)*Cosh[x]^(n+1)/(m+1)-
    (m+n+2)/(m+1)*Integrate[Sinh[x]^(m+2)*Cosh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1


(* GR5 2.411.6, CRC 568b *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  -Sinh[x]^(m+1)*Cosh[x]^(n+1)/(n+1)+
    (m+n+2)/(n+1)*Integrate[Sinh[x]^m*Cosh[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1


(* Kool rule *)
Integrate[Sinh[x_]^m_*Cosh[x_]^n_,x_Symbol] :=
  Subst[Integrate[x^(1/m)/(1-x^(2/m)),x],x,Sinh[x]^m*Cosh[x]^n]/m /;
FractionQ[{m,n}] && ZeroQ[m+n] && IntegerQ[1/m]


(* ::Subsubsection::Closed:: *)
(*Csch[x]^m Sech[x]^n		Products of powers of hyperbolic cosecants and secants (8)*)


(* GR5 2.423.49 *)
Integrate[Csch[x_]*Sech[x_],x_Symbol] :=
  Log[Tanh[x]]


Integrate[Csch[x_]^m_*Sech[x_]^n_,x_Symbol] :=
  Csch[x]^(m-1)*Sech[x]^(n-1)/(n-1) /;
FreeQ[{m,n},x] && ZeroQ[m+n-2]


(* GR5 2.411.3 *)
Integrate[Csch[x_]^m_*Sech[x_]^n_,x_Symbol] :=
  -Csch[x]^(m-1)*Sech[x]^(n+1)/(m-1)-
    (n+1)/(m-1)*Integrate[Csch[x]^(m-2)*Sech[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1


(* GR5 2.411.4 *)
Integrate[Csch[x_]^m_*Sech[x_]^n_,x_Symbol] :=
  -Csch[x]^(m+1)*Sech[x]^(n-1)/(n-1)-
    (m+1)/(n-1)*Integrate[Csch[x]^(m+2)*Sech[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1


(* GR5 2.411.5, CRC 568a *)
Integrate[Csch[x_]^m_*Sech[x_]^n_.,x_Symbol] :=
  -Csch[x]^(m-1)*Sech[x]^(n-1)/(m-1)-
    (m+n-2)/(m-1)*Integrate[Csch[x]^(m-2)*Sech[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1


(* GR5 2.411.6, CRC 568b *)
Integrate[Csch[x_]^m_.*Sech[x_]^n_,x_Symbol] :=
  Csch[x]^(m-1)*Sech[x]^(n-1)/(n-1)+
    (m+n-2)/(n-1)*Integrate[Csch[x]^m*Sech[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1


(* GR5 2.411.2, CRC 567b *)
Integrate[Csch[x_]^m_*Sech[x_]^n_.,x_Symbol] :=
  -Csch[x]^(m+1)*Sech[x]^(n-1)/(m+n)-
    (m+1)/(m+n)*Integrate[Csch[x]^(m+2)*Sech[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n]


(* GR5 2.411.1, CRC 567a *)
Integrate[Csch[x_]^m_.*Sech[x_]^n_,x_Symbol] :=
  -Csch[x]^(m-1)*Sech[x]^(n+1)/(m+n)+
    (n+1)/(m+n)*Integrate[Csch[x]^m*Sech[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n]


(* ::Subsubsection::Closed:: *)
(*Sinh[x]^m Tanh[x]^n		Products of powers of hyperbolic sines and tangents (8)*)


(* GR5 2.423.18' *)
Integrate[Sinh[x_]*Tanh[x_],x_Symbol] :=
  Sinh[x]-2*ArcTan[Tanh[x/2]]


Integrate[Sinh[x_]^m_*Tanh[x_]^n_,x_Symbol]:=
  Sinh[x]^m*Tanh[x]^(n-1)/m /;
FreeQ[{m,n},x] && ZeroQ[m+n-1]


(* GR5 2.411.1, CRC 567a *)
Integrate[Sinh[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sinh[x]^m*Tanh[x]^(n+1)/m-
    (n+1)/m*Integrate[Sinh[x]^(m-2)*Tanh[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.6, CRC 568b *)
Integrate[Sinh[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sinh[x]^(m+2)*Tanh[x]^(n-1)/(n-1)-
    (m+2)/(n-1)*Integrate[Sinh[x]^(m+2)*Tanh[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.2, CRC 567b *)
Integrate[Sinh[x_]^m_*Tanh[x_]^n_.,x_Symbol]:=
  Sinh[x]^m*Tanh[x]^(n-1)/m-
    (m+n-1)/m*Integrate[Sinh[x]^(m-2)*Tanh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.3 *)
Integrate[Sinh[x_]^m_.*Tanh[x_]^n_,x_Symbol] :=
  -Sinh[x]^m*Tanh[x]^(n-1)/(n-1)+
    (m+n-1)/(n-1)*Integrate[Sinh[x]^m*Tanh[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.5, CRC 568a *)
Integrate[Sinh[x_]^m_*Tanh[x_]^n_.,x_Symbol]:=
  Sinh[x]^(m+2)*Tanh[x]^(n-1)/(m+n+1)-
    (m+2)/(m+n+1)*Integrate[Sinh[x]^(m+2)*Tanh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.4 *)
Integrate[Sinh[x_]^m_.*Tanh[x_]^n_,x_Symbol]:=
  Sinh[x]^m*Tanh[x]^(n+1)/(m+n+1)+
    (n+1)/(m+n+1)*Integrate[Sinh[x]^m*Tanh[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* ::Subsubsection::Closed:: *)
(*Sech[x]^m Tanh[x]^n		Products of powers of hyperbolic secants and tangents (8)*)


Integrate[Sech[x_]^2*Tanh[x_]^n_,x_Symbol] :=
  Tanh[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sech[x]^m*Tanh[x]^(n+1)/(n+1) /;
FreeQ[{m,n},x] && ZeroQ[m+n+1]


(* GR5 2.411.5, CRC 568a *)
Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sech[x]^(m-2)*Tanh[x]^(n+1)/(n+1)+
    (m-2)/(n+1)*Integrate[Sech[x]^(m-2)*Tanh[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[EvenQ[m]]


(* GR5 2.411.2, CRC 567b *)
Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  -Sech[x]^m*Tanh[x]^(n-1)/m+
    (n-1)/m*Integrate[Sech[x]^(m+2)*Tanh[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[EvenQ[m]]


(* GR5 2.411.6, CRC 568b *)
Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sech[x]^(m-2)*Tanh[x]^(n+1)/(m+n-1)+
    (m-2)/(m+n-1)*Integrate[Sech[x]^(m-2)*Tanh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.411.3 *)
Integrate[Sech[x_]^m_.*Tanh[x_]^n_,x_Symbol] :=
  -Sech[x]^m*Tanh[x]^(n-1)/(m+n-1)+
    (n-1)/(m+n-1)*Integrate[Sech[x]^m*Tanh[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.411.1, CRC 567a *)
Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  -Sech[x]^m*Tanh[x]^(n+1)/m+
    (m+n+1)/m*Integrate[Sech[x]^(m+2)*Tanh[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && Not[EvenQ[m]]


(* GR5 2.411.4 *)
Integrate[Sech[x_]^m_*Tanh[x_]^n_,x_Symbol] :=
  Sech[x]^m*Tanh[x]^(n+1)/(n+1)+
    (m+n+1)/(n+1)*Integrate[Sech[x]^m*Tanh[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && Not[EvenQ[m]]


(* ::Subsubsection::Closed:: *)
(*Cosh[x]^m Coth[x]^n		Products of powers of hyperbolic cosines and cotangents (8)*)


Integrate[Cosh[x_]*Coth[x_],x_Symbol] :=
  Cosh[x]+Integrate[Csch[x],x]


Integrate[Cosh[x_]^m_*Coth[x_]^n_,x_Symbol] :=
  Cosh[x]^m*Coth[x]^(n-1)/m /;
FreeQ[{m,n},x] && ZeroQ[m+n-1]


(* GR5 2.411.2, CRC 567b *)
Integrate[Cosh[x_]^m_.*Coth[x_]^n_.,x_Symbol] :=
  Cosh[x]^m*Coth[x]^(n+1)/m+
    (n+1)/m*Integrate[Cosh[x]^(m-2)*Coth[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.5, CRC 568a *)
Integrate[Cosh[x_]^m_.*Coth[x_]^n_.,x_Symbol] :=
  -Cosh[x]^(m+2)*Coth[x]^(n-1)/(n-1)+
    (m+2)/(n-1)*Integrate[Cosh[x]^(m+2)*Coth[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.1, CRC 567a *)
Integrate[Cosh[x_]^m_*Coth[x_]^n_.,x_Symbol] :=
  Cosh[x]^m*Coth[x]^(n-1)/m+
    (m+n-1)/m*Integrate[Cosh[x]^(m-2)*Coth[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.4 *)
Integrate[Cosh[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  -Cosh[x]^m*Coth[x]^(n-1)/(n-1)+
    (m+n-1)/(n-1)*Integrate[Cosh[x]^m*Coth[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.6, CRC 568b *)
Integrate[Cosh[x_]^m_.*Coth[x_]^n_.,x_Symbol] :=
  -Cosh[x]^(m+2)*Coth[x]^(n-1)/(m+n+1)+
    (m+2)/(m+n+1)*Integrate[Cosh[x]^(m+2)*Coth[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* GR5 2.411.3 *)
Integrate[Cosh[x_]^m_.*Coth[x_]^n_.,x_Symbol] :=
  Cosh[x]^m*Coth[x]^(n+1)/(m+n+1)+
    (n+1)/(m+n+1)*Integrate[Cosh[x]^m*Coth[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && NonzeroQ[m+n+1] && Not[OddQ[m] && EvenQ[n]]


(* ::Subsubsection::Closed:: *)
(*Csch[x]^m Coth[x]^n		Products of powers of hyperbolic cosecants and cotangents (8)*)
(**)


Integrate[Csch[x_]^2*Coth[x_]^n_,x_Symbol] :=
  -Coth[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  Csch[x]^m*Coth[x]^(n+1)/(n+1) /;
FreeQ[{m,n},x] && ZeroQ[m+n+1]


(* GR5 2.411.6, CRC 568b *)
Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  -Csch[x]^(m-2)*Coth[x]^(n+1)/(n+1)-
    (m-2)/(n+1)*Integrate[Csch[x]^(m-2)*Coth[x]^(n+2),x] /;
RationalQ[{m,n}] && m>1 && n<-1 && Not[EvenQ[m]]


(* GR5 2.411.1, CRC 567a *)
Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  -Csch[x]^m*Coth[x]^(n-1)/m-
    (n-1)/m*Integrate[Csch[x]^(m+2)*Coth[x]^(n-2),x] /;
RationalQ[{m,n}] && m<-1 && n>1 && Not[EvenQ[m]]


(* GR5 2.411.5, CRC 568a *)
Integrate[Csch[x_]^m_*Coth[x_]^n_,x_Symbol] :=
  -Csch[x]^(m-2)*Coth[x]^(n+1)/(m+n-1)-
    (m-2)/(m+n-1)*Integrate[Csch[x]^(m-2)*Coth[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.411.4 *)
Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  -Csch[x]^m*Coth[x]^(n-1)/(m+n-1)+
    (n-1)/(m+n-1)*Integrate[Csch[x]^m*Coth[x]^(n-2),x] /;
FreeQ[m,x] && RationalQ[n] && n>1 && NonzeroQ[m+n-1] && Not[EvenQ[m]]


(* GR5 2.411.2, CRC 567b *)
Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  -Csch[x]^m*Coth[x]^(n+1)/m-
    (m+n+1)/m*Integrate[Csch[x]^(m+2)*Coth[x]^n,x] /;
FreeQ[n,x] && RationalQ[m] && m<-1 && Not[EvenQ[m]]


(* GR5 2.411.3 *)
Integrate[Csch[x_]^m_.*Coth[x_]^n_,x_Symbol] :=
  Csch[x]^m*Coth[x]^(n+1)/(n+1)+
    (m+n+1)/(n+1)*Integrate[Csch[x]^m*Coth[x]^(n+2),x] /;
FreeQ[m,x] && RationalQ[n] && n<-1 && Not[EvenQ[m]]


(* ::Subsubsection::Closed:: *)
(*x^m Sinh[a+b x^n]^p		Products of monomials and powers of hyperbolic sines of binomials (9)*)


Integrate[Sinh[a_.+b_.*x_^2],x_Symbol] :=
  -E^(-a)*Sqrt[Pi]*Erf[Rt[b,2]*x]/(4*Rt[b,2]) +
    E^a*Sqrt[Pi]*Erfi[Rt[b,2]*x]/(4*Rt[b,2]) /;
FreeQ[{a,b},x]


Integrate[Sinh[b_.*x_^n_.]/x_,x_Symbol] :=
  SinhIntegral[b*x^n]/n /;
FreeQ[{b,n},x]


Integrate[Sinh[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  Sinh[a]*CoshIntegral[b*x^n]/n+Cosh[a]*SinhIntegral[b*x^n]/n /;
FreeQ[{a,b,n},x]


(* CRC 392h *)
Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m-n+1)*Cosh[a+b*x^n]/(b*n)-
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Cosh[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 405h *)
Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*Sinh[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)*Cosh[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && n>0 && m<-1


(* GR5 2.631.2'h *)
Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -n*Sinh[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^n*Cosh[a+b*x^n]*Sinh[a+b*x^n]^(p-1)/(b*n*p)-
    (p-1)/p*Integrate[x^m*Sinh[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>1 && ZeroQ[m-2*n+1]


(* GR5 2.631.2h *)
Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -(m-n+1)*x^(m-2*n+1)*Sinh[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^(m-n+1)*Cosh[a+b*x^n]*Sinh[a+b*x^n]^(p-1)/(b*n*p)-
    (p-1)/p*Integrate[x^m*Sinh[a+b*x^n]^(p-2),x]+
    (m-n+1)*(m-2*n+1)/(b^2*n^2*p^2)*Integrate[x^(m-2*n)*Sinh[a+b*x^n]^p,x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && 0<2*n<m+1


(* GR5 2.638.1h *)
Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -b*n*p*x^(m+n+1)*Sinh[a+b*x^n]^(p-1)*Cosh[a+b*x^n]/((m+1)*(m+n+1))+
    x^(m+1)*Sinh[a+b*x^n]^p/(m+1)+
    b^2*n^2*p^2/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Sinh[a+b*x^n]^p,x]+
    b^2*n^2*p*(p-1)/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Sinh[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && n>0 && m<-1 && m+n+1!=0


Integrate[(a_.+b_.*x_)^m_*Sinh[c_.+d_.*x_]^p_.,x_Symbol] :=
  Subst[Integrate[x^m*Sinh[c-a*d/b+d*x/b]^p,x],x,a+b*x]/b /;
FreeQ[{a,b,c,d,m},x] && RationalQ[p] && Not[a===0 && b===1]


(* ::Subsubsection::Closed:: *)
(*x^m Cosh[a+b x^n]^p		Products of monomials and powers of hyperbolic cosines of binomials (9)*)


Integrate[Cosh[a_.+b_.*x_^2],x_Symbol] :=
  E^(-a)*Sqrt[Pi]*Erf[Rt[b,2]*x]/(4*Rt[b,2]) +
    E^a*Sqrt[Pi]*Erfi[Rt[b,2]*x]/(4*Rt[b,2]) /;
FreeQ[{a,b},x]


Integrate[Cosh[b_.*x_^n_.]/x_,x_Symbol] :=
  CoshIntegral[b*x^n]/n /;
FreeQ[{b,n},x]


Integrate[Cosh[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  Cosh[a]*CoshIntegral[b*x^n]/n+Sinh[a]*SinhIntegral[b*x^n]/n /;
FreeQ[{a,b,n},x]


(* CRC 396h *)
Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m-n+1)*Sinh[a+b*x^n]/(b*n)-
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Sinh[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 406h *)
Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*Cosh[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)*Sinh[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && n>0 && m<-1


(* GR5 2.631.3'h *)
Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -n*Cosh[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^n*Sinh[a+b*x^n]*Cosh[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Cosh[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>1 && ZeroQ[m-2*n+1]


(* GR5 2.631.3h *)
Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -(m-n+1)*x^(m-2*n+1)*Cosh[a+b*x^n]^p/(b^2*n^2*p^2)+
    x^(m-n+1)*Sinh[a+b*x^n]*Cosh[a+b*x^n]^(p-1)/(b*n*p)+
    (p-1)/p*Integrate[x^m*Cosh[a+b*x^n]^(p-2),x]+
    (m-n+1)*(m-2*n+1)/(b^2*n^2*p^2)*Integrate[x^(m-2*n)*Cosh[a+b*x^n]^p,x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && 0<2*n<m+1


(* GR5 2.638.2h *)
Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -b*n*p*x^(m+n+1)*Sinh[a+b*x^n]*Cosh[a+b*x^n]^(p-1)/((m+1)*(m+n+1))+
    x^(m+1)*Cosh[a+b*x^n]^p/(m+1)+
    b^2*n^2*p^2/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Cosh[a+b*x^n]^p,x]-
    b^2*n^2*p*(p-1)/((m+1)*(m+n+1))*Integrate[x^(m+2*n)*Cosh[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && IntegerQ[n] && RationalQ[{m,p}] && p>1 && n>0 && m<-1 && m+n+1!=0


Integrate[(a_.+b_.*x_)^m_*Cosh[c_.+d_.*x_]^p_.,x_Symbol] :=
  Subst[Integrate[x^m*Cosh[c-a*d/b+d*x/b]^p,x],x,a+b*x]/b /;
FreeQ[{a,b,c,d,m},x] && RationalQ[p] && Not[a===0 && b===1]


(* ::Subsubsection::Closed:: *)
(*x^m Tanh[a+b x^n]^p		Products of monomials and powers of hyperbolictangents of binomials (2)*)


Integrate[x_^m_.*Tanh[a_.+b_.*x_^n_.],x_Symbol] :=
  Integrate[x^m,x] -
    2*Integrate[x^m/(1+E^(2*(a+b*x^n))),x] /;
FreeQ[{a,b,m,n},x] && NonzeroQ[m-n+1]


Integrate[x_^m_.*Tanh[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  Integrate[x^m,x] -
    Integrate[x^m*Sech[a+b*x^n]^2,x] /;
FreeQ[{a,b,m,n},x]

Integrate[x_^m_.*Tanh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  Integrate[x^m*Tanh[a+b*x^n]^(p-2),x] -
    Integrate[x^m*Sech[a+b*x^n]^2*Tanh[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Coth[a+b x^n]^p		Products of monomials and powers of hyperboliccotangents of binomials (2)*)


Integrate[x_^m_.*Coth[a_.+b_.*x_^n_.],x_Symbol] :=
  Integrate[x^m,x] -
    2*Integrate[x^m/(1-E^(2*(a+b*x^n))),x] /;
FreeQ[{a,b,m,n},x] && NonzeroQ[m-n+1]


Integrate[x_^m_.*Coth[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  Integrate[x^m,x] +
    Integrate[x^m*Csch[a+b*x^n]^2,x] /;
FreeQ[{a,b,m,n},x]

Integrate[x_^m_.*Coth[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  Integrate[x^m*Coth[a+b*x^n]^(p-2),x] +
    Integrate[x^m*Csch[a+b*x^n]^2*Coth[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b,m,n},x] && RationalQ[p] && p>0


(* ::Subsubsection::Closed:: *)
(*x^m Sech[a+b x^n]^p		Products of monomials and powers of hyperbolic secants of binomials (4)*)


(* CRC 430h *)
Integrate[x_^m_.*Sech[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  x^(m-n+1)*Tanh[a+b*x^n]/(b*n)-
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Tanh[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 431h *)
Integrate[x_*Sech[a_.+b_.*x_]^p_,x_Symbol] :=
  Sech[a+b*x]^(p-2)/(b^2*(p-1)*(p-2))+
    x*Tanh[a+b*x]*Sech[a+b*x]^(p-2)/(b*(p-1))+
    (p-2)/(p-1)*Integrate[x*Sech[a+b*x]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>1 && p!=2


(* GR5 2.643.2h *)
Integrate[Sech[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  Tanh[a+b*x^n]*Sech[a+b*x^n]^(p-2)/(b*n*(p-1)*x^(n-1))-
    (n-1)*Sech[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2)*x^(2*n-1))+
    (p-2)/(p-1)*Integrate[Sech[a+b*x^n]^(p-2),x]-
    (n-1)*(2*n-1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Sech[a+b*x^n]^(p-2)/x^(2*n),x] /;
FreeQ[{a,b},x] && RationalQ[p] && IntegerQ[n] && n>0 && p>1 && p!=2


(* GR5 2.643.2h *)
Integrate[x_^m_.*Sech[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  x^(m-n+1)*Tanh[a+b*x^n]*Sech[a+b*x^n]^(p-2)/(b*n*(p-1))+
    (m-n+1)*x^(m-2*n+1)*Sech[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2))+
    (p-2)/(p-1)*Integrate[x^m*Sech[a+b*x^n]^(p-2),x]-
    (m-n+1)*(m-2*n+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^(m-2*n)*Sech[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[{m,p}] && IntegerQ[n] && n>0 && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Csch[a+b x^n]^p		Products of monomials and powers of hyperbolic cosecants of binomials (4)*)
(**)


(* CRC 428h *)
Integrate[x_^m_.*Csch[a_.+b_.*x_^n_.]^2,x_Symbol] :=
  -x^(m-n+1)*Coth[a+b*x^n]/(b*n)+
    (m-n+1)/(b*n)*Integrate[x^(m-n)*Coth[a+b*x^n],x] /;
FreeQ[{a,b},x] && RationalQ[m] && IntegerQ[n] && 0<n<=m


(* CRC 429h *)
Integrate[x_*Csch[a_.+b_.*x_]^p_,x_Symbol] :=
  -Csch[a+b*x]^(p-2)/(b^2*(p-1)*(p-2))-
    x*Coth[a+b*x]*Csch[a+b*x]^(p-2)/(b*(p-1))-
    (p-2)/(p-1)*Integrate[x*Csch[a+b*x]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[p] && p>1 && p!=2


(* GR5 2.643.1h *)
Integrate[Csch[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -Coth[a+b*x^n]*Csch[a+b*x^n]^(p-2)/(b*n*(p-1)*x^(n-1))+
    (n-1)*Csch[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2)*x^(2*n-1))-
    (p-2)/(p-1)*Integrate[Csch[a+b*x^n]^(p-2),x]+
    (n-1)*(2*n-1)/(b^2*n^2*(p-1)*(p-2))*Integrate[Csch[a+b*x^n]^(p-2)/x^(2*n),x] /;
FreeQ[{a,b},x] && RationalQ[p] && IntegerQ[n] && p>1 && p!=2


(* GR5 2.643.1h *)
Integrate[x_^m_.*Csch[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  -x^(m-n+1)*Coth[a+b*x^n]*Csch[a+b*x^n]^(p-2)/(b*n*(p-1))-
    (m-n+1)*x^(m-2*n+1)*Csch[a+b*x^n]^(p-2)/(b^2*n^2*(p-1)*(p-2))-
    (p-2)/(p-1)*Integrate[x^m*Csch[a+b*x^n]^(p-2),x]+
    (m-n+1)*(m-2*n+1)/(b^2*n^2*(p-1)*(p-2))*Integrate[x^(m-2*n)*Csch[a+b*x^n]^(p-2),x] /;
FreeQ[{a,b},x] && RationalQ[{m,p}] && IntegerQ[n] && n>0 && p>1 && p!=2


(* ::Subsubsection::Closed:: *)
(*x^m Sinh[a+b x^n] Cosh[a+b x^n]^p	Products of monomials, hyperbolic sines and powers of cosines of binomials (1)*)


Integrate[x_^m_.*Sinh[a_.+b_.*x_^n_.]*Cosh[a_.+b_.*x_^n_.]^p_,x_Symbol] :=
  x^(m-n+1)*Cosh[a+b*x^n]^(p+1)/(b*n*(p+1))-
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*Cosh[a+b*x^n]^(p+1),x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>0 && Not[p===-1]


(* ::Subsubsection::Closed:: *)
(*x^m Cosh[a+b x^n] Sinh[a+b x^n]^p	Products of monomials, hyperbolic cosines and powers of sines of binomials (1)*)


Integrate[x_^m_.*Cosh[a_.+b_.*x_^n_.]*Sinh[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  x^(m-n+1)*Sinh[a+b*x^n]^(p+1)/(b*n*(p+1))-
    (m-n+1)/(b*n*(p+1))*Integrate[x^(m-n)*Sinh[a+b*x^n]^(p+1),x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>0 && Not[p===-1]


(* ::Subsubsection::Closed:: *)
(*x^m Tanh[a+b x^n] Sech[a+b x^n]^p	Products of monomials, hyperbolic tangents and powers of secants of binomials (1)*)


Integrate[x_^m_.*Tanh[a_.+b_.*x_^n_.]^q_.*Sech[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  -x^(m-n+1)*Sech[a+b*x^n]^p/(b*n*p)+
    (m-n+1)/(b*n*p)*Integrate[x^(m-n)*Sech[a+b*x^n]^p,x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>=0 && q===1 (* Required so InputForm is matchable *)


(* ::Subsubsection::Closed:: *)
(*x^m Coth[a+b x^n] Csch[a+b x^n]^p	Products of monomials, hyperbolic cotangents and powers of cosecants of binomials (1)*)
(**)


Integrate[x_^m_.*Coth[a_.+b_.*x_^n_.]^q_.*Csch[a_.+b_.*x_^n_.]^p_.,x_Symbol] :=
  -x^(m-n+1)*Csch[a+b*x^n]^p/(b*n*p)+
    (m-n+1)/(b*n*p)*Integrate[x^(m-n)*Csch[a+b*x^n]^p,x] /;
FreeQ[{a,b,p},x] && RationalQ[m] && IntegerQ[n] && m-n>=0 && q===1 (* Required so InputForm is matchable *)


(* ::Subsubsection::Closed:: *)
(*x^m Sinh[a+b*Log[c x^n]]^p		Products of monomials and powers of hyperbolic sines of logarithms (2)*)


Integrate[Sinh[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  x*Sinh[a+b*Log[c*x^n]]/(1-b^2*n^2)-
    b*n*x*Cosh[a+b*Log[c*x^n]]/(1-b^2*n^2) /;
FreeQ[{a,b,c,n},x] && NonzeroQ[b^2*n^2+1]


(* CRC 498h *)
Integrate[x_^m_.*Sinh[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  (m+1)*x^(m+1)*Sinh[a+b*Log[c*x^n]]/((m+1)^2-b^2*n^2)-
    b*n*x^(m+1)*Cosh[a+b*Log[c*x^n]]/((m+1)^2-b^2*n^2) /;
FreeQ[{a,b,c,m,n},x] && NonzeroQ[b^2*n^2+(m+1)^2]


(* ::Subsubsection::Closed:: *)
(*x^m Cosh[a+b*Log[c x^n]]^p		Products of monomials and powers of hyperbolic cosines of logarithms (2)*)
(**)


Integrate[Cosh[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  x*Cosh[a+b*Log[c*x^n]]/(1-b^2*n^2)-
    b*n*x*Sinh[a+b*Log[c*x^n]]/(1-b^2*n^2) /;
FreeQ[{a,b,c,n},x] && NonzeroQ[b^2*n^2+1]


(* CRC 497h *)
Integrate[x_^m_.*Cosh[a_.+b_.*Log[c_.*x_^n_.]],x_Symbol] :=
  (m+1)*x^(m+1)*Cosh[a+b*Log[c*x^n]]/((m+1)^2-b^2*n^2)-
    b*n*x^(m+1)*Sinh[a+b*Log[c*x^n]]/((m+1)^2-b^2*n^2) /;
FreeQ[{a,b,c,m,n},x] && NonzeroQ[b^2*n^2+(m+1)^2]


(* ::Subsubsection::Closed:: *)
(*1 / (a+b Hyper[x]^n)			Reciprocals of binomial hyperbolic functions (4)*)
(**)


Integrate[1/(a_.+b_.*Tanh[x_]),x_Symbol] :=
  (a*x-b*Log[a*Cosh[x]+b*Sinh[x]])/(a^2-b^2) /;
FreeQ[{a,b},x] && NonzeroQ[a^2-b^2]


Integrate[1/(a_.+b_.*Coth[x_]),x_Symbol] :=
  (a*x-b*Log[b*Cosh[x]+a*Sinh[x]])/(a^2-b^2) /;
FreeQ[{a,b},x] && NonzeroQ[a^2-b^2]


Integrate[1/(a_.+b_.*Tanh[x_]^2),x_Symbol] :=
  (x+(Sqrt[b]*ArcTan[(Sqrt[b]*Tanh[x])/Sqrt[a]])/Sqrt[a])/(a+b) /;
FreeQ[{a,b},x] && NonzeroQ[a+b]


Integrate[1/(a_.+b_.*Coth[x_]^2),x_Symbol] :=
  (x+(Sqrt[b]*ArcTan[(Sqrt[b]*Coth[x])/Sqrt[a]])/Sqrt[a])/(a+b) /;
FreeQ[{a,b},x] && NonzeroQ[a+b]


(* ::Subsubsection::Closed:: *)
(*v (1+Hyper[u]^2)^n			Simplify one plus or minus the square of hyperbolic functions (6)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
(* Should generalize this for any subexpression of the form w+w*Hyper[u]^2 *)
Integrate[v_.*(w_+t_.*Sinh[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Cosh[u]^2)^n,x] /;
ZeroQ[w-t]


Integrate[v_.*(w_+t_.*Cosh[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(t*Sinh[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Tanh[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Sech[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Coth[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Csch[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Sech[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Tanh[u]^2)^n,x] /;
ZeroQ[w+t]


Integrate[v_.*(w_+t_.*Csch[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(w*Coth[u]^2)^n,x] /;
ZeroQ[w-t]


(* ::Subsubsection::Closed:: *)
(*v (a Hyper[u]^m+b Hyper[u]^m)^n	Simplify sum of powers of hyperbolic functions (2)*)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[v_.*(a_.*Tanh[u_]^2+b_.*Sech[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(b+(a-b)*Tanh[u]^2)^n,x] /;
FreeQ[{a,b},x]


Integrate[v_.*(a_.*Coth[u_]^2+b_.*Csch[u_]^2)^n_.,x_Symbol] :=
  Integrate[v*(-b+(a+b)*Coth[u]^2)^n,x] /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*v Hyper[u]^2/(a+b Hyper[u]^2)	Simplify quotients of squares of hyperbolic functions by binomials (2)*)
(**)


(* These simplifications should be done automatically by the built-in simplifier! *)
Integrate[v_.*Cosh[u_]^2/(a_.+b_.*Sinh[u_]^2),x_Symbol] :=
  Integrate[v/(a-(a-b)*Tanh[u]^2),x] /;
FreeQ[{a,b},x]


Integrate[v_.*Sinh[u_]^2/(a_.+b_.*Cosh[u_]^2),x_Symbol] :=
  Integrate[v/(-a+(a+b)*Coth[u]^2),x] /;
FreeQ[{a,b},x]


(* ::Subsubsection::Closed:: *)
(*v (a+b Hyper[u]^m) / (c+d Hyper[u]^n)	Expand quotients of linear sums of hyperbolic functions (2)*)


(* This partial fraction expansion of hyperbolic functions should be done by the Apart in
	NormalizeExpression! *)
Integrate[v_.*(a_.+b_.*Sech[u_]^m_.)/(c_+d_.*Cosh[u_]^n_.),x_Symbol] :=
  b/c*Integrate[v*Sech[u]^m,x] +
    Integrate[v*(a*c-b*d*Sech[u]^(m-n))/(c+d*Cosh[u]^n),x]/c /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && 0<n<=m


Integrate[v_.*(a_.+b_.*Csch[u_]^m_.)/(c_+d_.*Sinh[u_]^n_.),x_Symbol] :=
  b/c*Integrate[v*Csch[u]^m,x] +
    Integrate[v*(a*c-b*d*Csch[u]^(m-n))/(c+d*Sinh[u]^n),x]/c /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && 0<n<=m


(* ::Subsection::Closed:: *)
(*Inverse Hyperbolic Functions (72)*)


(* ::Subsubsection::Closed:: *)
(*x^m ArcSinh[a x]		Products of monomials and hyperbolic arcsines (3)*)


(* CRC 579 *)
Integrate[ArcSinh[a_.*x_],x_Symbol] :=
  x*ArcSinh[a*x]-Sqrt[1+a^2*x^2]/a /;
FreeQ[a,x]


Integrate[ArcSinh[a_.*x_]/x_,x_Symbol] :=
  ArcSinh[a*x]*(ArcSinh[a*x]+2*Log[2*a*x/(a*x+Sqrt[1+a^2*x^2])])/2-
    PolyLog[2, 1/(a*x+Sqrt[1+a^2*x^2])^2]/2 /;
FreeQ[a,x]


(* CRC 581 *)
Integrate[x_^m_.*ArcSinh[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcSinh[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/Sqrt[1+a^2*x^2],x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCosh[a x]		Products of monomials and hyperbolic arccosines (3)*)


(* CRC 582' *)
(* Should be a simpler, analagous to that for ArcSinh *) 
Integrate[ArcCosh[a_.*x_],x_Symbol] :=
  x*ArcCosh[a*x]-Sqrt[-1+a*x]*Sqrt[1+a*x]/a /;
FreeQ[a,x]


Integrate[ArcCosh[a_.*x_]/x_,x_Symbol] :=
  ArcCosh[a*x]*(ArcCosh[a*x]+2*Log[2*a*x/(a*x+Sqrt[-1+a*x]*Sqrt[1+a*x])])/2-
    PolyLog[2, -1/(a*x+Sqrt[-1+a*x]*Sqrt[1+a*x])^2]/2 /;
FreeQ[a,x]


(* CRC 584 *)
Integrate[x_^m_.*ArcCosh[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCosh[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/(Sqrt[-1+a*x]*Sqrt[1+a*x]),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcTanh[a x]		Products of monomials and hyperbolic arctangents (3)*)


(* CRC 585 *)
Integrate[ArcTanh[a_.*x_],x_Symbol] :=
  x*ArcTanh[a*x]+Log[1-a^2*x^2]/(2*a) /;
FreeQ[a,x]


Integrate[ArcTanh[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  Integrate[Log[1+(a+b*x^n)]/x,x]/2-
    Integrate[Log[1-(a+b*x^n)]/x,x]/2 /;
FreeQ[{a,b,n},x]


(* CRC 588 *)
Integrate[x_^m_.*ArcTanh[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcTanh[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/(1-a^2*x^2),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCoth[a x]		Products of monomials and hyperbolic arccotangents (3)*)


(* CRC 586 *)
Integrate[ArcCoth[a_.*x_],x_Symbol] :=
  x*ArcCoth[a*x]+Log[1-a^2*x^2]/(2*a) /;
FreeQ[a,x]


Integrate[ArcCoth[a_.+b_.*x_^n_.]/x_,x_Symbol] :=
  Integrate[Log[1+1/(a+b*x^n)]/x,x]/2-
    Integrate[Log[1-1/(a+b*x^n)]/x,x]/2 /;
FreeQ[{a,b,n},x]


(* CRC 590 *)
Integrate[x_^m_.*ArcCoth[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCoth[a*x]/(m+1)-
    a/(m+1)*Integrate[x^(m+1)/(1-a^2*x^2),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcSech[a x]		Products of monomials and hyperbolic arcsecants (3)*)


(* CRC 591' *)
Integrate[ArcSech[a_.*x_],x_Symbol] :=
  x*ArcSech[a*x]-2*ArcTan[Sqrt[(1-a*x)/(1+a*x)]]/a /;
FreeQ[a,x]


Integrate[ArcSech[a_.*x_]/x_,x_Symbol] :=
  -ArcSech[a*x]*(ArcSech[a*x]+2*Log[2/(1+a*x*Sqrt[-1+1/(a*x)]*Sqrt[1+1/(a*x)])])/2+
    PolyLog[2, -1/(1/(a*x)+Sqrt[-1+1/(a*x)]*Sqrt[1+1/(a*x)])^2]/2 /;
FreeQ[a,x]


(* CRC 593 *)
Integrate[x_^m_.*ArcSech[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcSech[a*x]/(m+1)+
    1/(m+1)*Integrate[x^(m+1)/(x*Sqrt[(1-a*x)/(1+a*x)]*(1+a*x)),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCsch[a x]		Products of monomials and hyperbolic arccosecants (3)*)
(**)


(* CRC 594' *)
Integrate[ArcCsch[a_.*x_],x_Symbol] :=
  x*ArcCsch[a*x]+ArcTanh[Sqrt[1+1/(a^2*x^2)]]/a /;
FreeQ[a,x]


Integrate[ArcCsch[a_.*x_]/x_,x_Symbol] :=
  -ArcCsch[a*x]*(ArcCsch[a*x]+2*Log[2/(1+a*x*Sqrt[1+1/(a^2*x^2)])])/2+
    PolyLog[2, 1/(1/(a*x)+Sqrt[1+1/(a^2*x^2)])^2]/2 /;
FreeQ[a,x]


(* CRC 596 *)
Integrate[x_^m_.*ArcCsch[a_.*x_],x_Symbol] :=
  x^(m+1)*ArcCsch[a*x]/(m+1)+
    1/(a*(m+1))*Integrate[x^(m+1)/(x^2*Sqrt[1+1/(a^2*x^2)]),x] /;
FreeQ[{a,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*ArcSinh[a x]^n		Powers of hyperbolic arcsines (4)*)


Integrate[1/ArcSinh[a_.*x_],x_Symbol] :=
  CoshIntegral[ArcSinh[a*x]]/a


Integrate[1/ArcSinh[a_.*x_]^2,x_Symbol] :=
  -Sqrt[1+a^2*x^2]/(a*ArcSinh[a*x])+
    SinhIntegral[ArcSinh[a*x]]/a


Integrate[ArcSinh[a_.*x_]^n_,x_Symbol] :=
  x*ArcSinh[a*x]^n-
    n/a*Sqrt[1+a^2*x^2]*ArcSinh[a*x]^(n-1)+
    n*(n-1)*Integrate[ArcSinh[a*x]^(n-2),x] /;
 RationalQ[n] && n>1


Integrate[ArcSinh[a_.*x_]^n_,x_Symbol] :=
  -x*ArcSinh[a*x]^(n+2)/((n+1)*(n+2))+
    Sqrt[1+a^2*x^2]*ArcSinh[a*x]^(n+1)/(a*(n+1))+
    1/((n+1)*(n+2))*Integrate[ArcSinh[a*x]^(n+2),x] /;
 RationalQ[n] && n<-1 && n!=-2


(* ::Subsubsection::Closed:: *)
(*ArcCosh[a x]^n		Powers of hyperbolic arccosines (4)*)
(**)


Integrate[1/ArcCosh[a_.*x_],x_Symbol] :=
  SinhIntegral[ArcCosh[a*x]]/a


Integrate[1/ArcCosh[a_.*x_]^2,x_Symbol] :=
  -Sqrt[-1+a*x]*Sqrt[1+a*x]/(a*ArcCosh[a*x])+
    CoshIntegral[ArcCosh[a*x]]/a


Integrate[ArcCosh[a_.*x_]^n_,x_Symbol] :=
  x*ArcCosh[a*x]^n-
    n/a*Sqrt[-1+a*x]*Sqrt[1+a*x]*ArcCosh[a*x]^(n-1)+
    n*(n-1)*Integrate[ArcCosh[a*x]^(n-2),x] /;
 RationalQ[n] && n>1


Integrate[ArcCosh[a_.*x_]^n_,x_Symbol] :=
  -x*ArcCosh[a*x]^(n+2)/((n+1)*(n+2))+
    Sqrt[-1+a*x]*Sqrt[1+a*x]*ArcCosh[a*x]^(n+1)/(a*(n+1))+
    1/((n+1)*(n+2))*Integrate[ArcCosh[a*x]^(n+2),x] /;
 RationalQ[n] && n<-1 && n!=-2


(* ::Subsubsection::Closed:: *)
(*(1+x^2)^(m/2) ArcSinh[x]^n	Products of half powers of binomials and powers of hyperbolic arcsines (4)*)


Integrate[1/(Sqrt[1+x_^2]*ArcSinh[x_]),x_Symbol] :=
  Log[ArcSinh[x]]


Integrate[ArcSinh[x_]^n_./Sqrt[1+x_^2],x_Symbol] :=
  ArcSinh[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1+x_^2)^m_.*ArcSinh[x_],x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcSinh[x]-
    Integrate[u/Sqrt[1+x^2],x]] /;
HalfIntegerQ[m] && m!=-1/2


Integrate[(1+x_^2)^m_.*ArcSinh[x_]^n_,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x^2)^m,x]]},
  u*ArcSinh[x]^n-
    n*Integrate[Expand[u*ArcSinh[x]^(n-1)/Sqrt[1+x^2]],x]] /;
HalfIntegerQ[m] && m!=-1/2 && IntegerQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*(1+x)^(m/2) (-1+x)^(m/2) ArcCosh[x]^n  Products of half powers of linears and powers of hyperbolic arccosines (4)*)


Integrate[1/(Sqrt[1+x_]*Sqrt[-1+x_]*ArcCosh[x_]),x_Symbol] :=
  Log[ArcCosh[x]]


Integrate[ArcCosh[x_]^n_./(Sqrt[1+x_]*Sqrt[-1+x_]),x_Symbol] :=
  ArcCosh[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1+x_)^m_.*(-1+x_)^m_.*ArcCosh[x_],x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x)^m*(-1+x)^m,x]]},
  u*ArcCosh[x]-
    Integrate[u/(Sqrt[1+x]*Sqrt[-1+x]),x]] /;
HalfIntegerQ[m] && m!=-1/2


Integrate[(1+x_)^m_.*(-1+x_)^m_.*ArcCosh[x_]^n_,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1+x)^m*(-1+x)^m,x]]},
  u*ArcCosh[x]^n-
    n*Integrate[Expand[u*ArcCosh[x]^(n-1)/(Sqrt[1+x]*Sqrt[-1+x])],x]] /;
HalfIntegerQ[m] && m!=-1/2 && IntegerQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*(1-x^2)^m ArcTanh[x]^n	Products of integer powers of binomials and powers of hyperbolic arctangents (3)*)


Integrate[1/((1-x_^2)*ArcTanh[x_]),x_Symbol] :=
  Log[ArcTanh[x]]


Integrate[ArcTanh[x_]^n_./(1-x_^2),x_Symbol] :=
  ArcTanh[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1-x_^2)^m_*ArcTanh[x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcTanh[x]^n-
    n*Integrate[Expand[u*ArcTanh[x]^(n-1)/(1-x^2)],x]] /;
IntegerQ[{m,n}] && m<-1 && n>0

(* Ug.  (-1+x^2)^m should automatically evalute to (-1)^m*(1-x^2)^m for integer m! *)
Integrate[(-1+x_^2)^m_*ArcTanh[x_]^n_.,x_Symbol] :=
  (-1)^m*Integrate[(1-x^2)^m*ArcTanh[x]^n,x] /;
IntegerQ[{m,n}] && m<-1 && n>0


(* ::Subsubsection::Closed:: *)
(*(1-x^2)^m ArcCoth[x]^n	Products of integer powers of binomials and powers of hyperbolic arccotangents (3)*)


Integrate[1/((1-x_^2)*ArcCoth[x_]),x_Symbol] :=
  Log[ArcCoth[x]]


Integrate[ArcCoth[x_]^n_./(1-x_^2),x_Symbol] :=
  ArcCoth[x]^(n+1)/(n+1) /;
FreeQ[n,x] && NonzeroQ[n+1]


Integrate[(1-x_^2)^m_*ArcCoth[x_]^n_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcCoth[x]^n-
    n*Integrate[Expand[u*ArcCoth[x]^(n-1)/(1-x^2)],x]] /;
IntegerQ[{m,n}] && m<-1 && n>0

(* Ug.  (-1+x^2)^m should automatically evalute to (-1)^m*(1-x^2)^m for integer m! *)
Integrate[(-1+x_^2)^m_*ArcCoth[x_]^n_.,x_Symbol] :=
  (-1)^m*Integrate[(1-x^2)^m*ArcCoth[x]^n,x] /;
IntegerQ[{m,n}] && m<-1 && n>0


(* ::Subsubsection::Closed:: *)
(*(1-x^2)^m ArcCoth[x]^n ArcTanh[x]^p  Products of powers of binomials, hyperbolic arccotangents and arctangents (4)*)
(**)


Integrate[1/((1-x_^2)*ArcCoth[x_]*ArcTanh[x_]),x_Symbol] :=
  (-Log[ArcCoth[x]]+Log[ArcTanh[x]])/(ArcCoth[x]-ArcTanh[x])


Integrate[ArcCoth[x_]^n_.*ArcTanh[x_]^p_./(1-x_^2),x_Symbol] :=
  ArcCoth[x]^(n+1)*ArcTanh[x]^p/(n+1)-
    p/(n+1)*Integrate[ArcCoth[x]^(n+1)*ArcTanh[x]^(p-1)/(1-x^2),x] /;
IntegerQ[{n,p}] && 0<p<=n


Integrate[ArcCoth[x_]^n_.*ArcTanh[x_]^p_/(1-x_^2),x_Symbol] :=
  ArcCoth[x]^n*ArcTanh[x]^(p+1)/(p+1)-
    n/(p+1)*Integrate[ArcCoth[x]^(n-1)*ArcTanh[x]^(p+1)/(1-x^2),x] /;
IntegerQ[{n,p}] && 0<n<p


Integrate[(1-x_^2)^m_.*ArcCoth[x_]^n_.*ArcTanh[x_]^p_.,x_Symbol] :=
  Module[{u=Block[{ShowSteps=False}, Integrate[(1-x^2)^m,x]]},
  u*ArcCoth[x]^n*ArcTanh[x]^p-
    p*Integrate[u*ArcCoth[x]^n*ArcTanh[x]^(p-1)/(1-x^2),x]-
    n*Integrate[u*ArcCoth[x]^(n-1)*ArcTanh[x]^p/(1-x^2),x]] /;
IntegerQ[{m,p,n}] && m<-1 && p>1 && n>1

(* Ug.  (-1+x^2)^m should automatically evalute to (-1)^m*(1-x^2)^m for integer m! *)
Integrate[(-1+x_^2)^m_.*ArcCoth[x_]^n_.*ArcTanh[x_]^p_.,x_Symbol] :=
  (-1)^m*Integrate[(1-x^2)^m*ArcCoth[x]^n*ArcTanh[x]^p,x] /;
IntegerQ[{m,n,p}] && m<-1 && n>0


(* ::Subsubsection::Closed:: *)
(*x^m ArcSinh[a+b x^n]		Products of monomials and hyperbolic arcsines of binomials (2)*)


Integrate[ArcSinh[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcSinh[a+b*x^n]-
    b*n*Integrate[x^n/Sqrt[1+(a+b*x^n)^2],x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 581' *)
Integrate[x_^m_.*ArcSinh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcSinh[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/Sqrt[1+(a+b*x^n)^2],x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCosh[a+b x^n]	Products of monomials and hyperbolic arccosines of binomials (2)*)


Integrate[ArcCosh[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCosh[a+b*x^n]-
    b*n*Integrate[x^n/(Sqrt[-1+a+b*x^n]*Sqrt[1+a+b*x^n]),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 584' *)
Integrate[x_^m_.*ArcCosh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCosh[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/(Sqrt[-1+a+b*x^n]*Sqrt[1+a+b*x^n]),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcTanh[a+b x^n]	Products of monomials and hyperbolic arctangents of binomials (2)*)


Integrate[ArcTanh[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcTanh[a+b*x^n]-
    b*n*Integrate[x^n/(1-(a+b*x^n)^2),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 588' *)
Integrate[x_^m_.*ArcTanh[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcTanh[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/(1-(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCoth[a+b x^n]	Products of monomials and hyperbolic arccotangents of binomials (2)*)


Integrate[ArcCoth[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCoth[a+b*x^n]-
    b*n*Integrate[x^n/(1-(a+b*x^n)^2),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 590' *)
Integrate[x_^m_.*ArcCoth[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCoth[a+b*x^n]/(m+1)-
    b*n/(m+1)*Integrate[x^(m+n)/(1-(a+b*x^n)^2),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcSech[a+b x^n]	Products of monomials and hyperbolic arcsecants of binomials (2)*)


Integrate[ArcSech[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcSech[a+b*x^n]+
    b*n*Integrate[x^n/(Sqrt[-1+2/(1+a+b*x^n)]*(a+b*x^n)*(1+a+b*x^n)),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 593' *)
Integrate[x_^m_.*ArcSech[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcSech[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)/(Sqrt[(1-a-b*x^n)/(1+a+b*x^n)]*(a+b*x^n)*(1+a+b*x^n)),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m ArcCsch[a+b x^n]	Products of monomials and hyperbolic arccosecants of binomials (2)*)
(**)


Integrate[ArcCsch[a_.+b_.*x_^n_],x_Symbol] :=
  x*ArcCsch[a+b*x^n]+
    b*n*Integrate[x^n/((a+b*x^n)^2*Sqrt[1+1/(a+b*x^n)^2]),x] /;
FreeQ[{a,b},x] && IntegerQ[n]


(* CRC 596' *)
Integrate[x_^m_.*ArcCsch[a_.+b_.*x_^n_.],x_Symbol] :=
  x^(m+1)*ArcCsch[a+b*x^n]/(m+1)+
    b*n/(m+1)*Integrate[x^(m+n)/((a+b*x^n)^2*Sqrt[1+1/(a+b*x^n)^2]),x] /;
FreeQ[{a,b,m},x] && IntegerQ[n] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x ArcTanh[a+b x]^n		Products of x and powers of hyperbolic arctangents of linears (2)*)


Integrate[x_*ArcTanh[a_.*x_]^n_,x_Symbol] :=
  (-1+a^2*x^2)*ArcTanh[a*x]^n/(2*a^2)+
    n/(2*a)*Integrate[ArcTanh[a*x]^(n-1),x] /;
FreeQ[a,x] && RationalQ[n] && n>1


Integrate[x_*ArcTanh[a_.+b_.*x_]^n_,x_Symbol] :=
  -(1-(a+b*x)^2)*ArcTanh[a+b*x]^n/(2*b^2)+
    n/(2*b)*Integrate[ArcTanh[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcTanh[a+b*x]^n,x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*x ArcCoth[a+b x]^n		Products of x and powers of hyperbolic arccotangents of linears (2)*)
(**)


Integrate[x_*ArcCoth[a_.*x_]^n_,x_Symbol] :=
  (-1+a^2*x^2)*ArcCoth[a*x]^n/(2*a^2)+
    n/(2*a)*Integrate[ArcCoth[a*x]^(n-1),x] /;
FreeQ[a,x] && RationalQ[n] && n>1


Integrate[x_*ArcCoth[a_.+b_.*x_]^n_,x_Symbol] :=
  (-1+(a+b*x)^2)*ArcCoth[a+b*x]^n/(2*b^2)+
    n/(2*b)*Integrate[ArcCoth[a+b*x]^(n-1),x]-
    a/b*Integrate[ArcCoth[a+b*x]^n,x] /;
FreeQ[{a,b},x] && RationalQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*u ArcTanh[u]			Products of easily integrable functions and hyperbolic arctangents (3)*)


(* Integration by parts transforms integrand into an algebraic function. *)
Integrate[ArcTanh[u_],x_Symbol] :=
  x*ArcTanh[u]-
    Integrate[x*D[u,x]/(1-u^2),x] /;
InverseFunctionFreeQ[u,x] && Not[LinearQ[u,x]]


Integrate[(a_.+b_.*x_)^p_.*ArcTanh[u_],x_Symbol] :=
  (a+b*x)^(p+1)*ArcTanh[u]/(b*(p+1))-
    Integrate[(a+b*x)^(p+1)*D[u,x]/(1-u^2),x]/(b*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[p] && p!=-1 && InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*(a_.+b_.*x_^n_.)^p_.*ArcTanh[u_],x_Symbol] :=
  (a+b*x^n)^(p+1)*ArcTanh[u]/(b*n*(p+1))-
    Integrate[(a+b*x^n)^(p+1)*D[u,x]/(1-u^2),x]/(b*n*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p!=-1 && m==n-1 && InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*u ArcCoth[u]			Products of easily integrable functions and hyperbolic arccotangents (3)*)
(**)


(* Integration by parts transforms integrand into an algebraic function. *)
Integrate[ArcCoth[u_],x_Symbol] :=
  x*ArcCoth[u]-
    Integrate[x*D[u,x]/(1-u^2),x] /;
InverseFunctionFreeQ[u,x] && Not[LinearQ[u,x]]


Integrate[(a_.+b_.*x_)^p_.*ArcCoth[u_],x_Symbol] :=
  (a+b*x)^(p+1)*ArcCoth[u]/(b*(p+1))-
    Integrate[(a+b*x)^(p+1)*D[u,x]/(1-u^2),x]/(b*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[p] && p!=-1 && InverseFunctionFreeQ[u,x]


Integrate[x_^m_.*(a_.+b_.*x_^n_.)^p_.*ArcCoth[u_],x_Symbol] :=
  (a+b*x^n)^(p+1)*ArcCoth[u]/(b*n*(p+1))-
    Integrate[(a+b*x^n)^(p+1)*D[u,x]/(1-u^2),x]/(b*n*(p+1)) /;
FreeQ[{a,b},x] && RationalQ[{m,n,p}] && p!=-1 && m==n-1 && InverseFunctionFreeQ[u,x]


(* ::Subsubsection::Closed:: *)
(*u ArcHyper[c / (a+b x^n)]	Inverse hyperbolic functions of reciprocals of binomials (6)*)


Integrate[u_.*ArcSinh[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCsch[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCosh[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcSech[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcTanh[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCoth[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCoth[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcTanh[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcSech[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcCosh[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


Integrate[u_.*ArcCsch[c_./(a_.+b_.*x_^n_.)]^m_.,x_Symbol] :=
  Integrate[u*ArcSinh[a/c+b*x^n/c]^m,x] /;
FreeQ[{a,b,c,n,m},x]


(* ::Section::Closed:: *)
(*Special Function Rules (23)*)


(* ::Subsection::Closed:: *)
(*Error Functions (6)*)


(* ::Subsubsection::Closed:: *)
(*x^m Erf[a+b x]			Products of monomials and error functions of linears (2)*)


Integrate[Erf[a_.+b_.*x_],x_Symbol] :=
  1/(b*Sqrt[Pi]*Exp[(a+b*x)^2])+
    (a+b*x)*Erf[a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*Erf[a_.+b_.*x_],x_Symbol] :=
  x^(m+1)*Erf[a+b*x]/(m+1)-
    2*b/(Sqrt[Pi]*(m+1))*Integrate[x^(m+1)/Exp[(a+b*x)^2],x] /;
FreeQ[{a,b,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m Erfc[ a+b x]		Products of monomials and complementary error functions of linears (2)*)


Integrate[Erfc[a_.+b_.*x_],x_Symbol] :=
  -1/(b*Sqrt[Pi]*Exp[(a+b*x)^2])+
    (a+b*x)*Erfc[a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*Erfc[a_.+b_.*x_],x_Symbol] :=
  x^(m+1)*Erfc[a+b*x]/(m+1)+
    2*b/(Sqrt[Pi]*(m+1))*Integrate[x^(m+1)/Exp[(a+b*x)^2],x] /;
FreeQ[{a,b,m},x] && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m Erfi[a+b x]		Products of monomials and imaginary error functions of linears (2)*)


Integrate[Erfi[a_.+b_.*x_],x_Symbol] :=
  -Exp[(a+b*x)^2]/(b*Sqrt[Pi])+
    (a+b*x)*Erfi[a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*Erfi[a_.+b_.*x_],x_Symbol] :=
  x^(m+1)*Erfi[a+b*x]/(m+1)-
    2*b/(Sqrt[Pi]*(m+1))*Integrate[x^(m+1)*Exp[(a+b*x)^2],x] /;
FreeQ[{a,b,m},x] && NonzeroQ[m+1]


(* ::Subsection::Closed:: *)
(*Gamma Functions (6)*)


(* ::Subsubsection::Closed:: *)
(*x^m Gamma[n,a+b x]		Products of monomials and incomplete gamma functions of linears (2)*)


Integrate[Gamma[n_,a_.+b_.*x_],x_Symbol] :=
  (a+b*x)*Gamma[n,a+b*x]/b-
    Gamma[n+1,a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*Gamma[n_,a_.+b_.*x_],x_Symbol] :=
  x^m*(a+b*x)*Gamma[n,a+b*x]/(b*(m+1))-
    x^m*Gamma[n+1,a+b*x]/(b*(m+1))-
    a*m/(b*(m+1))*Integrate[x^(m-1)*Gamma[n,a+b*x],x]+
    m/(b*(m+1))*Integrate[x^(m-1)*Gamma[n+1,a+b*x],x] /;
FreeQ[{a,b},x] && RationalQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*x^m LogGamma[a+b x]	Products of monomials and log gamma functions of linears (2)*)


Integrate[LogGamma[a_.+b_.*x_],x_Symbol] :=
  PolyGamma[-2,a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*LogGamma[a_.+b_.*x_],x_Symbol] :=
  x^m*PolyGamma[-2,a+b*x]/b-
    m/b*Integrate[x^(m-1)*PolyGamma[-2,a+b*x],x] /;
FreeQ[{a,b},x] && RationalQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*x^m PolyGamma[n, a+b x]	Products of monomials and poly gamma functions of linears (2)*)


Integrate[PolyGamma[n_,a_.+b_.*x_],x_Symbol] :=
  PolyGamma[n-1,a+b*x]/b /;
FreeQ[{a,b,n},x]


Integrate[x_^m_.*PolyGamma[n_,a_.+b_.*x_],x_Symbol] :=
  x^m*PolyGamma[n-1,a+b*x]/b-
    m/b*Integrate[x^(m-1)*PolyGamma[n-1,a+b*x],x] /;
FreeQ[{a,b,n},x] && RationalQ[m] && m>0


(* ::Subsection::Closed:: *)
(*Zeta Function (4)*)


(* ::Subsubsection::Closed:: *)
(*x^m Zeta[s, a + b x]		Products of monomials and Hurwitz zeta function of linears (4)*)


Integrate[Zeta[2,a_.+b_.*x_],x_Symbol] :=
  PolyGamma[0,a+b*x]/b /;
FreeQ[{a,b},x]


Integrate[x_^m_.*Zeta[2,a_.+b_.*x_],x_Symbol] :=
  x^m*PolyGamma[0,a+b*x]/b-
    m/b*Integrate[x^(m-1)*PolyGamma[0,a+b*x],x] /;
FreeQ[{a,b},x] && RationalQ[m] && m>0


Integrate[Zeta[s_,a_.+b_.*x_],x_Symbol] :=
  -Zeta[s-1,a+b*x]/(b*(s-1)) /;
FreeQ[{a,b,s},x] && Not[s===1] && Not[s===2]


Integrate[x_^m_.*Zeta[s_,a_.+b_.*x_],x_Symbol] :=
  -x^m*Zeta[s-1,a+b*x]/(b*(s-1))+
    m/(b*(s-1))*Integrate[x^(m-1)*Zeta[s-1,a+b*x],x] /;
FreeQ[{a,b,s},x] && RationalQ[m] && m>0 && Not[s===1] && Not[s===2]


(* ::Subsection::Closed:: *)
(*Polylogarithm Function (7)*)


(* ::Subsubsection::Closed:: *)
(*x^m PolyLog[n, a (b x^p)^q]	Products of monomials and polylogarithms of monomials (3)*)


Integrate[PolyLog[n_,a_.*(b_.*x_^p_.)^q_.]/x_,x_Symbol] :=
  PolyLog[n+1,a*(b*x^p)^q]/(p*q) /;
FreeQ[{a,b,n,p,q},x]


Integrate[PolyLog[n_,a_.*(b_.*x_^p_.)^q_.],x_Symbol] :=
  x*PolyLog[n,a*(b*x^p)^q]-
    p*q*Integrate[PolyLog[n-1,a*(b*x^p)^q],x] /;
FreeQ[{a,b,p,q},x] && RationalQ[n] && n>0


Integrate[x_^m_.*PolyLog[n_,a_.*(b_.*x_^p_.)^q_.],x_Symbol] :=
  x^(m+1)*PolyLog[n,a*(b*x^p)^q]/(m+1)-
    p*q/(m+1)*Integrate[x^m*PolyLog[n-1,a*(b*x^p)^q],x] /;
FreeQ[{a,b,m,p,q},x] && RationalQ[n] && n>0 && NonzeroQ[m+1]


(* ::Subsubsection::Closed:: *)
(*x^m PolyLog[n, c (a+b x)^p]	Products of monomials and polylogarithms of powers of linears (2)*)


Integrate[PolyLog[n_,c_.*(a_.+b_.*x_)^p_.],x_Symbol] :=
  x*PolyLog[n,c*(a+b*x)^p]-
    p*Integrate[PolyLog[n-1,c*(a+b*x)^p],x]+
    a*p*Integrate[PolyLog[n-1,c*(a+b*x)^p]/(a+b*x),x] /;
FreeQ[{a,b,c,p},x] && RationalQ[n] && n>0


Integrate[x_^m_.*PolyLog[n_,c_.*(a_.+b_.*x_)^p_.],x_Symbol] :=
  x^(m+1)*PolyLog[n,c*(a+b*x)^p]/(m+1)-
    b*p/(m+1)*Integrate[x^(m+1)*PolyLog[n-1,c*(a+b*x)^p]/(a+b*x),x] /;
FreeQ[{a,b,c,m,p},x] && RationalQ[n] && n>0 && IntegerQ[m] && m>0


(* ::Subsubsection::Closed:: *)
(*x^m PolyLog[n, c f^(a+b x)]	Products of monomials and polylogarithms of exponentials (2)*)


Integrate[PolyLog[n_,c_.*f_^(a_.+b_.*x_)],x_Symbol] :=
  PolyLog[n+1,c*f^(a+b*x)]/(b*Log[f]) /;
FreeQ[{a,b,c,n},x]


Integrate[x_^m_.*PolyLog[n_,c_.*f_^(a_.+b_.*x_)],x_Symbol] :=
  x^m*PolyLog[n+1,c*f^(a+b*x)]/(b*Log[f]) -
    m/(b*Log[f])*Integrate[x^(m-1)*PolyLog[n+1,c*f^(a+b*x)],x] /;
FreeQ[{a,b,c,n},x] && RationalQ[m] && m>0


(* ::Section::Closed:: *)
(*Calculus Function Rules (4)*)


(* ::Subsection::Closed:: *)
(*Differentiation Function (4)*)


Integrate[D[u_,x_],x_Symbol] :=
  u


Integrate[f_[u_]*D[u_,x_],x_Symbol] :=
  Subst[Integrate[f[x],x],x,u]


Integrate[f_[u_,v_]*D[u_,x_],x_Symbol] :=
  Subst[Integrate[f[x,v],x],x,u] /;
IndependentQ[v,x]


Integrate[f_[u_,v_]*D[v_,x_],x_Symbol] :=
  Subst[Integrate[f[u,x],x],x,v] /;
IndependentQ[u,x]


(* ::Section::Closed:: *)
(*Derivative Divides Rules (62)*)


(* ::Subsection::Closed:: *)
(*Functions of linears (1)*)


(* Integrate[f(a+b*x),x] --> Subst[Integrate[f(x),x],x,a+b*x]/b *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=FunctionOfLinear[u,x]},
  ShowStep["","Integrate[f[a+b*x],x]","Subst[Integrate[f[x],x],x,a+b*x]/b",Hold[
  Subst[Integrate[lst[[1]],x],x,lst[[2]]+lst[[3]]*x]/lst[[3]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{lst=FunctionOfLinear[u,x]},
  Subst[Integrate[lst[[1]],x],x,lst[[2]]+lst[[3]]*x]/lst[[3]] /;
 Not[FalseQ[lst]]]]


(* ::Subsection::Closed:: *)
(*Products of functions of monomials and monomials (3)*)


(* Integrate[x^(n-1)*f(x^n),x] --> Subst[Integrate[f(x),x],x,x^n]/n *)
Integrate[u_*x_^m_.,x_Symbol] :=
  Subst[Integrate[SubstFor[x^(m+1),u,x],x],x,x^(m+1)]/(m+1) /;
FreeQ[m,x] && NonzeroQ[m+1] && NonsumQ[u] && Not[IntegerQ[m] && m<0 && PolynomialQ[u,x]] &&
	FunctionOfQ[x^(m+1),u,x]


(* Reduces the degree of x^m and the function of x^n by the gcd of m+1 and n *)
(* If g=GCD[m+1,n]>1,
	 Integrate[x^m*f(x^n),x] --> Subst[Integrate[x^((m+1)/g-1)*f(x^(n/g)),x],x,x^g]/g *)
If[ShowSteps,

Integrate[u_*x_^m_.,x_Symbol] :=
  Module[{lst=PowerVariableExpn[u,m+1,x]},
  If[m==-1,
    ShowStep["","Integrate[f[x^n]/x,x]","Subst[Integrate[f[x]/x,x],x,x^n]/n",Hold[
    Subst[Integrate[lst[[1]]/x,x],x,x^lst[[2]]]/lst[[2]]]],
  ShowStep["If g=GCD[m+1,n]>1,","Integrate[x^m*f[x^n],x]",
		"Subst[Integrate[x^((m+1)/g-1)*f[x^(n/g)],x],x,x^g]/g",Hold[
  Subst[Integrate[lst[[1]]/x,x],x,x^lst[[2]]]/lst[[2]]]]] /;
 Not[FalseQ[lst]] && lst[[2]]!=m+1] /;
SimplifyFlag && IntegerQ[m] && m!=-1 && NonsumQ[u] && Not[PolynomialQ[u,x]],

Integrate[u_*x_^m_.,x_Symbol] :=
  Module[{lst=PowerVariableExpn[u,m+1,x]},
  Subst[Integrate[lst[[1]]/x,x],x,x^lst[[2]]]/lst[[2]] /;
 Not[FalseQ[lst]] && lst[[2]]!=m+1] /;
IntegerQ[m] && m!=-1 && NonsumQ[u] && Not[PolynomialQ[u,x]]]


(* If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=PowerVariableExpn[Simplify[x*u],0,x]},
  ShowStep["","Integrate[f[x^n]/x,x]","Subst[Integrate[f[x]/x,x],x,x^n]/n",Hold[
  Subst[Integrate[lst[[1]]/x,x],x,x^lst[[2]]]/lst[[2]]]] /;
 Not[FalseQ[lst]] && lst[[2]]!=1 && lst[[2]]!=0] /;
SimplifyFlag && NonsumQ[u] && Not[PolynomialQ[u,x]],

Integrate[u_,x_Symbol] :=
  Module[{lst=PowerVariableExpn[Simplify[x*u],0,x]},
  Subst[Integrate[lst[[1]]/x,x],x,x^lst[[2]]]/lst[[2]] /;
 Not[FalseQ[lst]] && lst[[2]]!=1 && lst[[2]]!=0] /;
NonsumQ[u] && Not[PolynomialQ[u,x]]] *)


Integrate[u_*(a_.+b_.*x_),x_Symbol] :=
  Subst[Integrate[SubstFor[a*x+b*x^2/2,u,x],x],x,a*x+b*x^2/2] /;
FreeQ[{a,b},x] && FunctionOfQ[a*x+b*x^2/2,u,x]


(* ::Subsection::Closed:: *)
(*Products of functions of exponentials and exponentials (1)*)


(* Integrate[f(E^x)*E^x,x] --> Subst[Integrate[f(x),x],x,E^x] *)
Integrate[u_*E^x_,x_Symbol] :=
  Subst[Integrate[SubstFor[E^x,u,x],x],x,E^x] /;
NonsumQ[u] && FunctionOfQ[E^x,u,x]

(* Integrate[f(c^x)*c^x,x] --> Subst[Integrate[f(x),x],x,c^x]/Log[c] *)
(* Integrate[u_*c_^x_,x_Symbol] :=
  Subst[Integrate[SubstFor[c^x,u,x],x],x,c^x]/Log[c] /;
NonsumQ[u] && FreeQ[c,x] && FunctionOfQ[c^x,u,x] *)


(* ::Subsection::Closed:: *)
(*Products of functions of logarithms and reciprocals (1)*)


(* Integrate[f(Log[a*x^n])/x,x] --> Subst[Integrate[f(x),x],x,Log[a*x^n]]/n *)
If[ShowSteps,

Integrate[u_/x_,x_Symbol] :=
  Module[{lst=FunctionOfLog[u,x]},
  ShowStep["","Integrate[f[Log[a*x^n]]/x,x]","Subst[Integrate[f[x],x],x,Log[a*x^n]]/n",Hold[
  Subst[Integrate[lst[[1]],x],x,Log[lst[[2]]]]/lst[[3]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag && NonsumQ[u],

Integrate[u_/x_,x_Symbol] :=
  Module[{lst=FunctionOfLog[u,x]},
  Subst[Integrate[lst[[1]],x],x,Log[lst[[2]]]]/lst[[3]] /;
 Not[FalseQ[lst]]] /;
NonsumQ[u]]


(* Integrate[f(Log[x])/x,x] --> Subst[Integrate[f(x),x],x,Log[x]] *)
(* Integrate[u_/x_,x_Symbol] :=
  Subst[Integrate[SubstFor[Log[x],u,x],x],x,Log[x]] /;
NonsumQ[u] && FunctionOfQ[Log[x],u,x] *)


(* ::Subsection::Closed:: *)
(*Products of functions of trig functions and trig functions (22)*)


(* ::Subsubsection::Closed:: *)
(*f(Trig[x]) Trig[x]			Products of functions of trig functions and trig functions (8)*)


(* Integrate[f(Cos[x])*Sin[x],x] --> -Subst[Integrate[f(x),x],x,Cos[x]] *)
Integrate[u_*Sin[x_],x_Symbol] :=
  -Subst[Integrate[SubstFor[Cos[x],u,x],x],x,Cos[x]] /;
NonsumQ[u] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Cos[x],x] --> Subst[Integrate[f(x),x],x,Sin[x]] *)
Integrate[u_*Cos[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sin[x],u,x],x],x,Sin[x]] /;
NonsumQ[u] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Tan[x],x] --> -Subst[Integrate[f(x)/x,x],x,Cos[x]] *)
Integrate[u_*Tan[x_],x_Symbol] :=
  -Subst[Integrate[SubstFor[Cos[x],u,x]/x,x],x,Cos[x]] /;
NonsumQ[u] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Tan[x],x] --> Subst[Integrate[x*f(x)/(1-x^2),x],x,Sin[x]] *)
Integrate[u_*Tan[x_],x_Symbol] :=
  Subst[Integrate[x*SubstFor[Sin[x],u,x]/(1-x^2),x],x,Sin[x]] /;
NonsumQ[u] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Sin[x])*Cot[x],x] --> Subst[Integrate[f(x)/x,x],x,Sin[x]] *)
Integrate[u_*Cot[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sin[x],u,x]/x,x],x,Sin[x]] /;
NonsumQ[u] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Cot[x],x] --> -Subst[Integrate[x*f(x)/(1-x^2),x],x,Cos[x]] *)
Integrate[u_*Cot[x_],x_Symbol] :=
  -Subst[Integrate[x*SubstFor[Cos[x],u,x]/(1-x^2),x],x,Cos[x]] /;
NonsumQ[u] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Sec[x],x] --> Subst[Integrate[f(x)/(1-x^2),x],x,Sin[x]] *)
Integrate[u_*Sec[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sin[x],u,x]/(1-x^2),x],x,Sin[x]] /;
FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Csc[x],x] --> -Subst[Integrate[f(x)/(1-x^2),x],x,Cos[x]] *)
Integrate[u_*Csc[x_],x_Symbol] :=
  -Subst[Integrate[SubstFor[Cos[x],u,x]/(1-x^2),x],x,Cos[x]] /;
FunctionOfQ[Cos[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Tan[x])				Functions of tangent (1)*)


(* Integrate[f(Tan[x]),x] --> Subst[Integrate[f(x)/(1+x^2),x],x,Tan[x]] *)
Integrate[u_,x_Symbol] :=
  Subst[Integrate[SubstFor[Tan[x],u,x]/(1+x^2),x],x,Tan[x]] /;
NonsumQ[u] && FunctionOfQ[Tan[x],u,x] &&
	Not[IntegerPowerQ[u] && u[[2]]>0 && SumQ[u[[1]]]] && Not[u===Sqrt[Tan[x]^2]]


(* ::Subsubsection::Closed:: *)
(*f(Trig[x]) Trig[x]^n			Products of functions of trig functions and odd powers of trig functions (8)*)


(* Integrate[f(Cos[x])*Sin[x],x] --> -Subst[Integrate[f(x),x],x,Cos[x]] *)
Integrate[u_*Sin[x_]^n_,x_Symbol] :=
  -Subst[Integrate[(1-x^2)^((n-1)/2)*SubstFor[Cos[x],u,x],x],x,Cos[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Cos[x],x] --> Subst[Integrate[f(x),x],x,Sin[x]] *)
Integrate[u_*Cos[x_]^n_,x_Symbol] :=
  Subst[Integrate[(1-x^2)^((n-1)/2)*SubstFor[Sin[x],u,x],x],x,Sin[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Tan[x],x] --> -Subst[Integrate[f(x)/x,x],x,Cos[x]] *)
Integrate[u_*Tan[x_]^n_,x_Symbol] :=
  -Subst[Integrate[(1-x^2)^((n-1)/2)*SubstFor[Cos[x],u,x]/x^n,x],x,Cos[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Tan[x],x] --> Subst[Integrate[x*f(x)/(1-x^2),x],x,Sin[x]] *)
Integrate[u_*Tan[x_]^n_,x_Symbol] :=
  Subst[Integrate[x^n*SubstFor[Sin[x],u,x]/(1-x^2)^((n+1)/2),x],x,Sin[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Sin[x])*Cot[x],x] --> Subst[Integrate[f(x)/x,x],x,Sin[x]] *)
Integrate[u_*Cot[x_]^n_,x_Symbol] :=
  Subst[Integrate[(1-x^2)^((n-1)/2)*SubstFor[Sin[x],u,x]/x^n,x],x,Sin[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Cot[x],x] --> -Subst[Integrate[x*f(x)/(1-x^2),x],x,Cos[x]] *)
Integrate[u_*Cot[x_]^n_,x_Symbol] :=
  -Subst[Integrate[x^n*SubstFor[Cos[x],u,x]/(1-x^2)^((n+1)/2),x],x,Cos[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cos[x],u,x]


(* Integrate[f(Sin[x])*Sec[x],x] --> Subst[Integrate[f(x)/(1-x^2),x],x,Sin[x]] *)
Integrate[u_*Sec[x_]^n_,x_Symbol] :=
  Subst[Integrate[SubstFor[Sin[x],u,x]/(1-x^2)^((n+1)/2),x],x,Sin[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sin[x],u,x]


(* Integrate[f(Cos[x])*Csc[x],x] --> -Subst[Integrate[f(x)/(1-x^2),x],x,Cos[x]] *)
Integrate[u_*Csc[x_]^n_,x_Symbol] :=
  -Subst[Integrate[SubstFor[Cos[x],u,x]/(1-x^2)^((n+1)/2),x],x,Cos[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cos[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Trig[x]) Trig[2 x]			Products of functions of trig functions and trig functions of 2 x (3)*)


(* Integrate[f(Sin[x])*Sin[2*x],x] --> 2*Subst[Integrate[x*f(x),x],x,Sin[x]] *)
Integrate[u_*Sin[2*x_],x_Symbol] :=
  2*Subst[Integrate[x*SubstFor[Sin[x],u,x],x],x,Sin[x]] /;
NonsumQ[u] && FunctionOfQ[Sin[x],u,x]

(* Eliminate this when FunctionOfLinear transforms argument into f(Sin[x])*Sin[2*x]! *)
Integrate[u_*Sin[a_.+b_.*x_],x_Symbol] :=
  4*Subst[Integrate[x*SubstFor[Sin[a/2+b/2*x],u,x],x],x,Sin[a/2+b/2*x]]/b /;
NonsumQ[u] && FreeQ[{a,b},x] && FunctionOfQ[Sin[a/2+b/2*x],u,x]


(* Integrate[f(Cos[x])*Sin[2*x],x] --> -2*Subst[Integrate[x*f(x),x],x,Cos[x]] *)
Integrate[u_*Sin[2*x_],x_Symbol] :=
  -2*Subst[Integrate[x*SubstFor[Cos[x],u,x],x],x,Cos[x]] /;
NonsumQ[u] && FunctionOfQ[Cos[x],u,x]

(* Eliminate this when FunctionOfLinear transforms argument into f(Cos[x])*Sin[2*x]! *)
Integrate[u_*Sin[a_.+b_.*x_],x_Symbol] :=
  -4*Subst[Integrate[x*SubstFor[Cos[a/2+b/2*x],u,x],x],x,Cos[a/2+b/2*x]]/b /;
NonsumQ[u] && FreeQ[{a,b},x] && FunctionOfQ[Cos[a/2+b/2*x],u,x]


(* Integrate[f(Cos[x]*Sin[x])*Cos[2*x],x] --> Subst[Integrate[f(x),x],x,Cos[x]*Sin[x]] *)
Integrate[u_*Cos[2*x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Cos[x]*Sin[x],u,x],x],x,Cos[x]*Sin[x]] /;
NonsumQ[u] && FunctionOfQ[Cos[x]*Sin[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Log[Trig[x]]) Sec[x] Csc[x]		Products of functions of log of trig functions, secants and cosecants (2)*)


(* Integrate[f(Log[Tan[x]])*Sec[x]*Csc[x],x] --> Subst[Integrate[f(x),x],x,Log[Tan[x]]] *)
Integrate[u_*Sec[x_]*Csc[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Log[Tan[x]],u,x],x],x,Log[Tan[x]]] /;
NonsumQ[u] && FunctionOfQ[Log[Tan[x]],u,x]


(* Integrate[f(Log[Cot[x]])*Sec[x]*Csc[x],x] --> -Subst[Integrate[f(x),x],x,Log[Cot[x]]] *)
Integrate[u_*Sec[x_]*Csc[x_],x_Symbol] :=
  -Subst[Integrate[SubstFor[Log[Cot[x]],u,x],x],x,Log[Cot[x]]] /;
NonsumQ[u] && FunctionOfQ[Log[Cot[x]],u,x]


(* ::Subsection::Closed:: *)
(*Products of functions of inverse trig functions and its derivative (4)*)


(* ::Subsubsection::Closed:: *)
(*f(ArcTrig[x]) /(1+x^2)			Quotients of functions of inverse trig functions and 1+x^2 (2)*)


(* Integrate[f(ArcTan[x])/(1+x^2),x] --> Subst[Integrate[f(x),x],x,ArcTan[x]] *)
Integrate[u_/(1+x_^2),x_Symbol] :=
  Subst[Integrate[SubstFor[ArcTan[x],u,x],x],x,ArcTan[x]] /;
FunctionOfQ[ArcTan[x],u,x]


(* Integrate[f(ArcCot[x])/(1+x^2),x] --> -Subst[Integrate[f(x),x],x,ArcCot[x]] *)
Integrate[u_/(1+x_^2),x_Symbol] :=
  -Subst[Integrate[SubstFor[ArcCot[x],u,x],x],x,ArcCot[x]] /;
FunctionOfQ[ArcCot[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(ArcTrig[x]) /Sqrt[1-x^2]		Quotients of functions of inverse trig functions and Sqrt[1-x^2] (2)*)


(* Integrate[f(ArcSin[x])/Sqrt[1-x^2],x] --> Subst[Integrate[f(x),x],x,ArcSin[x]] *)
Integrate[u_/Sqrt[1-x_^2],x_Symbol] :=
  Subst[Integrate[SubstFor[ArcSin[x],u,x],x],x,ArcSin[x]] /;
FunctionOfQ[ArcSin[x],u,x]


(* Integrate[f(ArcCos[x])/Sqrt[1-x^2],x] --> -Subst[Integrate[f(x),x],x,ArcCos[x]] *)
Integrate[u_/Sqrt[1-x_^2],x_Symbol] :=
  -Subst[Integrate[SubstFor[ArcCos[x],u,x],x],x,ArcCos[x]] /;
FunctionOfQ[ArcCos[x],u,x]


(* ::Subsection::Closed:: *)
(*Products of functions of hyperbolic functions and hyperbolic functions (21)*)


(* ::Subsubsection::Closed:: *)
(*f(Hyper[x]) Hyper'[x]			Products of functions of hyperbolic functions and hyperbolic functions (8)*)


(* Integrate[f(Cosh[x])*Sinh[x],x] --> Subst[Integrate[f(x),x],x,Cosh[x]] *)
Integrate[u_*Sinh[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Cosh[x],u,x],x],x,Cosh[x]] /;
NonsumQ[u] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Cosh[x],x] --> Subst[Integrate[f(x),x],x,Sinh[x]] *)
Integrate[u_*Cosh[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sinh[x],u,x],x],x,Sinh[x]] /;
NonsumQ[u] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Tanh[x],x] --> Subst[Integrate[f(x)/x,x],x,Cosh[x]] *)
Integrate[u_*Tanh[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Cosh[x],u,x]/x,x],x,Cosh[x]] /;
NonsumQ[u] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Tanh[x],x] --> Subst[Integrate[x*f(x)/(1+x^2),x],x,Sinh[x]] *)
Integrate[u_*Tanh[x_],x_Symbol] :=
  Subst[Integrate[x*SubstFor[Sinh[x],u,x]/(1+x^2),x],x,Sinh[x]] /;
NonsumQ[u] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Sinh[x])*Coth[x],x] --> Subst[Integrate[f(x)/x,x],x,Sinh[x]] *)
Integrate[u_*Coth[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sinh[x],u,x]/x,x],x,Sinh[x]] /;
NonsumQ[u] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Coth[x],x] --> Subst[Integrate[x*f(x)/(-1+x^2),x],x,Cosh[x]] *)
Integrate[u_*Coth[x_],x_Symbol] :=
  Subst[Integrate[x*SubstFor[Cosh[x],u,x]/(-1+x^2),x],x,Cosh[x]] /;
NonsumQ[u] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Sech[x],x] --> Subst[Integrate[f(x)/(1+x^2),x],x,Sinh[x]] *)
Integrate[u_*Sech[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Sinh[x],u,x]/(1+x^2),x],x,Sinh[x]] /;
FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Csch[x],x] --> Subst[Integrate[f(x)/(-1+x^2),x],x,Cosh[x]] *)
Integrate[u_*Csch[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Cosh[x],u,x]/(-1+x^2),x],x,Cosh[x]] /;
FunctionOfQ[Cosh[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Tanh[x])				Functions of hyperbolic tangent (1)*)


(* Integrate[f(Tanh[x]),x] --> Subst[Integrate[f(x)/(1-x^2),x],x,Tanh[x]] *)
Integrate[u_,x_Symbol] :=
  Subst[Integrate[SubstFor[Tanh[x],u,x]/(1-x^2),x],x,Tanh[x]] /;
Not[IntegerPowerQ[u] && u[[2]]>0] && FunctionOfQ[Tanh[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Hyper[x]) Hyper'[x]^n		Products of functions of hyperbolic functions and odd powers of hyperbolic functions (8)*)


(* Integrate[f(Cosh[x])*Sinh[x],x] --> Subst[Integrate[f(x),x],x,Cosh[x]] *)
Integrate[u_*Sinh[x_]^n_,x_Symbol] :=
  Subst[Integrate[(-1+x^2)^((n-1)/2)*SubstFor[Cosh[x],u,x],x],x,Cosh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Cosh[x],x] --> Subst[Integrate[f(x),x],x,Sinh[x]] *)
Integrate[u_*Cosh[x_]^n_,x_Symbol] :=
  Subst[Integrate[(1+x^2)^((n-1)/2)*SubstFor[Sinh[x],u,x],x],x,Sinh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Tanh[x],x] --> Subst[Integrate[f(x)/x,x],x,Cosh[x]] *)
Integrate[u_*Tanh[x_]^n_,x_Symbol] :=
  Subst[Integrate[(-1+x^2)^((n-1)/2)*SubstFor[Cosh[x],u,x]/x^n,x],x,Cosh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Tanh[x],x] --> Subst[Integrate[x*f(x)/(1+x^2),x],x,Sinh[x]] *)
Integrate[u_*Tanh[x_]^n_,x_Symbol] :=
  Subst[Integrate[x^n*SubstFor[Sinh[x],u,x]/(1+x^2)^((n+1)/2),x],x,Sinh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Sinh[x])*Coth[x],x] --> Subst[Integrate[f(x)/x,x],x,Sinh[x]] *)
Integrate[u_*Coth[x_]^n_,x_Symbol] :=
  Subst[Integrate[(1+x^2)^((n-1)/2)*SubstFor[Sinh[x],u,x]/x^n,x],x,Sinh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Coth[x],x] --> Subst[Integrate[x*f(x)/(-1+x^2),x],x,Cosh[x]] *)
Integrate[u_*Coth[x_]^n_,x_Symbol] :=
  Subst[Integrate[x^n*SubstFor[Cosh[x],u,x]/(-1+x^2)^((n+1)/2),x],x,Cosh[x]] /;
NonsumQ[u] && OddQ[n] && FunctionOfQ[Cosh[x],u,x]


(* Integrate[f(Sinh[x])*Sech[x],x] --> Subst[Integrate[f(x)/(1+x^2),x],x,Sinh[x]] *)
Integrate[u_*Sech[x_]^n_,x_Symbol] :=
  Subst[Integrate[SubstFor[Sinh[x],u,x]/(1+x^2)^((n+1)/2),x],x,Sinh[x]] /;
OddQ[n] && FunctionOfQ[Sinh[x],u,x]


(* Integrate[f(Cosh[x])*Csch[x],x] --> Subst[Integrate[f(x)/(-1+x^2),x],x,Cosh[x]] *)
Integrate[u_*Csch[x_]^n_,x_Symbol] :=
  Subst[Integrate[SubstFor[Cosh[x],u,x]/(-1+x^2)^((n+1)/2),x],x,Cosh[x]] /;
OddQ[n] && FunctionOfQ[Cosh[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Hyper[x]) Sinh[2 x]			Products of functions of hyperbolic functions and sines of 2 x (2)*)


(* Integrate[f(Sinh[x])*Sinh[2*x],x] --> 2*Subst[Integrate[x*f(x),x],x,Sinh[x]] *)
Integrate[u_*Sinh[a_.+b_.*x_],x_Symbol] :=
  4*Subst[Integrate[x*SubstFor[Sinh[a/2+b/2*x],u,x],x],x,Sinh[a/2+b/2*x]]/b /;
NonsumQ[u] && FreeQ[{a,b},x] && FunctionOfQ[Sinh[a/2+b/2*x],u,x]


(* Integrate[f(Cosh[x])*Sinh[2*x],x] --> 2*Subst[Integrate[x*f(x),x],x,Cosh[x]] *)
Integrate[u_*Sinh[a_.+b_.*x_],x_Symbol] :=
  4*Subst[Integrate[x*SubstFor[Cosh[a/2+b/2*x],u,x],x],x,Cosh[a/2+b/2*x]]/b /;
NonsumQ[u] && FreeQ[{a,b},x] && FunctionOfQ[Cosh[a/2+b/2*x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(Log[Hyper[x]]) Sech[x] Csch[x]	Products of functions of log of hyperbolic tangent and its derivative (2)*)


(* Integrate[f(Log[Tanh[x]])*Sech[x]*Csch[x],x] --> Subst[Integrate[f(x),x],x,Log[Tanh[x]]] *)
Integrate[u_*Sech[x_]*Csch[x_],x_Symbol] :=
  Subst[Integrate[SubstFor[Log[Tanh[x]],u,x],x],x,Log[Tanh[x]]] /;
NonsumQ[u] && FunctionOfQ[Log[Tanh[x]],u,x]


(* Integrate[f(Log[Coth[x]])*Sech[x]*Csch[x],x] --> -Subst[Integrate[f(x),x],x,Log[Coth[x]]] *)
Integrate[u_*Sech[x_]*Csch[x_],x_Symbol] :=
  -Subst[Integrate[SubstFor[Log[Coth[x]],u,x],x],x,Log[Coth[x]]] /;
NonsumQ[u] && FunctionOfQ[Log[Coth[x]],u,x]


(* ::Subsection::Closed:: *)
(*Products of functions of inverse hyperbolic functions and its derivative (4)*)


(* ::Subsubsection::Closed:: *)
(*f(ArcHyper[x]) /(1-x^2)			Quotients of functions of inverse hyperbolic functions and 1-x^2 (2)*)


(* Integrate[f(ArcTanh[x])/(1-x^2),x] --> Subst[Integrate[f(x),x],x,ArcTanh[x]] *)
Integrate[u_/(1-x_^2),x_Symbol] :=
  Subst[Integrate[SubstFor[ArcTanh[x],u,x],x],x,ArcTanh[x]] /;
FunctionOfQ[ArcTanh[x],u,x]


(* Integrate[f(ArcCoth[x])/(1-x^2),x] --> Subst[Integrate[f(x),x],x,ArcCoth[x]] *)
Integrate[u_/(1-x_^2),x_Symbol] :=
  Subst[Integrate[SubstFor[ArcCoth[x],u,x],x],x,ArcCoth[x]] /;
FunctionOfQ[ArcCoth[x],u,x]


(* ::Subsubsection::Closed:: *)
(*f(ArcHyper[x]) /Sqrt[1+x^2]		Quotients of functions of inverse hyperbolic functions and Sqrt[1+x^2] (2)*)


(* Integrate[f(ArcSinh[x])/Sqrt[1+x^2],x] --> Subst[Integrate[f(x),x],x,ArcSinh[x]] *)
Integrate[u_/Sqrt[1+x_^2],x_Symbol] :=
  Subst[Integrate[SubstFor[ArcSinh[x],u,x],x],x,ArcSinh[x]] /;
FunctionOfQ[ArcSinh[x],u,x]


(* Integrate[f(ArcCosh[x])/(Sqrt[1+x]*Sqrt[-1+x]),x] --> Subst[Integrate[f(x),x],x,ArcCosh[x]] *)
Integrate[u_/(Sqrt[1+x_]*Sqrt[-1+x_]),x_Symbol] :=
  Subst[Integrate[SubstFor[ArcCosh[x],u,x],x],x,ArcCosh[x]] /;
FunctionOfQ[ArcCosh[x],u,x]


(* ::Subsection::Closed:: *)
(*Products of an expression and the derivative of a subexpression (5)*)


(* Integrate[f'(x)/f(x),x] --> Log[f(x)] *)
If[ShowSteps,

Integrate[v_/u_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  ShowStep["","Integrate[f'[x]/f[x],x]","Log[f[x]]",Hold[
  w*Log[u]]] /;
 Not[FalseQ[w]]] /;
SimplifyFlag,

Integrate[v_/u_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  w*Log[u] /;
 Not[FalseQ[w]]]]


(* Integrate[f(x)^n*f'(x),x] --> f(x)^(n+1)/(n+1) *)
If[ShowSteps,

Integrate[u_^n_.*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  ShowStep["If nonzero[n+1],","Integrate[f[x]^n*f'[x],x]","f[x]^(n+1)/(n+1)",Hold[
  w*u^(n+1)/(n+1)]] /;
 Not[FalseQ[w]]] /;
SimplifyFlag && FreeQ[n,x] && NonzeroQ[n+1] && (SumQ[v] || NonsumQ[u] || NonzeroQ[n-1]),

Integrate[u_^n_.*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  w*u^(n+1)/(n+1) /;
 Not[FalseQ[w]]] /;
FreeQ[n,x] && NonzeroQ[n+1] && (SumQ[v] || NonsumQ[u] || NonzeroQ[n-1])]


(* Integrate[x^m*f(x)^n*f'(x),x] -->
				x^m*f(x)^(n+1)/(n+1) - m/(n+1)*Integrate[x^(m-1)*f(x)^(n+1),x] *)
If[ShowSteps,

Integrate[x_^m_.*u_^n_.*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  ShowStep["If nonzero[n+1],","Integrate[x^m*f[x]^n*f'[x],x]",
				"x^m*f[x]^(n+1)/(n+1) - m/(n+1)*Integrate[x^(m-1)*f[x]^(n+1),x]",Hold[
  w*x^m*u^(n+1)/(n+1) -
    m/(n+1)*w*Integrate[x^(m-1)*u^(n+1),x]]] /;
 Not[FalseQ[w]]] /;
SimplifyFlag && FreeQ[n,x] && NonzeroQ[n+1] && RationalQ[m] &&
	(SumQ[v] || NonsumQ[u] || NonzeroQ[n-1]),

Integrate[x_^m_.*u_^n_.*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  w*x^m*u^(n+1)/(n+1) -
    m/(n+1)*w*Integrate[x^(m-1)*u^(n+1),x] /;
 Not[FalseQ[w]]] /;
FreeQ[n,x] && NonzeroQ[n+1] && RationalQ[m] && (SumQ[v] || NonsumQ[u] || NonzeroQ[n-1])]


(* Integrate[x^m*f(x)^(-1+a*x^m)*f'(x),x] -->
				f(x)^(a*x^m)/a - m*Integrate[x^(m-1)*f(x)^(a*x^m)*Log[f(x)],x] *)
If[ShowSteps,

Integrate[x_^m_.*u_^(-1+a_.*x_^m_.)*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  ShowStep["If m>0,","Integrate[x^m*f[x]^(-1+a*x^m)*f'[x],x]",
				"f[x]^(a*x^m)/a - m*Integrate[x^(m-1)*f[x]^(a*x^m)*Log[f[x]],x]",Hold[
  w*u^(a*x^m)/a -
    m*w*Integrate[x^(m-1)*u^(a*x^m)*Log[u],x]]] /;
 Not[FalseQ[w]]] /;
SimplifyFlag && FreeQ[a,x] && RationalQ[m],

Integrate[x_^m_.*u_^(-1+a_.*x_^m_.)*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  w*u^(a*x^m)/a -
    m*w*Integrate[x^(m-1)*u^(a*x^m)*Log[u],x] /;
 Not[FalseQ[w]]] /;
FreeQ[a,x] && RationalQ[m]]


(* Integrate[Log[f(x)]^n/f(x)*f'(x),x] --> Log[f(x)]^(n+1)/(n+1) *)
(* Integrate[Log[u_]^n_./u_*v_,x_Symbol] :=
  Module[{w=DerivativeDivides[u,v,x]},
  w*Log[u]^(n+1)/(n+1) /;
 Not[FalseQ[w]]] /;
FreeQ[n,x] && NonzeroQ[n+1] *)


(* Integrate[(g(x)*f'(x)-f(x)*g'(x))/(f(x)+g(x))^2,x] -> f(x)/(f(x)+g(x)) *)
Integrate[u_/(v_+w_)^2,x_Symbol] :=
  Module[{q=Block[{ShowSteps=False}, Simplify[u/(w*D[v,x]-v*D[w,x])]]},
  q*v/(v+w) /;
 IndependentQ[q,x]] /;
EasyDQ[v,x] && EasyDQ[w,x]


(* ::Section::Closed:: *)
(*Miscellaneous Rules (31)*)


(* ::Subsection::Closed:: *)
(*Functions of root of inverse linear expressions (1)*)


(* Substitution for root of a inverse linear expression *)
(* Integrate[f((a+b/x)^(1/n),x),x] -->
		-b*n*Subst[Integrate[x^(n-1)*f(x,b/(x^n-a))/(a-x^n)^2,x],x,(a+b/x)^(1/n)] *) 
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=InverseLinearRootExpn[u,x]},
  ShowStep["","Integrate[f[(a+b/x)^(1/n),x],x]",
			  "-b*n*Subst[Integrate[x^(n-1)*f[x,b/(x^n-a)]/(a-x^n)^2,x],x,(a+b/x)^(1/n)]",Hold[
  -lst[[2]]*lst[[4]]*Subst[Integrate[x^(lst[[2]]-1)*lst[[1]],x],x,lst[[3]]^(1/lst[[2]])]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{lst=InverseLinearRootExpn[u,x]},
  -lst[[2]]*lst[[4]]*Subst[Integrate[x^(lst[[2]]-1)*lst[[1]],x],x,lst[[3]]^(1/lst[[2]])] /;
 Not[FalseQ[lst]]]]


(* ::Subsection::Closed:: *)
(*Distribute powers over products (2)*)


Integrate[u_.*(v_^m_)^p_,x_Symbol] :=
  (v^m)^p/v^(m*p)*Integrate[u*v^(m*p),x] /;
FreeQ[p,x]


Integrate[u_.*(v_^m_.*w_^n_.)^p_,x_Symbol] :=
  (v^m*w^n)^p/(v^(m*p)*w^(n*p))*Integrate[u*v^(m*p)*w^(n*p),x] /;
FreeQ[p,x]


(* ::Subsection::Closed:: *)
(*Collect fractional powers of products (1)*)


Integrate[u_. v_^m_*w_^n_,x_Symbol] :=
  Module[{q=Cancel[v/w]},
  (v^m*w^n)/q^m*Integrate[u*q^m,x] /;
 PolynomialQ[q,x]] /;
FractionQ[{m,n}] && m+n==0 && PolynomialQ[{v,w},x]


(* ::Subsection::Closed:: *)
(*Normalize integrands (1)*)


If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{v=NormalizeExpression[u,x]},
  If[SumQ[v] && Not[MonomialSumQ[v,x]],
    ShowStep["If f[x] normalizes to g[x]+h[x]+\[CenterEllipsis],","Integrate[f[x],x]",
		"Integrate[g[x],x]+Integrate[h[x],x]+\[CenterEllipsis]",Hold[
    Map[Function[Integrate[#,x]],v]]],
  ShowStep["If f[x] normalizes to g[x],","Integrate[f[x],x]","Integrate[g[x],x]",Hold[
  Integrate[v,x]]]] /;
 Not[v===u]] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{v=NormalizeExpression[u,x]},
  If[SumQ[v] && Not[MonomialSumQ[v,x]],
    Map[Function[Integrate[#,x]],v],
  Integrate[v,x]] /;
 Not[v===u]]]


(* ::Subsection::Closed:: *)
(*Distribute products over sums (1)*)


(* Integrate[(a*u+b*v+...)*w,x] --> a*Integrate[u*w,x]+b*Integrate[v*w,x]+... *)
Integrate[u_*w_,x_Symbol] :=
  Map[Function[IndependentFactors[#,x]*Integrate[DependentFactors[#,x]*w,x]],u] /;
SumQ[u]

(* Integrate[(u_+v_)*w_,x_Symbol] :=
  Integrate[u*w,x]+Integrate[v*w,x] *)


(* ::Subsection::Closed:: *)
(*Expressions with a linear raised to a fractional power (1)*)


(* Substitution for root of a linear expression *)
(* Integrate[f((a+b*x)^(1/n),x),x] -->
		n/b*Subst[Integrate[x^(n-1)*f(x,-a/b+x^n/b),x],x,(a+b*x)^(1/n)] *) 
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=LinearRootExpn[u,x]},
  ShowStep["","Integrate[f[(a+b*x)^(1/n),x],x]",
			  "n/b*Subst[Integrate[x^(n-1)*f[x,-a/b+x^n/b],x],x,(a+b*x)^(1/n)]",Hold[
  lst[[2]]*Subst[Integrate[x^(lst[[2]]-1)*lst[[1]],x],x,lst[[3]]^(1/lst[[2]])]/lst[[4]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{lst=LinearRootExpn[u,x]},
  lst[[2]]*Subst[Integrate[x^(lst[[2]]-1)*lst[[1]],x],x,lst[[3]]^(1/lst[[2]])]/lst[[4]] /;
 Not[FalseQ[lst]]]]


(* ::Subsection::Closed:: *)
(*Functions of exponential function (1)*)


(* Integrate[f(E^x),x] --> Subst[Integrate[f(x)/x,x],x,E^x] *)
Integrate[u_,x_Symbol] :=
  Subst[Integrate[SubstFor[E^x,u,x]/x,x],x,E^x] /;
FunctionOfQ[E^x,u,x]


(* ::Subsection::Closed:: *)
(*Trigonometric Function Rules (9)*)


(* ::Subsubsection::Closed:: *)
(*u Trig[a+b x]^m Trig[c+d x]^n		Expand products of powers of trig functions of linears into sums (6)*)


Integrate[u_.*Sin[a_.+b_.*x_]^m_,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sin[a+b*x]^m]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b},x] && IntegerQ[m] && m>1


Integrate[u_.*Sin[a_.+b_.*x_]^m_.*Sin[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sin[a+b*x]^m*Sin[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0


Integrate[u_.*Cos[a_.+b_.*x_]^m_,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Cos[a+b*x]^m]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b},x] && IntegerQ[m] && m>1


Integrate[u_.*Cos[a_.+b_.*x_]^m_.*Cos[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Cos[a+b*x]^m*Cos[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0


Integrate[u_.*Sin[a_.+b_.*x_]^m_.*Cos[a_.+b_.*x_]^m_.,x_Symbol] :=
  Integrate[u*Sin[2*a+2*b*x]^m,x]/2^m /;
FreeQ[{a,b},x] && IntegerQ[m]


Integrate[u_.*Sin[a_.+b_.*x_]^m_.*Cos[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sin[a+b*x]^m*Cos[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0 && (m!=n || Not[a===c] || Not[b===d])


(* ::Subsubsection::Closed:: *)
(*u Trig[v]^n				Expand integer powers of trig functions into sums (2)*)


Integrate[u_.*Tan[v_]^2,x_Symbol] :=
  Integrate[u*Sec[v]^2,x] -
    Integrate[u,x]

Integrate[u_.*Tan[v_]^n_,x_Symbol] :=
  Integrate[u*Sec[v]^2*Tan[v]^(n-2),x] -
    Integrate[u*Tan[v]^(n-2),x] /;
IntegerQ[n] && n>1


Integrate[u_.*Cot[v_]^2,x_Symbol] :=
  Integrate[u*Csc[v]^2,x] -
    Integrate[u,x]

Integrate[u_.*Cot[v_]^n_,x_Symbol] :=
  Integrate[u*Csc[v]^2*Cot[v]^(n-2),x] -
    Integrate[u*Cot[v]^(n-2),x] /;
IntegerQ[n] && n>1


(* ::Subsubsection::Closed:: *)
(*f(Sin[x],Cos[x],Tan[x],...)		Tangent \[Theta]/2 substitution for functions of trigonometric functions (1)*)


(* Tangent[\[Theta]/2] substitution for functions of trig functions *)
(* Integrate[f(Sin[x],Cos[x]),x] -->
		2*Subst[Integrate[f(2*x/(1+x^2),(1-x^2)/(1+x^2))/(1+x^2),x],x,Tan[x/2]] *) 
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  ShowStep["","Integrate[f[Sin[x],Cos[x]],x]",
			"2*Subst[Integrate[f[2*x/(1+x^2),(1-x^2)/(1+x^2)]/(1+x^2),x],x,Tan[x/2]]",Hold[
  2*Subst[Integrate[SubstForTrig[u,x]/(1+x^2),x],x,Tan[x/2]]]] /;
SimplifyFlag && FunctionOfTrigQ[u,x],

Integrate[u_,x_Symbol] :=
  2*Subst[Integrate[SubstForTrig[u,x]/(1+x^2),x],x,Tan[x/2]] /;
FunctionOfTrigQ[u,x]]


(* ::Subsection::Closed:: *)
(*Hyperbolic Function Rules (11)*)


(* ::Subsubsection::Closed:: *)
(*u Hyper[a+b x]^m Hyper[c+d x]^n	Expand products of powers of hyperbolic functions of linears into sums (6)*)


Integrate[u_.*Sinh[a_.+b_.*x_]^m_,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sinh[a+b*x]^m]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b},x] && IntegerQ[m] && m>1


Integrate[u_.*Sinh[a_.+b_.*x_]^m_.*Sinh[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sinh[a+b*x]^m*Sinh[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0


Integrate[u_.*Cosh[a_.+b_.*x_]^m_,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Cosh[a+b*x]^m]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b},x] && IntegerQ[m] && m>1


Integrate[u_.*Cosh[a_.+b_.*x_]^m_.*Cosh[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Cosh[a+b*x]^m*Cosh[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0


Integrate[u_.*Sinh[a_.+b_.*x_]^m_.*Cosh[a_.+b_.*x_]^m_.,x_Symbol] :=
  Integrate[u*Sinh[2*a+2*b*x]^m,x]/2^m /;
FreeQ[{a,b},x] && IntegerQ[m]


Integrate[u_.*Sinh[a_.+b_.*x_]^m_.*Cosh[c_.+d_.*x_]^n_.,x_Symbol] :=
  Module[{v=Expand[TrigReduce[Sinh[a+b*x]^m*Cosh[c+d*x]^n]]},
  Map[Function[Integrate[u*#,x]],v] /;
 SumQ[v]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[{m,n}] && m>0 && n>0 && (m!=n || Not[a===c] || Not[b===d])


(* ::Subsubsection::Closed:: *)
(*u Hyper[v]^m				Expand integer powers of hyperbolic functions into sums (4)*)


(* Integrate[u_*Sinh[v_],x_Symbol] :=
  Integrate[u*E^v,x]/2-Integrate[u*E^(-v),x]/2 *)

Integrate[u_.*Sinh[v_]^m_.,x_Symbol] :=
  Integrate[Expand[u*(E^v/2-E^(-v)/2)^m,x],x] /;
IntegerQ[m] && m>0


(* Integrate[u_*Cosh[v_],x_Symbol] :=
  Integrate[u*E^v,x]/2+Integrate[u*E^(-v),x]/2 *)

Integrate[u_.*Cosh[v_]^m_.,x_Symbol] :=
  Integrate[Expand[u*(E^v/2+E^(-v)/2)^m],x] /;
IntegerQ[m] && m>0


Integrate[u_.*Tanh[v_]^2,x_Symbol] :=
  -Integrate[u*Sech[v]^2,x] +
    Integrate[u,x]

Integrate[u_.*Tanh[v_]^m_,x_Symbol] :=
  -Integrate[u*Sech[v]^2*Tanh[v]^(m-2),x] +
    Integrate[u*Tanh[v]^(m-2),x] /;
IntegerQ[m] && m>1


Integrate[u_.*Coth[v_]^2,x_Symbol] :=
  Integrate[u*Csch[v]^2,x] +
    Integrate[u,x]

Integrate[u_.*Coth[v_]^m_,x_Symbol] :=
  Integrate[u*Csch[v]^2*Coth[v]^(m-2),x] +
    Integrate[u*Coth[v]^(m-2),x] /;
IntegerQ[m] && m>1


(* ::Subsubsection::Closed:: *)
(*f(Sinh[x],Cosh[x],Tanh[x],...)		Hyperbolic tangent \[Theta]/2 substitution for functions of hyperbolic functions (1)*)
(**)


(* Hyperbolic Tangent[\[Theta]/2] substitution for functions of hyperbolic functions *)
(* Integrate[f(Sinh[x],Cosh[x]),x] -->
		2*Subst[Integrate[f(2*x/(1-x^2),(1+x^2)/(1-x^2))/(1-x^2),x],x,Tanh[x/2]] *) 
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  ShowStep["","Integrate[f[Sinh[x],Cosh[x]],x]",
			"2*Subst[Integrate[f[2*x/(1-x^2),(1+x^2)/(1-x^2)]/(1-x^2),x],x,Tanh[x/2]]",Hold[
  2*Subst[Integrate[SubstForHyperbolic[u,x]/(1-x^2),x],x,Tanh[x/2]]]] /;
SimplifyFlag && FunctionOfHyperbolicQ[u,x],

Integrate[u_,x_Symbol] :=
  2*Subst[Integrate[SubstForHyperbolic[u,x]/(1-x^2),x],x,Tanh[x/2]] /;
FunctionOfHyperbolicQ[u,x]]


(* ::Subsection::Closed:: *)
(*Products of monomials and powers of functions of improper binomials (2)*)


(* Transforms improper binomials into proper binomials *)
(* Transforms degree n of binomial to a positive integer *)
Integrate[f_[a_.+b_.*x_^n_]^p_.,x_Symbol] :=
  Module[{q=Numerator[1/n]},
  q*Subst[Integrate[x^(q-1)*f[a+b*x^(q*n)]^p,x],x,x^(1/q)]] /;
FreeQ[{a,b,f,p},x] && FractionOrNegativeQ[n]


Integrate[x_^m_.*f_[a_.+b_.*x_^n_]^p_.,x_Symbol] :=
  Module[{q=Sign[n]*LCM[Denominator[m],Denominator[n]]},
  q*Subst[Integrate[x^(q*m+q-1)*f[a+b*x^(q*n)]^p,x],x,x^(1/q)]] /;
FreeQ[{a,b,f,p},x] && RationalQ[{m,n}] && (FractionQ[m] || FractionOrNegativeQ[n])


(* ::Subsection::Closed:: *)
(*Functions of square-root of quadratic expressions (1)*)


(* Euler substitution #1 for square-root of a quadratic expression when PosQ[a] *)
(* Integrate[f(Sqrt[a+b*x+c*x^2],x),x] -->
	2*Subst[Integrate[f[(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2),(-b+2*Sqrt[a]*x)/(c-x^2)]*
			(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2)^2,x],x,(-Sqrt[a]+Sqrt[a+b*x+c*x^2])/x] *)

(* Euler substitution #2 for square-root of a quadratic expression when PosQ[c] *)
(* Integrate[f(Sqrt[a+b*x+c*x^2],x),x] -->
	2*Subst[Integrate[f[(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x),(-a+x^2)/(b+2*Sqrt[c]*x)]*
			(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x)^2,x],x,Sqrt[c]*x+Sqrt[a+b*x+c*x^2]] *)

(* Euler substitution #3 for square-root of a quadratic expression when NegQ[a] and NegQ[c] *)
(* Integrate[f(Sqrt[a+b*x+c*x^2],x),x] -->
	-2*Sqrt[b^2-4*a*c]*Subst[Integrate[f[-Sqrt[b^2-4*a*c]*x/(c-x^2),
		(b*c+c*Sqrt[b^2-4*a*c]+(-b+Sqrt[b^2-4*a*c])*x^2)/(-2*c*(c-x^2))]*x/(c-x^2)^2,x],
			x,2*c*Sqrt[a+b*x+c*x^2]/(b-Sqrt[b^2-4*a*c]+2*c*x)] *)
If[ShowSteps,

Integrate[u_,x_Symbol] :=
  Module[{lst=FunctionOfSquareRootOfQuadratic[u,x]},
  ShowStep["","Integrate[f[Sqrt[a+b*x+c*x^2],x],x]",
		If[lst[[3]]===1,
		  "2*Subst[Integrate[f[(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2),(-b+2*Sqrt[a]*x)/(c-x^2)]*
			(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2)^2,x],x,(-Sqrt[a]+Sqrt[a+b*x+c*x^2])/x]",
		If[lst[[3]]===2,
		  "2*Subst[Integrate[f[(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x),(-a+x^2)/(b+2*Sqrt[c]*x)]*
			(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x)^2,x],x,Sqrt[c]*x+Sqrt[a+b*x+c*x^2]]",
		"-2*Sqrt[b^2-4*a*c]*Subst[Integrate[f[-Sqrt[b^2-4*a*c]*x/(c-x^2),
		(b*c+c*Sqrt[b^2-4*a*c]+(-b+Sqrt[b^2-4*a*c])*x^2)/(-2*c*(c-x^2))]*x/(c-x^2)^2,x],
			x,2*c*Sqrt[a+b*x+c*x^2]/(b-Sqrt[b^2-4*a*c]+2*c*x)]"]],Hold[
  2*Subst[Integrate[lst[[1]],x],x,lst[[2]]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag,

Integrate[u_,x_Symbol] :=
  Module[{lst=FunctionOfSquareRootOfQuadratic[u,x]},
  2*Subst[Integrate[lst[[1]],x],x,lst[[2]]] /;
 Not[FalseQ[lst]]]]
