classdef nma_spring
    %
    %static class to make spring for plotting animations
    %by Nasser M. Abbasi
    
    
    properties
    end
    
    methods(Static)
        
        %---------------------------
        %
        %---------------------------
        function [x,y] = make(r,theta,N)
            %r: total length of spring
            %theta: in radians, anticlock wise is positive,
            %       theta zero is position x-axis
            %N: number of twists in spring
            %
            %OUTPUT:
            % x,y coordinates of line to use to plot spring
            len = (4/6)*r;
            p = zeros(N,2);
            delr = len/N;
            
            r0     = (1/6)*r;
            p(2,1) = r0;  
            p(2,2) = theta;
            
            for n=3:N-2
                p(n,1)=r0+delr*n;
                z=atan(2*delr/p(n,1));
                p(n,2)=theta+(-1)^n*z;
            end
            p(end-1,1)=(5/6)*r; p(end-1,2)=theta;
            p(end,1)=r; p(end,2)=theta;
            
            [x,y] = pol2cart(p(:,2),p(:,1));
        end

        %----------------------------------------
        function [x,y] = makeBox(w,h)
            x = zeros(5,1);
            y = zeros(5,1);
            x(1)= w/2; y(1)=0;
            x(2)= w/2; y(2)=h/2;
            x(3)= -w/2; y(3)=h/2;
            x(4)=-w/2;  y(4)=0;
            x(5)=x(1); y(5)=y(1);
            
        end
        %---------------------------
        %
        %---------------------------
        function [x,y] = makeV2(len,N,w)
            %len: total length of spring
            %N: number of twists in spring
            %
            %OUTPUT:
            % x,y coordinates of line to use to plot spring
                       
            nCoordinates = 2*N+4;
            p = zeros(nCoordinates,2);
            h = (1/6)*len;
            del=(len-2*h)/(N+1);
            done = false;
            n = 1;
            while not(done)
                            
                if n==1
                   p(1,1)=0;
                   p(1,2)=0;                   
                   n = n + 1;                   
                elseif n==2
                   p(2,1)=0;
                   p(2,2)=h;                   
                   n = n + 1;                   
                elseif n<nCoordinates-2
                   p(n,1)=w;
                   p(n,2)=p(n-1,2)+del;
                   n = n  + 1;
                   p(n,1)=-w;
                   p(n,2)=p(n-1,2);                   
                   n = n + 1;
                elseif n==nCoordinates-1
                   p(n,1) = 0;
                   p(n,2)=p(n-1,2)+del;                   
                   n = n + 1;
                else
                   p(n,1) = 0;
                   p(n,2)=p(n-1,2)+h;                   
                   done = true;             
                end
            end
            x=p(:,1);
            y=p(:,2);
            
        end        
                
        
       
        %------------------------
        %
        %------------------------
        function test(theta)
            
            close all;
            
            theta = theta*pi/180;
            figure;
            set(gcf,'Units','normalized');
            delr=0.3;
            for r=1:.1:3
                cla;
                [x,y] = nma_spring.make(r,theta,30);
                line(x,y);
                hold on;
                
                %baseX = [2*delr*cos((pi/2)-theta) -2*delr*sin(theta)];
                %baseY = [-2*delr*sin((pi/2)-theta) 2*delr*cos(theta)];
                
                baseX = [-2*delr*sin(abs(theta)) 2*delr*sin(abs(theta))];
                baseY = [-2*delr*cos(theta)      2*delr*cos(theta)];
                line(baseX,baseY);
                
                triX=[baseX(1) ...
                    baseX(1) ...
                    30*delr*cos(theta)-abs(baseX(1))...
                    baseX(1)];
                
                triY=[baseY(1) ...
                    -(30*delr*sin(abs(theta))+abs(baseY(1)))...
                    -(30*delr*sin(abs(theta))+abs(baseY(1)))...
                    baseY(1)];
                
                line(triX,triY);
                
                L=sqrt(x(end)^2+y(end)^2);
                xx0=L*cos(theta);
                yy0=-L*sin(abs(theta));
                massX=[xx0 ...
                    xx0+2*delr*sin(abs(theta)) ...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta) ...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta)-4*delr*sin(abs(theta))...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)...
                    xx0];
                
                massY=[ yy0 ...
                    yy0+2*delr*cos(theta) ...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta)) ...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)+4*delr*sin(abs(theta))...
                    yy0];
                
                line(massX,massY);
                
                xlim([-3,10]); ylim([-10,3]);
                
                set(gca,'DataAspectRatioMode','manual','DataAspectRatio',[1 1 1]);
                drawnow;
                pause(.1);
            end
                        
        end
        
        %-------------------------------
        %
        %-------------------------------
        function testV2(len)
            
            close all;
            
            theta = 0;
            figure;
            set(gcf,'Units','normalized');
            delr=0.3;
            for r=1:len/3:len
                cla;
                [x,y] = nma_spring.makeV2(r,10,1);
                line(x,y);
                hold on;
                
                %baseX = [2*delr*cos((pi/2)-theta) -2*delr*sin(theta)];
                %baseY = [-2*delr*sin((pi/2)-theta) 2*delr*cos(theta)];
                
                baseX = [-2*delr*sin(abs(theta)) 2*delr*sin(abs(theta))];
                baseY = [-2*delr*cos(theta)      2*delr*cos(theta)];
                line(baseX,baseY);
                
                triX=[baseX(1) ...
                    baseX(1) ...
                    30*delr*cos(theta)-abs(baseX(1))...
                    baseX(1)];
                
                triY=[baseY(1) ...
                    -(30*delr*sin(abs(theta))+abs(baseY(1)))...
                    -(30*delr*sin(abs(theta))+abs(baseY(1)))...
                    baseY(1)];
                
                line(triX,triY);
                
                L=sqrt(x(end)^2+y(end)^2);
                xx0=L*cos(theta);
                yy0=-L*sin(abs(theta));
                massX=[xx0 ...
                    xx0+2*delr*sin(abs(theta)) ...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta) ...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta)-4*delr*sin(abs(theta))...
                    xx0+2*delr*sin(abs(theta))+4*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)...
                    xx0];
                
                massY=[ yy0 ...
                    yy0+2*delr*cos(theta) ...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta)) ...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)...
                    yy0+2*delr*cos(theta)-4*delr*sin(abs(theta))-4*delr*cos(theta)+4*delr*sin(abs(theta))...
                    yy0];
                
                line(massX,massY);
                
                xlim([-3,10]); ylim([-10,3]);
                
                set(gca,'DataAspectRatioMode','manual','DataAspectRatio',[1 1 1]);
                drawnow;
                pause(.3);
            end
                        
        end        
        
    end
end

