function varargout = eme_121_lab1(varargin)
% EME_121_LAB1 M-file for eme_121_lab1.fig
%      EME_121_LAB1, by itself, creates a new EME_121_LAB1 or raises the existing
%      singleton*.
%
%      H = EME_121_LAB1 returns the handle to a new EME_121_LAB1 or the handle to
%      the existing singleton*.
%
%      EME_121_LAB1('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EME_121_LAB1.M with the given input arguments.
%
%      EME_121_LAB1('Property','Value',...) creates a new EME_121_LAB1 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before eme_121_lab1_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to eme_121_lab1_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help eme_121_lab1

% Last Modified by GUIDE v2.5 10-Apr-2011 23:32:56

% By Nasser M. Abbasi

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @eme_121_lab1_OpeningFcn, ...
    'gui_OutputFcn',  @eme_121_lab1_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before eme_121_lab1 is made visible.
function eme_121_lab1_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to eme_121_lab1 (see VARARGIN)

% Choose default command line output for eme_121_lab1
handles.output = hObject;

set(handles.figure1, 'UserData',[]);
set(handles.figure1,'Name','EME 121 first lab by Nasser M. Abbasi');

data.stop = false;
set(handles.figure1, 'UserData',data);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes eme_121_lab1 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = eme_121_lab1_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function mass_tag_Callback(hObject, eventdata, handles)
% hObject    handle to mass_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of mass_tag as text
%        str2double(get(hObject,'String')) returns contents of mass_tag as a double


% --- Executes during object creation, after setting all properties.
function mass_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mass_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function f_tag_Callback(hObject, eventdata, handles)
% hObject    handle to f_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of f_tag as text
%        str2double(get(hObject,'String')) returns contents of f_tag as a double


% --- Executes during object creation, after setting all properties.
function f_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to f_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function length_tag_Callback(hObject, eventdata, handles)
% hObject    handle to length_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of length_tag as text
%        str2double(get(hObject,'String')) returns contents of length_tag as a double


% --- Executes during object creation, after setting all properties.
function length_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to length_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function angle_zero_tag_Callback(hObject, eventdata, handles)
% hObject    handle to angle_zero_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of angle_zero_tag as text
%        str2double(get(hObject,'String')) returns contents of angle_zero_tag as a double


% --- Executes during object creation, after setting all properties.
function angle_zero_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to angle_zero_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function angle_speed_zero_Callback(hObject, eventdata, handles)
% hObject    handle to angle_speed_zero (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of angle_speed_zero as text
%        str2double(get(hObject,'String')) returns contents of angle_speed_zero as a double


% --- Executes during object creation, after setting all properties.
function angle_speed_zero_CreateFcn(hObject, eventdata, handles)
% hObject    handle to angle_speed_zero (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function r_zero_tag_Callback(hObject, eventdata, handles)
% hObject    handle to r_zero_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_zero_tag as text
%        str2double(get(hObject,'String')) returns contents of r_zero_tag as a double


% --- Executes during object creation, after setting all properties.
function r_zero_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_zero_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function r_speed_zero_Callback(hObject, eventdata, handles)
% hObject    handle to r_speed_zero (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r_speed_zero as text
%        str2double(get(hObject,'String')) returns contents of r_speed_zero as a double


% --- Executes during object creation, after setting all properties.
function r_speed_zero_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r_speed_zero (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in run_btn.
function run_btn_Callback(hObject, eventdata, handles)
% hObject    handle to run_btn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[data,status] = parse_input(handles);
if not(status)
    return;
end

data.handles = handles;
data.g = 9.8;

enable_all(handles,'off');
userData = get(handles.figure1, 'UserData');
userData.stop = false;
set(handles.figure1, 'UserData',userData);

[g_msg,g_status]=process_eme_121_lab1(data);
if not(g_status)
    uiwait(errordlg(sprintf('Processing terminated: %s',g_msg),...
        'Bad Input', 'modal'));
    uicontrol(handles.f_tag);
end
enable_all(handles,'on');

%----------------------------
function [data,status]= parse_input(handles)

[data.mass,status]=verify_valid_positive_numeric...
    (get(handles.mass_tag,'String'),handles.mass_tag,...
    'Mass must be positive number');
if not(status)
    return;
end

[data.f,status]=verify_valid_positive_numeric...
    (get(handles.f_tag,'String'),handles.f_tag,...
    'natural frequency must be positive number');
if not(status)
    return;
end


[data.L,status]=verify_valid_positive_numeric...
    (get(handles.length_tag,'String'),handles.length_tag,...
    'pendulum length must be positive number');
if not(status)
    return;
end

[data.angle_zero,status]=verify_valid_numeric...
    (get(handles.angle_zero_tag,'String'),handles.angle_zero_tag,...
    'Initial angle must be numerical value');
if not(status)
    return;
end

if abs(data.angle_zero)>180
    uiwait(errordlg('Initial angle must be between 0 and 180 degrees only',...
        'Bad Input', 'modal'));
    status = 0;
    uicontrol(handles.angle_zero);
    return
else
    data.angle_zero = data.angle_zero*pi/180;
end

[data.r_zero,status]=verify_valid_positive_numeric...
    (get(handles.r_zero_tag,'String'),handles.r_zero_tag,...
    'initial r must be  numerical value');
if not(status)
    return;
end


[data.r_speed_zero,status]=verify_valid_numeric...
    (get(handles.r_speed_zero,'String'),handles.r_speed_zero,...
    'initial r speed must be numerical value');
if not(status)
    return;
end


[data.time_step,status]=verify_valid_numeric...
    (get(handles.time_Step_tag,'String'),handles.time_Step_tag,...
    'time step must be zero or larger');
if not(status)
    return;
end

[data.angle_speed_zero,status]=verify_valid_numeric...
    (get(handles.angle_speed_zero,'String'),handles.angle_speed_zero,...
    'initial angle speed must be numerical value');
if not(status)
    return;
end

[data.max_t,status]=verify_valid_positive_numeric...
    (get(handles.max_t_tag,'String'),handles.max_t_tag,...
    'maximum simulation time must be positive number');
if not(status)
    return;
end

contents = cellstr(get(handles.ode_solver_tag,'String'));
data.solver = contents{get(handles.ode_solver_tag,'Value')};


data.k = data.mass*(2*pi*data.f)^2;

%-------------------------------
function enable_all(handles,to)
set(handles.mass_tag,'Enable',to);
set(handles.f_tag,'Enable',to);
set(handles.length_tag,'Enable',to);
set(handles.angle_zero_tag,'Enable',to);
set(handles.r_speed_zero,'Enable',to);
set(handles.angle_speed_zero,'Enable',to);
set(handles.r_zero_tag,'Enable',to);
set(handles.max_t_tag,'Enable',to);
set(handles.ode_solver_tag,'Enable',to);
set(handles.time_Step_tag,'Enable',to);

function max_t_tag_Callback(hObject, eventdata, handles)
% hObject    handle to max_t_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of max_t_tag as text
%        str2double(get(hObject,'String')) returns contents of max_t_tag as a double


% --- Executes during object creation, after setting all properties.
function max_t_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to max_t_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in reset_tag.
function reset_tag_Callback(hObject, eventdata, handles)
% hObject    handle to reset_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


data = get(handles.figure1, 'UserData');
data.stop = true;
set(handles.figure1, 'UserData',data);
enable_all(handles,'on');


% --- Executes on selection change in ode_solver_tag.
function ode_solver_tag_Callback(hObject, eventdata, handles)
% hObject    handle to ode_solver_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns ode_solver_tag contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ode_solver_tag

% --- Executes during object creation, after setting all properties.
function ode_solver_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ode_solver_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function time_Step_tag_Callback(hObject, eventdata, handles)
% hObject    handle to time_Step_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of time_Step_tag as text
%        str2double(get(hObject,'String')) returns contents of time_Step_tag as a double


% --- Executes during object creation, after setting all properties.
function time_Step_tag_CreateFcn(hObject, eventdata, handles)
% hObject    handle to time_Step_tag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
